/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.report.channelaccount;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.CellStyleRule;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.model.BMallAppInfo;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.SaleOrderUtil;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.occba.report.channelaccount.ChannelAccountRptParam;
import kd.occ.occba.report.util.RptUtil;

public final class ChannelAccountRptForm
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final Set<String> HEADFILTER_SET = Stream.of("settleorgid", "balancechannelid", "balancecustomerid", "remark", "srcbilltype", "srcbillno", "materialid").collect(Collectors.toCollection(HashSet::new));
    private static final Set<String> HIDEFIELDSET = Stream.of("srcbillid", "srcbillentity", "accountdate", "saleorgid", "orderchannelid", "salechannelid", "srcbillid", "srcbillentryid", "srcbillentryseq", "paymentamounttype").collect(Collectors.toCollection(HashSet::new));
    private static final Set<String> ENTRYHIDEFIELDSET = Stream.of("materialid", "ispresent", "unitid", "qty", "actualtaxprice").collect(Collectors.toCollection(HashSet::new));
    private static final String CACHE_KEY_ORG_IDS = "hasPermissionOrg";
    private static final String SAVECHECKACCOUNT = "savecheckaccount";
    private static final String CHECKFEEDBACK = "checkfeedback";
    private static final String CHECKCONFIRM = "checkconfirm";
    private static final String CHECKCANCEL = "checkcancel";
    private static final String CHECKPAGE = "occba_checkaccountlist";

    public void registerListener(EventObject e) {
        BasedataEdit periodF7;
        BasedataEdit channelF7;
        super.registerListener(e);
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("settleorgid_h");
        if (orgF7 != null) {
            orgF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((channelF7 = (BasedataEdit)this.getControl("balancechannelid_h")) != null) {
            channelF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((periodF7 = (BasedataEdit)this.getControl("period")) != null) {
            periodF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String key = e.getFieldName();
        if ("srcbillno".equals(key)) {
            this.showDetailRpt(e);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.removeCommonFilterGridCols();
        this.initQueryParamValue();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        switch (fieldKey = e.getProperty().getName()) {
            case "balancechannelid_h": {
                if (!this.isFromPurRpt()) break;
                this.getModel().setValue("settleorgid_h", (Object)this.getSettleOrgIdByRelation());
                break;
            }
            case "period": {
                Object obj = this.getModel().getValue("period");
                if (!(obj instanceof DynamicObject)) break;
                DynamicObject periodDynObj = (DynamicObject)obj;
                this.getModel().setValue("startdate", (Object)periodDynObj.getDate("starttime"));
                this.getModel().setValue("enddate", (Object)periodDynObj.getDate("endtime"));
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        List keyCols;
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        if ("showkeycols".equals(key) && !(keyCols = Stream.of(((String)value).split(",")).collect(Collectors.toList())).contains("settleorgid") && !keyCols.contains("balancecustomerid")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u4f9d\u636e\u201d\u4e2d\u7684\u7ed3\u7b97\u201c\u7ec4\u7ec7\u3001\u7ed3\u7b97\u5ba2\u6237\u201d\u5fc5\u9009\u5176\u4e00\u3002", (String)"ChannelAccountRptForm_0", (String)"occ-occba-report", (Object[])new Object[0]));
            e.setCancel(true);
            this.getView().updateView(key);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent f7) {
        String name;
        switch (name = f7.getProperty().getName()) {
            case "settleorgid_h": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)f7, (QFilter)new QFilter("id", "in", this.getSettleOrgIdList()));
                f7.getFormShowParameter().setCustomParam("isIncludeAllSub", (Object)true);
                break;
            }
            case "balancechannelid_h": {
                QFilter filter = new QFilter("id", "in", (Object)CUserHelper.getAuthorizedChannelIdList((boolean)false));
                if (!this.isFromPurRpt()) {
                    filter.and(new QFilter("customer", "!=", (Object)0L));
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)f7, (QFilter)filter);
                break;
            }
            case "period": {
                QFilter joinFiler = QFilter.join((String)"periodid", (String)String.join((CharSequence)".", "ocdbd_assess_period", "id"), (QFilter)new QFilter(String.join((CharSequence)".", "ocdbd_assess_period", "enable"), "=", (Object)"1"));
                F7Utils.addF7Filter((BeforeF7SelectEvent)f7, (QFilter)joinFiler);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        IReportView view = this.getView();
        boolean isVerify = this.verifyRptParams(view);
        if (isVerify) {
            this.buildReportParams();
        }
        return isVerify;
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        List columnList = event.getColumns();
        for (AbstractReportColumn reportColumn : columnList) {
            ReportColumn column = (ReportColumn)reportColumn;
            if (HIDEFIELDSET.contains(column.getFieldKey())) {
                column.setHide(true);
            }
            if (!ENTRYHIDEFIELDSET.contains(column.getFieldKey())) continue;
            column.setHide(!this.getModel().getDataEntity().getBoolean("showbilldetail"));
        }
    }

    public void setSortAndFilter(List<SortAndFilterEvent> list) {
        super.setSortAndFilter(list);
        for (SortAndFilterEvent event : list) {
            if (!HEADFILTER_SET.contains(event.getColumnName())) continue;
            event.setFilter(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        ReportList reportlistap = (ReportList)this.getView().getControl("reportlistap");
        AbstractGrid.GridState entryState = reportlistap.getEntryState();
        int[] selectedRows = entryState.getSelectedRows();
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (key = operate.getOperateKey()) {
            case "savecheckaccount": {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId(CHECKPAGE);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(parameter);
                break;
            }
            case "checkfeedback": {
                if (selectedRows == null || selectedRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ChannelAccountRptForm_1", (String)"occ-occba-report", (Object[])new Object[0]));
                    break;
                }
                ArrayList<Map<String, Object>> feedBackParams = new ArrayList<Map<String, Object>>();
                this.buildFeedBackParams(selectedRows, reportlistap, feedBackParams);
                if (CollectionUtils.isEmpty(feedBackParams)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u6570\u636e\u65e0\u9700\u6570\u636e\u53cd\u9988\u3002", (String)"ChannelAccountRptForm_2", (String)"occ-occba-report", (Object[])new Object[0]));
                    break;
                }
                HashMap<String, ArrayList<Map<String, Object>>> params = new HashMap<String, ArrayList<Map<String, Object>>>(1);
                params.put("feedbackparams", feedBackParams);
                FormShowParameter backparameter = FormShowUtils.openNewForm((String)"", (String)"occba_checkaccountback_dp", (ShowType)BMallAppInfo.getShowType((ShowType)ShowType.NewTabPage), (OperationStatus)OperationStatus.ADDNEW, params);
                backparameter.setHasRight(true);
                this.getView().showForm(backparameter);
                break;
            }
            case "checkconfirm": {
                if (selectedRows == null || selectedRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ChannelAccountRptForm_1", (String)"occ-occba-report", (Object[])new Object[0]));
                    break;
                }
                this.saveCheckConfirm(selectedRows, reportlistap);
                break;
            }
            case "checkcancel": {
                if (selectedRows == null || selectedRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ChannelAccountRptForm_1", (String)"occ-occba-report", (Object[])new Object[0]));
                    break;
                }
                this.deleteCheckConfirm(selectedRows, reportlistap);
                break;
            }
        }
        super.beforeDoOperation(args);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        String selectedRowstr;
        super.processRowData(gridPK, rowData, queryParam);
        if (rowData != null && !rowData.isEmpty() && (selectedRowstr = this.getPageCache().get("selectedRows")) != null) {
            String[] split = selectedRowstr.split(",");
            int[] seletRows = new int[split.length];
            for (int i = 0; i < split.length; ++i) {
                seletRows[i] = Integer.parseInt(split[i]);
            }
            ReportList reportlistap = (ReportList)this.getView().getControl("reportlistap");
            reportlistap.selectRows(seletRows, seletRows[0]);
            this.getPageCache().remove("selectedRows");
        }
    }

    public void setCellStyleRules(List<CellStyleRule> cellStyleRules) {
        CellStyleRule cellStyleRule = new CellStyleRule();
        cellStyleRule.setFieldKey("checkstatus");
        cellStyleRule.setForeColor("#fb2323");
        cellStyleRule.setCondition("checkstatus='0'");
        cellStyleRules.add(cellStyleRule);
        super.setCellStyleRules(cellStyleRules);
    }

    private void buildFeedBackParams(int[] selectedRows, ReportList reportlistap, List<Map<String, Object>> feedBackParams) {
        for (int selectedRow : selectedRows) {
            String lineType;
            DynamicObject reportData = reportlistap.getReportModel().getRowData(selectedRow);
            if (reportData == null || !StringUtils.equals((CharSequence)(lineType = reportData.getString("linetype")), (CharSequence)"0")) continue;
            HashMap<String, Object> srcBillParams = new HashMap<String, Object>(6);
            srcBillParams.put("srcbillno", reportData.getString("srcbillno"));
            srcBillParams.put("srcbillid", reportData.getLong("srcbillid"));
            srcBillParams.put("srcbilltype", reportData.getString("srcbilltype"));
            srcBillParams.put("payableamount", reportData.getBigDecimal("payableamount"));
            srcBillParams.put("paymentamount", reportData.getBigDecimal("paymentamount"));
            srcBillParams.put("remark", reportData.getString("remark"));
            feedBackParams.add(srcBillParams);
        }
    }

    private ChannelAccountRptParam buildReportParams() {
        ReportQueryParam param = this.getQueryParam();
        DynamicObject data = this.getModel().getDataEntity();
        ChannelAccountRptParam channelAccountRptParam = new ChannelAccountRptParam();
        channelAccountRptParam.setSettleOrgIdList(RptUtil.getBaseDataLongIds(this.getView(), "settleorgid_h"));
        channelAccountRptParam.setSettleChannelIdList(RptUtil.getBaseDataLongIds(this.getView(), "balancechannelid_h"));
        List<Long> customerIdList = RptUtil.getBaseDataLongIds(this.getView(), "balancechannelid_h", "customer");
        customerIdList.remove(0L);
        channelAccountRptParam.setSettleCustomerIdList(customerIdList);
        DynamicObjectCollection channelColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("balancechannelid_h");
        Map<Long, Long> settleCustomerIdMap = channelColl.stream().collect(Collectors.toMap(o -> DynamicObjectUtils.getPkValue((DynamicObject)o.getDynamicObject("fbasedataid"), (String)"customer"), o -> DynamicObjectUtils.getPkValue((DynamicObject)o.getDynamicObject("fbasedataid")), (r1, r2) -> r1));
        channelAccountRptParam.setSettleCustomerIdMap(settleCustomerIdMap);
        channelAccountRptParam.setCurrencyId(DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"currencyid_h"));
        Date fromDate = RptUtil.getShortDate(data.getDate("startdate"));
        channelAccountRptParam.setFromDate(fromDate);
        Date toDate = RptUtil.getShortDate(data.getDate("enddate"), 1);
        channelAccountRptParam.setToDate(toDate);
        channelAccountRptParam.setShowBillDetail(data.getBoolean("showbilldetail"));
        channelAccountRptParam.setOnlyShowRowCount(data.getBoolean("onlyshowrowcount"));
        param.getCustomParam().put(ChannelAccountRptParam.class.getName(), channelAccountRptParam);
        channelAccountRptParam.setFromPurRpt(this.isFromPurRpt());
        channelAccountRptParam.setPreviousPeriodId(this.getPreviousPeriodId());
        return channelAccountRptParam;
    }

    private void initQueryParamValue() {
        Date nowDate = DateUtil.getDataFormat((Date)KDDateUtils.now(), (boolean)true);
        QFilter filter = new QFilter("starttime", "<=", (Object)nowDate);
        filter.and(new QFilter("endtime", ">=", (Object)nowDate));
        DynamicObject dynObj = BusinessDataServiceHelper.loadSingleFromCache((String)"ocdbd_assess_entity", (QFilter[])filter.toArray());
        if (dynObj != null) {
            this.getModel().setValue("period", (Object)dynObj.getLong("id"));
            this.getModel().setValue("startdate", (Object)dynObj.getDate("starttime"));
            this.getModel().setValue("enddate", (Object)dynObj.getDate("endtime"));
        }
        if (this.isFromPurRpt()) {
            long channelId = B2BUserHelper.getLoginChannelId();
            Object[] balanceChannelIds = new Object[]{channelId};
            this.getModel().setValue("balancechannelid_h", (Object)balanceChannelIds);
            this.getModel().setValue("settleorgid_h", (Object)this.getSettleOrgIdByRelation());
        } else {
            List<Long> orgIdList = this.getHasPermissionSettleOrg();
            Object[] ids = null;
            if (!CommonUtils.isNull(orgIdList) && orgIdList.contains(UserUtil.getOrgId()) && OrgUnitServiceHelper.checkOrgFunction((Long)UserUtil.getOrgId(), (String)"10")) {
                ids = new Object[]{UserUtil.getOrgId()};
            }
            this.getModel().setValue("settleorgid_h", ids);
        }
    }

    private Set<String> removeCommonFilterGridCols() {
        HashSet<String> removedPros = new HashSet<String>();
        removedPros.add("srcbillid");
        removedPros.add("srcbillentryid");
        removedPros.add("srcbillentryseq");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        String fieldName = null;
        for (Map info : filterColumns) {
            fieldName = (String)info.get("fieldName");
            if (removedPros.contains(fieldName.split("\\.")[0])) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
        return removedPros;
    }

    private void saveCheckConfirm(int[] selectedRows, ReportList reportlistap) {
        int rowCount = selectedRows.length;
        StringBuilder rowStr = new StringBuilder();
        HashSet<String> srcBillNos = new HashSet<String>(rowCount);
        HashSet<Long> srcBillIds = new HashSet<Long>(rowCount);
        HashSet<String> srcBillTypes = new HashSet<String>(rowCount);
        ArrayList<String> lstUniqueValues = new ArrayList<String>(rowCount);
        HashMap<String, DynamicObject> uniqueReportDataMap = new HashMap<String, DynamicObject>(rowCount);
        for (int rowIndex : selectedRows) {
            String lineType;
            rowStr.append(rowIndex);
            rowStr.append(",");
            DynamicObject reportData = reportlistap.getReportModel().getRowData(rowIndex);
            if (reportData == null || !StringUtils.equals((CharSequence)(lineType = reportData.getString("linetype")), (CharSequence)"0")) continue;
            String srcBillNo = reportData.getString("srcbillno");
            long srcBillId = reportData.getLong("srcbillid");
            String srcBillType = reportData.getString("srcbilltype");
            String uniqueValues = srcBillNo + "_" + srcBillType;
            if (lstUniqueValues.contains(uniqueValues)) continue;
            lstUniqueValues.add(uniqueValues);
            uniqueReportDataMap.put(uniqueValues, reportData);
            srcBillNos.add(srcBillNo);
            srcBillIds.add(srcBillId);
            srcBillTypes.add(srcBillType);
        }
        this.getPageCache().put("selectedRows", rowStr.toString());
        if (lstUniqueValues.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u6570\u636e\u65e0\u9700\u6570\u636e\u786e\u8ba4", (String)"ChannelAccountRptForm_3", (String)"occ-occba-report", (Object[])new Object[0]));
            reportlistap.refresh();
            return;
        }
        QFilter filters = new QFilter("srcbillno", "in", srcBillNos);
        filters.and("srcbillid", "in", srcBillIds);
        filters.and("srcbilltype", "in", srcBillTypes);
        String selectFields = "srcbillno,srcbilltype";
        DynamicObjectCollection checkEntities = QueryServiceHelper.query((String)"occba_checkconfirm", (String)selectFields, (QFilter[])filters.toArray());
        for (DynamicObject checkEntry : checkEntities) {
            String srcBillNo = checkEntry.getString("srcbillno");
            String srcBillType = checkEntry.getString("srcbilltype");
            String uniqueValues = srcBillNo + "_" + srcBillType;
            uniqueReportDataMap.remove(uniqueValues);
        }
        if (uniqueReportDataMap.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u6570\u636e\u5df2\u786e\u8ba4", (String)"ChannelAccountRptForm_4", (String)"occ-occba-report", (Object[])new Object[0]));
            reportlistap.refresh();
            return;
        }
        DynamicObjectType type = (DynamicObjectType)ORM.create().getDataEntityType("occba_checkconfirm");
        ArrayList<DynamicObject> dataEntities = new ArrayList<DynamicObject>(rowCount);
        ArrayList<Map<String, Object>> lstCheckLog = new ArrayList<Map<String, Object>>(rowCount);
        long currentUserId = UserServiceHelper.getCurrentUserId();
        Date currentTime = TimeServiceHelper.now();
        for (Map.Entry entry : uniqueReportDataMap.entrySet()) {
            DynamicObject reportData = (DynamicObject)entry.getValue();
            String srcBillNo = reportData.getString("srcbillno");
            long srcBillId = reportData.getLong("srcbillid");
            String srcBillType = reportData.getString("srcbilltype");
            BigDecimal paymentAmount = reportData.getBigDecimal("paymentamount");
            DynamicObject dataEntry = new DynamicObject(type);
            dataEntry.set("srcbillno", (Object)srcBillNo);
            dataEntry.set("srcbillid", (Object)srcBillId);
            dataEntry.set("srcbilltype", (Object)srcBillType);
            dataEntry.set("checkamount", (Object)paymentAmount);
            dataEntry.set("checktime", (Object)currentTime);
            dataEntry.set("checker", (Object)currentUserId);
            dataEntities.add(dataEntry);
            HashMap<String, Object> checkLogMap = new HashMap<String, Object>(3);
            checkLogMap.put("srcbillno", srcBillNo);
            checkLogMap.put("srcbillid", srcBillId);
            checkLogMap.put("srcbilltype", srcBillType);
            lstCheckLog.add(checkLogMap);
        }
        if (!CollectionUtils.isEmpty(dataEntities)) {
            SaveServiceHelper.save((DynamicObject[])dataEntities.toArray(new DynamicObject[0]));
            this.saveCheckConfirmLog(lstCheckLog, "A");
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u786e\u8ba4\u6210\u529f", (String)"ChannelAccountRptForm_5", (String)"occ-occba-report", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }

    private void deleteCheckConfirm(int[] selectedRows, ReportList reportlistap) {
        int rowCount = selectedRows.length;
        HashSet<String> srcBillNos = new HashSet<String>(rowCount);
        HashSet<String> srcBillTypes = new HashSet<String>(rowCount);
        ArrayList<Map<String, Object>> lstCheckLog = new ArrayList<Map<String, Object>>(rowCount);
        ArrayList<String> lstUniqueValues = new ArrayList<String>(rowCount);
        StringBuilder rowStr = new StringBuilder();
        for (int rowIndex : selectedRows) {
            String lineType;
            rowStr.append(rowIndex);
            rowStr.append(",");
            DynamicObject reportData = reportlistap.getReportModel().getRowData(rowIndex);
            if (reportData == null || !StringUtils.equals((CharSequence)(lineType = reportData.getString("linetype")), (CharSequence)"0")) continue;
            String srcBillNo = reportData.getString("srcbillno");
            long srcBillId = reportData.getLong("srcbillid");
            String srcBillType = reportData.getString("srcbilltype");
            String uniqueValues = srcBillNo + "_" + srcBillType;
            if (lstUniqueValues.contains(uniqueValues)) continue;
            lstUniqueValues.add(uniqueValues);
            srcBillNos.add(srcBillNo);
            srcBillTypes.add(srcBillType);
            HashMap<String, Object> checkLogMap = new HashMap<String, Object>(3);
            checkLogMap.put("srcbillno", srcBillNo);
            checkLogMap.put("srcbillid", srcBillId);
            checkLogMap.put("srcbilltype", srcBillType);
            lstCheckLog.add(checkLogMap);
        }
        this.getPageCache().put("selectedRows", rowStr.toString());
        if (CollectionUtils.isEmpty(srcBillNos)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u6570\u636e\u65e0\u9700\u53d6\u6d88\u786e\u8ba4", (String)"ChannelAccountRptForm_6", (String)"occ-occba-report", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
            return;
        }
        QFilter filters = new QFilter("srcbillno", "in", srcBillNos);
        filters.and("srcbilltype", "in", srcBillTypes);
        DynamicObjectCollection checkDatas = QueryServiceHelper.query((String)"occba_checkconfirm", (String)"id", (QFilter[])filters.toArray());
        List idLst = checkDatas.stream().map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"id")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(idLst)) {
            this.saveCheckConfirmLog(lstCheckLog, "B");
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"occba_checkconfirm", (Object[])idLst.toArray(), (OperateOption)option);
            if (!result.isSuccess()) {
                this.getView().showOperationResult(result);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u786e\u8ba4\u6210\u529f", (String)"ChannelAccountRptForm_7", (String)"occ-occba-report", (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u6570\u636e\u5747\u672a\u786e\u8ba4", (String)"ChannelAccountRptForm_8", (String)"occ-occba-report", (Object[])new Object[0]));
        }
        this.getView().invokeOperation("refresh");
    }

    private void saveCheckConfirmLog(List<Map<String, Object>> lstCheckLog, String checkStatus) {
        DynamicObjectType type = (DynamicObjectType)ORM.create().getDataEntityType("occba_checkconfirmlog");
        ArrayList<DynamicObject> checkLogEnities = new ArrayList<DynamicObject>(lstCheckLog.size());
        long currentUserId = UserServiceHelper.getCurrentUserId();
        Date currentTime = TimeServiceHelper.now();
        for (Map<String, Object> checkLogMap : lstCheckLog) {
            DynamicObject checkLogEnitry = new DynamicObject(type);
            checkLogEnitry.set("srcbillno", checkLogMap.get("srcbillno"));
            checkLogEnitry.set("srcbillid", checkLogMap.get("srcbillid"));
            checkLogEnitry.set("srcbilltype", checkLogMap.get("srcbilltype"));
            checkLogEnitry.set("checkstatus", (Object)checkStatus);
            checkLogEnitry.set("checktime", (Object)currentTime);
            checkLogEnitry.set("checker", (Object)currentUserId);
            checkLogEnities.add(checkLogEnitry);
        }
        if (!CollectionUtils.isEmpty(checkLogEnities)) {
            SaveServiceHelper.save((DynamicObject[])checkLogEnities.toArray(new DynamicObject[0]));
        }
    }

    private boolean verifyRptParams(IReportView view) {
        if (RptUtil.isNull(view, "settleorgid_h") || RptUtil.isNull(view, "balancechannelid_h") || RptUtil.isNull(view, "currencyid_h") || RptUtil.isNull(view, "startdate") || RptUtil.isNull(view, "enddate") || RptUtil.isNull(view, "periodtype") || RptUtil.isNull(view, "period")) {
            return false;
        }
        DynamicObject data = this.getModel().getDataEntity();
        Date startDate = data.getDate("startdate");
        Date enddate = data.getDate("enddate");
        if (enddate.before(startDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"ChannelAccountRptForm_9", (String)"occ-occba-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private List<Long> getHasPermissionSettleOrg() {
        List orgIdList = null;
        String idStr = this.getView().getPageCache().get(CACHE_KEY_ORG_IDS);
        if (kd.occ.ocbase.common.util.StringUtils.isEmpty((String)idStr)) {
            String formId = this.getModel().getDataEntity().getDataEntityType().getName();
            HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)UserUtil.getCurrUserId(), (String)"10", (String)"occba", (String)formId, (String)"47150e89000000ac", (boolean)true);
            orgIdList = allPermOrgs.getHasPermOrgs();
            if (CommonUtils.isNull((Object)orgIdList)) {
                orgIdList.add(0L);
            }
            this.getView().getPageCache().put(CACHE_KEY_ORG_IDS, SerializationUtils.toJsonString((Object)orgIdList));
        } else {
            orgIdList = SerializationUtils.fromJsonStringToList((String)idStr, Long.class);
        }
        return orgIdList;
    }

    private void showDetailRpt(HyperLinkClickEvent e) {
        ReportList reportList = (ReportList)e.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(e.getRowIndex());
        String srcBillEntity = DynamicObjectUtils.getStrPkValue((DynamicObject)rowData, (String)"srcbillentity");
        long billId = rowData.getLong("srcbillid");
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(srcBillEntity);
        parameter.setPkId((Object)billId);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private List<Long> getSettleOrgIdList() {
        List<Long> settleOrgIdList;
        if (this.isFromPurRpt()) {
            List<Long> balanceChannelIdList = RptUtil.getBaseDataLongIds(this.getView(), "balancechannelid_h");
            DynamicObjectCollection channelAuthDynObjColl = SaleOrderUtil.getChannelAuthColl(balanceChannelIdList, (String)"A");
            settleOrgIdList = new ArrayList<Long>(16);
            if (!CommonUtils.isNull((Object)channelAuthDynObjColl)) {
                for (DynamicObject dynObj : channelAuthDynObjColl) {
                    long orgId;
                    Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)dynObj.getLong("saleorg"), (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                    if (CollectionUtils.isEmpty((Map)map) || settleOrgIdList.contains(orgId = Long.parseLong(map.get("id").toString()))) continue;
                    settleOrgIdList.add(orgId);
                }
            }
        } else {
            settleOrgIdList = this.getHasPermissionSettleOrg();
        }
        return settleOrgIdList;
    }

    private boolean isFromPurRpt() {
        return "occba_purchlaccount_rpt".equals(this.getModel().getDataEntity().getDataEntityType().getName());
    }

    private long getPreviousPeriodId() {
        long previousPeriodId = 0L;
        Object obj = this.getModel().getValue("period");
        if (obj instanceof DynamicObject) {
            DynamicObject periodDynObj = (DynamicObject)obj;
            int entrySeq = periodDynObj.getInt("entryseq");
            int beforeEntrySeq = entrySeq - 1;
            long periodId = periodDynObj.getLong("periodid");
            if (beforeEntrySeq > 1 || entrySeq > 1) {
                QFilter filter = new QFilter("periodid", "=", (Object)periodId);
                filter.and(new QFilter("entryseq", "=", (Object)beforeEntrySeq));
                DynamicObject dynObj = BusinessDataServiceHelper.loadSingleFromCache((String)"ocdbd_assess_entity", (QFilter[])filter.toArray());
                previousPeriodId = DynamicObjectUtils.getPkValue((DynamicObject)dynObj);
            } else {
                QFilter filter = new QFilter("id", "=", (Object)periodId);
                DynamicObject dynObj = BusinessDataServiceHelper.loadSingleFromCache((String)"ocdbd_assess_period", (QFilter[])filter.toArray());
                int periodYear = DynamicObjectUtils.getInt((DynamicObject)dynObj, (String)"periodyear");
                filter = new QFilter("periodyear", "=", (Object)(periodYear - 1));
                if ((dynObj = BusinessDataServiceHelper.loadSingleFromCache((String)"ocdbd_assess_period", (QFilter[])filter.toArray())) != null) {
                    DynamicObject entryDynObj = dynObj.getDynamicObjectCollection("entity").stream().max(Comparator.comparing(o -> o.getInt("seq"))).get();
                    previousPeriodId = DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj);
                }
            }
        }
        return previousPeriodId;
    }

    private Object[] getSettleOrgIdByRelation() {
        ArrayList<Long> settleOrgIdList = new ArrayList<Long>(16);
        List<Long> balanceChannelIdList = RptUtil.getBaseDataLongIds(this.getView(), "balancechannelid_h");
        for (Long channelId : balanceChannelIdList) {
            Map map;
            DynamicObject channelAuthDynObj = SaleOrderUtil.getDefaultChannelAuthDynObj(null, (Object)channelId, null, (String)"A");
            if (channelAuthDynObj == null || CollectionUtils.isEmpty((Map)(map = OrgUnitServiceHelper.getCompanyByOrg((Long)channelAuthDynObj.getLong("saleorg"), (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)))) continue;
            settleOrgIdList.add(Long.parseLong(map.get("id").toString()));
        }
        return settleOrgIdList.toArray();
    }
}

