/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.report.channelaccount;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.occba.report.channelaccount.ChannelAccountRptParam;
import kd.occ.occba.report.channelaccount.transform.ChannelAccountAddSumRowTransform;
import kd.occ.occba.report.channelaccount.transform.ChannelAccountAfterUnionTransform;
import kd.occ.occba.report.channelaccount.transform.ChannelAccountResultTransform;
import kd.occ.occba.report.util.RptUtil;

public final class ChannelAccountRptHandle
implements IReportDataHandle {
    private ChannelAccountRptParam reportParam;

    public void setupCtx(ReportDataCtx ctx) {
        this.reportParam = (ChannelAccountRptParam)ctx.getParam(ChannelAccountRptParam.class.getName());
        this.setFixedFilter(ctx);
        this.setShowKeyCols(ctx);
        this.setSumKeyCols(ctx);
        this.setShowQtyCols(ctx);
        RptUtil.setChannelAccountHeadFilter(ctx, this.reportParam);
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        for (SrcBlockConf blockConf : blockCollector) {
            blockConf.setAllowNotMatch(true);
            String srcEntity = blockConf.getSrcEntity();
            QFilter dataFs = blockConf.getDataFs();
            switch (srcEntity) {
                case "im_saloutbill": {
                    if (!CommonUtils.isNull(this.reportParam.getSettleCustomerIdList())) break;
                    dataFs.and("1", "=", (Object)0);
                    break;
                }
                case "occba_moneyincome": {
                    this.setMoneyIncomeFilter(dataFs);
                    break;
                }
                case "cas_recbill": {
                    this.setRecBillFilter(dataFs);
                    break;
                }
                case "occba_channelbalance": {
                    this.setChannelBalanceFilter(dataFs);
                    break;
                }
                case "occba_balanceadjust": {
                    List<Long> channelIdList = this.reportParam.getSettleChannelIdList();
                    if (!CommonUtils.isNull(channelIdList)) {
                        dataFs.and(new QFilter(String.join((CharSequence)".", "entryentity", "channel"), "in", channelIdList));
                    }
                    dataFs.and(new QFilter(String.join((CharSequence)".", "entryentity", "accounttype", "accounttype"), "=", (Object)"C"));
                    break;
                }
            }
        }
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("settleorgid");
        repoColFilter.add("balancechannelid");
        repoColFilter.add("balancecustomerid");
        repoColFilter.add("srcbillno");
        repoColFilter.add("srcbillid");
        repoColFilter.add("srcbillentryid");
        repoColFilter.add("srcbillentity");
        repoColFilter.add("srcbilltype");
        repoColFilter.add("payableamount");
        repoColFilter.add("paymentamount");
        repoColFilter.add("balanceamount");
        repoColFilter.add("paymentamounttype");
        repoColFilter.add("remark");
        repoColFilter.add("bizdate");
        repoColFilter.add("accountdate");
        repoColFilter.add("saleorgid");
        repoColFilter.add("orderchannelid");
        repoColFilter.add("salechannelid");
        repoColFilter.add("currencyid");
        repoColFilter.add("srcbillentryseq");
        repoColFilter.add("itemid");
        repoColFilter.add("materialid");
        repoColFilter.add("ispresent");
        repoColFilter.add("unitid");
        repoColFilter.add("qty");
        repoColFilter.add("actualtaxprice");
        repoColFilter.add("ajustamount");
    }

    public void handleBlockDataSelectCols(Set<String> repoColFilter, SrcBlockConf blockConf, ReportDataCtx ctx) {
        String entityKey;
        Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
        switch (entityKey = blockConf.getSrcEntity()) {
            case "im_saloutbill": {
                repoColFullSrcColMap.put("srcbillid", "id");
                repoColFullSrcColMap.put("srcbillentryid", String.join((CharSequence)".", "billentry", "id"));
                repoColFullSrcColMap.put("materialid", String.join((CharSequence)".", "billentry", "material", "masterid"));
                break;
            }
            case "occba_moneyincome": {
                repoColFullSrcColMap.put("srcbillid", "id");
                repoColFullSrcColMap.put("srcbillentryid", String.join((CharSequence)".", "entryentity", "id"));
                repoColFullSrcColMap.put("paymentamounttype", String.join((CharSequence)".", "moneytypeid", "updatetype"));
                break;
            }
            case "cas_recbill": {
                repoColFullSrcColMap.put("srcbillid", "id");
                repoColFullSrcColMap.put("srcbillentryid", String.join((CharSequence)".", "entry", "id"));
                repoColFullSrcColMap.put("balancecustomerid", "payer");
                break;
            }
            case "occba_channelbalance": {
                repoColFullSrcColMap.put("srcbillid", "id");
                break;
            }
            case "occba_balanceadjust": {
                repoColFullSrcColMap.put("srcbillid", "id");
                repoColFullSrcColMap.put("srcbillentryid", String.join((CharSequence)".", "entryentity", "id"));
                break;
            }
            default: {
                repoColFullSrcColMap.put("srcbillid", "id");
            }
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new ChannelAccountAfterUnionTransform(ctx));
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        if (this.reportParam.isOnlyShowRowCount()) {
            transCollector.add(new ChannelAccountAddSumRowTransform());
        }
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new ChannelAccountResultTransform(ctx));
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> columns, ReportDataCtx ctx) {
        for (AbstractReportColumn col : columns) {
            ReportColumn reportCol = (ReportColumn)col;
            String field = reportCol.getFieldKey();
            if (!"srcbillno".equals(field) || this.reportParam.isFromPurRpt()) continue;
            reportCol.setHyperlink(true);
        }
        return columns;
    }

    private void setFixedFilter(ReportDataCtx ctx) {
        ArrayList fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            fixedFs = new ArrayList();
            ctx.setFixedFs(fixedFs);
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(5);
        List<Long> orgIdList = this.reportParam.getSettleOrgIdList();
        filterList.add(orgIdList.size() == 1 ? new QFilter("settleorgid", "=", (Object)orgIdList.get(0)) : new QFilter("settleorgid", "in", orgIdList));
        List<Long> customerIdList = this.reportParam.getSettleCustomerIdList();
        if (!CommonUtils.isNull(customerIdList)) {
            filterList.add(customerIdList.size() == 1 ? new QFilter("balancecustomerid", "=", (Object)customerIdList.get(0)) : new QFilter("balancecustomerid", "in", customerIdList));
        }
        filterList.add(new QFilter("currencyid", "=", (Object)this.reportParam.getCurrencyId()));
        QFilter bizDateFilter = new QFilter("bizdate", ">=", (Object)this.reportParam.getFromDate()).and("bizdate", "<", (Object)this.reportParam.getToDate());
        filterList.add(bizDateFilter);
        fixedFs.addAll(filterList);
    }

    private void setShowKeyCols(ReportDataCtx ctx) {
        Set showKeyColSet = ctx.getShowKeyCols();
        showKeyColSet.add("srcbillid");
        showKeyColSet.add("srcbillentity");
        showKeyColSet.add("accountdate");
        showKeyColSet.add("saleorgid");
        showKeyColSet.add("orderchannelid");
        showKeyColSet.add("salechannelid");
        showKeyColSet.add("checkstatus");
        if (this.reportParam.isShowBillDetail()) {
            showKeyColSet.add("srcbillentryid");
            showKeyColSet.add("srcbillentryseq");
            showKeyColSet.add("materialid");
            showKeyColSet.add("ispresent");
            showKeyColSet.add("unitid");
            showKeyColSet.add("qty");
            showKeyColSet.add("actualtaxprice");
        }
    }

    private void setSumKeyCols(ReportDataCtx ctx) {
        Set sumKeyColSet = ctx.getSumKeyCols();
        sumKeyColSet.add("settleorgid");
        sumKeyColSet.add("balancechannelid");
        sumKeyColSet.add("balancecustomerid");
        sumKeyColSet.add("currencyid");
        ctx.setSumKeyCols4Count(sumKeyColSet);
    }

    private void setShowQtyCols(ReportDataCtx ctx) {
        Set qtyCols = ctx.getShowQtyCols();
        qtyCols.add("payableamount");
        qtyCols.add("paymentamount");
        qtyCols.add("balanceamount");
        qtyCols.add("ajustamount");
        ctx.setSumQtyCols4Count(qtyCols);
    }

    private void setMoneyIncomeFilter(QFilter dataFs) {
        List<Long> channelIdList = this.reportParam.getSettleChannelIdList();
        if (!CommonUtils.isNull(channelIdList)) {
            dataFs.and(channelIdList.size() == 1 ? new QFilter("paychannelid", "=", (Object)channelIdList.get(0)) : new QFilter("paychannelid", "in", channelIdList));
        }
    }

    private void setRecBillFilter(QFilter dataFs) {
        List<Long> settleCustomerIdList = this.reportParam.getSettleCustomerIdList();
        if (CommonUtils.isNull(settleCustomerIdList)) {
            dataFs.and("1", "=", (Object)0);
        } else {
            dataFs.and(settleCustomerIdList.size() == 1 ? new QFilter("payer", "=", (Object)settleCustomerIdList.get(0)) : new QFilter("payer", "in", settleCustomerIdList));
        }
    }

    private void setChannelBalanceFilter(QFilter dataFs) {
        List<Long> channelIdList = this.reportParam.getSettleChannelIdList();
        if (!CommonUtils.isNull(channelIdList)) {
            if (channelIdList.size() == 1) {
                dataFs.and(new QFilter("channelid", "=", (Object)channelIdList.get(0)));
            } else {
                dataFs.and(new QFilter("channelid", "in", channelIdList));
            }
        }
        dataFs.and(new QFilter(String.join((CharSequence)".", "accountid", "accounttype"), "=", (Object)"C"));
        dataFs.and(new QFilter("periodid", "=", (Object)this.reportParam.getPreviousPeriodId()));
    }
}

