/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.report.channelaccount.transform;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;

public class ChannelAccountResultTransform
implements IDataTransform {
    private Set<String> sumKeyCols;

    public ChannelAccountResultTransform(ReportDataCtx ctx) {
        this.sumKeyCols = ctx.getSumKeyCols();
    }

    public DataSet doTransform(DataSet srcData) {
        HashSet<Long> srcBillIds = new HashSet<Long>(0);
        HashSet<String> srcBillTypes = new HashSet<String>(0);
        ArrayList<String> lstUniqueValues = new ArrayList<String>(0);
        DataSet copySrcData = srcData.copy();
        for (Row rowData : copySrcData) {
            String lineType = rowData.getString("linetype");
            if (!StringUtils.equals((CharSequence)lineType, (CharSequence)"0")) continue;
            long srcBillId = rowData.getLong("srcbillid");
            String srcBillType = rowData.getString("srcbilltype");
            String uniqueValues = srcBillId + "_" + srcBillType;
            if (lstUniqueValues.contains(uniqueValues)) continue;
            lstUniqueValues.add(uniqueValues);
            srcBillIds.add(srcBillId);
            srcBillTypes.add(srcBillType);
        }
        QFilter filters = new QFilter("srcbillid", "in", srcBillIds);
        filters.and("srcbilltype", "in", srcBillTypes);
        String selectFields = "srcbillid as billid,srcbilltype";
        DataSet checkDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"occba_checkconfirm", (String)selectFields, (QFilter[])filters.toArray(), null);
        checkDataSet = checkDataSet.distinct();
        srcData = srcData.leftJoin(checkDataSet).on("srcbillid", "billid").on("srcbilltype", "srcbilltype").select(srcData.getRowMeta().getFieldNames(), new String[]{"billid"}).finish();
        srcData = srcData.updateField("checkstatus", "case when linetype <> '0' then '' when billid is null then '0' else '1' end");
        LinkedList<String> orderByFields = new LinkedList<String>();
        orderByFields.add(String.join((CharSequence)" ", "settleorgid", "desc"));
        orderByFields.add(String.join((CharSequence)" ", "balancecustomerid", "desc"));
        for (String key : this.sumKeyCols) {
            if ("settleorgid".equals(key) || "balancecustomerid".equals(key)) continue;
            orderByFields.add(key + " asc");
        }
        orderByFields.add(String.join((CharSequence)" ", "linetype", "asc"));
        orderByFields.add(String.join((CharSequence)" ", "bizdate", "asc"));
        orderByFields.add(String.join((CharSequence)" ", "srcbillno", "asc"));
        return srcData.orderBy(orderByFields.toArray(new String[0]));
    }
}

