/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.report.channelaccount.transform.func;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bplat.scmc.report.util.TransformUtil;
import kd.occ.ocbase.common.util.Convert;
import kd.occ.occba.report.channelaccount.ChannelAccountRptParam;

public class ChannelAccountColumnMapFunc
extends MapFunction {
    private static final long serialVersionUID = 100000009999L;
    private RowMeta rowMeta;
    private Map<String, Integer> indexs;
    private ChannelAccountRptParam reportParam;

    public ChannelAccountColumnMapFunc(RowMeta rowMeta, ChannelAccountRptParam reportParam) {
        this.rowMeta = rowMeta;
        this.indexs = this.buildIndexs();
        this.reportParam = reportParam;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX rowX) {
        BigDecimal payableAmount = rowX.getBigDecimal(this.indexs.get("payableamount").intValue());
        int paymentAmountIndex = this.indexs.get("paymentamount");
        BigDecimal paymentAmount = rowX.getBigDecimal(paymentAmountIndex);
        String paymentAmountType = rowX.getString(this.indexs.get("paymentamounttype").intValue());
        if ("1".equals(paymentAmountType)) {
            paymentAmount = paymentAmount.negate();
            rowX.set(paymentAmountIndex, (Object)paymentAmount);
        }
        String remark = rowX.getString(this.indexs.get("remark").intValue());
        boolean isInit = "occba_channelbalance".equals(remark);
        BigDecimal initBalanceAmount = rowX.getBigDecimal(this.indexs.get("initbalanceamount").intValue());
        BigDecimal ajustAmount = rowX.getBigDecimal(this.indexs.get("ajustamount").intValue());
        BigDecimal amount = isInit ? initBalanceAmount : payableAmount.subtract(paymentAmount).subtract(ajustAmount);
        rowX.set(this.indexs.get("balanceamount").intValue(), (Object)amount);
        Long balanceChannelId = rowX.getLong(this.indexs.get("balancechannelid").intValue());
        if (Convert.toLong((Object)balanceChannelId) == 0L) {
            rowX.set(this.indexs.get("balancechannelid").intValue(), (Object)this.reportParam.getSettleCustomerIdMap().get(rowX.getLong(this.indexs.get("balancecustomerid").intValue())));
        }
        return rowX;
    }

    private Map<String, Integer> buildIndexs() {
        ArrayList<String> columns = new ArrayList<String>(5);
        columns.add("balancechannelid");
        columns.add("balancecustomerid");
        columns.add("payableamount");
        columns.add("paymentamount");
        columns.add("paymentamounttype");
        columns.add("balanceamount");
        columns.add("initbalanceamount");
        columns.add("ajustamount");
        columns.add("remark");
        return TransformUtil.buildIndexs((RowMeta)this.rowMeta, columns);
    }
}

