/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.report.rebateaccount;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.occ.ocbase.common.util.CollectionUtil;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.occba.report.rebateaccount.RebateAccountParamVo;

public class RebateAccountRptDataTransform
implements IDataTransform {
    private static final String COLS_REBATE_ACCOUNT = String.join((CharSequence)",", "id", "org", "channel", "receivechannel", "customer", "type", "accounttype", "availablebalance", "setcurrency", "occupyamount", "balance");
    private static final String QUERY_COLS = String.join((CharSequence)",", "id", "org", "channel", "customer", "stmcurrency", "accout");
    private static final String QUERY_FLOW_COLS = String.join((CharSequence)",", "id", "org", "channel", "customer", "stmcurrency", "accout", "afteramount");
    List<RebateAccountParamVo> paramList;

    public RebateAccountRptDataTransform(ReportDataCtx ctx, List<RebateAccountParamVo> paramList) {
        this.paramList = paramList;
    }

    public DataSet doTransform(DataSet srcData) {
        RebateAccountParamVo param;
        List<Long> recordIdList = this.getRecentRecordIdList(this.paramList);
        QFilter filter = new QFilter("id", "in", recordIdList);
        DataSet recordDataSet = QueryServiceHelper.queryDataSet((String)RebateAccountRptDataTransform.class.getName(), (String)"occba_flowrecord", (String)QUERY_FLOW_COLS, (QFilter[])filter.toArray(), null).distinct();
        String[] names = srcData.getRowMeta().getFieldNames();
        String[] copyNames = this.copyRowMetaFieldNames(names, "beginamount");
        srcData = srcData.leftJoin(recordDataSet).on("org", "org").on("channel", "channel").on("customer", "customer").on("currency", "stmcurrency").on("accounttype", "accout").select(copyNames, new String[]{"afteramount beginamount"}).finish();
        copyNames = this.copyRowMetaFieldNames(names, "rebateaccount");
        DataSet rebateAccountDataSet = this.queryRebateAccountDataSet(this.paramList);
        srcData = srcData.leftJoin(rebateAccountDataSet).on("org", "org").on("channel", "channel").on("customer", "customer").on("currency", "setcurrency").on("pooltype", "type").on("accounttype", "accounttype").select(copyNames, new String[]{"id rebateaccount", "balance balance", "availablebalance availablebalance", "occupyamount occupyamount"}).finish();
        srcData = srcData.updateField("lastamount", String.join((CharSequence)"+", "beginamount", "incomeamount", "orderapplyamount", "returnbillamount", "adjustamount"));
        srcData = srcData.updateField("notincludeadjustamount", String.join((CharSequence)"+", "beginamount", "incomeamount", "orderapplyamount", "returnbillamount"));
        if (CollectionUtil.isNotNull(this.paramList) && (param = this.paramList.get(0)).getEndDate() != null && !param.getEndDate().before(DateUtil.getDayFirst((Date)TimeServiceHelper.now()))) {
            srcData = srcData.updateField("differentamount", String.join((CharSequence)"-", "lastamount", "balance"));
            srcData = srcData.updateField("notinadjdiffamount", String.join((CharSequence)"-", "notincludeadjustamount", "balance"));
        }
        return srcData;
    }

    private List<Long> getRecentRecordIdList(List<RebateAccountParamVo> paramList) {
        QFilter paramFilter = this.buildRecordFilter(paramList);
        DataSet recordSet = QueryServiceHelper.queryDataSet((String)RebateAccountRptDataTransform.class.getName(), (String)"occba_flowrecord", (String)QUERY_COLS, (QFilter[])paramFilter.toArray(), (String)(String.join((CharSequence)",", "org", "channel", "customer", "stmcurrency", "accout", "createtime") + " desc"));
        ArrayList<Long> recordIdList = new ArrayList<Long>(10);
        ArrayList<String> groupKey = new ArrayList<String>(10);
        if (!recordSet.isEmpty()) {
            for (Row row : recordSet) {
                String key = this.getGroupKey(row);
                if (groupKey.contains(key)) continue;
                recordIdList.add(row.getLong("id"));
                groupKey.add(key);
            }
        }
        return recordIdList;
    }

    private String[] copyRowMetaFieldNames(String[] names, String fieldName) {
        String[] copyNames = new String[names.length - 1];
        int index = 0;
        for (int i = 0; i < names.length; ++i) {
            if (fieldName.equalsIgnoreCase(names[i])) continue;
            copyNames[index] = names[i];
            ++index;
        }
        return copyNames;
    }

    private QFilter buildRecordFilter(List<RebateAccountParamVo> paramList) {
        QFilter paramFilter = new QFilter("1", "!=", (Object)1);
        int index = 0;
        HashSet<Long> billIds = new HashSet<Long>(0);
        for (RebateAccountParamVo reportQueryParam : paramList) {
            QFilter filter = new QFilter("stmcurrency", "=", (Object)reportQueryParam.getCurrencyId());
            filter.and("customer", "=", (Object)reportQueryParam.getCustomerId());
            filter.and("org", "=", (Object)reportQueryParam.getOrgId());
            filter.and("channel", "=", (Object)reportQueryParam.getChannelId());
            filter.and("accout", "=", (Object)reportQueryParam.getAccountTypeId());
            if (reportQueryParam.getBeginDate() != null) {
                filter.and("createtime", "<=", (Object)DateUtil.getDayFirst((Date)reportQueryParam.getBeginDate()));
            }
            paramFilter.or(filter);
            if (++index != 300) continue;
            this.getBillIds("occba_flowrecord", "", billIds, paramFilter);
            index = 0;
            paramFilter = new QFilter("1", "!=", (Object)1);
        }
        this.getBillIds("occba_flowrecord", "", billIds, paramFilter);
        paramFilter = billIds.size() > 0 ? new QFilter("id", "in", billIds) : new QFilter("1", "!=", (Object)1);
        return paramFilter;
    }

    private void getBillIds(String entityName, String entryEntityName, Set<Long> billIds, QFilter filter) {
        DataSet ds;
        HashSet<Long> ids = new HashSet<Long>(0);
        String selectFields = "id";
        if (StringUtils.isNotEmpty((CharSequence)entryEntityName)) {
            selectFields = String.join((CharSequence)",", selectFields, String.format("%s.id as entryId ", entryEntityName));
        }
        if ((ds = QueryServiceHelper.queryDataSet((String)entityName, (String)entityName, (String)selectFields, (QFilter[])filter.toArray(), (String)"")) != null) {
            while (ds.hasNext()) {
                Row row = ds.next();
                if (StringUtils.isNotEmpty((CharSequence)entryEntityName)) {
                    ids.add(row.getLong("entryId"));
                    continue;
                }
                ids.add(row.getLong("id"));
            }
            billIds.addAll(ids);
        }
    }

    private String getGroupKey(Row row) {
        return String.format("%d_%d_%d_%d_%d", row.getLong("org"), row.getLong("channel"), row.getLong("customer"), row.getLong("accout"), row.getLong("stmcurrency"));
    }

    private DataSet queryRebateAccountDataSet(List<RebateAccountParamVo> paramList) {
        QFilter paramFilter = new QFilter("1", "!=", (Object)1);
        int index = 0;
        HashSet<Long> billIds = new HashSet<Long>(0);
        for (RebateAccountParamVo reportQueryParam : paramList) {
            QFilter filter = new QFilter("org", "=", (Object)reportQueryParam.getOrgId());
            filter.and("type", "=", (Object)reportQueryParam.getPoolType());
            filter.and("channel", "=", (Object)reportQueryParam.getChannelId());
            filter.and("customer", "=", (Object)reportQueryParam.getCustomerId());
            filter.and("setcurrency", "=", (Object)reportQueryParam.getCurrencyId());
            filter.and("accounttype", "=", (Object)reportQueryParam.getAccountTypeId());
            filter.and("receivechannel", "=", (Object)0L);
            paramFilter.or(filter);
            if (++index != 300) continue;
            this.getBillIds("ocdbd_rebateaccount", "", billIds, paramFilter);
            index = 0;
            paramFilter = new QFilter("1", "!=", (Object)1);
        }
        paramFilter = billIds.size() > 0 ? new QFilter("id", "in", billIds) : new QFilter("1", "!=", (Object)1);
        return QueryServiceHelper.queryDataSet((String)RebateAccountRptDataTransform.class.getName(), (String)"ocdbd_rebateaccount", (String)COLS_REBATE_ACCOUNT, (QFilter[])paramFilter.toArray(), null);
    }
}

