/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.report.rebateaccount;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.occba.report.rebateaccount.RebateAccountParamVo;

public class RebateAccountRptForm
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String CTL_REPORTLISTAP = "reportlistap";
    private static final String BTN_QUERYRECORD = "queryrecord";
    private static final String TB_TOOLBARAP = "toolbarap";
    private static final String BTN_QUERYBILLACCOUNTRECORD = "querybillaccountrecord";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initDateTime();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        ReportList reportlistap = (ReportList)this.getView().getControl(CTL_REPORTLISTAP);
        AbstractGrid.GridState entryState = reportlistap.getEntryState();
        int[] selectedRows = entryState.getSelectedRows();
        switch (evt.getItemKey()) {
            case "queryrecord": {
                if (selectedRows == null || selectedRows.length == 0 || selectedRows.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"RebateAccountRptForm_0", (String)"occ-occba-report", (Object[])new Object[0]));
                    break;
                }
                DynamicObject reportData = reportlistap.getReportModel().getRowData(selectedRows[0]);
                ListFilterParameter listFilterParameter = this.buildListFilterParameter(reportData);
                ListShowParameter parameter = this.buildListShowParameter(listFilterParameter);
                parameter.setListFilterParameter(listFilterParameter);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "querybillaccountrecord": {
                if (selectedRows == null || selectedRows.length == 0 || selectedRows.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"RebateAccountRptForm_0", (String)"occ-occba-report", (Object[])new Object[0]));
                    break;
                }
                DynamicObject chooseReportData = reportlistap.getReportModel().getRowData(selectedRows[0]);
                this.showAccountDetailRptForm(chooseReportData);
                break;
            }
        }
    }

    private ListShowParameter buildListShowParameter(ListFilterParameter listFilterParameter) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("bos_list");
        parameter.setBillFormId("occba_flowrecord");
        parameter.setListFilterParameter(listFilterParameter);
        return parameter;
    }

    private ListFilterParameter buildListFilterParameter(DynamicObject reportData) {
        Date beginDate = (Date)this.getModel().getValue("begindate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(new QFilter("org", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)reportData, (String)"org")));
        listFilterParameter.setFilter(new QFilter("customer", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)reportData, (String)"customer")));
        listFilterParameter.setFilter(new QFilter("channel", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)reportData, (String)"channel")));
        listFilterParameter.setFilter(new QFilter("accout", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)reportData, (String)"accounttype")));
        listFilterParameter.setFilter(new QFilter("stmcurrency", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)reportData, (String)"currency")));
        listFilterParameter.setFilter(new QFilter("createtime", ">=", (Object)DateUtil.getDayFirst((Date)beginDate)));
        listFilterParameter.setFilter(new QFilter("createtime", "<=", (Object)DateUtil.getDayLast2((Date)endDate)));
        listFilterParameter.setFilter(new QFilter("receivechannel", "=", (Object)0L));
        return listFilterParameter;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportlist = (ReportList)this.getView().getControl(CTL_REPORTLISTAP);
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{TB_TOOLBARAP});
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String key = e.getFieldName();
        if ("lastamount".equalsIgnoreCase(key)) {
            this.showDetailRpt(e);
        }
    }

    private void showDetailRpt(HyperLinkClickEvent e) {
        ReportList reportList = (ReportList)e.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(e.getRowIndex());
        this.showAccountDetailRptForm(rowData);
    }

    private void showAccountDetailRptForm(DynamicObject rowData) {
        Map<String, Object> paramMap = this.buildParamMap(rowData);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("occba_rebaterecord_rpt");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("rebateDetailRptParam", paramMap);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private Map<String, Object> buildParamMap(DynamicObject rowData) {
        Date beginDate = (Date)this.getModel().getValue("begindate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("org", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)rowData, (String)"org"));
        paramMap.put("channel", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)rowData, (String)"channel"));
        paramMap.put("currency", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)rowData, (String)"currency"));
        paramMap.put("customer", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)rowData, (String)"customer"));
        paramMap.put("pooltype", DynamicObjectUtils.getString((DynamicObject)rowData, (String)"pooltype"));
        paramMap.put("accounttype", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)rowData, (String)"accounttype"));
        paramMap.put("beginDate", beginDate);
        paramMap.put("endDate", endDate);
        paramMap.put("balance", rowData.getBigDecimal("lastamount"));
        paramMap.put("rebateaccount", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)rowData, (String)"rebateaccount"));
        paramMap.put("beginamount", DynamicObjectUtils.getBigDecimal((DynamicObject)rowData, (String)"beginamount"));
        paramMap.put("differentamount", rowData.getBigDecimal("differentamount"));
        return paramMap;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        ReportQueryParam param = this.getQueryParam();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        List accountIdList = (List)showParameter.getCustomParam("accountIdList");
        List<RebateAccountParamVo> rebateAccountParamList = this.buildRebateAccountParams(accountIdList);
        param.getCustomParam().put(RebateAccountParamVo.class.getName(), rebateAccountParamList);
        super.beforeQuery(queryParam);
    }

    private List<RebateAccountParamVo> buildRebateAccountParams(List<Object> accountIdList) {
        QFilter filter = new QFilter("id", "in", accountIdList);
        String selectProperties = String.join((CharSequence)",", "org", "customer", "channel", "accounttype", "receivechannel", "setcurrency", "type");
        DynamicObject[] accountInfoList = BusinessDataServiceHelper.load((String)"ocdbd_rebateaccount", (String)selectProperties, (QFilter[])filter.toArray());
        ArrayList<RebateAccountParamVo> rebateAccountParamList = new ArrayList<RebateAccountParamVo>(accountInfoList.length);
        Date beginDate = (Date)this.getModel().getValue("begindate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        for (DynamicObject accountInfo : accountInfoList) {
            RebateAccountParamVo param = new RebateAccountParamVo();
            param.setEndDate(DateUtil.getDayFirst((Date)endDate));
            param.setBeginDate(DateUtil.getDayFirst((Date)beginDate));
            param.setOrgId(DynamicObjectUtils.getPkValue((DynamicObject)accountInfo, (String)"org"));
            param.setPoolType(DynamicObjectUtils.getString((DynamicObject)accountInfo, (String)"type"));
            param.setChannelId(DynamicObjectUtils.getPkValue((DynamicObject)accountInfo, (String)"channel"));
            param.setCustomerId(DynamicObjectUtils.getPkValue((DynamicObject)accountInfo, (String)"customer"));
            param.setCurrencyId(DynamicObjectUtils.getPkValue((DynamicObject)accountInfo, (String)"setcurrency"));
            param.setAccountTypeId(DynamicObjectUtils.getPkValue((DynamicObject)accountInfo, (String)"accounttype"));
            rebateAccountParamList.add(param);
        }
        return rebateAccountParamList;
    }

    private void initDateTime() {
        Date nowDate = KDDateUtils.now();
        this.getModel().setValue("begindate", (Object)DateUtil.getFirstDayOfMonth((Date)nowDate));
        this.getModel().setValue("enddate", (Object)nowDate);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        Date date = (Date)filterInfo.getValue("begindate");
        if (date == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f00\u59cb\u65e5\u671f\u3002", (String)"RebateAccountRptForm_1", (String)"occ-occba-report", (Object[])new Object[0]));
            return false;
        }
        date = (Date)filterInfo.getValue("enddate");
        if (date == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ed3\u675f\u65e5\u671f\u3002", (String)"RebateAccountRptForm_2", (String)"occ-occba-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

