/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.report.rebateaccount;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.occba.report.rebateaccount.RebateAccountDataXTransform;
import kd.occ.occba.report.rebateaccount.RebateAccountParamVo;
import kd.occ.occba.report.rebateaccount.RebateAccountResultTransform;
import kd.occ.occba.report.rebateaccount.RebateAccountRptDataTransform;
import kd.occ.occba.report.rebateaccount.RebateAccountRptRecordAmountTransform;
import kd.occ.occba.report.rebateaccount.RebateAccountUnionXTransform;

public class RebateAccountRptHandle
implements IReportDataHandle {
    public void setupCtx(ReportDataCtx ctx) {
        Set showKeyColSet = ctx.getShowKeyCols();
        showKeyColSet.add("billentity");
        showKeyColSet.add("billno");
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("balance");
        repoColFilter.add("recordamount");
        repoColFilter.add("occupyamount");
        repoColFilter.add("rebateaccount");
        repoColFilter.add("multipleamount");
        repoColFilter.add("recordmultiple");
        repoColFilter.add("availablebalance");
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new RebateAccountUnionXTransform());
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new RebateAccountDataXTransform(ctx));
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        List paramList = (List)ctx.getParam(RebateAccountParamVo.class.getName());
        transCollector.add(new RebateAccountRptRecordAmountTransform(ctx, paramList));
        transCollector.add(new RebateAccountRptDataTransform(ctx, paramList));
        transCollector.add(new RebateAccountResultTransform(ctx, paramList));
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        List paramList = (List)ctx.getParam(RebateAccountParamVo.class.getName());
        Map<String, String> colNameMap = this.getReportColConfig();
        int maxDetailCnt = 500000;
        for (SrcBlockConf blockConf : blockCollector) {
            blockConf.setAllowNotMatch(true);
            String srcEntity = blockConf.getSrcEntity();
            QFilter dataFs = blockConf.getDataFs();
            if (dataFs == null) {
                dataFs = new QFilter("1", "=", (Object)1);
            }
            switch (srcEntity) {
                case "ocbsoc_saleorder": {
                    maxDetailCnt = this.setSaleOrderFilter(paramList, dataFs, colNameMap.get("ocbsoc_saleorder"), maxDetailCnt);
                    break;
                }
                case "ocbsoc_returnorder": {
                    maxDetailCnt = this.setReturnOrderFilter(paramList, dataFs, colNameMap.get("ocbsoc_returnorder"), maxDetailCnt);
                    break;
                }
                case "occba_balanceadjust": {
                    maxDetailCnt = this.setBalanceAdjustFilter(paramList, dataFs, colNameMap.get("occba_balanceadjust"), maxDetailCnt);
                    break;
                }
                case "occba_moneyincome": {
                    maxDetailCnt = this.setMoneyIncomeFilter(paramList, dataFs, colNameMap.get("occba_moneyincome"), maxDetailCnt);
                    break;
                }
                case "occba_flowrecord": {
                    maxDetailCnt = this.setFlowRecordFilter(paramList, dataFs, maxDetailCnt);
                    break;
                }
                case "ocdbd_rebateaccount": {
                    maxDetailCnt = this.setRebateAccountFilter(paramList, dataFs, maxDetailCnt);
                    break;
                }
            }
        }
    }

    private Map<String, String> getReportColConfig() {
        DynamicObject rptColCfg = BusinessDataServiceHelper.loadSingle((Object)1555787018360081408L, (String)"occba_rebateactrpt_colcfg");
        DynamicObjectCollection configDetail = rptColCfg.getDynamicObjectCollection("entryentity");
        HashMap<String, String> colNameMap = new HashMap<String, String>(5);
        for (DynamicObject colConfig : configDetail) {
            colNameMap.put(DynamicObjectUtils.getString((DynamicObject)colConfig.getDynamicObject("srcentity"), (String)"number"), colConfig.getString("datatimecol"));
        }
        return colNameMap;
    }

    private int setRebateAccountFilter(List<RebateAccountParamVo> paramList, QFilter dataFilter, int maxDetailCnt) {
        int batchCnt = 0;
        HashSet<Long> billIds = new HashSet<Long>(0);
        QFilter paramFilter = new QFilter("1", "!=", (Object)1);
        for (RebateAccountParamVo reportQueryParam : paramList) {
            QFilter filter = new QFilter("org", "=", (Object)reportQueryParam.getOrgId());
            filter.and("type", "=", (Object)reportQueryParam.getPoolType());
            filter.and("channel", "=", (Object)reportQueryParam.getChannelId());
            filter.and("customer", "=", (Object)reportQueryParam.getCustomerId());
            filter.and("setcurrency", "=", (Object)reportQueryParam.getCurrencyId());
            filter.and("accounttype", "=", (Object)reportQueryParam.getAccountTypeId());
            filter.and("receivechannel", "=", (Object)0L);
            paramFilter.or(filter);
            if (++batchCnt != 300) continue;
            maxDetailCnt = this.getBillIds("ocdbd_rebateaccount", "", billIds, maxDetailCnt, paramFilter);
            batchCnt = 0;
            paramFilter = new QFilter("1", "!=", (Object)1);
        }
        maxDetailCnt = this.getBillIds("ocdbd_rebateaccount", "", billIds, maxDetailCnt, paramFilter);
        if (billIds.size() > 0) {
            dataFilter.and("id", "in", billIds);
        } else {
            dataFilter.and("id", "=", (Object)0L);
        }
        return maxDetailCnt;
    }

    private int setFlowRecordFilter(List<RebateAccountParamVo> paramList, QFilter dataFilter, int maxDetailCnt) {
        int batchCnt = 0;
        HashSet<Long> billIds = new HashSet<Long>(0);
        QFilter paramFilter = new QFilter("1", "!=", (Object)1);
        for (RebateAccountParamVo reportQueryParam : paramList) {
            QFilter filter = new QFilter("stmcurrency", "=", (Object)reportQueryParam.getCurrencyId());
            filter.and("customer", "=", (Object)reportQueryParam.getCustomerId());
            filter.and("org", "=", (Object)reportQueryParam.getOrgId());
            filter.and("channel", "=", (Object)reportQueryParam.getChannelId());
            filter.and("accout", "=", (Object)reportQueryParam.getAccountTypeId());
            paramFilter.or(filter);
            if (++batchCnt != 300) continue;
            maxDetailCnt = this.getBillIds("occba_flowrecord", "", billIds, maxDetailCnt, paramFilter);
            batchCnt = 0;
            paramFilter = new QFilter("1", "!=", (Object)1);
        }
        maxDetailCnt = this.getBillIds("occba_flowrecord", "", billIds, maxDetailCnt, paramFilter);
        if (billIds.size() > 0) {
            dataFilter.and("id", "in", billIds);
        } else {
            dataFilter.and("id", "=", (Object)0L);
        }
        return maxDetailCnt;
    }

    private int setMoneyIncomeFilter(List<RebateAccountParamVo> paramList, QFilter dataFilter, String dateTimeColName, int maxDetailCnt) {
        int batchCnt = 0;
        HashSet<Long> entryIds = new HashSet<Long>(0);
        QFilter paramFilter = new QFilter("1", "!=", (Object)1);
        for (RebateAccountParamVo reportQueryParam : paramList) {
            QFilter filter = new QFilter("currencyid", "=", (Object)reportQueryParam.getCurrencyId());
            filter.and("paycustomerid", "=", (Object)reportQueryParam.getCustomerId());
            filter.and(String.join((CharSequence)".", "entryentity", "settleorgid"), "=", (Object)reportQueryParam.getOrgId());
            filter.and("paychannelid", "=", (Object)reportQueryParam.getChannelId());
            filter.and("moneyaccountid", "=", (Object)reportQueryParam.getAccountTypeId());
            if (reportQueryParam.getBeginDate() != null) {
                filter.and(dateTimeColName, ">=", (Object)DateUtil.getDayFirst((Date)reportQueryParam.getBeginDate()));
            }
            if (reportQueryParam.getEndDate() != null) {
                filter.and(dateTimeColName, "<=", (Object)DateUtil.getDayLast2((Date)reportQueryParam.getEndDate()));
            }
            paramFilter.or(filter);
            if (++batchCnt != 300) continue;
            maxDetailCnt = this.getBillIds("occba_moneyincome", "entryentity", entryIds, maxDetailCnt, paramFilter);
            batchCnt = 0;
            paramFilter = new QFilter("1", "!=", (Object)1);
        }
        maxDetailCnt = this.getBillIds("occba_moneyincome", "entryentity", entryIds, maxDetailCnt, paramFilter);
        if (entryIds.size() > 0) {
            dataFilter.and(String.join((CharSequence)".", "entryentity", "id"), "in", entryIds);
        } else {
            dataFilter.and("id", "=", (Object)0L);
        }
        return maxDetailCnt;
    }

    private int setBalanceAdjustFilter(List<RebateAccountParamVo> paramList, QFilter dataFilter, String dateTimeColName, int maxDetailCnt) {
        int batchCnt = 0;
        HashSet<Long> entryIds = new HashSet<Long>(0);
        QFilter paramFilter = new QFilter("1", "!=", (Object)1);
        for (RebateAccountParamVo reportQueryParam : paramList) {
            QFilter filter = new QFilter("org", "=", (Object)reportQueryParam.getOrgId());
            filter.and(String.join((CharSequence)".", "entryentity", "currency"), "=", (Object)reportQueryParam.getCurrencyId());
            filter.and(String.join((CharSequence)".", "entryentity", "customer"), "=", (Object)reportQueryParam.getCustomerId());
            filter.and(String.join((CharSequence)".", "entryentity", "channel"), "=", (Object)reportQueryParam.getChannelId());
            filter.and(String.join((CharSequence)".", "entryentity", "accounttype"), "=", (Object)reportQueryParam.getAccountTypeId());
            if (reportQueryParam.getBeginDate() != null) {
                filter.and(dateTimeColName, ">=", (Object)DateUtil.getDayFirst((Date)reportQueryParam.getBeginDate()));
            }
            if (reportQueryParam.getEndDate() != null) {
                filter.and(dateTimeColName, "<=", (Object)DateUtil.getDayLast2((Date)reportQueryParam.getEndDate()));
            }
            paramFilter.or(filter);
            if (++batchCnt != 300) continue;
            maxDetailCnt = this.getBillIds("occba_balanceadjust", "entryentity", entryIds, maxDetailCnt, paramFilter);
            batchCnt = 0;
            paramFilter = new QFilter("1", "!=", (Object)1);
        }
        maxDetailCnt = this.getBillIds("occba_balanceadjust", "entryentity", entryIds, maxDetailCnt, paramFilter);
        if (entryIds.size() > 0) {
            dataFilter.and(String.join((CharSequence)".", "entryentity", "id"), "in", entryIds);
        } else {
            dataFilter.and("id", "=", (Object)0L);
        }
        return maxDetailCnt;
    }

    private int setReturnOrderFilter(List<RebateAccountParamVo> paramList, QFilter dataFilter, String dateTimeColName, int maxDetailCnt) {
        int batchCnt = 0;
        HashSet<Long> entryIds = new HashSet<Long>(0);
        QFilter filters = new QFilter("1", "!=", (Object)1);
        for (RebateAccountParamVo reportQueryParam : paramList) {
            QFilter filter = new QFilter("settleorgid", "=", (Object)reportQueryParam.getOrgId());
            filter.and("settlecurrencyid", "=", (Object)reportQueryParam.getCurrencyId());
            filter.and("customerid", "=", (Object)reportQueryParam.getCustomerId());
            filter.and("balancechannelid", "=", (Object)reportQueryParam.getChannelId());
            filter.and(String.join((CharSequence)".", "recentryentity", "accounttypeid"), "=", (Object)reportQueryParam.getAccountTypeId());
            if (reportQueryParam.getBeginDate() != null) {
                filter.and(dateTimeColName, ">=", (Object)DateUtil.getDayFirst((Date)reportQueryParam.getBeginDate()));
            }
            if (reportQueryParam.getEndDate() != null) {
                filter.and(dateTimeColName, "<=", (Object)DateUtil.getDayLast2((Date)reportQueryParam.getEndDate()));
            }
            filters.or(filter);
            if (++batchCnt != 300) continue;
            maxDetailCnt = this.getBillIds("ocbsoc_returnorder", "recentryentity", entryIds, maxDetailCnt, filters);
            batchCnt = 0;
            filters = new QFilter("1", "!=", (Object)1);
        }
        maxDetailCnt = this.getBillIds("ocbsoc_returnorder", "recentryentity", entryIds, maxDetailCnt, filters);
        if (entryIds.size() > 0) {
            dataFilter.and(String.join((CharSequence)".", "recentryentity", "id"), "in", entryIds);
        } else {
            dataFilter.and("id", "=", (Object)0L);
        }
        return maxDetailCnt;
    }

    private int setSaleOrderFilter(List<RebateAccountParamVo> paramList, QFilter dataFilter, String dateTimeColName, int maxDetailCnt) {
        int batchCnt = 0;
        HashSet<Long> entryIds = new HashSet<Long>(0);
        QFilter paramFilter = new QFilter("1", "!=", (Object)1);
        for (RebateAccountParamVo reportQueryParam : paramList) {
            QFilter filter = new QFilter("settleorgid", "=", (Object)reportQueryParam.getOrgId());
            filter.and("settlecurrencyid", "=", (Object)reportQueryParam.getCurrencyId());
            filter.and("customerid", "=", (Object)reportQueryParam.getCustomerId());
            filter.and("balancechannelid", "=", (Object)reportQueryParam.getChannelId());
            filter.and(String.join((CharSequence)".", "recentryentity", "accounttypeid"), "=", (Object)reportQueryParam.getAccountTypeId());
            if (reportQueryParam.getBeginDate() != null) {
                filter.and(dateTimeColName, ">=", (Object)DateUtil.getDayFirst((Date)reportQueryParam.getBeginDate()));
            }
            if (reportQueryParam.getEndDate() != null) {
                filter.and(dateTimeColName, "<=", (Object)DateUtil.getDayLast2((Date)reportQueryParam.getEndDate()));
            }
            paramFilter.or(filter);
            if (++batchCnt != 300) continue;
            maxDetailCnt = this.getBillIds("ocbsoc_saleorder", "recentryentity", entryIds, maxDetailCnt, paramFilter);
            batchCnt = 0;
            paramFilter = new QFilter("1", "!=", (Object)1);
        }
        maxDetailCnt = this.getBillIds("ocbsoc_saleorder", "recentryentity", entryIds, maxDetailCnt, paramFilter);
        if (entryIds.size() > 0) {
            dataFilter.and(String.join((CharSequence)".", "recentryentity", "id"), "in", entryIds);
        } else {
            dataFilter.and("id", "=", (Object)0L);
        }
        return maxDetailCnt;
    }

    private int getBillIds(String entityName, String entryEntityName, Set<Long> billIds, int maxDetailCnt, QFilter filter) {
        DataSet ds;
        HashSet<Long> ids = new HashSet<Long>(0);
        String selectFields = "id";
        if (StringUtils.isNotEmpty((CharSequence)entryEntityName)) {
            selectFields = String.join((CharSequence)",", selectFields, String.format("%s.id as entryId ", entryEntityName));
        }
        if ((ds = QueryServiceHelper.queryDataSet((String)entityName, (String)entityName, (String)selectFields, (QFilter[])filter.toArray(), (String)"")) != null) {
            while (ds.hasNext()) {
                Row row = ds.next();
                if (StringUtils.isNotEmpty((CharSequence)entryEntityName)) {
                    ids.add(row.getLong("entryId"));
                    continue;
                }
                ids.add(row.getLong("id"));
            }
            if ((maxDetailCnt -= ids.size()) <= 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u4e0e\u8fd0\u7b97\u6570\u636e\u8fc7\u5927\uff0c\u8bf7\u4fee\u6539\u67e5\u8be2\u6761\u4ef6", (String)"RebateAccountRptHandle_0", (String)"occ-occba-report", (Object[])new Object[0]));
            }
            billIds.addAll(ids);
        }
        return maxDetailCnt;
    }
}

