/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.report.rebateaccount;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.occ.ocbase.common.util.CollectionUtil;
import kd.occ.occba.report.rebateaccount.RebateAccountParamVo;
import kd.occ.occba.report.rebatedetail.RebateDetailRptDataTransform;

public class RebateAccountRptRecordAmountTransform
implements IDataTransform {
    private static final String QUERY_FLOW_COLS = String.join((CharSequence)",", "id", "org", "channel", "customer", "stmcurrency", "accout", "changeamount", "billentity", "sourcebillno", "transaction");
    private static final String[] GROUPBY_FLOW_COLS = new String[]{"org", "channel", "customer", "stmcurrency", "accout", "billentity", "sourcebillno"};
    private static final String[] translation = new String[]{"A", "C", "D", "E", "F", "H", "I", "J"};
    List<RebateAccountParamVo> paramList;
    Set<String> showKeyCols;
    Set<String> showQtyCols;

    public RebateAccountRptRecordAmountTransform(ReportDataCtx ctx, List<RebateAccountParamVo> paramList) {
        this.paramList = paramList;
        this.showKeyCols = ctx.getShowKeyCols();
        this.showQtyCols = ctx.getShowQtyCols();
        this.showKeyCols.remove("billentity");
        this.showKeyCols.remove("billno");
        ctx.setShowKeyCols(this.showKeyCols);
    }

    public DataSet doTransform(DataSet srcData) {
        DataSet recordDataSet = this.queryRecordDataSet(this.paramList);
        srcData = this.dealBillAndRecordDateSet(srcData, recordDataSet);
        GroupbyDataSet resultGroupbyDataSet = srcData.groupBy(this.showKeyCols.toArray(new String[this.showKeyCols.size()]));
        srcData = resultGroupbyDataSet.sum("notinadjdiffamount").sum("beginamount").sum("incomeamount").sum("adjustamount").sum("orderapplyamount").sum("returnbillamount").sum("recordincomeamount").sum("recorduseamount").sum("recordadjustamount").sum("recordreturnamount").sum("diffuseamount").sum("diffadjustamount").sum("diffreturnamount").sum("diffincomeamount").sum("availablebalance").sum("lastamount").sum("occupyamount").sum("balance").sum("differentamount").finish();
        srcData = srcData.removeFields(new String[]{"balance", "availablebalance", "occupyamount"});
        return srcData;
    }

    private DataSet dealBillAndRecordDateSet(DataSet srcData, DataSet recordDataSet) {
        String[] names = srcData.getRowMeta().getFieldNames();
        ArrayList<String> nameList = new ArrayList<String>(Arrays.asList(names));
        nameList.remove("recordadjustamount");
        nameList.remove("recordincomeamount");
        nameList.remove("recordreturnamount");
        nameList.remove("recorduseamount");
        srcData = srcData.leftJoin(recordDataSet).on("org", "org").on("channel", "channel").on("customer", "customer").on("currency", "stmcurrency").on("accounttype", "accout").on("billno", "sourcebillno").on("billentity", "billentity").select(nameList.toArray(new String[nameList.size()]), new String[]{"recordadjustamount", "recordincomeamount", "recordreturnamount", "recorduseamount"}).finish();
        srcData = srcData.removeFields(new String[]{"billno", "billentity"});
        return srcData;
    }

    private DataSet queryRecordDataSet(List<RebateAccountParamVo> paramList2) {
        QFilter recordFilter = this.buildRecordFilter(this.paramList);
        DataSet recordDataSet = QueryServiceHelper.queryDataSet((String)RebateAccountRptRecordAmountTransform.class.getName(), (String)"occba_flowrecord", (String)QUERY_FLOW_COLS, (QFilter[])recordFilter.toArray(), null);
        recordDataSet = recordDataSet.updateField("changeamount", " case when (transaction='C' OR transaction='H' OR transaction='I' OR transaction='J' OR transaction='E') then (changeamount * -1) else changeamount end ");
        recordDataSet.removeFields(new String[]{"transaction"});
        DataSet orderChangeSet = this.queryOrderChangeDataSet(this.paramList);
        recordDataSet = recordDataSet.leftJoin(orderChangeSet).on("sourcebillno", "changebillno").select(recordDataSet.getRowMeta().getFieldNames(), new String[]{"billno"}).finish();
        recordDataSet = recordDataSet.updateField("billentity", " case when (billentity = 'ocbsoc_xsaleorder' and billno is not null) then 'ocbsoc_saleorder' else billentity end ");
        recordDataSet = recordDataSet.updateField("sourcebillno", " case when billno is not null then billno else sourcebillno end ");
        recordDataSet.removeFields(new String[]{"billno"});
        GroupbyDataSet groupbyDataSet = recordDataSet.groupBy(GROUPBY_FLOW_COLS);
        recordDataSet = groupbyDataSet.sum("changeamount").finish();
        recordDataSet = recordDataSet.addBalanceField("changeamount", "recordadjustamount");
        recordDataSet = recordDataSet.addBalanceField("changeamount", "recordincomeamount");
        recordDataSet = recordDataSet.addBalanceField("changeamount", "recordreturnamount");
        recordDataSet = recordDataSet.addBalanceField("changeamount", "recorduseamount");
        recordDataSet = recordDataSet.updateField("recordadjustamount", "case when billentity = 'occba_balanceadjust' then changeamount else 0 end");
        recordDataSet = recordDataSet.updateField("recorduseamount", "case when billentity = 'ocbsoc_saleorder' then changeamount else 0 end");
        recordDataSet = recordDataSet.updateField("recordincomeamount", "case when billentity = 'occba_moneyincome' then changeamount else 0 end");
        recordDataSet = recordDataSet.updateField("recordreturnamount", "case when billentity = 'ocbsoc_returnorder' then changeamount else 0 end");
        recordDataSet.removeFields(new String[]{"changeamount"});
        return recordDataSet;
    }

    private DataSet queryOrderChangeDataSet(List<RebateAccountParamVo> paramList) {
        QFilter totalFilter = new QFilter("1", "!=", (Object)1);
        if (CollectionUtil.isNotNull(paramList)) {
            int index = 0;
            HashSet<Long> entryIds = new HashSet<Long>(0);
            for (RebateAccountParamVo param : paramList) {
                QFilter filter = new QFilter("saleorgid", "=", (Object)param.getOrgId());
                filter.and("balancechannelid", "=", (Object)param.getChannelId());
                filter.and("customerid", "=", (Object)param.getCustomerId());
                filter.and(kd.occ.ocbase.common.util.StringUtils.join((CharSequence)".", (Object[])new Object[]{"recentryentity", "accounttypeid"}), "=", (Object)param.getAccountTypeId());
                filter.and("settlecurrencyid", "=", (Object)param.getCurrencyId());
                filter.and("billstatus", "not in", (Object)new String[]{"A", "B"});
                totalFilter.or(filter);
                if (++index != 300) continue;
                this.getBillIds("ocbsoc_xsaleorder", "recentryentity", entryIds, totalFilter);
                index = 0;
                totalFilter = new QFilter("1", "!=", (Object)1);
            }
            this.getBillIds("ocbsoc_xsaleorder", "recentryentity", entryIds, totalFilter);
            totalFilter = entryIds.size() > 0 ? new QFilter(kd.occ.ocbase.common.util.StringUtils.join((CharSequence)".", (Object[])new Object[]{"recentryentity", "id"}), "in", entryIds) : new QFilter("1", "!=", (Object)1);
        }
        return QueryServiceHelper.queryDataSet((String)RebateDetailRptDataTransform.class.getName(), (String)"ocbsoc_xsaleorder", (String)String.join((CharSequence)",", "billno", "changebillno", "id"), (QFilter[])totalFilter.toArray(), null);
    }

    private void getBillIds(String entityName, String entryEntityName, Set<Long> billIds, QFilter filter) {
        DataSet ds;
        HashSet<Long> ids = new HashSet<Long>(0);
        String selectFields = "id";
        if (StringUtils.isNotEmpty((CharSequence)entryEntityName)) {
            selectFields = String.join((CharSequence)",", selectFields, String.format("%s.id as entryId ", entryEntityName));
        }
        if ((ds = QueryServiceHelper.queryDataSet((String)entityName, (String)entityName, (String)selectFields, (QFilter[])filter.toArray(), (String)"")) != null) {
            while (ds.hasNext()) {
                Row row = ds.next();
                if (StringUtils.isNotEmpty((CharSequence)entryEntityName)) {
                    ids.add(row.getLong("entryId"));
                    continue;
                }
                ids.add(row.getLong("id"));
            }
            billIds.addAll(ids);
        }
    }

    private QFilter buildRecordFilter(List<RebateAccountParamVo> paramList) {
        if (CollectionUtil.isNull(paramList)) {
            return new QFilter("1", "!=", (Object)1);
        }
        QFilter paramFilter = new QFilter("1", "!=", (Object)1);
        int index = 0;
        HashSet<Long> billIds = new HashSet<Long>(0);
        for (RebateAccountParamVo vo : paramList) {
            QFilter filter = new QFilter("stmcurrency", "=", (Object)vo.getCurrencyId());
            filter.and("customer", "=", (Object)vo.getCustomerId());
            filter.and("org", "=", (Object)vo.getOrgId());
            filter.and("channel", "=", (Object)vo.getChannelId());
            filter.and("accout", "=", (Object)vo.getAccountTypeId());
            paramFilter.or(filter);
            if (++index != 300) continue;
            this.getBillIds("occba_flowrecord", "", billIds, paramFilter);
            index = 0;
            paramFilter = new QFilter("1", "!=", (Object)1);
        }
        this.getBillIds("occba_flowrecord", "", billIds, paramFilter);
        QFilter totalFilter = new QFilter("transaction", "in", (Object)translation);
        totalFilter = totalFilter.and("receivechannel", "=", (Object)0L);
        if (billIds.size() > 0) {
            totalFilter.and("id", "in", billIds);
        } else {
            totalFilter = totalFilter.and(new QFilter("1", "!=", (Object)1));
        }
        return totalFilter;
    }
}

