/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.report.rebatedetail;

import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.RowMeta;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.occba.report.rebatedetail.RebateDetailRptConstant;
import kd.occ.occba.report.rebatedetail.RebateDetailRptParam;

public class RebateDetailRptDataTransform
implements IDataTransform {
    private static final String[] transaction = new String[]{"A", "C", "D", "E", "F", "H", "I", "J"};
    private RebateDetailRptParam reportParam;
    private static final String FLOW_RECORD_COLS = String.join((CharSequence)",", "org", "channel", "customer", "accout", "receivechannel", "stmcurrency", "createtime", "billentity", "sourcebillno", "changeamount updateamount");
    private static final String[] FLOW_RECORD_GROUPBY_COLS = new String[]{"org", "channel", "customer", "accout", "receivechannel", "stmcurrency", "billentity", "sourcebillno"};

    public RebateDetailRptDataTransform(RebateDetailRptParam reportParam) {
        this.reportParam = reportParam;
    }

    public DataSet doTransform(DataSet srcData) {
        DataSet recordDataSet = this.queryRecordDataSet(this.reportParam);
        DataSet res = srcData.leftJoin(recordDataSet).on("billno", "sourcebillno").on("billentity", "billentity").select(srcData.getRowMeta().getFieldNames(), new String[]{"updateamount"}).finish();
        res = res.updateField("updateamount", "case when (billentity = 'ocbsoc_saleorder' or billentity ='ocbsoc_returnorder') then updateamount * (-1) else updateamount end");
        res = res.updateField("differentamount", String.format("%s+%s+%s+%s-%s", "incomeamount", "returnamount", "useamount", "adjustamount", "updateamount"));
        res = res.updateField("result", "case when ((billentity = 'ocbsoc_saleorder' and useamount = 0) or differentamount = 0) then 'A' else 'B' end");
        res = res.orderBy(new String[]{"billdate"});
        DataSet beginDataSet = this.getRecentRecordInfo(this.reportParam, srcData.getRowMeta());
        res = beginDataSet.union(res);
        return res;
    }

    private DataSet queryRecordDataSet(RebateDetailRptParam reportParam) {
        QFilter filter = new QFilter("org", "=", (Object)reportParam.getOrgId());
        filter.and("channel", "=", (Object)reportParam.getChannelId());
        filter.and("customer", "=", (Object)reportParam.getCustomerId());
        filter.and("accout", "=", (Object)reportParam.getAccountTypeId());
        filter.and("receivechannel", "=", (Object)0L);
        filter.and("stmcurrency", "=", (Object)reportParam.getCurrencyId());
        filter.and("transaction", "in", (Object)transaction);
        DataSet recordDataSet = QueryServiceHelper.queryDataSet((String)RebateDetailRptDataTransform.class.getName(), (String)"occba_flowrecord", (String)FLOW_RECORD_COLS, (QFilter[])filter.toArray(), null);
        DataSet orderChangeSet = this.queryOrderChangeDataSet(reportParam);
        recordDataSet = recordDataSet.leftJoin(orderChangeSet).on("sourcebillno", "changebillno").select(recordDataSet.getRowMeta().getFieldNames(), new String[]{"billno"}).finish();
        recordDataSet = recordDataSet.updateField("billentity", " case when (billentity = 'ocbsoc_xsaleorder' and billno is not null) then 'ocbsoc_saleorder' else billentity end ");
        recordDataSet = recordDataSet.updateField("sourcebillno", " case when billno is not null then billno else sourcebillno end ");
        recordDataSet.removeFields(new String[]{"billno"});
        GroupbyDataSet groupbyDataSet = recordDataSet.groupBy(FLOW_RECORD_GROUPBY_COLS);
        recordDataSet = groupbyDataSet.sum("updateamount").finish();
        return recordDataSet.copy();
    }

    private DataSet queryOrderChangeDataSet(RebateDetailRptParam reportParam) {
        QFilter filter = new QFilter("saleorgid", "=", (Object)reportParam.getOrgId());
        filter.and("balancechannelid", "=", (Object)reportParam.getChannelId());
        filter.and("customerid", "=", (Object)reportParam.getCustomerId());
        filter.and(StringUtils.join((CharSequence)".", (Object[])new Object[]{"recentryentity", "accounttypeid"}), "=", (Object)reportParam.getAccountTypeId());
        filter.and("settlecurrencyid", "=", (Object)reportParam.getCurrencyId());
        filter.and("billstatus", "not in", (Object)new String[]{"A", "B"});
        return QueryServiceHelper.queryDataSet((String)RebateDetailRptDataTransform.class.getName(), (String)"ocbsoc_xsaleorder", (String)String.join((CharSequence)",", "billno", "changebillno", "id"), (QFilter[])filter.toArray(), null);
    }

    private DataSet getRecentRecordInfo(RebateDetailRptParam reportParam, RowMeta rowMeta) {
        QFilter filter = this.buildRecordFilter(reportParam);
        String[] fieldNames = rowMeta.getFieldNames();
        StringBuilder colNames = new StringBuilder();
        int size = fieldNames.length;
        for (int i = 0; i < size; ++i) {
            this.buildQueryColNames(colNames, fieldNames[i], false);
        }
        this.buildQueryColNames(colNames, "updateamount", true);
        DataSet recordSet = QueryServiceHelper.queryDataSet((String)RebateDetailRptDataTransform.class.getName(), (String)"occba_flowrecord", (String)colNames.toString(), (QFilter[])filter.toArray(), (String)"createtime desc");
        recordSet = recordSet.top(1);
        recordSet = recordSet.updateField("beginamount", reportParam.getBeginAmount().toPlainString());
        return recordSet;
    }

    private void buildQueryColNames(StringBuilder colNames, String fieldName, boolean isLast) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return;
        }
        if ("currency".equalsIgnoreCase(fieldName)) {
            colNames.append(this.reportParam.getCurrencyId()).append(" as ").append(fieldName);
        } else if ("beginamount".equalsIgnoreCase(fieldName)) {
            colNames.append("afteramount").append(" as ").append(fieldName);
        } else if (RebateDetailRptConstant.isNumber(fieldName)) {
            colNames.append(" 0 as ").append(fieldName);
        } else {
            colNames.append(" null as ").append(fieldName);
        }
        if (!isLast) {
            colNames.append(',');
        }
    }

    private QFilter buildRecordFilter(RebateDetailRptParam reportParam) {
        QFilter filter = new QFilter("stmcurrency", "=", (Object)reportParam.getCurrencyId());
        filter.and("customer", "=", (Object)reportParam.getCustomerId());
        filter.and("org", "=", (Object)reportParam.getOrgId());
        filter.and("channel", "=", (Object)reportParam.getChannelId());
        filter.and("accout", "=", (Object)reportParam.getAccountTypeId());
        return filter;
    }
}

