/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.report.rebatedetail;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.occba.report.rebatedetail.RebateDetailRptParam;

public class RebateDetailRptForm
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String CTL_REPORTLISTAP = "reportlistap";
    private static final String CTL_TOOLBARAP = "toolbarap";
    private static final String BTN_CREATEADJUSTBILL = "createadjustbill";
    private static final String BTN_QUERYRECORD = "queryrecord";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        this.buildReportQueryParam();
    }

    private void initData() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map paramMap = (Map)showParameter.getCustomParam("rebateDetailRptParam");
        this.getModel().setValue("rebateaccount", paramMap.get("rebateaccount"));
        this.getModel().setValue("org", paramMap.get("org"));
        this.getModel().setValue("channel", paramMap.get("channel"));
        this.getModel().setValue("customer", paramMap.get("customer"));
        this.getModel().setValue("accounttype", paramMap.get("accounttype"));
        this.getModel().setValue("pooltype", paramMap.get("pooltype"));
        this.getModel().setValue("balance", paramMap.get("balance"));
        this.getModel().setValue("search_currency", paramMap.get("currency"));
        this.getModel().setValue("begindate", paramMap.get("beginDate"));
        this.getModel().setValue("enddate", paramMap.get("endDate"));
        this.getModel().setValue("search_beginamount", paramMap.get("beginamount"));
        this.getModel().setValue("search_differentamount", paramMap.get("differentamount"));
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String key = e.getFieldName();
        if ("billno".equals(key)) {
            this.showDetailRpt(e);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportlist = (ReportList)this.getView().getControl(CTL_REPORTLISTAP);
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{CTL_TOOLBARAP});
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        for (DynamicObject row : rowData) {
            if (row.getDynamicObject("billentity") == null) {
                row.set("beginamountcol", (Object)ResManager.loadKDString((String)"\u671f\u521d\u91d1\u989d", (String)"RebateDetailRptForm_0", (String)"occ-occba-report", (Object[])new Object[0]));
            }
            if (!"ocbsoc_saleorder".equalsIgnoreCase(DynamicObjectUtils.getString((DynamicObject)row.getDynamicObject("billentity"), (String)"number")) || !"C".equalsIgnoreCase(row.getString("billstatus")) && !"D".equalsIgnoreCase(row.getString("billstatus")) || row.getBigDecimal("differentamount").compareTo(BigDecimal.ZERO) == 0) continue;
            row.set("reson", (Object)ResManager.loadKDString((String)"1\u3001\u8ba2\u5355\u53d8\u66f4\uff1b2\u3001\u8ba2\u5355\u5f02\u5e38\u5173\u95ed\uff1b3\u3001\u5176\u4ed6\u5f02\u5e38\u539f\u56e0\u3002", (String)"RebateDetailRptForm_1", (String)"occ-occba-report", (Object[])new Object[0]));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        ReportList reportlistap = (ReportList)this.getView().getControl(CTL_REPORTLISTAP);
        AbstractGrid.GridState entryState = reportlistap.getEntryState();
        int[] selectedRows = entryState.getSelectedRows();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        switch (evt.getItemKey()) {
            case "createadjustbill": {
                BigDecimal differentAmount = (BigDecimal)this.getModel().getValue("search_differentamount");
                DynamicObject rebateAccount = (DynamicObject)this.getModel().getValue("rebateaccount");
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setFormId("occba_balanceadjust");
                HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
                paramMap.put("isFromReport", Boolean.TRUE);
                paramMap.put("adjustAmount", differentAmount);
                ArrayList<Long> rebateAccountIdList = new ArrayList<Long>(1);
                rebateAccountIdList.add(DynamicObjectUtils.getPkValue((DynamicObject)rebateAccount));
                paramMap.put("rebateAccountIdList", rebateAccountIdList);
                paramMap.put("orgId", DynamicObjectUtils.getPkValue((DynamicObject)org));
                paramMap.put("billtype", 1184064738158648320L);
                formShowParameter.setCustomParams(paramMap);
                this.getView().showForm(formShowParameter);
                break;
            }
            case "queryrecord": {
                if (selectedRows == null || selectedRows.length == 0 || selectedRows.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"RebateDetailRptForm_2", (String)"occ-occba-report", (Object[])new Object[0]));
                    break;
                }
                DynamicObject reportData = reportlistap.getReportModel().getRowData(selectedRows[0]);
                ListFilterParameter listFilterParameter = this.buildListFilterParameter(reportData);
                ListShowParameter parameter = this.buildListShowParameter(listFilterParameter);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
        }
    }

    private ListShowParameter buildListShowParameter(ListFilterParameter listFilterParameter) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("bos_list");
        parameter.setBillFormId("occba_flowrecord");
        parameter.setListFilterParameter(listFilterParameter);
        return parameter;
    }

    private ListFilterParameter buildListFilterParameter(DynamicObject reportData) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject customer = (DynamicObject)this.getModel().getValue("customer");
        DynamicObject channel = (DynamicObject)this.getModel().getValue("channel");
        DynamicObject accountType = (DynamicObject)this.getModel().getValue("accounttype");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("search_currency");
        Date beginDate = (Date)this.getModel().getValue("begindate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(new QFilter("org", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)org)));
        listFilterParameter.setFilter(new QFilter("customer", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)customer)));
        listFilterParameter.setFilter(new QFilter("channel", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channel)));
        listFilterParameter.setFilter(new QFilter("accout", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)accountType)));
        listFilterParameter.setFilter(new QFilter("stmcurrency", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)currency)));
        listFilterParameter.setFilter(new QFilter("createtime", ">=", (Object)DateUtil.getDayFirst((Date)beginDate)));
        listFilterParameter.setFilter(new QFilter("createtime", "<=", (Object)DateUtil.getDayLast2((Date)endDate)));
        String billEntity = DynamicObjectUtils.getString((DynamicObject)reportData.getDynamicObject("billentity"), (String)"number");
        if ("ocbsoc_saleorder".equalsIgnoreCase(billEntity)) {
            listFilterParameter.setFilter(new QFilter("sourcebillno", "like", (Object)(reportData.getString("billno") + "%")));
            listFilterParameter.setFilter(new QFilter("billentity", "in", (Object)new String[]{"ocbsoc_saleorder", "ocbsoc_xsaleorder"}));
        } else {
            listFilterParameter.setFilter(new QFilter("sourcebillno", "=", (Object)reportData.getString("billno")));
            listFilterParameter.setFilter(new QFilter("billentity", "=", (Object)billEntity));
        }
        return listFilterParameter;
    }

    private void showDetailRpt(HyperLinkClickEvent e) {
        ReportList reportList = (ReportList)e.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(e.getRowIndex());
        String srcBillEntity = DynamicObjectUtils.getStrPkValue((DynamicObject)rowData, (String)"billentity");
        String srcBillNumber = rowData.getString("billno");
        QFilter filter = new QFilter("billno", "=", (Object)srcBillNumber);
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)srcBillEntity, (QFilter[])filter.toArray());
        long billId = DynamicObjectUtils.getPkValue((DynamicObject)bill);
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(srcBillEntity);
        parameter.setPkId((Object)billId);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void buildReportQueryParam() {
        DynamicObject data = this.getModel().getDataEntity();
        RebateDetailRptParam rebateDetailRptParam = new RebateDetailRptParam();
        rebateDetailRptParam.setOrgId(DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"org"));
        rebateDetailRptParam.setChannelId(DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"channel"));
        rebateDetailRptParam.setCustomerId(DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"customer"));
        rebateDetailRptParam.setAccountTypeId(DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"accounttype"));
        rebateDetailRptParam.setCurrencyId(DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"search_currency"));
        rebateDetailRptParam.setBeginDate(DynamicObjectUtils.getDate((DynamicObject)data, (String)"begindate"));
        rebateDetailRptParam.setEndDate(DynamicObjectUtils.getDate((DynamicObject)data, (String)"enddate"));
        rebateDetailRptParam.setBeginAmount(DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"search_beginamount"));
        ReportQueryParam param = this.getQueryParam();
        param.getCustomParam().put(RebateDetailRptParam.class.getName(), rebateDetailRptParam);
    }
}

