/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.report.rebatedetail;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.occba.report.rebatedetail.RebateDetailRptDataTransform;
import kd.occ.occba.report.rebatedetail.RebateDetailRptParam;
import kd.occ.occba.report.rebatedetail.RebateDetailUnionXTransform;

public class RebateDetailRptHandle
implements IReportDataHandle {
    private RebateDetailRptParam reportParam;

    public void setupCtx(ReportDataCtx ctx) {
        this.reportParam = (RebateDetailRptParam)ctx.getParam(RebateDetailRptParam.class.getName());
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("differentamount");
        repoColFilter.add("updateamount");
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new RebateDetailUnionXTransform());
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        super.transFormAfterGroup(transCollector, ctx);
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        int size = cols.size() + 2;
        ArrayList<AbstractReportColumn> colList = new ArrayList<AbstractReportColumn>(size);
        ReportColumn beginAmountCol = new ReportColumn();
        beginAmountCol.setCaption(new LocaleString("zh_CN", ResManager.loadKDString((String)"\u671f\u521d", (String)"RebateDetailRptHandle_0", (String)"occ-occba-report", (Object[])new Object[0])));
        beginAmountCol.setFieldKey("beginamountcol");
        beginAmountCol.setFieldType(DataType.StringType.getName());
        colList.add((AbstractReportColumn)beginAmountCol);
        colList.addAll(cols);
        ReportColumn reson = new ReportColumn();
        reson.setCaption(new LocaleString("zh_CN", ResManager.loadKDString((String)"\u5f02\u5e38\u4fe1\u606f", (String)"RebateDetailRptHandle_1", (String)"occ-occba-report", (Object[])new Object[0])));
        reson.setFieldKey("reson");
        reson.setFieldType(DataType.StringType.getName());
        colList.add((AbstractReportColumn)reson);
        return colList;
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new RebateDetailRptDataTransform(this.reportParam));
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        RebateDetailRptParam reportQueryParam = (RebateDetailRptParam)ctx.getParam(RebateDetailRptParam.class.getName());
        Map<String, String> colNameMap = this.getReportColConfig();
        for (SrcBlockConf blockConf : blockCollector) {
            blockConf.setAllowNotMatch(true);
            String srcEntity = blockConf.getSrcEntity();
            QFilter dataFs = blockConf.getDataFs();
            switch (srcEntity) {
                case "ocbsoc_saleorder": {
                    this.setSaleOrderFilter(reportQueryParam, dataFs, colNameMap.get("ocbsoc_saleorder"));
                    break;
                }
                case "ocbsoc_returnorder": {
                    this.setReturnOrderFilter(reportQueryParam, dataFs, colNameMap.get("ocbsoc_returnorder"));
                    break;
                }
                case "occba_balanceadjust": {
                    this.setBalanceAdjustFilter(reportQueryParam, dataFs, colNameMap.get("occba_balanceadjust"));
                    break;
                }
                case "occba_moneyincome": {
                    this.setMoneyIncomeFilter(reportQueryParam, dataFs, colNameMap.get("occba_moneyincome"));
                    break;
                }
                case "occba_flowrecord": {
                    this.setFlowRecordFilter(reportQueryParam, dataFs, colNameMap.get("occba_flowrecord"));
                    break;
                }
            }
        }
    }

    private Map<String, String> getReportColConfig() {
        DynamicObject rptColCfg = BusinessDataServiceHelper.loadSingle((Object)1555787018360081408L, (String)"occba_rebateactrpt_colcfg");
        DynamicObjectCollection configDetail = rptColCfg.getDynamicObjectCollection("entryentity");
        HashMap<String, String> colNameMap = new HashMap<String, String>(5);
        for (DynamicObject colConfig : configDetail) {
            colNameMap.put(DynamicObjectUtils.getString((DynamicObject)colConfig.getDynamicObject("srcentity"), (String)"number"), colConfig.getString("datatimecol"));
        }
        return colNameMap;
    }

    private void setFlowRecordFilter(RebateDetailRptParam reportQueryParam, QFilter dataFilter, String dateTimeColName) {
        dataFilter.and("channel", "=", (Object)reportQueryParam.getChannelId());
        dataFilter.and("customer", "=", (Object)reportQueryParam.getCustomerId());
        dataFilter.and("accout", "=", (Object)reportQueryParam.getAccountTypeId());
        dataFilter.and("org", "=", (Object)reportQueryParam.getOrgId());
        dataFilter.and("stmcurrency", "=", (Object)reportQueryParam.getCurrencyId());
    }

    private void setMoneyIncomeFilter(RebateDetailRptParam reportQueryParam, QFilter dataFilter, String dateTimeColName) {
        Date beginDate = reportQueryParam.getBeginDate();
        Date endDate = reportQueryParam.getEndDate();
        if (beginDate != null) {
            dataFilter.and(dateTimeColName, ">=", (Object)beginDate);
        }
        if (endDate != null) {
            dataFilter.and(dateTimeColName, "<=", (Object)DateUtil.getDayLast2((Date)endDate));
        }
        dataFilter.and("paychannelid", "=", (Object)reportQueryParam.getChannelId());
        dataFilter.and("paycustomerid", "=", (Object)reportQueryParam.getCustomerId());
        dataFilter.and("moneyaccountid", "=", (Object)reportQueryParam.getAccountTypeId());
        dataFilter.and(StringUtils.join((CharSequence)".", (Object[])new Object[]{"entryentity", "settleorgid"}), "=", (Object)reportQueryParam.getOrgId());
        dataFilter.and("currencyid", "=", (Object)reportQueryParam.getCurrencyId());
    }

    private void setBalanceAdjustFilter(RebateDetailRptParam reportQueryParam, QFilter dataFilter, String dateTimeColName) {
        Date beginDate = reportQueryParam.getBeginDate();
        Date endDate = reportQueryParam.getEndDate();
        if (beginDate != null) {
            dataFilter.and(dateTimeColName, ">=", (Object)beginDate);
        }
        if (endDate != null) {
            dataFilter.and(dateTimeColName, "<=", (Object)DateUtil.getDayLast2((Date)endDate));
        }
        dataFilter.and(StringUtils.join((CharSequence)".", (Object[])new Object[]{"entryentity", "channel"}), "=", (Object)reportQueryParam.getChannelId());
        dataFilter.and(StringUtils.join((CharSequence)".", (Object[])new Object[]{"entryentity", "customer"}), "=", (Object)reportQueryParam.getCustomerId());
        dataFilter.and(StringUtils.join((CharSequence)".", (Object[])new Object[]{"entryentity", "accounttype"}), "=", (Object)reportQueryParam.getAccountTypeId());
        dataFilter.and("org", "=", (Object)reportQueryParam.getOrgId());
        dataFilter.and(StringUtils.join((CharSequence)".", (Object[])new Object[]{"entryentity", "currency"}), "=", (Object)reportQueryParam.getCurrencyId());
    }

    private void setReturnOrderFilter(RebateDetailRptParam reportQueryParam, QFilter dataFilter, String dateTimeColName) {
        Date beginDate = reportQueryParam.getBeginDate();
        Date endDate = reportQueryParam.getEndDate();
        if (beginDate != null) {
            dataFilter.and(dateTimeColName, ">=", (Object)beginDate);
        }
        if (endDate != null) {
            dataFilter.and(dateTimeColName, "<=", (Object)DateUtil.getDayLast2((Date)endDate));
        }
        dataFilter.and("balancechannelid", "=", (Object)reportQueryParam.getChannelId());
        dataFilter.and("customerid", "=", (Object)reportQueryParam.getCustomerId());
        dataFilter.and(StringUtils.join((CharSequence)".", (Object[])new Object[]{"recentryentity", "accounttypeid"}), "=", (Object)reportQueryParam.getAccountTypeId());
        dataFilter.and("settleorgid", "=", (Object)reportQueryParam.getOrgId());
        dataFilter.and("settlecurrencyid", "=", (Object)reportQueryParam.getCurrencyId());
    }

    private void setSaleOrderFilter(RebateDetailRptParam reportQueryParam, QFilter dataFilter, String dateTimeColName) {
        Date beginDate = reportQueryParam.getBeginDate();
        Date endDate = reportQueryParam.getEndDate();
        if (beginDate != null) {
            dataFilter.and(dateTimeColName, ">=", (Object)beginDate);
        }
        if (endDate != null) {
            dataFilter.and(dateTimeColName, "<=", (Object)DateUtil.getDayLast2((Date)endDate));
        }
        dataFilter.and("balancechannelid", "=", (Object)reportQueryParam.getChannelId());
        dataFilter.and("customerid", "=", (Object)reportQueryParam.getCustomerId());
        dataFilter.and(StringUtils.join((CharSequence)".", (Object[])new Object[]{"recentryentity", "accounttypeid"}), "=", (Object)reportQueryParam.getAccountTypeId());
        dataFilter.and("settleorgid", "=", (Object)reportQueryParam.getOrgId());
        dataFilter.and("settlecurrencyid", "=", (Object)reportQueryParam.getCurrencyId());
    }
}

