/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.report.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.occba.report.businessaccount.BusinessAccountRptParam;
import kd.occ.occba.report.channelaccount.ChannelAccountRptParam;

public class RptUtil {
    private static final String F_BASEDATAID = "fbasedataid";

    public static void setChannelAccountHeadFilter(ReportDataCtx ctx, ChannelAccountRptParam rptParam) {
        List<QFilter> headFilters = rptParam.getHeadFilters();
        Set qtyCols = ctx.getSumQtyCols4Count();
        if (headFilters == null || headFilters.isEmpty()) {
            return;
        }
        Map<String, String> transHeadFiltersMap = RptUtil.buildTransHeadFiltersMap(ctx);
        LinkedList<QFilter> billHeadFilters = new LinkedList<QFilter>();
        for (QFilter headFilter : headFilters) {
            Map dataTypeMap;
            String originalProp = headFilter.getProperty();
            Object val = headFilter.getValue();
            String newProp = transHeadFiltersMap.get(originalProp);
            newProp = newProp == null ? originalProp : newProp;
            String cp = headFilter.getCP();
            if (!qtyCols.contains(originalProp.split("_")[0])) {
                headFilter.__setProperty(newProp);
                billHeadFilters.add(headFilter);
            }
            if ("is null".equals(cp) || "is not null".equals(cp)) {
                String qcp = "is null".equals(cp) ? "=" : "!=";
                headFilter.clearNests();
                if (originalProp.equals(newProp) || originalProp.contains("_ref_")) {
                    headFilter.__setCP(qcp);
                    headFilter.__setValue((Object)"");
                } else {
                    headFilter.__setProperty(originalProp);
                    headFilter.__setCP(qcp);
                    headFilter.__setValue((Object)0);
                }
            }
            if (!DataType.TimestampType.equals((dataTypeMap = ctx.getReportConf().getDataTypeMap()).get(originalProp)) || !"=".equals(cp) || !(val instanceof String)) continue;
            Date date = DateUtil.getDateFormat((String)val.toString());
            headFilter.__setValue((Object)date);
        }
        ctx.getPageFs().addAll(billHeadFilters);
    }

    public static void setBusinnessAccountHeadFilter(ReportDataCtx ctx, BusinessAccountRptParam rptParam) {
        List<QFilter> headFilters = rptParam.getHeadFilters();
        Set qtyCols = ctx.getSumQtyCols4Count();
        if (headFilters == null || headFilters.isEmpty()) {
            return;
        }
        Map<String, String> transHeadFiltersMap = RptUtil.buildTransHeadFiltersMap(ctx);
        LinkedList<QFilter> billHeadFilters = new LinkedList<QFilter>();
        for (QFilter headFilter : headFilters) {
            Map dataTypeMap;
            String originalProp = headFilter.getProperty();
            Object val = headFilter.getValue();
            String newProp = transHeadFiltersMap.get(originalProp);
            newProp = newProp == null ? originalProp : newProp;
            String cp = headFilter.getCP();
            if (!qtyCols.contains(originalProp.split("_")[0])) {
                headFilter.__setProperty(newProp);
                billHeadFilters.add(headFilter);
            }
            if ("is null".equals(cp) || "is not null".equals(cp)) {
                String qcp = "is null".equals(cp) ? "=" : "!=";
                headFilter.clearNests();
                if (originalProp.equals(newProp) || originalProp.contains("_ref_")) {
                    headFilter.__setCP(qcp);
                    headFilter.__setValue((Object)"");
                } else {
                    headFilter.__setProperty(originalProp);
                    headFilter.__setCP(qcp);
                    headFilter.__setValue((Object)0);
                }
            }
            if (!DataType.TimestampType.equals((dataTypeMap = ctx.getReportConf().getDataTypeMap()).get(originalProp)) || !"=".equals(cp) || !(val instanceof String)) continue;
            Date date = DateUtil.getDateFormat((String)val.toString());
            headFilter.__setValue((Object)date);
        }
        ctx.getPageFs().addAll(billHeadFilters);
    }

    public static boolean isNull(IReportView view, String colName) {
        boolean isNull;
        IDataModel model = view.getModel();
        boolean bl = isNull = model.getValue(colName) == null;
        if (model.getValue(colName) instanceof DynamicObjectCollection) {
            isNull = CommonUtils.isNull((Object)((DynamicObjectCollection)model.getValue(colName)));
        }
        if (isNull) {
            String collName = RptUtil.getColDisplayName(model, colName);
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RptUtil_1", (String)"occ-occba-report", (Object[])new Object[0]), collName);
            view.showTipNotification(msg);
        }
        return isNull;
    }

    public static <T> List<T> getBaseDataIds(DynamicObjectCollection dys) {
        ArrayList<Object> ids = new ArrayList<Object>(20);
        if (dys != null) {
            for (DynamicObject dy : dys) {
                ids.add(dy.getDynamicObject(F_BASEDATAID).getPkValue());
            }
        }
        return ids;
    }

    public static <T> List<T> getBaseDataIds(DynamicObjectCollection dys, String key) {
        ArrayList<Object> ids = new ArrayList<Object>(20);
        if (dys != null) {
            for (DynamicObject dy : dys) {
                ids.add(dy.getDynamicObject(F_BASEDATAID).get(String.join((CharSequence)"_", key, "id")));
            }
        }
        return ids;
    }

    public static List<Long> getBaseDataLongIds(IReportView view, String col) {
        return RptUtil.getBaseDataIds(view, col);
    }

    public static List<Long> getBaseDataLongIds(IReportView view, String col, String key) {
        return RptUtil.getBaseDataIds(view, col, key);
    }

    public static Date getShortDate(Date date) {
        return RptUtil.shortDate(date).getTime();
    }

    public static Date getShortDate(Date date, int addDays) {
        return RptUtil.getShortDate(date, 5, addDays);
    }

    public static Date getShortDate(Date date, int addType, int addDays) {
        Calendar calendar = RptUtil.shortDate(date);
        calendar.add(addType, addDays);
        return calendar.getTime();
    }

    public static String getDisplayProp(String type) {
        switch (type = type == null ? "1" : type) {
            case "1": {
                return "name";
            }
            case "2": {
                return "number";
            }
            case "3": {
                return "name,number";
            }
            case "4": {
                return "number,name";
            }
        }
        return "name";
    }

    private static <T> List<T> getBaseDataIds(IReportView view, String col) {
        DynamicObjectCollection dys = view.getModel().getDataEntity(true).getDynamicObjectCollection(col);
        return RptUtil.getBaseDataIds(dys);
    }

    private static <T> List<T> getBaseDataIds(IReportView view, String col, String key) {
        DynamicObjectCollection dys = view.getModel().getDataEntity(true).getDynamicObjectCollection(col);
        return RptUtil.getBaseDataIds(dys, key);
    }

    private static Calendar shortDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private static String getColDisplayName(IDataModel model, String colName) {
        MainEntityType type = model.getDataEntityType();
        DynamicProperty pro = type.getProperty(colName);
        return pro == null ? "null" : pro.getDisplayName().getLocaleValue();
    }

    private static Map<String, String> buildTransHeadFiltersMap(ReportDataCtx ctx) {
        ReportConf reportConf = ctx.getReportConf();
        List bigTableColConf = reportConf.getBigTableColConf();
        HashMap<String, String> resultMap = new HashMap<String, String>(bigTableColConf.size());
        for (BigTableColConf colConf : bigTableColConf) {
            String key;
            String val = key = colConf.getCol();
            String showProp = colConf.getShowProp();
            if (colConf.getDataType() == DataType.LongType) {
                val = String.join((CharSequence)".", key, RptUtil.getDisplayProp(showProp));
            }
            resultMap.put(key, val);
            List showRefProps = colConf.getShowRefProps();
            if (showRefProps == null || showRefProps.isEmpty()) continue;
            showRefProps.stream().forEach(c -> resultMap.put(String.join((CharSequence)"_ref_", key, c), String.join((CharSequence)".", key, c)));
        }
        return resultMap;
    }
}

