/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.opplugin.adjustamount;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.entity.AccountRecord;
import kd.occ.ocbase.common.enums.AccountPoolTypeEnum;
import kd.occ.ocbase.common.enums.AccountUpdateTypeEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.opplugin.base.OcBaseOperationServicePlugIn;
import kd.occ.occba.business.rebateservice.RebateServiceInvokeHelper;
import org.apache.commons.collections.CollectionUtils;

public class AdjustAmountAuditOp
extends OcBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List cols = e.getFieldKeys();
        cols.add("currency");
        cols.add("org");
        cols.add("signparty");
        cols.add("billstatus");
        cols.add("entryentity");
        cols.add("entryentity.customer");
        cols.add("entryentity.accounttype");
        cols.add("entryentity.currency");
        cols.add("entryentity.channel");
        cols.add("entryentity.adjustamount");
        cols.add("adjusttype");
        cols.add("receivechannel");
        cols.add("adjusttype");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] collect = e.getDataEntities();
        ArrayList<AccountRecord> accountRecordList = new ArrayList<AccountRecord>(collect.length);
        for (int i = 0; i < collect.length; ++i) {
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)collect[i].get("id"), (String)"occba_balanceadjust");
            String poolType = bill.getString("adjusttype");
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entryentity");
            for (int j = 0; j < entry.size(); ++j) {
                DynamicObject obj = (DynamicObject)entry.get(j);
                AccountRecord accountRecord = new AccountRecord();
                accountRecord.setChannelId(DynamicObjectUtils.getPkValue((DynamicObject)obj, (String)"channel"));
                accountRecord.setAreaDeptId(DynamicObjectUtils.getPkValue((DynamicObject)bill, (String)"areadept"));
                accountRecord.setOfficeId(DynamicObjectUtils.getPkValue((DynamicObject)bill, (String)"rptoffice"));
                accountRecord.setCountryId(DynamicObjectUtils.getPkValue((DynamicObject)bill, (String)"country"));
                accountRecord.setAccountType(DynamicObjectUtils.getPkValue((DynamicObject)obj, (String)"accounttype"));
                accountRecord.setAmount(obj.getBigDecimal("adjustamount"));
                accountRecord.setSourceBillId(DynamicObjectUtils.getPkValue((DynamicObject)bill));
                accountRecord.setSourceEntryId(DynamicObjectUtils.getPkValue((DynamicObject)obj));
                accountRecord.setSourceBillNo(bill.getString("billno"));
                accountRecord.setBillType("C");
                accountRecord.setCurrencyId(DynamicObjectUtils.getPkValue((DynamicObject)obj, (String)"currency"));
                if (AccountPoolTypeEnum.CHANNEL.getValue().equalsIgnoreCase(poolType)) {
                    accountRecord.setReceiveChannelId(DynamicObjectUtils.getPkValue((DynamicObject)bill, (String)"receivechannel"));
                    accountRecord.setPoolType(AccountPoolTypeEnum.CHANNEL.getValue());
                } else {
                    accountRecord.setPoolType(AccountPoolTypeEnum.BRANDS.getValue());
                    accountRecord.setOrgId(DynamicObjectUtils.getPkValue((DynamicObject)bill, (String)"org"));
                    accountRecord.setCustomerId(DynamicObjectUtils.getPkValue((DynamicObject)obj, (String)"customer"));
                }
                accountRecord.setUpdateType(AccountUpdateTypeEnum.balanceAdjust.getValue());
                accountRecord.setBillEntity(collect[i].getDynamicObjectType().getName());
                if (obj.getBigDecimal("adjustamount").compareTo(BigDecimal.ZERO) < 0) {
                    accountRecord.setUpdateOccupy(true);
                } else {
                    accountRecord.setUpdateOccupy(false);
                }
                accountRecord.setIsAutoCreateRebateAccount(true);
                accountRecordList.add(accountRecord);
            }
        }
        if (CollectionUtils.isNotEmpty(accountRecordList)) {
            RebateServiceInvokeHelper.getRebateServiceResultList(accountRecordList);
        }
    }
}

