/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.opplugin.adjustamount;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang.StringUtils;

public class AdjustAmountImportOp
extends BatchImportPlugin {
    private static final String COL_NUMBER = ".number";

    protected ApiResult save(List<ImportBillData> billdatas, ImportLogger logger) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<ImportBillData> billDataIterator = billdatas.iterator();
        while (billDataIterator.hasNext()) {
            ImportBillData singleBillData = billDataIterator.next();
            String validMsg = this.checkData(singleBillData, hashSet);
            if (StringUtils.isNotBlank((String)validMsg)) {
                logger.log(Integer.valueOf(singleBillData.getStartIndex()), validMsg).fail();
                billDataIterator.remove();
                continue;
            }
            JSONObject adjustBill = singleBillData.getData();
            this.setAdjustBillMainInfo(adjustBill);
            this.setAdjustBillEntryInfo(adjustBill);
        }
        return super.save(billdatas, logger);
    }

    private void setAdjustBillEntryInfo(JSONObject adjustBill) {
        String adjustType = adjustBill.getString("adjusttype");
        JSONObject org = adjustBill.getJSONObject("org");
        JSONObject receiveChannel = adjustBill.getJSONObject("receivechannel");
        JSONArray entity = adjustBill.getJSONArray("entryentity");
        if (entity != null) {
            for (int i = 0; i < entity.size(); ++i) {
                JSONObject entry = entity.getJSONObject(i);
                JSONObject channel = entry.getJSONObject("channel");
                JSONObject currency = entry.getJSONObject("currency");
                JSONObject accountType = entry.getJSONObject("accounttype");
                QFilter filter = new QFilter("channel.number", "=", (Object)channel.getString("number"));
                filter.and("setcurrency.number", "=", (Object)currency.getString("number"));
                filter.and("accounttype.number", "=", (Object)accountType.getString("number"));
                if ("A".equalsIgnoreCase(adjustType)) {
                    JSONObject customer = entry.getJSONObject("customer");
                    filter = new QFilter("org.number", "=", (Object)org.getString("number"));
                    filter.and("customer.number", "=", (Object)customer.getString("number"));
                } else {
                    adjustBill.put("org", (Object)0L);
                    entry.put("customer", (Object)0L);
                    filter.and("receivechannel.number", "=", (Object)receiveChannel.getString("number"));
                }
                DynamicObject account = BusinessDataServiceHelper.loadSingle((String)"ocdbd_rebateaccount", (String)String.join((CharSequence)",", "id", "number", "balance"), (QFilter[])filter.toArray());
                if (account == null) continue;
                entry.put("accountamount", (Object)account.getBigDecimal("balance"));
                BigDecimal adjustAmount = entry.getBigDecimal("adjustamount");
                BigDecimal afterAmount = account.getBigDecimal("balance").add(adjustAmount);
                entry.put("adjustedamount", (Object)afterAmount);
            }
        }
    }

    private void setAdjustBillMainInfo(JSONObject adjustBill) {
        adjustBill.put("billstatus", (Object)"A");
        adjustBill.put("areadept_id", (Object)1107277408660427776L);
        adjustBill.put("rptoffice_id", (Object)1107277588671566848L);
        adjustBill.put("country_id", (Object)1102720996932074496L);
    }

    private String checkData(ImportBillData data, HashSet<String> hashSet) {
        DynamicObject billInfo;
        JSONObject adjustBill = data.getData();
        if (adjustBill.containsKey((Object)"billno") && (billInfo = BusinessDataServiceHelper.loadSingle((String)this.getBillFormId(), (QFilter[])new QFilter("billno", "=", (Object)adjustBill.getString("billno")).toArray())) != null) {
            if (!"new".equals(this.ctx.getOption().get("importtype").toString())) {
                if (!"A".equalsIgnoreCase(billInfo.getString("billstatus"))) {
                    return ResManager.loadKDString((String)"\u975e\u6682\u5b58\u72b6\u6001\u4e0b\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"AdjustAmountImportOp_0", (String)"occ-occba-opplugin", (Object[])new Object[0]);
                }
            } else {
                return ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"AdjustAmountImportOp_1", (String)"occ-occba-opplugin", (Object[])new Object[0]);
            }
        }
        String adjustType = adjustBill.getString("adjusttype");
        JSONObject org = adjustBill.getJSONObject("org");
        JSONObject receiveChannel = adjustBill.getJSONObject("receivechannel");
        if ("A".equalsIgnoreCase(adjustType) && org == null) {
            return ResManager.loadKDString((String)"\u8c03\u6574\u7c7b\u578b\u4e3a\u54c1\u724c\u5546\u7684\u5355\u636e\uff0c\u7ed3\u7b97\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"AdjustAmountImportOp_2", (String)"occ-occba-opplugin", (Object[])new Object[0]);
        }
        if ("B".equalsIgnoreCase(adjustType) && receiveChannel == null) {
            return ResManager.loadKDString((String)"\u8c03\u6574\u7c7b\u578b\u4e3a\u6e20\u9053\u5546\u7684\u5355\u636e\uff0c\u6536\u5165\u6e20\u9053\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"AdjustAmountImportOp_3", (String)"occ-occba-opplugin", (Object[])new Object[0]);
        }
        JSONArray entity = adjustBill.getJSONArray("entryentity");
        if (entity != null) {
            for (int i = 0; i < entity.size(); ++i) {
                JSONObject customer;
                JSONObject entry = entity.getJSONObject(i);
                if (!"A".equalsIgnoreCase(adjustType) || (customer = entry.getJSONObject("customer")) != null) continue;
                return ResManager.loadKDString((String)"\u8c03\u6574\u7c7b\u578b\u4e3a\u54c1\u724c\u5546\u7684\u5355\u636e\uff0c\u76f4\u63a5\u5ba2\u6237\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"AdjustAmountImportOp_4", (String)"occ-occba-opplugin", (Object[])new Object[0]);
            }
        }
        return null;
    }
}

