/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.opplugin.balanceoccupy.validators;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.occba.business.rebate.IncentiveBalanceHelper;

public class BalanceOccupyValidator
extends AbstractValidator {
    public void validate() {
        String key = this.getOperateKey();
        if ("save".equalsIgnoreCase(key) || "submit".equalsIgnoreCase(key)) {
            for (ExtendedDataEntity data : this.dataEntities) {
                this.checkOccupyDataEntity(data);
            }
        }
    }

    private void checkOccupyDataEntity(ExtendedDataEntity data) {
        DynamicObject dataEntity = data.getDataEntity();
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity.getDynamicObject("org"));
        long receiveChannelId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity.getDynamicObject("receivechannel"));
        DynamicObjectCollection occupyAccountList = dataEntity.getDynamicObjectCollection("entryentity");
        for (DynamicObject occupyAccount : occupyAccountList) {
            long customerId = DynamicObjectUtils.getPkValue((DynamicObject)occupyAccount.getDynamicObject("customer"));
            long chanelId = DynamicObjectUtils.getPkValue((DynamicObject)occupyAccount.getDynamicObject("channel"));
            long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)occupyAccount.getDynamicObject("currency"));
            long accountTypeId = DynamicObjectUtils.getPkValue((DynamicObject)occupyAccount.getDynamicObject("accounttype"));
            DynamicObject queryAccount = IncentiveBalanceHelper.queryRebateAccount((long)orgId, (long)customerId, (long)chanelId, (long)receiveChannelId, (long)accountTypeId, (long)currencyId);
            if (queryAccount == null) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u8be5\u7ef4\u5ea6\u4e0b\u4e0d\u5b58\u5728\u8d44\u91d1\u6c60\u8d26\u6237\u3002", (String)"BalanceOccupyValidator_0", (String)"occ-occba-opplugin", (Object[])new Object[0]), occupyAccount.getInt("seq")));
                continue;
            }
            BigDecimal balance = queryAccount.getBigDecimal("balance");
            if (balance.compareTo(BigDecimal.ZERO) <= 0) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u8d26\u6237\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u4e0d\u53ef\u51bb\u7ed3\u3002", (String)"BalanceOccupyValidator_1", (String)"occ-occba-opplugin", (Object[])new Object[0]), occupyAccount.getInt("seq")));
                continue;
            }
            BigDecimal occupyAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)occupyAccount, (String)"occupyamount");
            BigDecimal newOccupyAmount = occupyAmount.add(queryAccount.getBigDecimal("occupyamount"));
            BigDecimal newAvailableAmount = balance.subtract(newOccupyAmount);
            if (newAvailableAmount.compareTo(BigDecimal.ZERO) >= 0) continue;
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u51bb\u7ed3\u540e\uff0c\u8d26\u6237\u53ef\u7528\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e0\u3002", (String)"BalanceOccupyValidator_2", (String)"occ-occba-opplugin", (Object[])new Object[0]), occupyAccount.getInt("seq")));
        }
    }
}

