/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.opplugin.checkaccount;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.enums.Checked;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.ocbase.opplugin.base.OcBaseOperationServicePlugIn;

public class CheckAccountAuditOp
extends OcBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("customer");
        fieldKeys.add("settleorg");
        fieldKeys.add("settlechannel");
        fieldKeys.add("currency");
        fieldKeys.add("period");
        fieldKeys.add("balance");
        fieldKeys.add("checkdate");
        fieldKeys.add("invalidstatus");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities != null && dataEntities.length > 0) {
            this.setUniqueInvalidBill(dataEntities);
            this.saveChannelBalance(dataEntities);
        }
        super.beginOperationTransaction(e);
    }

    private void setUniqueInvalidBill(DynamicObject[] dataEntities) {
        ArrayList<Long> billIds = new ArrayList<Long>(dataEntities.length);
        ArrayList<String> keyList = new ArrayList<String>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            billIds.add(dataEntity.getLong("id"));
            String periodUniqueKey = dataEntity.getLong("settleorg_id") + "_" + dataEntity.getLong("customer_id") + "_" + dataEntity.getLong("currency_id") + "_" + dataEntity.getLong("period_id");
            if (keyList.contains(periodUniqueKey)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u5ba1\u6838\u7ed3\u7b97\u7ec4\u7ec7\u3001\u5ba2\u6237\u3001\u5e01\u522b\u76f8\u540c\u7684\u540c\u4e00\u671f\u95f4\u5185\u7684\u5355\u636e", (String)"CheckAccountAuditOp_0", (String)"occ-occba-opplugin", (Object[])new Object[0]));
            }
            keyList.add(periodUniqueKey);
        }
        ArrayList<DynamicObject> checkAccountList = new ArrayList<DynamicObject>();
        for (String key : keyList) {
            QFilter filter = new QFilter("id", "not in", billIds);
            filter.and("settleorg", "=", (Object)Long.parseLong(key.split("_")[0]));
            filter.and("customer", "=", (Object)Long.parseLong(key.split("_")[1]));
            filter.and("currency", "=", (Object)Long.parseLong(key.split("_")[2]));
            filter.and("period", "=", (Object)Long.parseLong(key.split("_")[3]));
            filter.and("invalidstatus", "=", (Object)"A");
            DynamicObject[] dataArray = BusinessDataServiceHelper.load((String)"occba_checkaccount", (String)String.join((CharSequence)",", "id", "period", "invalidstatus"), (QFilter[])filter.toArray());
            checkAccountList.addAll(Arrays.asList(dataArray));
        }
        if (!checkAccountList.isEmpty()) {
            for (DynamicObject data : checkAccountList) {
                data.set("invalidstatus", (Object)"B");
            }
            SaveServiceHelper.save((DynamicObject[])checkAccountList.toArray(new DynamicObject[checkAccountList.size()]));
        }
    }

    private void saveChannelBalance(DynamicObject[] dataEntities) {
        ArrayList channelBalanceId = new ArrayList();
        ArrayList<DynamicObject> channelBalanceList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            long periodId = dataEntity.getLong("period_id");
            long settleOrgId = dataEntity.getLong("settleorg_id");
            long settleChannelId = dataEntity.getLong("settlechannel_id");
            long customerId = dataEntity.getLong("customer_id");
            long currencyId = dataEntity.getLong("currency_id");
            QFilter filter = new QFilter("periodid", "=", (Object)periodId);
            filter.and("settleorg", "=", (Object)settleOrgId);
            filter.and("channelid", "=", (Object)settleChannelId);
            filter.and("customerid", "=", (Object)customerId);
            filter.and("currencyid", "=", (Object)currencyId);
            filter.and("accountid", "=", (Object)1176015964144286720L);
            List ids = QueryServiceHelper.queryPrimaryKeys((String)"occba_channelbalance", (QFilter[])filter.toArray(), (String)"id desc", (int)999999);
            if (ids != null && !ids.isEmpty()) {
                channelBalanceId.addAll(ids);
            }
            DynamicObject channelBalance = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"occba_channelbalance"));
            channelBalance.set("periodid", (Object)dataEntity.getLong("period_id"));
            channelBalance.set("settleorg", (Object)dataEntity.getLong("settleorg_id"));
            channelBalance.set("channelid", (Object)dataEntity.getLong("settlechannel_id"));
            channelBalance.set("customerid", (Object)dataEntity.getLong("customer_id"));
            channelBalance.set("accountid", (Object)1176015964144286720L);
            channelBalance.set("currencyid", (Object)dataEntity.getLong("currency_id"));
            channelBalance.set("balanceamount", (Object)dataEntity.getBigDecimal("balance"));
            channelBalance.set("type", (Object)"B");
            channelBalance.set("creator", (Object)UserUtil.getCurrUserId());
            channelBalance.set("status", (Object)Checked.YES.toString());
            channelBalance.set("billstatus", (Object)"C");
            channelBalanceList.add(channelBalance);
        }
        if (!channelBalanceId.isEmpty()) {
            QFilter filter = new QFilter("id", "in", channelBalanceId);
            DeleteServiceHelper.delete((String)"occba_channelbalance", (QFilter[])filter.toArray());
        }
        OperationServiceHelper.executeOperate((String)"save", (String)"occba_channelbalance", (DynamicObject[])channelBalanceList.toArray(new DynamicObject[channelBalanceList.size()]), (OperateOption)CommonUtils.getOperateOption());
    }
}

