/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.opplugin.itemsupadjust;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.occ.ocbase.common.entity.itemsup.ItemSuppParam;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.opplugin.base.OcBaseOperationServicePlugIn;
import kd.occ.occba.business.itemsupplement.ItemSupplementPoolHelper;

public class ItemSupplementAuditOp
extends OcBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("entryentity");
        fieldKeys.add(String.join((CharSequence)".", "entryentity", "customer"));
        fieldKeys.add(String.join((CharSequence)".", "entryentity", "item"));
        fieldKeys.add(String.join((CharSequence)".", "entryentity", "material"));
        fieldKeys.add(String.join((CharSequence)".", "entryentity", "auxpty"));
        fieldKeys.add(String.join((CharSequence)".", "entryentity", "unit"));
        fieldKeys.add(String.join((CharSequence)".", "entryentity", "seq"));
        fieldKeys.add(String.join((CharSequence)".", "entryentity", "adjustqty"));
        fieldKeys.add(String.join((CharSequence)".", "entryentity", "afterqty"));
        fieldKeys.add(String.join((CharSequence)".", "entryentity", "availableqty"));
        fieldKeys.add(String.join((CharSequence)".", "entryentity", "rebateaccount"));
        fieldKeys.add(String.join((CharSequence)".", "entryentity", "itemsupplement"));
        fieldKeys.add("billno");
        fieldKeys.add("org");
        fieldKeys.add("account");
        fieldKeys.add("adjusttype");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] collect = e.getDataEntities();
        this.updateItemSuppParamListByAdjustType(collect);
    }

    private void updateItemSuppParamListByAdjustType(DynamicObject[] collect) {
        if (collect == null || collect.length == 0) {
            return;
        }
        int length = collect.length;
        ArrayList<ItemSuppParam> insertList = new ArrayList<ItemSuppParam>(length);
        ArrayList<ItemSuppParam> updateList = new ArrayList<ItemSuppParam>(length);
        for (int i = 0; i < collect.length; ++i) {
            DynamicObject billDynObj = collect[i];
            if (billDynObj == null) continue;
            DynamicObjectCollection recEntryColl = billDynObj.getDynamicObjectCollection("entryentity");
            String adjustType = DynamicObjectUtils.getString((DynamicObject)billDynObj, (String)"adjusttype");
            for (DynamicObject entry : recEntryColl) {
                ItemSuppParam param = new ItemSuppParam();
                param.setSettOrgId(DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"org"));
                param.setChannelId(DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)"customer"));
                param.setItemId(DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)"item"));
                param.setMaterialId(DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)"material"));
                param.setAuxptyId(DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)"auxpty"));
                param.setUnitId(DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)"unit"));
                param.setUpdateQty(entry.getBigDecimal("adjustqty"));
                param.setSourceBillNo(billDynObj.getString("billno"));
                param.setSourceBillEntity("occba_suppadjust");
                if ("B".equalsIgnoreCase(adjustType)) {
                    param.setRebateAccountId(DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"account"));
                    insertList.add(param);
                    continue;
                }
                param.setRebateAccountId(DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("itemsupplement"), (String)"rebateaccount"));
                updateList.add(param);
            }
        }
        ItemSupplementPoolHelper.balanceAdjust(updateList);
        ItemSupplementPoolHelper.insertItemSupplementByAdjust(insertList);
    }
}

