/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.opplugin.itemsupadjust.validators;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.occba.business.itemsupplement.ItemSupplementPoolHelper;
import org.apache.commons.collections.CollectionUtils;

public class ItemSupplementValidator
extends AbstractValidator {
    public void validate() {
        String key = this.getOperateKey();
        if ("save".equalsIgnoreCase(key) || "submit".equalsIgnoreCase(key)) {
            for (ExtendedDataEntity data : this.dataEntities) {
                DynamicObject dataEntity = data.getDataEntity();
                this.checkDataValue(data, dataEntity);
                DynamicObjectCollection detailList = dataEntity.getDynamicObjectCollection("entryentity");
                long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity.getDynamicObject("org"));
                long pkValue = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity);
                this.checkAdjustExist(data, pkValue, orgId, detailList);
                this.checkAuxptyMustInput(data, dataEntity);
            }
        }
    }

    private void checkDataValue(ExtendedDataEntity data, DynamicObject dataEntity) {
        long accountOrgId;
        String adjustType = dataEntity.getString("adjusttype");
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity.getDynamicObject("org"));
        if ("A".equalsIgnoreCase(adjustType)) {
            DynamicObjectCollection detailList = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject detail : detailList) {
                long accountOrgId2 = DynamicObjectUtils.getPkValue((DynamicObject)detail.getDynamicObject("itemsupplement"), (String)"org");
                if (orgId == accountOrgId2) continue;
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u8d27\u8865\u6c60\u8c03\u6574\u5355\u7684\u7ed3\u7b97\u7ec4\u7ec7\u548c\u8d44\u91d1\u6c60\u7684\u7ed3\u7b97\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"ItemSupplementValidator_0", (String)"occ-occba-opplugin", (Object[])new Object[0]), detail.getInt("seq")));
            }
        } else if ("B".equalsIgnoreCase(adjustType) && orgId != (accountOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity.getDynamicObject("account"), (String)"org"))) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8d27\u8865\u6c60\u8c03\u6574\u5355\u7684\u7ed3\u7b97\u7ec4\u7ec7\u548c\u8d44\u91d1\u6c60\u7684\u7ed3\u7b97\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"ItemSupplementValidator_1", (String)"occ-occba-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkAdjustExist(ExtendedDataEntity data, long pkValue, long orgId, DynamicObjectCollection detailList) {
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u586b\u5199\u4e00\u6761\u8d27\u8865\u4fe1\u606f\u3002", (String)"ItemSupplementValidator_2", (String)"occ-occba-opplugin", (Object[])new Object[0]));
        }
        ItemSupplementPoolHelper.checkDetailExist((DynamicObjectCollection)detailList);
    }

    private void checkAuxptyMustInput(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        String adjustType = dataEntity.getString("adjusttype");
        if ("B".equalsIgnoreCase(adjustType)) {
            DynamicObjectCollection entryColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
            if (CollectionUtils.isEmpty((Collection)entryColl)) {
                return;
            }
            for (DynamicObject entryItem : entryColl) {
                DynamicObject material = DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"material");
                if (material == null || !DynamicObjectUtils.getBoolean((DynamicObject)material, (String)"isuseauxpty") || DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entryItem, (String)"auxpty") != 0L) continue;
                String seq = DynamicObjectUtils.getString((DynamicObject)entryItem, (String)"seq");
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8d27\u8865\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u5546\u54c1\u7269\u6599\u542f\u7528\u8f85\u52a9\u5c5e\u6027\uff0c\u8f85\u52a9\u5c5e\u6027\u5fc5\u5f55\u3002", (String)"ItemSupplementValidator_3", (String)"occ-occba-opplugin", (Object[])new Object[0]), seq));
            }
        }
    }
}

