/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.opplugin.moneyusesetting;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;

public class MoneyUseSettingSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas;
        for (ExtendedDataEntity data : datas = this.getDataEntities()) {
            Set logicalRelationSet;
            DynamicObject billDynObj = data.getDataEntity();
            String msg = this.verifyUniqueData(billDynObj);
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                this.addErrorMessage(data, msg);
            }
            if ((logicalRelationSet = billDynObj.getDynamicObjectCollection("entryentity").stream().map(o -> o.getString("logicalrealtion")).collect(Collectors.toSet())).size() <= 1) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u6e20\u9053\u8303\u56f4\u4e2d\u7684\u903b\u8f91\u5173\u7cfb\u65e2\u6709\u4f8b\u5916\u6392\u9664\u53c8\u6709\u5305\u542b\u5173\u7cfb\uff0c\u9020\u6210\u63a7\u5236\u4e0d\u5bf9\uff0c\u8bf7\u7edf\u4e00\u4e3a\u4f8b\u5916\u6392\u9664\u6216\u5305\u542b\u5173\u7cfb\u3002", (String)"MoneyUseSettingSaveValidator_1", (String)"occ-occba-opplugin", (Object[])new Object[0]));
        }
    }

    private String verifyUniqueData(DynamicObject billDynObj) {
        String msg = "";
        String billEntityId = DynamicObjectUtils.getStrPkValue((DynamicObject)billDynObj, (String)"billentityid");
        QFilter qFilter = new QFilter("billentityid", "=", (Object)billEntityId);
        long moneyAccountId = DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"moneyaccountid");
        qFilter = qFilter.and(new QFilter("moneyaccountid", "=", (Object)moneyAccountId));
        DynamicObject[] moneyUseDynObjs = BusinessDataServiceHelper.load((String)"occba_moneyusesetting", (String)String.join((CharSequence)",", "number", "billentityid", "billtypeid", "moneyaccountid", "enable"), (QFilter[])qFilter.toArray());
        if (!CommonUtils.isNull((Object)moneyUseDynObjs)) {
            Set billTypeIdSet = billDynObj.getDynamicObjectCollection("billtypeid").stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toSet());
            HashSet<String> numberSet = new HashSet<String>(10);
            for (DynamicObject moneyUseDynObj : moneyUseDynObjs) {
                if (DynamicObjectUtils.getPkValue((DynamicObject)moneyUseDynObj) == DynamicObjectUtils.getPkValue((DynamicObject)billDynObj)) continue;
                Set existBillTypeIdSet = moneyUseDynObj.getDynamicObjectCollection("billtypeid").stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toSet());
                for (Long billTypeId : billTypeIdSet) {
                    if (!existBillTypeIdSet.contains(billTypeId)) continue;
                    numberSet.add(moneyUseDynObj.getString("number"));
                }
            }
            if (!numberSet.isEmpty()) {
                msg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u4e2d\u7684\u8d44\u91d1\u4f7f\u7528\u5355\u636e\u3001\u8d44\u91d1\u8d26\u6237\u3001\u5355\u636e\u7c7b\u578b\u4e0d\u5141\u8bb8\u91cd\u590d\u914d\u7f6e\u3002", (String)"MoneyUseSettingSaveValidator_3", (String)"occ-occba-opplugin", (Object[])new Object[0]), StringUtils.join((Object[])numberSet.toArray(), (char)','));
            }
        }
        return msg;
    }
}

