/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.business.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.entity.AccountRecord;
import kd.occ.ocbase.common.entity.ServiceResult;
import kd.occ.ocbase.common.enums.AccountPoolTypeEnum;
import kd.occ.ocbase.common.enums.AccountUpdateTypeEnum;
import kd.occ.ocbase.common.util.CollectionUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.occba.business.rebateservice.RebateServiceInvokeHelper;

public class BalanceOccupyHelper {
    public static void addPreparePropertys(List<String> cols) {
        cols.add("billstatus");
        cols.add("occupytype");
        cols.add("occupystatus");
        cols.add("org");
        cols.add("receivechannel");
        cols.add("entryentity");
        cols.add("releaseuser");
        cols.add("releasedate");
        cols.add("entryentity.customer");
        cols.add("entryentity.accounttype");
        cols.add("entryentity.currency");
        cols.add("entryentity.channel");
        cols.add("entryentity.occupyamount");
        cols.add("entryentity.accountamount");
        cols.add("entryentity.oldavailableamount");
        cols.add("entryentity.newavailableamount");
    }

    public static void releaseBalanceOccupyBill(DynamicObject[] balanceOccupy) {
        DynamicObject[] balanceOccupyList;
        List<ServiceResult> serviceResultList = BalanceOccupyHelper.updateRebateAccountList(balanceOccupy, AccountUpdateTypeEnum.amountunfrozen);
        if (CollectionUtil.isNull(serviceResultList)) {
            return;
        }
        ArrayList<Long> billIdList = new ArrayList<Long>(serviceResultList.size());
        for (ServiceResult serviceResult : serviceResultList) {
            if (!serviceResult.isSuccess()) continue;
            billIdList.add(serviceResult.getBillId());
        }
        QFilter filter = new QFilter("id", "in", billIdList);
        for (DynamicObject billInfo : balanceOccupyList = BusinessDataServiceHelper.load((String)"occba_occupybalance_pp", (String)String.join((CharSequence)",", "occupystatus", "id", "releaseuser", "releasedate"), (QFilter[])filter.toArray())) {
            billInfo.set("occupystatus", (Object)"C");
            billInfo.set("releaseuser", (Object)RequestContext.get().getCurrUserId());
            billInfo.set("releasedate", (Object)KDDateUtils.now());
        }
        SaveServiceHelper.update((DynamicObject[])balanceOccupyList);
    }

    public static List<ServiceResult> updateRebateAccountList(DynamicObject[] balanceOccupy, AccountUpdateTypeEnum updateType) {
        if (balanceOccupy == null || balanceOccupy.length == 0) {
            return new ArrayList<ServiceResult>(0);
        }
        int size = balanceOccupy.length;
        ArrayList<AccountRecord> accountRecordList = new ArrayList<AccountRecord>(size);
        for (int i = 0; i < size; ++i) {
            DynamicObject billInfo = balanceOccupy[i];
            String occupyType = billInfo.getString("occupytype");
            DynamicObjectCollection entryEntity = billInfo.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                AccountRecord accountRecord = new AccountRecord();
                accountRecord.setChannelId(DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)"channel"));
                accountRecord.setAccountType(DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)"accounttype"));
                accountRecord.setAmount(entry.getBigDecimal("occupyamount"));
                accountRecord.setCurrencyId(DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)"currency"));
                if (AccountPoolTypeEnum.CHANNEL.getValue().equalsIgnoreCase(occupyType)) {
                    accountRecord.setPoolType(AccountPoolTypeEnum.CHANNEL.getValue());
                    accountRecord.setReceiveChannelId(DynamicObjectUtils.getPkValue((DynamicObject)billInfo, (String)"receivechannel"));
                } else {
                    accountRecord.setPoolType(AccountPoolTypeEnum.BRANDS.getValue());
                    accountRecord.setOrgId(DynamicObjectUtils.getPkValue((DynamicObject)billInfo, (String)"org"));
                    accountRecord.setCustomerId(DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)"customer"));
                }
                accountRecord.setUpdateType(updateType.getValue());
                accountRecord.setAmount(entry.getBigDecimal("occupyamount"));
                accountRecord.setSourceBillId(DynamicObjectUtils.getPkValue((DynamicObject)billInfo));
                accountRecord.setSourceEntryId(DynamicObjectUtils.getPkValue((DynamicObject)entry));
                accountRecord.setSourceBillNo(billInfo.getString("billno"));
                accountRecord.setBillEntity(billInfo.getDynamicObjectType().getName());
                accountRecordList.add(accountRecord);
            }
        }
        return RebateServiceInvokeHelper.getRebateServiceResultList(accountRecordList);
    }

    public static void updateOccupyBillOccupyStatus(List<ServiceResult> serviceResultList, String occupyStatus) {
        if (CollectionUtil.isNull(serviceResultList)) {
            return;
        }
        ArrayList<Long> billIdList = new ArrayList<Long>(serviceResultList.size());
        for (ServiceResult serviceResult : serviceResultList) {
            if (!serviceResult.isSuccess()) continue;
            billIdList.add(serviceResult.getBillId());
        }
        BalanceOccupyHelper.updateOccupyStatusByIds(billIdList, occupyStatus);
    }

    private static void updateOccupyStatusByIds(List<Long> billIdList, String occupyStatus) {
        DynamicObject[] balanceOccupyList;
        QFilter filter = new QFilter("id", "in", billIdList);
        for (DynamicObject balanceOccupy : balanceOccupyList = BusinessDataServiceHelper.load((String)"occba_occupybalance_pp", (String)String.join((CharSequence)",", "occupystatus", "id"), (QFilter[])filter.toArray())) {
            balanceOccupy.set("occupystatus", (Object)occupyStatus);
        }
        SaveServiceHelper.update((DynamicObject[])balanceOccupyList);
    }
}

