/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.occ.ocbase.common.entity.AccountRecord;
import kd.occ.ocbase.common.enums.AccountPoolTypeEnum;
import kd.occ.ocbase.common.enums.AccountUpdateTypeEnum;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.occba.business.rebateservice.RebateServiceInvokeHelper;

public class MoneyIncomeHelper {
    private MoneyIncomeHelper() {
    }

    public static void batchUpdateRebateAccountListByAudit(DynamicObject[] billDynObjs) {
        List<AccountRecord> accountRecordList = MoneyIncomeHelper.getAccountRecordList(billDynObjs, false);
        if (!CommonUtils.isNull(accountRecordList)) {
            RebateServiceInvokeHelper.getRebateServiceResultList(accountRecordList);
        }
    }

    public static void batchUpdateRebateAccountListByUnAudit(DynamicObject[] billDynObjs) {
        List<AccountRecord> accountRecordList = MoneyIncomeHelper.getAccountRecordList(billDynObjs, true);
        if (!CommonUtils.isNull(accountRecordList)) {
            RebateServiceInvokeHelper.getRebateServiceResultList(accountRecordList);
        }
    }

    private static List<AccountRecord> getAccountRecordList(DynamicObject[] billDynObjs, boolean isNevigate) {
        if (CommonUtils.isNull((Object)billDynObjs)) {
            return new ArrayList<AccountRecord>(0);
        }
        ArrayList<AccountRecord> accountRecordList = new ArrayList<AccountRecord>(billDynObjs.length * 10);
        for (DynamicObject billDynObj : billDynObjs) {
            boolean isUpdateMoney = DynamicObjectUtils.getBoolean((DynamicObject)billDynObj.getDynamicObject("moneytypeid"), (String)"isupdatemoney");
            if (!isUpdateMoney) continue;
            DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("entryentity");
            boolean isChannel = AccountPoolTypeEnum.CHANNEL.getValue().equalsIgnoreCase(billDynObj.getString("pooltype"));
            String poolType = isChannel ? AccountPoolTypeEnum.CHANNEL.getValue() : AccountPoolTypeEnum.BRANDS.getValue();
            for (DynamicObject recEntryDynObj : entryColl) {
                AccountRecord accountRecord = MoneyIncomeHelper.createAccountRecord(billDynObj, recEntryDynObj, isNevigate);
                accountRecord.setIsAutoCreateRebateAccount(true);
                accountRecord.setPoolType(poolType);
                accountRecord.setUpdateType(AccountUpdateTypeEnum.balanceAdjust.getValue());
                accountRecordList.add(accountRecord);
            }
        }
        return accountRecordList;
    }

    private static AccountRecord createAccountRecord(DynamicObject billDynObj, DynamicObject recEntryDynObj, boolean isNevigate) {
        AccountRecord accountRecord = new AccountRecord();
        long accountTypeId = DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"moneyaccountid");
        BigDecimal recAmount = recEntryDynObj.getBigDecimal("recamount");
        String updateType = DynamicObjectUtils.getString((DynamicObject)billDynObj.getDynamicObject("moneytypeid"), (String)"updatetype");
        if ("1".equals(updateType)) {
            recAmount = recAmount.negate();
        }
        accountRecord.setBillType("E");
        accountRecord.setBillEntity("occba_moneyincome");
        if (AccountPoolTypeEnum.CHANNEL.getValue().equalsIgnoreCase(billDynObj.getString("pooltype"))) {
            accountRecord.setReceiveChannelId(DynamicObjectUtils.getPkValue((DynamicObject)recEntryDynObj, (String)"settlechannel"));
        } else {
            accountRecord.setCustomerId(DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"paycustomerid"));
            accountRecord.setOrgId(DynamicObjectUtils.getPkValue((DynamicObject)recEntryDynObj, (String)"settleorgid"));
        }
        accountRecord.setSourceBillNo(billDynObj.getString("billno"));
        accountRecord.setChannelId(DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"paychannelid"));
        accountRecord.setSourceBillId(DynamicObjectUtils.getPkValue((DynamicObject)billDynObj));
        accountRecord.setSourceEntryId(DynamicObjectUtils.getPkValue((DynamicObject)recEntryDynObj));
        accountRecord.setAccountType(accountTypeId);
        if (isNevigate) {
            accountRecord.setAmount(recAmount.negate());
        } else {
            accountRecord.setAmount(recAmount);
        }
        accountRecord.setCurrencyId(DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"currencyid"));
        return accountRecord;
    }
}

