/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.entity.AccountRecord;
import kd.occ.ocbase.common.entity.ServiceResult;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.occba.business.rebateservice.RebateCalculateHelper;
import org.apache.commons.collections.CollectionUtils;

public class RebateAccountHelper {
    private static final String RECORD_COLS = String.join((CharSequence)",", "org", "changeamount", "customer", "accout", "stmcurrency", "receivechannel", "sourcebillid", "sourcebillno", "billentity", "channel");

    public static List<ServiceResult> getSaleOrderAccountOccupyResult(List<AccountRecord> paramList) {
        if (CollectionUtils.isEmpty(paramList)) {
            return new ArrayList<ServiceResult>(0);
        }
        Map<String, List<AccountRecord>> paramAccountMap = paramList.stream().collect(Collectors.groupingBy(AccountRecord::getSourceBillNo));
        ArrayList<ServiceResult> resultList = new ArrayList<ServiceResult>(paramAccountMap.size());
        Map<String, DynamicObject> rebateAccountMap = RebateCalculateHelper.getQueryRebateAccountInfoMap(paramList);
        Map<String, BigDecimal> recordChangeAmountMap = RebateAccountHelper.queryRebateAccountRecord(paramList);
        for (Map.Entry<String, List<AccountRecord>> param : paramAccountMap.entrySet()) {
            List<AccountRecord> checkAccountList = param.getValue();
            ServiceResult serviceResult = new ServiceResult();
            serviceResult.setSuccess(true);
            serviceResult.setBillId(checkAccountList.get(0).getSourceBillId());
            serviceResult.setBillNo(param.getKey());
            ArrayList<String> accountNoList = new ArrayList<String>(3);
            for (AccountRecord accountRecord : checkAccountList) {
                BigDecimal changeAmount = recordChangeAmountMap.get(RebateAccountHelper.getAccountRecordKey(accountRecord));
                DynamicObject account = rebateAccountMap.get(accountRecord.getKey());
                if (changeAmount == null || changeAmount.compareTo(BigDecimal.ZERO) == 0 || account == null) continue;
                accountNoList.add(DynamicObjectUtils.getString((DynamicObject)account, (String)"number"));
            }
            if (CollectionUtils.isNotEmpty(accountNoList)) {
                serviceResult.setSuccess(false);
                serviceResult.setErrorMsg(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u8d44\u91d1\u6c60\u8d26\u6237\u5bf9\u5e94\u7684\u53d1\u751f\u91d1\u989d\u4e0d\u4e3a0\u3002", (String)"RebateAccountHelper_0", (String)"occ-occba-business", (Object[])new Object[0]), String.join((CharSequence)"\u3001", accountNoList)));
            }
            resultList.add(serviceResult);
        }
        return resultList;
    }

    private static Map<String, BigDecimal> queryRebateAccountRecord(List<AccountRecord> paramList) {
        QFilter filter = RebateAccountHelper.buildRebateAccountRecordFilters(paramList);
        DataSet dataSet1 = QueryServiceHelper.queryDataSet((String)RebateAccountHelper.class.getName(), (String)"occba_flowrecord", (String)RECORD_COLS, (QFilter[])filter.toArray(), null);
        GroupbyDataSet groupby = dataSet1.groupBy(new String[]{"org", "customer", "accout", "stmcurrency", "receivechannel", "channel", "sourcebillid", "sourcebillno", "billentity"});
        groupby = groupby.sum("changeamount");
        DataSet dataSet2 = groupby.finish();
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(paramList.size());
        for (Row row : dataSet2) {
            map.put(RebateAccountHelper.getKey(row), row.getBigDecimal("changeamount"));
        }
        return map;
    }

    private static String getAccountRecordKey(AccountRecord accountRecord) {
        return String.format("%s_%d_%s_%s", accountRecord.getKey(), accountRecord.getSourceBillId(), accountRecord.getSourceBillNo(), accountRecord.getBillEntity());
    }

    private static String getKey(Row row) {
        return String.format("%d_%d_%d_%d_%d_%d_%d_%s_%s", row.getLong("org"), row.getLong("channel"), row.getLong("customer"), row.getLong("stmcurrency"), row.getLong("accout"), row.getLong("receivechannel"), row.getLong("sourcebillid"), row.getString("sourcebillno"), row.getString("billentity"));
    }

    private static QFilter buildRebateAccountRecordFilters(List<AccountRecord> paramList) {
        QFilter filters = new QFilter("1", "!=", (Object)1);
        if (CollectionUtils.isEmpty(paramList)) {
            return filters;
        }
        for (AccountRecord account : paramList) {
            QFilter filter = new QFilter("org", "=", (Object)account.getOrgId());
            filter.and("channel", "=", (Object)account.getChannelId());
            filter.and("customer", "=", (Object)account.getCustomerId());
            filter.and("accout", "=", (Object)account.getAccountType());
            filter.and("stmcurrency", "=", (Object)account.getCurrencyId());
            filter.and("receivechannel", "=", (Object)account.getReceiveChannelId());
            filter.and("sourcebillid", "=", (Object)account.getSourceBillId());
            filter.and("sourcebillno", "=", (Object)account.getSourceBillNo());
            filter.and("billentity", "=", (Object)account.getBillEntity());
            filters.or(filter);
        }
        ArrayList<String> transactionList = new ArrayList<String>(4);
        transactionList.add("E");
        transactionList.add("H");
        transactionList.add("I");
        transactionList.add("J");
        QFilter totalFilter = new QFilter("transaction", "in", transactionList);
        totalFilter = totalFilter.and(filters);
        return totalFilter;
    }
}

