/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class SupplementCombineHelper {
    public static void batchCombineSupplementList(DynamicObject[] billDynObjs) {
        List suppList = DynamicObjectUtils.convertDynamicObjList((DynamicObject[])billDynObjs);
        SupplementCombineHelper.checkSupplementBeforeCombine(suppList);
        List<DynamicObject> recordList = SupplementCombineHelper.getSupplememtRecordIds(suppList);
        SupplementCombineHelper.copySupplememtAndRecord(suppList, recordList);
        SupplementCombineHelper.combineReduplicateSuppAndRecord(suppList, recordList);
    }

    private static void combineReduplicateSuppAndRecord(List<DynamicObject> suppList, List<DynamicObject> recordList) {
        BigDecimal totalSupqty = BigDecimal.ZERO;
        BigDecimal totalOccupyQty = BigDecimal.ZERO;
        BigDecimal totalAvailableQty = BigDecimal.ZERO;
        for (DynamicObject supp : suppList) {
            totalSupqty = totalSupqty.add(supp.getBigDecimal("supqty"));
            totalOccupyQty = totalOccupyQty.add(supp.getBigDecimal("occupyqty"));
            totalAvailableQty = totalAvailableQty.add(supp.getBigDecimal("availableqty"));
        }
        DynamicObject updateSupp = suppList.get(0);
        updateSupp.set("supqty", (Object)totalSupqty);
        updateSupp.set("occupyqty", (Object)totalOccupyQty);
        updateSupp.set("availableqty", (Object)totalAvailableQty);
        updateSupp.set("lastupdatetime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.update((DynamicObject)updateSupp);
        List deleteSupplememtIdList = suppList.stream().map(a -> DynamicObjectUtils.getPkValue((DynamicObject)a)).collect(Collectors.toList());
        deleteSupplememtIdList.remove(DynamicObjectUtils.getPkValue((DynamicObject)updateSupp));
        List<DynamicObject> deleteRecordList = recordList.stream().filter(record -> DynamicObjectUtils.getPkValue((DynamicObject)record, (String)"supplement") != DynamicObjectUtils.getPkValue((DynamicObject)updateSupp)).collect(Collectors.toList());
        SupplementCombineHelper.synchronousRecordToSupplement(updateSupp, deleteRecordList);
        List deleteRecordIdList = deleteRecordList.stream().map(a -> DynamicObjectUtils.getPkValue((DynamicObject)a)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deleteSupplememtIdList)) {
            QFilter deleteFilter = new QFilter("id", "in", deleteSupplememtIdList);
            DeleteServiceHelper.delete((String)"occba_supplement", (QFilter[])deleteFilter.toArray());
        }
        if (CollectionUtils.isNotEmpty(deleteRecordIdList)) {
            QFilter recordFilter = new QFilter("id", "in", deleteRecordIdList);
            DeleteServiceHelper.delete((String)"occba_suprecord", (QFilter[])recordFilter.toArray());
        }
    }

    private static void synchronousRecordToSupplement(DynamicObject updateSupp, List<DynamicObject> deleteRecordList) {
        if (CollectionUtils.isEmpty(deleteRecordList)) {
            return;
        }
        ArrayList<DynamicObject> synchronousRecordList = new ArrayList<DynamicObject>(deleteRecordList.size());
        for (DynamicObject record : deleteRecordList) {
            DynamicObject copyRecord = new DynamicObject(record.getDynamicObjectType());
            DynamicObjectUtils.copyPropertiesWithOutId((DynamicObject)copyRecord, (DynamicObject)record);
            copyRecord.set("mark", (Object)ResManager.loadKDString((String)"\u8d27\u8865\u6c60\u5408\u5e76", (String)"SupplementCombineHelper_0", (String)"occ-occba-business", (Object[])new Object[0]));
            copyRecord.set("supplement", (Object)updateSupp);
            synchronousRecordList.add(copyRecord);
        }
        SaveServiceHelper.save((DynamicObject[])synchronousRecordList.toArray(new DynamicObject[0]));
    }

    private static void copySupplememtAndRecord(List<DynamicObject> suppList, List<DynamicObject> recordList) {
        ArrayList<DynamicObject> copyList = new ArrayList<DynamicObject>(suppList.size());
        for (DynamicObject supp : suppList) {
            DynamicObject copySupp = BusinessDataServiceHelper.newDynamicObject((String)"occba_supplement_bak");
            copySupp.set("linkedsupplement", (Object)supp.getString("number"));
            copySupp.set("org", (Object)supp.getDynamicObject("org"));
            copySupp.set("item", (Object)supp.getDynamicObject("item"));
            copySupp.set("auxpty", (Object)supp.getDynamicObject("auxpty"));
            copySupp.set("unitid", (Object)supp.getDynamicObject("unitid"));
            copySupp.set("supqty", (Object)supp.getBigDecimal("supqty"));
            copySupp.set("channel", (Object)supp.getDynamicObject("channel"));
            copySupp.set("material", (Object)supp.getDynamicObject("material"));
            copySupp.set("occupyqty", (Object)supp.getBigDecimal("occupyqty"));
            copySupp.set("availableqty", (Object)supp.getBigDecimal("availableqty"));
            copySupp.set("rebateaccount", (Object)supp.getDynamicObject("rebateaccount"));
            copySupp.set("lastupdatetime", (Object)supp.getDate("lastupdatetime"));
            copyList.add(copySupp);
        }
        if (CollectionUtils.isNotEmpty(copyList)) {
            SaveServiceHelper.save((DynamicObject[])copyList.toArray(new DynamicObject[0]));
        }
        SupplementCombineHelper.copySupplememtRecordList(recordList);
    }

    private static void copySupplememtRecordList(List<DynamicObject> recordList) {
        if (CollectionUtils.isNotEmpty(recordList)) {
            ArrayList<DynamicObject> copyRecordList = new ArrayList<DynamicObject>(recordList.size());
            for (DynamicObject record : recordList) {
                DynamicObject copyRecord = BusinessDataServiceHelper.newDynamicObject((String)"occba_suprecord_bak");
                copyRecord.set("linkedsupplement", (Object)DynamicObjectUtils.getString((DynamicObject)record.getDynamicObject("supplement"), (String)"number"));
                copyRecord.set("channel", (Object)record.getDynamicObject("channel"));
                copyRecord.set("org", (Object)record.getDynamicObject("org"));
                copyRecord.set("item", (Object)record.getDynamicObject("item"));
                copyRecord.set("material", (Object)record.getDynamicObject("material"));
                copyRecord.set("auxpty", (Object)record.getDynamicObject("auxpty"));
                copyRecord.set("unit", (Object)record.getDynamicObject("unit"));
                copyRecord.set("beforeqty", (Object)record.getBigDecimal("beforeqty"));
                copyRecord.set("afterqty", (Object)record.getBigDecimal("afterqty"));
                copyRecord.set("updateqty", (Object)record.getBigDecimal("updateqty"));
                copyRecord.set("sourcebillno", (Object)record.getString("sourcebillno"));
                copyRecord.set("sourcebillentity", (Object)record.getDynamicObject("sourcebillentity"));
                copyRecord.set("creater", (Object)record.getDynamicObject("creater"));
                copyRecord.set("createdate", (Object)record.getDate("createdate"));
                copyRecordList.add(copyRecord);
            }
            SaveServiceHelper.save((DynamicObject[])copyRecordList.toArray(new DynamicObject[0]));
        }
    }

    private static List<DynamicObject> getSupplememtRecordIds(List<DynamicObject> supplementList) {
        List supplementIdList = supplementList.stream().map(a -> DynamicObjectUtils.getPkValue((DynamicObject)a)).collect(Collectors.toList());
        QFilter filter = new QFilter("supplement", "in", supplementIdList);
        DynamicObject[] recordList = BusinessDataServiceHelper.load((String)"occba_suprecord", (String)"id,supplement,sourcebillentity,sourcebillno,creater,createdate,updatetype,channel,org,item,material,unit,beforeqty,afterqty,updateqty,auxpty,mark", (QFilter[])filter.toArray());
        return DynamicObjectUtils.convertDynamicObjList((DynamicObject[])recordList);
    }

    private static void checkSupplementBeforeCombine(List<DynamicObject> suppList) {
        if (CollectionUtils.isEmpty(suppList) || suppList.size() < 2) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5408\u5e76\u7684\u8d27\u8865\u6c60\u6570\u636e\u3002", (String)"SupplementCombineHelper_1", (String)"occ-occba-business", (Object[])new Object[0]));
        }
        DynamicObject supplement = suppList.get(0);
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)supplement, (String)"org");
        long itemId = DynamicObjectUtils.getPkValue((DynamicObject)supplement, (String)"item");
        long unitId = DynamicObjectUtils.getPkValue((DynamicObject)supplement, (String)"unitid");
        long auxptyId = DynamicObjectUtils.getPkValue((DynamicObject)supplement, (String)"auxpty");
        long channelId = DynamicObjectUtils.getPkValue((DynamicObject)supplement, (String)"channel");
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)supplement, (String)"material");
        long rebateAccountId = DynamicObjectUtils.getPkValue((DynamicObject)supplement, (String)"rebateaccount");
        for (DynamicObject checkSupp : suppList) {
            if (DynamicObjectUtils.getPkValue((DynamicObject)checkSupp, (String)"rebateaccount") == rebateAccountId && DynamicObjectUtils.getPkValue((DynamicObject)checkSupp, (String)"org") == orgId && DynamicObjectUtils.getPkValue((DynamicObject)checkSupp, (String)"channel") == channelId && DynamicObjectUtils.getPkValue((DynamicObject)checkSupp, (String)"item") == itemId && DynamicObjectUtils.getPkValue((DynamicObject)checkSupp, (String)"auxpty") == auxptyId && DynamicObjectUtils.getPkValue((DynamicObject)checkSupp, (String)"material") == materialId && DynamicObjectUtils.getPkValue((DynamicObject)checkSupp, (String)"unitid") == unitId) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5408\u5e76\u540c\u4e00\u8d44\u91d1\u6c60\u4e0b\uff0c\u7ed3\u7b97\u7ec4\u7ec7\u3001\u6e20\u9053\u3001\u5546\u54c1\u3001\u7269\u6599\u3001\u8f85\u52a9\u5c5e\u6027\u4ee5\u53ca\u8ba1\u91cf\u5355\u4f4d\u4e00\u81f4\u7684\u8d27\u8865\u6c60\u6570\u636e\u3002", (String)"SupplementCombineHelper_2", (String)"occ-occba-business", (Object[])new Object[0]));
        }
        List suppIdList = suppList.stream().map(a -> DynamicObjectUtils.getPkValue((DynamicObject)a)).collect(Collectors.toList());
        QFilter filter = new QFilter(String.join((CharSequence)".", "entryentity", "itemsupplement"), "in", suppIdList);
        filter.and("billstatus", "!=", (Object)"C");
        DynamicObject[] adjustBillList = BusinessDataServiceHelper.load((String)"occba_suppadjust", (String)String.join((CharSequence)",", "billno", "entryentity", String.join((CharSequence)".", "entryentity", "itemsupplement")), (QFilter[])filter.toArray());
        if (adjustBillList != null && adjustBillList.length > 0) {
            List billNoList = DynamicObjectUtils.convertDynamicObjList((DynamicObject[])adjustBillList).stream().map(a -> DynamicObjectUtils.getString((DynamicObject)a, (String)"billno")).collect(Collectors.toList());
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8be5\u8d26\u6237\u5b58\u5728\u4e8e\u4fdd\u5b58\u3001\u63d0\u4ea4\u72b6\u6001\u7684\u8c03\u6574\u5355\uff0c\u4e0d\u80fd\u5408\u5e76\uff0c\u5bf9\u5e94\u5355\u636e\u7f16\u7801\u4e3a%1$s\u3002", (String)"SupplementCombineHelper_3", (String)"occ-occba-business", (Object[])new Object[0]), StringUtils.join(billNoList, (String)",")));
        }
    }
}

