/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.business.itemsupplement;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.entity.itemsup.ItemSuppParam;
import kd.occ.ocbase.common.entity.itemsup.ItemSupplement;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.occba.common.enums.ItemSupUpdateTypeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ItemSupplementProvider {
    public static DynamicObject[] queryItemSupplementInfoList(List<ItemSuppParam> itemSuppParamList) {
        if (CollectionUtils.isEmpty(itemSuppParamList)) {
            return null;
        }
        QFilter filters = ItemSupplementProvider.buildQueryItemSupplementFilter(itemSuppParamList);
        return BusinessDataServiceHelper.load((String)"occba_supplement", (String)"id,number,channel,org,item,material,auxpty,unitid,supqty,occupyqty,availableqty,lastupdatetime,rebateaccount", (QFilter[])filters.toArray());
    }

    public static DynamicObject[] queryItemSupplementInfoList(Set<Object> itemSuppIds) {
        if (CollectionUtils.isEmpty(itemSuppIds)) {
            return null;
        }
        QFilter filters = new QFilter("id", "in", itemSuppIds);
        return BusinessDataServiceHelper.load((String)"occba_supplement", (String)"id,number,channel,org,item,material,auxpty,unitid,supqty,occupyqty,availableqty,lastupdatetime,rebateaccount", (QFilter[])filters.toArray());
    }

    public static void checkAdjustAccountExist(long pkValue, long orgId, long channelId, long itemId, long materialId, long auxptyId, long unitId) {
        QFilter filter = new QFilter(String.join((CharSequence)".", "entryentity", "customer"), "=", (Object)channelId);
        filter.and(new QFilter("org", "=", (Object)orgId));
        filter.and(new QFilter(String.join((CharSequence)".", "entryentity", "item"), "=", (Object)itemId));
        filter.and(new QFilter(String.join((CharSequence)".", "entryentity", "material"), "=", (Object)materialId));
        filter.and(new QFilter(String.join((CharSequence)".", "entryentity", "auxpty"), "=", (Object)auxptyId));
        filter.and(new QFilter(String.join((CharSequence)".", "entryentity", "unit"), "=", (Object)unitId));
        filter.and(new QFilter("id", "!=", (Object)pkValue));
        DynamicObject adjustBill = ORM.create().queryOne("occba_suppadjust", filter.toArray());
        if (adjustBill != null) {
            DynamicObjectCollection adjustAccounts = adjustBill.getDynamicObjectCollection("entryentity");
            DynamicObject adjustInfo = (DynamicObject)adjustAccounts.get(0);
            ArrayList<String> nameList = new ArrayList<String>(6);
            String name = DynamicObjectUtils.getString((DynamicObject)adjustBill.getDynamicObject("org"), (String)"name");
            if (StringUtils.isNotEmpty((String)name)) {
                nameList.add(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%1$s\u3011", (String)"ItemSupplementProvider_23", (String)"occ-occba-business", (Object[])new Object[0]), name));
            }
            if (StringUtils.isNotEmpty((String)(name = DynamicObjectUtils.getString((DynamicObject)adjustInfo.getDynamicObject("customer"), (String)"name")))) {
                nameList.add(String.format(ResManager.loadKDString((String)"\u6e20\u9053\u3010%1$s\u3011", (String)"ItemSupplementProvider_24", (String)"occ-occba-business", (Object[])new Object[0]), name));
            }
            if (StringUtils.isNotEmpty((String)(name = DynamicObjectUtils.getString((DynamicObject)adjustInfo.getDynamicObject("item"), (String)"name")))) {
                nameList.add(String.format(ResManager.loadKDString((String)"\u5546\u54c1\u3010%1$s\u3011", (String)"ItemSupplementProvider_25", (String)"occ-occba-business", (Object[])new Object[0]), name));
            }
            if (StringUtils.isNotEmpty((String)(name = DynamicObjectUtils.getString((DynamicObject)adjustInfo.getDynamicObject("material"), (String)"name")))) {
                nameList.add(String.format(ResManager.loadKDString((String)"\u7269\u6599\u3010%1$s\u3011", (String)"ItemSupplementProvider_26", (String)"occ-occba-business", (Object[])new Object[0]), name));
            }
            if (StringUtils.isNotEmpty((String)(name = DynamicObjectUtils.getString((DynamicObject)adjustInfo.getDynamicObject("auxpty"), (String)"name")))) {
                nameList.add(String.format(ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027\u3010%1$s\u3011", (String)"ItemSupplementProvider_27", (String)"occ-occba-business", (Object[])new Object[0]), name));
            }
            if (StringUtils.isNotEmpty((String)(name = DynamicObjectUtils.getString((DynamicObject)adjustInfo.getDynamicObject("unit"), (String)"name")))) {
                nameList.add(String.format(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d\u3010%1$s\u3011", (String)"ItemSupplementProvider_28", (String)"occ-occba-business", (Object[])new Object[0]), name));
            }
            String errorMsg = String.format(ResManager.loadKDString((String)"[%1$s]\u7684\u8d27\u8865\u4fe1\u606f\u5df2\u5b58\u5728\u4e8e\u63d0\u4ea4\u72b6\u6001\u7684\u8c03\u6574\u5355\u4e2d\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u8c03\u6574\u3002", (String)"ItemSupplementProvider_29", (String)"occ-occba-business", (Object[])new Object[0]), StringUtils.join(nameList, (char)'\uff0c'));
            throw new KDBizException(errorMsg);
        }
    }

    public static List<ItemSupplement> getItemSupplementInfoList(List<ItemSuppParam> itemSuppParamList) {
        DynamicObject[] supList = ItemSupplementProvider.queryItemSupplementInfoList(itemSuppParamList);
        return ItemSupplementProvider.buildItemSupplementInfoList(supList);
    }

    public static void reimbursement(List<ItemSuppParam> itemSuppParamList, ItemSupUpdateTypeEnum itemSupUpdateType) {
        if (CollectionUtils.isEmpty(itemSuppParamList)) {
            return;
        }
        int size = itemSuppParamList.size();
        Map<String, List<ItemSuppParam>> paramMap = itemSuppParamList.stream().collect(Collectors.groupingBy(ItemSuppParam::getKey));
        Map<String, DynamicObject> existSupplementMap = ItemSupplementProvider.getExistSupplementInfoMap(itemSuppParamList);
        ArrayList<DynamicObject> updateSuppList = new ArrayList<DynamicObject>(size);
        ArrayList<DynamicObject> addSuppList = new ArrayList<DynamicObject>(size);
        ArrayList<DynamicObject> itemSupRecordList = new ArrayList<DynamicObject>(size);
        for (Map.Entry<String, List<ItemSuppParam>> inParam : paramMap.entrySet()) {
            ItemSuppParam updateParam = inParam.getValue().get(0);
            BigDecimal totalQty = inParam.getValue().stream().map(ItemSuppParam::getUpdateQty).reduce(BigDecimal.ZERO, BigDecimal::add);
            DynamicObject suppInfo = existSupplementMap.get(inParam.getKey());
            BigDecimal beforeSupQty = BigDecimal.ZERO;
            if (suppInfo == null) {
                suppInfo = ItemSupplementProvider.buildNewItemSupplement(updateParam, totalQty);
                addSuppList.add(suppInfo);
            } else {
                beforeSupQty = suppInfo.getBigDecimal("supqty");
                BigDecimal beforeOccupyQty = suppInfo.getBigDecimal("occupyqty");
                suppInfo.set("supqty", (Object)beforeSupQty.add(totalQty));
                suppInfo.set("availableqty", (Object)suppInfo.getBigDecimal("supqty").subtract(beforeOccupyQty));
                suppInfo.set("lastupdatetime", (Object)TimeServiceHelper.now());
                updateSuppList.add(suppInfo);
            }
            long itemSupId = DynamicObjectUtils.getPkValue((DynamicObject)suppInfo);
            for (ItemSuppParam itemSuppParam : inParam.getValue()) {
                DynamicObject itemSupRecord = ItemSupplementProvider.buildItemSupRecord(itemSuppParam, itemSupUpdateType);
                itemSupRecord.set("supplement", (Object)itemSupId);
                itemSupRecord.set("beforeqty", (Object)beforeSupQty);
                itemSupRecord.set("updateqty", (Object)itemSuppParam.getUpdateQty());
                beforeSupQty = beforeSupQty.add(itemSuppParam.getUpdateQty());
                itemSupRecord.set("afterqty", (Object)beforeSupQty);
                itemSupRecordList.add(itemSupRecord);
            }
        }
        SaveServiceHelper.save((DynamicObject[])addSuppList.toArray(new DynamicObject[0]));
        SaveServiceHelper.update((DynamicObject[])updateSuppList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])itemSupRecordList.toArray(new DynamicObject[0]));
    }

    public static Map<String, DynamicObject> getExistSupplementInfoMap(List<ItemSuppParam> itemSuppParamList) {
        DynamicObject[] querySuppList = ItemSupplementProvider.queryItemSupplementInfoList(itemSuppParamList);
        if (querySuppList == null || querySuppList.length == 0) {
            return new HashMap<String, DynamicObject>(0);
        }
        List suppInfoList = DynamicObjectUtils.convertDynamicObjList((DynamicObject[])querySuppList);
        return suppInfoList.stream().collect(Collectors.toMap(a -> ItemSupplementProvider.getGroupKey(a), a -> a, (k1, k2) -> k1));
    }

    public static Map<String, DynamicObject> getExistSupplementInfoMap(Set<Object> itemSuppIds) {
        DynamicObject[] querySuppList = ItemSupplementProvider.queryItemSupplementInfoList(itemSuppIds);
        if (querySuppList == null || querySuppList.length == 0) {
            return new HashMap<String, DynamicObject>(0);
        }
        List suppInfoList = DynamicObjectUtils.convertDynamicObjList((DynamicObject[])querySuppList);
        return suppInfoList.stream().collect(Collectors.toMap(ItemSupplementProvider::getGroupKey, a -> a, (k1, k2) -> k1));
    }

    public static void insertItemSupplementList(List<ItemSuppParam> itemSuppParamList, ItemSupUpdateTypeEnum itemSupUpdateTypeEnum) {
        if (CollectionUtils.isEmpty(itemSuppParamList)) {
            return;
        }
        ItemSupplementProvider.saveItemSupplementInfoList(itemSuppParamList, itemSupUpdateTypeEnum);
    }

    public static void insertItemSupplementList(List<ItemSuppParam> itemSuppParamList, ItemSupUpdateTypeEnum itemSupUpdateTypeEnum, Set<Object> newItemSuppIds, Set<Object> newItemSupRecordIds, boolean isGenItemSupRecord) {
        if (CollectionUtils.isEmpty(itemSuppParamList)) {
            return;
        }
        ItemSupplementProvider.saveItemSupplementInfoList(itemSuppParamList, itemSupUpdateTypeEnum, newItemSuppIds, newItemSupRecordIds, isGenItemSupRecord);
    }

    public static void updateItemSupplementList(List<ItemSuppParam> itemSuppParamList, ItemSupUpdateTypeEnum itemSupUpdateTypeEnum) {
        if (CollectionUtils.isEmpty(itemSuppParamList)) {
            return;
        }
        DynamicObject[] supList = ItemSupplementProvider.queryItemSupplementInfoList(itemSuppParamList);
        if (supList == null || supList.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a\u8d27\u8865\u6c60\u6570\u636e\u5747\u4e0d\u5b58\u5728\u3002", (String)"ItemSupplementProvider_7", (String)"occ-occba-business", (Object[])new Object[0]));
        }
        List<DynamicObject> supInfoList = Arrays.asList(supList);
        Map<String, DynamicObject> supMap = supInfoList.stream().collect(Collectors.toMap(a -> ItemSupplementProvider.getGroupKey(a), a -> a, (k1, k2) -> k1));
        ArrayList<ItemSuppParam> notExistList = new ArrayList<ItemSuppParam>(3);
        ArrayList<DynamicObject> supRecordList = new ArrayList<DynamicObject>(itemSuppParamList.size());
        for (ItemSuppParam param : itemSuppParamList) {
            DynamicObject itemSup = supMap.get(param.getKey());
            if (itemSup == null) {
                notExistList.add(param);
                continue;
            }
            DynamicObject itemSupRecord = ItemSupplementProvider.buildItemSupRecord(param, itemSupUpdateTypeEnum);
            itemSupRecord.set("supplement", (Object)DynamicObjectUtils.getPkValue((DynamicObject)itemSup));
            itemSupRecord.set("beforeqty", (Object)itemSup.getBigDecimal("supqty"));
            ItemSupplementProvider.updateSupplementItemQty(itemSup, param, itemSupUpdateTypeEnum);
            if (itemSup.getBigDecimal("availableqty").compareTo(BigDecimal.ZERO) < 0) {
                throw new KDBizException(ItemSupplementProvider.buildItemSupErrorMsg(itemSup));
            }
            itemSupRecord.set("updateqty", (Object)param.getUpdateQty());
            itemSup.set("lastupdatetime", (Object)TimeServiceHelper.now());
            itemSupRecord.set("afterqty", (Object)itemSup.getBigDecimal("supqty"));
            supRecordList.add(itemSupRecord);
            supMap.put(param.getKey(), itemSup);
        }
        if (CollectionUtils.isNotEmpty(notExistList)) {
            throw new KDBizException(ItemSupplementProvider.getCheckErrorMessageList(notExistList));
        }
        if (supMap != null && supMap.size() > 0) {
            ArrayList<DynamicObject> updateSupList = new ArrayList<DynamicObject>(supMap.values());
            SaveServiceHelper.update((DynamicObject[])updateSupList.toArray(new DynamicObject[updateSupList.size()]));
        }
        SaveServiceHelper.save((DynamicObject[])supRecordList.toArray(new DynamicObject[0]));
    }

    public static void updateSupplementItemQty(DynamicObject itemSup, ItemSuppParam param, ItemSupUpdateTypeEnum itemSupUpdateTypeEnum) {
        if (ItemSupUpdateTypeEnum.balanceadjust == itemSupUpdateTypeEnum || ItemSupUpdateTypeEnum.closebill == itemSupUpdateTypeEnum || ItemSupUpdateTypeEnum.orderreducerelease == itemSupUpdateTypeEnum || ItemSupUpdateTypeEnum.reimbursement == itemSupUpdateTypeEnum) {
            itemSup.set("supqty", (Object)itemSup.getBigDecimal("supqty").add(param.getUpdateQty()));
        } else if (ItemSupUpdateTypeEnum.orderoccupy == itemSupUpdateTypeEnum) {
            itemSup.set("occupyqty", (Object)itemSup.getBigDecimal("occupyqty").add(param.getUpdateQty()));
        } else if (ItemSupUpdateTypeEnum.orderrelease == itemSupUpdateTypeEnum) {
            param.setUpdateQty(param.getUpdateQty().negate());
            itemSup.set("occupyqty", (Object)itemSup.getBigDecimal("occupyqty").add(param.getUpdateQty()));
        } else if (ItemSupUpdateTypeEnum.orderreduce == itemSupUpdateTypeEnum) {
            itemSup.set("occupyqty", (Object)itemSup.getBigDecimal("occupyqty").subtract(param.getUpdateQty()));
            itemSup.set("supqty", (Object)itemSup.getBigDecimal("supqty").subtract(param.getUpdateQty()));
        } else if (ItemSupUpdateTypeEnum.unclosebill == itemSupUpdateTypeEnum) {
            itemSup.set("supqty", (Object)itemSup.getBigDecimal("supqty").subtract(param.getUpdateQty()));
        }
        itemSup.set("availableqty", (Object)itemSup.getBigDecimal("supqty").subtract(itemSup.getBigDecimal("occupyqty")));
    }

    public static String buildItemSupErrorMsg(DynamicObject itemSup) {
        StringBuilder errorMessage = ItemSupplementProvider.buildErrorMsg(itemSup);
        errorMessage.append(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u8d27\u8865\u6c60\u6570\u636e\u66f4\u65b0\u540e\u53ef\u7528\u6570\u91cf\u4e0d\u5141\u8bb8\u5c0f\u4e8e0\u3002", (String)"ItemSupplementProvider_8", (String)"occ-occba-business", (Object[])new Object[0]));
        return errorMessage.toString();
    }

    public static String getCheckErrorMessageList(List<ItemSuppParam> itemSuppParamList) {
        ArrayList<DynamicObject> dataEntitys = new ArrayList<DynamicObject>(itemSuppParamList.size());
        StringBuilder error = new StringBuilder();
        int index = 1;
        for (ItemSuppParam param : itemSuppParamList) {
            DynamicObject itemSupplement = ItemSupplementProvider.buildItemSupplement(param);
            dataEntitys.add(itemSupplement);
        }
        BusinessDataServiceHelper.loadRefence((Object[])dataEntitys.toArray(), (IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"occba_supplement").getDataEntityType());
        for (DynamicObject data : dataEntitys) {
            error.append(index).append("\uff1a").append((CharSequence)ItemSupplementProvider.buildErrorMsg(data)).append("\n");
        }
        error.append(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u8d27\u8865\u6c60\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"ItemSupplementProvider_9", (String)"occ-occba-business", (Object[])new Object[0]));
        return error.toString();
    }

    public static void checkDetailExist(DynamicObjectCollection detailList) {
        QFilter filter = new QFilter("1", "!=", (Object)1);
        for (DynamicObject detail : detailList) {
            QFilter cusFilter = new QFilter("channel", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)detail, (String)"customer"));
            cusFilter.and(new QFilter("org", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)detail, (String)"customer")));
            cusFilter.and(new QFilter("item", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)detail, (String)"item")));
            cusFilter.and(new QFilter("material", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)detail, (String)"material")));
            cusFilter.and(new QFilter("unitid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)detail, (String)"unit")));
            cusFilter.and(new QFilter("auxpty", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)detail, (String)"auxpty")));
            filter.or(cusFilter);
        }
        DynamicObject[] existList = BusinessDataServiceHelper.load((String)"occba_supplement", (String)"id,number,channel,org,item,material,auxpty,unitid,supqty,occupyqty,availableqty,lastupdatetime,rebateaccount", (QFilter[])filter.toArray());
        if (existList != null && existList.length > 0) {
            StringBuilder error = new StringBuilder();
            for (int i = 0; i < existList.length; ++i) {
                error.append((CharSequence)ItemSupplementProvider.buildErrorMsg(existList[i]));
            }
            if (StringUtils.isNotEmpty((String)error.toString())) {
                error.append(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u8d27\u8865\u6c60\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"ItemSupplementProvider_9", (String)"occ-occba-business", (Object[])new Object[0]));
                throw new KDBizException(error.toString());
            }
        }
    }

    private static StringBuilder buildErrorMsg(DynamicObject itemSupplement) {
        ArrayList<String> nameList = new ArrayList<String>(6);
        String name = DynamicObjectUtils.getString((DynamicObject)itemSupplement.getDynamicObject("org"), (String)"name");
        if (StringUtils.isNotEmpty((String)name)) {
            nameList.add(String.format(ResManager.loadKDString((String)"\u9500\u552e\u7ec4\u7ec7\u4e3a[%1$s]", (String)"ItemSupplementProvider_30", (String)"occ-occba-business", (Object[])new Object[0]), name));
        }
        if (StringUtils.isNotEmpty((String)(name = DynamicObjectUtils.getString((DynamicObject)itemSupplement.getDynamicObject("channel"), (String)"name")))) {
            nameList.add(String.format(ResManager.loadKDString((String)"\u6e20\u9053\u4e3a[%1$s]", (String)"ItemSupplementProvider_31", (String)"occ-occba-business", (Object[])new Object[0]), name));
        }
        if (StringUtils.isNotEmpty((String)(name = DynamicObjectUtils.getString((DynamicObject)itemSupplement.getDynamicObject("item"), (String)"name")))) {
            nameList.add(String.format(ResManager.loadKDString((String)"\u5546\u54c1\u4e3a[%1$s]", (String)"ItemSupplementProvider_32", (String)"occ-occba-business", (Object[])new Object[0]), name));
        }
        if (StringUtils.isNotEmpty((String)(name = DynamicObjectUtils.getString((DynamicObject)itemSupplement.getDynamicObject("material"), (String)"name")))) {
            nameList.add(String.format(ResManager.loadKDString((String)"\u7269\u6599\u4e3a[%1$s]", (String)"ItemSupplementProvider_33", (String)"occ-occba-business", (Object[])new Object[0]), name));
        }
        if (StringUtils.isNotEmpty((String)(name = DynamicObjectUtils.getString((DynamicObject)itemSupplement.getDynamicObject("auxpty"), (String)"name")))) {
            nameList.add(String.format(ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027\u4e3a[%1$s]", (String)"ItemSupplementProvider_34", (String)"occ-occba-business", (Object[])new Object[0]), name));
        }
        if (StringUtils.isNotEmpty((String)(name = DynamicObjectUtils.getString((DynamicObject)itemSupplement.getDynamicObject("unitid"), (String)"name")))) {
            nameList.add(String.format(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d\u4e3a[%1$s]", (String)"ItemSupplementProvider_35", (String)"occ-occba-business", (Object[])new Object[0]), name));
        }
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append(StringUtils.join(nameList, (char)'\uff0c'));
        return errorMsg;
    }

    private static DynamicObject buildItemSupplement(ItemSuppParam itemSuppParam) {
        DynamicObject itemSupInfo = BusinessDataServiceHelper.newDynamicObject((String)"occba_supplement");
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)itemSupInfo, (String)"org", (long)itemSuppParam.getSettOrgId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)itemSupInfo, (String)"channel", (long)itemSuppParam.getChannelId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)itemSupInfo, (String)"item", (long)itemSuppParam.getItemId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)itemSupInfo, (String)"material", (long)itemSuppParam.getMaterialId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)itemSupInfo, (String)"auxpty", (long)itemSuppParam.getMaterialId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)itemSupInfo, (String)"unitid", (long)itemSuppParam.getMaterialId());
        return itemSupInfo;
    }

    public static DynamicObject buildItemSupRecord(ItemSuppParam itemSuppParam, ItemSupUpdateTypeEnum updateTypeEnum) {
        DynamicObject itemSupRecord = BusinessDataServiceHelper.newDynamicObject((String)"occba_suprecord");
        itemSupRecord.set("sourcebillentity", (Object)itemSuppParam.getSourceBillEntity());
        itemSupRecord.set("sourcebillno", (Object)itemSuppParam.getSourceBillNo());
        itemSupRecord.set("creater", (Object)RequestContext.get().getUserId());
        itemSupRecord.set("createdate", (Object)TimeServiceHelper.now());
        itemSupRecord.set("updatetype", (Object)updateTypeEnum.getValue());
        itemSupRecord.set("channel", (Object)itemSuppParam.getChannelId());
        itemSupRecord.set("org", (Object)itemSuppParam.getSettOrgId());
        itemSupRecord.set("item", (Object)itemSuppParam.getItemId());
        itemSupRecord.set("material", (Object)itemSuppParam.getMaterialId());
        itemSupRecord.set("auxpty", (Object)itemSuppParam.getAuxptyId());
        itemSupRecord.set("unit", (Object)itemSuppParam.getUnitId());
        return itemSupRecord;
    }

    private static String getGroupKey(DynamicObject supInfo) {
        return String.format("%d_%d_%d_%d_%d_%d_%d", DynamicObjectUtils.getPkValue((DynamicObject)supInfo, (String)"org"), DynamicObjectUtils.getPkValue((DynamicObject)supInfo, (String)"channel"), DynamicObjectUtils.getPkValue((DynamicObject)supInfo, (String)"item"), DynamicObjectUtils.getPkValue((DynamicObject)supInfo, (String)"material"), DynamicObjectUtils.getPkValue((DynamicObject)supInfo, (String)"auxpty"), DynamicObjectUtils.getPkValue((DynamicObject)supInfo, (String)"unitid"), DynamicObjectUtils.getPkValue((DynamicObject)supInfo, (String)"rebateaccount"));
    }

    private static void saveItemSupplementInfoList(List<ItemSuppParam> itemSuppParamList, ItemSupUpdateTypeEnum itemSupUpdateType) {
        if (CollectionUtils.isEmpty(itemSuppParamList)) {
            return;
        }
        ArrayList<DynamicObject> itemSupList = new ArrayList<DynamicObject>(itemSuppParamList.size());
        ArrayList<DynamicObject> itemSupRecordList = new ArrayList<DynamicObject>(itemSuppParamList.size());
        long[] longIdList = DBServiceHelper.genLongIds((String)"t_occbo_supplement", (int)itemSuppParamList.size());
        if (longIdList == null || longIdList.length == 0 || longIdList.length != itemSuppParamList.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6279\u91cf\u751f\u6210ID\u5931\u8d25\u3002", (String)"ItemSupplementProvider_16", (String)"occ-occba-business", (Object[])new Object[0]));
        }
        int i = 0;
        for (ItemSuppParam itemSuppParam : itemSuppParamList) {
            DynamicObject itemSup = ItemSupplementProvider.buildItemSupplementInfo(itemSuppParam);
            itemSup.set("id", (Object)longIdList[i]);
            itemSup.set("supqty", (Object)itemSuppParam.getUpdateQty());
            itemSup.set("availableqty", (Object)itemSuppParam.getUpdateQty());
            itemSup.set("lastupdatetime", (Object)TimeServiceHelper.now());
            itemSup.set("rebateaccount", (Object)itemSuppParam.getRebateAccountId());
            itemSupList.add(itemSup);
            DynamicObject itemSupRecord = ItemSupplementProvider.buildItemSupRecord(itemSuppParam, itemSupUpdateType);
            itemSupRecord.set("supplement", (Object)longIdList[i]);
            itemSupRecord.set("beforeqty", (Object)BigDecimal.ZERO);
            itemSupRecord.set("updateqty", (Object)itemSuppParam.getUpdateQty());
            itemSupRecord.set("afterqty", (Object)itemSuppParam.getUpdateQty());
            itemSupRecordList.add(itemSupRecord);
            ++i;
        }
        SaveServiceHelper.save((DynamicObject[])itemSupList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])itemSupRecordList.toArray(new DynamicObject[0]));
    }

    private static void saveItemSupplementInfoList(List<ItemSuppParam> itemSuppParamList, ItemSupUpdateTypeEnum itemSupUpdateType, Set<Object> newItemSuppIds, Set<Object> newItemSupRecordIds, boolean isGenItemSupRecord) {
        if (CollectionUtils.isEmpty(itemSuppParamList)) {
            return;
        }
        ArrayList<DynamicObject> itemSupList = new ArrayList<DynamicObject>(itemSuppParamList.size());
        ArrayList<DynamicObject> itemSupRecordList = new ArrayList<DynamicObject>(itemSuppParamList.size());
        long[] longIdList = DBServiceHelper.genLongIds((String)"t_occbo_supplement", (int)itemSuppParamList.size());
        if (longIdList == null || longIdList.length == 0 || longIdList.length != itemSuppParamList.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6279\u91cf\u751f\u6210ID\u5931\u8d25\u3002", (String)"ItemSupplementProvider_16", (String)"occ-occba-business", (Object[])new Object[0]));
        }
        int i = 0;
        for (ItemSuppParam itemSuppParam : itemSuppParamList) {
            DynamicObject itemSup = ItemSupplementProvider.buildItemSupplementInfo(itemSuppParam);
            itemSup.set("id", (Object)longIdList[i]);
            itemSup.set("supqty", (Object)itemSuppParam.getUpdateQty());
            itemSup.set("availableqty", (Object)itemSuppParam.getUpdateQty());
            itemSup.set("lastupdatetime", (Object)TimeServiceHelper.now());
            itemSup.set("rebateaccount", (Object)itemSuppParam.getRebateAccountId());
            itemSupList.add(itemSup);
            DynamicObject itemSupRecord = ItemSupplementProvider.buildItemSupRecord(itemSuppParam, itemSupUpdateType);
            itemSupRecord.set("supplement", (Object)longIdList[i]);
            itemSupRecord.set("beforeqty", (Object)BigDecimal.ZERO);
            itemSupRecord.set("updateqty", (Object)itemSuppParam.getUpdateQty());
            itemSupRecord.set("afterqty", (Object)itemSuppParam.getUpdateQty());
            itemSupRecordList.add(itemSupRecord);
            ++i;
        }
        Object[] itemSups = SaveServiceHelper.save((DynamicObject[])itemSupList.toArray(new DynamicObject[0]));
        ItemSupplementProvider.getPkValues(itemSups, newItemSuppIds);
        if (isGenItemSupRecord) {
            Object[] itemSupRecords = SaveServiceHelper.save((DynamicObject[])itemSupRecordList.toArray(new DynamicObject[0]));
            ItemSupplementProvider.getPkValues(itemSupRecords, newItemSupRecordIds);
        }
    }

    private static DynamicObject buildNewItemSupplement(ItemSuppParam itemSuppParam, BigDecimal totalQty) {
        DynamicObject itemSup = ItemSupplementProvider.buildItemSupplementInfo(itemSuppParam);
        long genLongId = DB.genLongId((String)itemSup.getDataEntityType().getAlias());
        itemSup.set("id", (Object)genLongId);
        itemSup.set("supqty", (Object)totalQty);
        itemSup.set("availableqty", (Object)totalQty);
        return itemSup;
    }

    private static DynamicObject buildItemSupplementInfo(ItemSuppParam itemSuppParam) {
        DynamicObject itemSup = BusinessDataServiceHelper.newDynamicObject((String)"occba_supplement");
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)itemSup.getDataEntityType().getName(), (DynamicObject)itemSup, null);
        itemSup.set("number", (Object)CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)itemSup));
        itemSup.set("item", (Object)itemSuppParam.getItemId());
        itemSup.set("unitid", (Object)itemSuppParam.getUnitId());
        itemSup.set("org", (Object)itemSuppParam.getSettOrgId());
        itemSup.set("auxpty", (Object)itemSuppParam.getAuxptyId());
        itemSup.set("channel", (Object)itemSuppParam.getChannelId());
        itemSup.set("supqty", (Object)itemSuppParam.getUpdateQty());
        itemSup.set("material", (Object)itemSuppParam.getMaterialId());
        itemSup.set("rebateaccount", (Object)itemSuppParam.getRebateAccountId());
        itemSup.set("lastupdatetime", (Object)TimeServiceHelper.now());
        return itemSup;
    }

    private static List<ItemSupplement> buildItemSupplementInfoList(DynamicObject[] supList) {
        if (supList == null || supList.length == 0) {
            return new ArrayList<ItemSupplement>(0);
        }
        ArrayList<ItemSupplement> itemSupplementList = new ArrayList<ItemSupplement>(supList.length);
        for (DynamicObject sup : supList) {
            ItemSupplement itemSupplement = new ItemSupplement();
            itemSupplement.setSupplementId(DynamicObjectUtils.getPkValue((DynamicObject)sup));
            itemSupplement.setItemId(DynamicObjectUtils.getPkValue((DynamicObject)sup, (String)"item"));
            itemSupplement.setSettOrgId(DynamicObjectUtils.getPkValue((DynamicObject)sup, (String)"org"));
            itemSupplement.setUnitId(DynamicObjectUtils.getPkValue((DynamicObject)sup, (String)"unitid"));
            itemSupplement.setAuxptyId(DynamicObjectUtils.getPkValue((DynamicObject)sup, (String)"auxpty"));
            itemSupplement.setChannelId(DynamicObjectUtils.getPkValue((DynamicObject)sup, (String)"channel"));
            itemSupplement.setSupplementNo(DynamicObjectUtils.getString((DynamicObject)sup, (String)"number"));
            itemSupplement.setMaterialId(DynamicObjectUtils.getPkValue((DynamicObject)sup, (String)"material"));
            itemSupplement.setAvailableQty(DynamicObjectUtils.getBigDecimal((DynamicObject)sup, (String)"availableqty"));
            itemSupplementList.add(itemSupplement);
        }
        return itemSupplementList;
    }

    private static QFilter buildQueryItemSupplementFilter(List<ItemSuppParam> itemSuppParamList) {
        QFilter filters = new QFilter("1", "!=", (Object)1);
        for (ItemSuppParam supplement : itemSuppParamList) {
            filters.or(ItemSupplementProvider.buildSingleSupplementFilter(supplement));
        }
        return filters;
    }

    private static QFilter buildSingleSupplementFilter(ItemSuppParam itemSuppParam) {
        QFilter filter = new QFilter("channel", "=", (Object)itemSuppParam.getChannelId());
        filter.and(new QFilter("org", "=", (Object)itemSuppParam.getSettOrgId()));
        filter.and(new QFilter("item", "=", (Object)itemSuppParam.getItemId()));
        filter.and(new QFilter("material", "=", (Object)itemSuppParam.getMaterialId()));
        filter.and(new QFilter("auxpty", "=", (Object)itemSuppParam.getAuxptyId()));
        filter.and(new QFilter("unitid", "=", (Object)itemSuppParam.getUnitId()));
        filter.and(new QFilter("rebateaccount", "=", (Object)itemSuppParam.getRebateAccountId()));
        return filter;
    }

    public static DynamicObject getItemSupplementInfo(long orgId, long channelId, long itemId, long materialId, long unitId, long auxptyId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and(new QFilter("channel", "=", (Object)channelId));
        filter.and(new QFilter("item", "=", (Object)itemId));
        filter.and(new QFilter("material", "=", (Object)materialId));
        filter.and(new QFilter("unitid", "=", (Object)unitId));
        filter.and(new QFilter("auxpty", "=", (Object)auxptyId));
        return BusinessDataServiceHelper.loadSingle((String)"occba_supplement", (String)"id,number,channel,org,item,material,auxpty,unitid,supqty,occupyqty,availableqty,lastupdatetime,rebateaccount", (QFilter[])filter.toArray());
    }

    public static DynamicObject queryItemSupplementInfo(long orgId, long channelId, long itemId, long materialId, long unitId, long auxptyId, long accountId) {
        return ItemSupplementProvider.getItemSupplementInfo(orgId, channelId, itemId, materialId, unitId, auxptyId, accountId);
    }

    public static DynamicObject getItemSupplementInfo(long orgId, long channelId, long itemId, long materialId, long unitId, long auxptyId, long accountId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and(new QFilter("channel", "=", (Object)channelId));
        filter.and(new QFilter("item", "=", (Object)itemId));
        filter.and(new QFilter("material", "=", (Object)materialId));
        filter.and(new QFilter("unitid", "=", (Object)unitId));
        filter.and(new QFilter("auxpty", "=", (Object)auxptyId));
        filter.and(new QFilter("rebateaccount", "=", (Object)accountId));
        return BusinessDataServiceHelper.loadSingle((String)"occba_supplement", (String)"id,number,channel,org,item,material,auxpty,unitid,supqty,occupyqty,availableqty,lastupdatetime,rebateaccount", (QFilter[])filter.toArray());
    }

    private static void getPkValues(Object[] data, Set<Object> pkIds) {
        if (data != null && data.length > 0) {
            for (Object singleItemSup : data) {
                if (!(singleItemSup instanceof DynamicObject)) continue;
                DynamicObject itemSupDyn = (DynamicObject)singleItemSup;
                pkIds.add(itemSupDyn.getPkValue());
            }
        }
    }
}

