/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.business.rebate;

import java.math.BigDecimal;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.entity.AccountRecord;
import kd.occ.ocbase.common.enums.AccountPoolTypeEnum;
import kd.occ.ocbase.common.util.CodeRuleUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.occba.common.enums.CalculationTypeEnum;
import kd.occ.occba.common.enums.RecordUpdateTypeEnum;
import org.apache.commons.lang.StringUtils;

public class IncentiveBalanceHelper {
    public static DynamicObject calculateBalanceAndOccupyAmount(AccountRecord accountRecord, RecordUpdateTypeEnum recordUpdateType, CalculationTypeEnum calculationType) {
        DynamicObject accountInfo = IncentiveBalanceHelper.getRebateAccountInfo(accountRecord);
        IncentiveBalanceHelper.updateAccountAndRebateFlowRecord(accountRecord, accountInfo, recordUpdateType, calculationType);
        return accountInfo;
    }

    private static DynamicObject queryOrAddAccountInfo(AccountRecord accountRecord) {
        DynamicObject rebateAccount = IncentiveBalanceHelper.queryRebateAccount(accountRecord);
        if (rebateAccount == null) {
            rebateAccount = BusinessDataServiceHelper.newDynamicObject((String)"ocdbd_rebateaccount");
            rebateAccount.set("number", (Object)CodeRuleUtil.getCodeRule((String)"ocdbd_rebateaccount"));
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateAccount, (String)"org", (long)accountRecord.getOrgId());
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateAccount, (String)"customer", (long)accountRecord.getCustomerId());
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateAccount, (String)"channel", (long)accountRecord.getChannelId());
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateAccount, (String)"accounttype", (long)accountRecord.getAccountType());
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateAccount, (String)"setcurrency", (long)accountRecord.getCurrencyId());
            String pooltType = StringUtils.isEmpty((String)accountRecord.getPoolType()) ? AccountPoolTypeEnum.BRANDS.getValue() : accountRecord.getPoolType();
            rebateAccount.set("type", (Object)pooltType);
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateAccount, (String)"receivechannel", (long)accountRecord.getReceiveChannelId());
            rebateAccount.set("updatedatetime", (Object)TimeServiceHelper.now());
            DynamicObject[] saveRebateAccount = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rebateAccount});
            if (saveRebateAccount != null && saveRebateAccount.length > 0) {
                return BusinessDataServiceHelper.loadSingle((Object)saveRebateAccount[0].getPkValue(), (String)"ocdbd_rebateaccount");
            }
        }
        return rebateAccount;
    }

    public static DynamicObject adjustRebateAccountAmountAndRecord(AccountRecord accountRecord) {
        DynamicObject accountInfo = IncentiveBalanceHelper.queryOrAddAccountInfo(accountRecord);
        RecordUpdateTypeEnum recordUpdateType = "A".equalsIgnoreCase(accountRecord.getBillType()) || "E".equalsIgnoreCase(accountRecord.getBillType()) || "name".equalsIgnoreCase(accountRecord.getBillEntity()) || "occpic_rebatestatement".equalsIgnoreCase(accountRecord.getBillEntity()) ? RecordUpdateTypeEnum.JSZF : RecordUpdateTypeEnum.YETZ;
        IncentiveBalanceHelper.updateAccountAndRebateFlowRecord(accountRecord, accountInfo, recordUpdateType, CalculationTypeEnum.ONLYUPDATEACCOUNT);
        return accountInfo;
    }

    public static DynamicObject adjustRebateAccountApplyAndRecord(AccountRecord accountRecord) {
        DynamicObject accountInfo = IncentiveBalanceHelper.queryOrAddAccountInfo(accountRecord);
        RecordUpdateTypeEnum recordUpdateType = RecordUpdateTypeEnum.APPLY;
        if ("ocbsoc_xsaleorder".equalsIgnoreCase(accountRecord.getBillEntity()) || "D".equalsIgnoreCase(accountRecord.getBillType())) {
            recordUpdateType = RecordUpdateTypeEnum.DDBG;
        }
        IncentiveBalanceHelper.updateAccountApplyAndRebateFlowRecord(accountRecord, accountInfo, recordUpdateType, CalculationTypeEnum.ONLYUPDATEACCOUNT);
        return accountInfo;
    }

    public static DynamicObject adjustOccupyAmountAndRecord(AccountRecord accountRecord) {
        DynamicObject accountInfo = IncentiveBalanceHelper.getRebateAccountInfo(accountRecord);
        IncentiveBalanceHelper.updateAccountAndRebateFlowRecord(accountRecord, accountInfo, RecordUpdateTypeEnum.YEDJ, CalculationTypeEnum.OCCUPYAMOUNT);
        return accountInfo;
    }

    private static void updateAccountAndRebateFlowRecord(AccountRecord accountRecord, DynamicObject rebateAccount, RecordUpdateTypeEnum recordUpdateType, CalculationTypeEnum calculationType) {
        DynamicObject rebateRecord = IncentiveBalanceHelper.buildRebateRecord(accountRecord, recordUpdateType);
        rebateRecord.set("beforeamount", (Object)rebateAccount.getBigDecimal("balance"));
        IncentiveBalanceHelper.reCalculateForAccountInfo(accountRecord, rebateAccount, calculationType);
        SaveServiceHelper.update((DynamicObject)rebateAccount);
        rebateRecord.set("afteramount", (Object)rebateAccount.getBigDecimal("balance"));
        if (calculationType == CalculationTypeEnum.USEAMOUNT) {
            BigDecimal changeAmount = rebateRecord.getBigDecimal("afteramount").subtract(rebateRecord.getBigDecimal("beforeamount"));
            rebateRecord.set("changeamount", (Object)changeAmount);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rebateRecord});
    }

    private static void updateAccountApplyAndRebateFlowRecord(AccountRecord accountRecord, DynamicObject rebateAccount, RecordUpdateTypeEnum recordUpdateType, CalculationTypeEnum calculationType) {
        DynamicObject rebateRecord = IncentiveBalanceHelper.buildRebateRecord(accountRecord, recordUpdateType);
        BigDecimal availablebalance = rebateAccount.getBigDecimal("availablebalance");
        BigDecimal amount = availablebalance.subtract(accountRecord.getAmount());
        if (amount.compareTo(BigDecimal.ZERO) < 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u8d44\u91d1\u8d26\u6237\u4f59\u989d\u4e0d\u8db3\u3002", (String)"IncentiveBalanceHelper_3", (String)"occ-occba-business", (Object[])new Object[0]), new Object[0]));
        }
        BigDecimal balance = rebateAccount.getBigDecimal("balance");
        BigDecimal balanceUpdate = balance.subtract(accountRecord.getAmount());
        rebateAccount.set("balance", (Object)balanceUpdate);
        rebateAccount.set("availablebalance", (Object)amount);
        rebateAccount.set("updatedatetime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.update((DynamicObject)rebateAccount);
        rebateRecord.set("beforeamount", (Object)balance);
        rebateRecord.set("afteramount", (Object)balanceUpdate);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rebateRecord});
    }

    public static void reCalculateForAccountInfo(AccountRecord accountRecord, DynamicObject accountInfo, CalculationTypeEnum calculationType) {
        BigDecimal availablebalance;
        BigDecimal beforeAccountAmount;
        BigDecimal afterAccountAmount = beforeAccountAmount = accountInfo.getBigDecimal("balance");
        BigDecimal soAmount = accountRecord.getAmount();
        BigDecimal occupyAmount = accountInfo.getBigDecimal("occupyamount");
        if (calculationType == CalculationTypeEnum.USEAMOUNT) {
            afterAccountAmount = beforeAccountAmount.subtract(soAmount);
            if (afterAccountAmount.compareTo(BigDecimal.ZERO) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u91d1\u8d26\u6237\u4f59\u989d\u4e0d\u8db3\u3002", (String)"IncentiveBalanceHelper_0", (String)"occ-occba-business", (Object[])new Object[0]));
            }
            if (soAmount.compareTo(BigDecimal.ZERO) > 0 && accountRecord.isUpdateOccupy() && (occupyAmount = occupyAmount.subtract(soAmount)).compareTo(BigDecimal.ZERO) < 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u539f\u8d26\u6237\u5360\u7528\u91d1\u989d\u4e3a%1$s\uff0c\u672c\u6b21\u91ca\u653e\u5360\u7528\u91d1\u989d\u4e3a%2$s\uff0c\u5360\u7528\u603b\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e0\u3002", (String)"IncentiveBalanceHelper_4", (String)"occ-occba-business", (Object[])new Object[0]), accountInfo.getBigDecimal("occupyamount").toPlainString(), soAmount.toPlainString()));
            }
        } else if (calculationType == CalculationTypeEnum.USEAMOUNTRELEASE) {
            afterAccountAmount = beforeAccountAmount.add(soAmount);
            if (afterAccountAmount.compareTo(BigDecimal.ZERO) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u91d1\u8d26\u6237\u4f59\u989d\u4e0d\u8db3\u3002", (String)"IncentiveBalanceHelper_0", (String)"occ-occba-business", (Object[])new Object[0]));
            }
        } else if (calculationType == CalculationTypeEnum.OCCUPYAMOUNT) {
            if ((occupyAmount = occupyAmount.add(accountRecord.getAmount())).compareTo(beforeAccountAmount) > 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u539f\u8d26\u6237\u5360\u7528\u91d1\u989d\u4e3a%1$s\uff0c\u672c\u6b21\u5360\u7528\u91d1\u989d\u4e3a%2$s\uff0c\u5360\u7528\u603b\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u8d26\u6237\u91d1\u989d\u3002", (String)"IncentiveBalanceHelper_5", (String)"occ-occba-business", (Object[])new Object[0]), accountInfo.getBigDecimal("occupyamount").toPlainString(), soAmount.toPlainString()));
            }
        } else {
            afterAccountAmount = beforeAccountAmount.add(accountRecord.getAmount());
        }
        if ((availablebalance = afterAccountAmount.subtract(occupyAmount)).compareTo(BigDecimal.ZERO) < 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u539f\u8d26\u6237\u53ef\u7528\u4f59\u989d\u4e3a%1$s\uff0c\u672c\u6b21\u62b5\u6263\u91d1\u989d\u4e3a%2$s\uff0c\u53ef\u7528\u4f59\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e0\u3002", (String)"IncentiveBalanceHelper_6", (String)"occ-occba-business", (Object[])new Object[0]), accountInfo.getBigDecimal("availablebalance").toPlainString(), soAmount.toPlainString()));
        }
        accountInfo.set("occupyamount", (Object)occupyAmount);
        accountInfo.set("availablebalance", (Object)availablebalance);
        accountInfo.set("balance", (Object)afterAccountAmount);
        accountInfo.set("updatedatetime", (Object)TimeServiceHelper.now());
    }

    private static DynamicObject buildRebateRecord(AccountRecord accountRecord, RecordUpdateTypeEnum recordUpdateType) {
        DynamicObject rebateRecord = BusinessDataServiceHelper.newDynamicObject((String)"occba_flowrecord");
        String billEntity = StringUtils.isEmpty((String)accountRecord.getBillEntity()) ? IncentiveBalanceHelper.getBillEntityByBillType(accountRecord.getBillType()) : accountRecord.getBillEntity();
        rebateRecord.set("billentity", (Object)billEntity);
        rebateRecord.set("billtype", (Object)accountRecord.getBillType());
        rebateRecord.set("sourcebillno", (Object)accountRecord.getSourceBillNo());
        rebateRecord.set("sourcebillid", (Object)accountRecord.getSourceBillId());
        rebateRecord.set("createtime", (Object)TimeServiceHelper.now());
        rebateRecord.set("transaction", (Object)recordUpdateType.getValue());
        rebateRecord.set("changeamount", (Object)accountRecord.getAmount());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateRecord, (String)"org", (long)accountRecord.getOrgId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateRecord, (String)"office", (long)accountRecord.getOfficeId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateRecord, (String)"country", (long)accountRecord.getCountryId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateRecord, (String)"channel", (long)accountRecord.getChannelId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateRecord, (String)"accout", (long)accountRecord.getAccountType());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateRecord, (String)"areadept", (long)accountRecord.getAreaDeptId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateRecord, (String)"customer", (long)accountRecord.getCustomerId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateRecord, (String)"stmcurrency", (long)accountRecord.getCurrencyId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateRecord, (String)"creator", (long)RequestContext.get().getCurrUserId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateRecord, (String)"receivechannel", (long)accountRecord.getReceiveChannelId());
        return rebateRecord;
    }

    private static String getBillEntityByBillType(String billType) {
        String billEntity = "";
        switch (billType) {
            case "A": {
                billEntity = "occpic_rebatestatement";
                break;
            }
            case "B": {
                billEntity = "ocbsoc_saleorder";
                break;
            }
            case "C": {
                billEntity = "occba_balanceadjust";
                break;
            }
            case "D": {
                billEntity = "ocbsoc_xsaleorder";
                break;
            }
            case "E": {
                billEntity = "occba_moneyincome";
                break;
            }
            case "F": {
                billEntity = "ocmem_mc_reimburse";
                break;
            }
        }
        return billEntity;
    }

    private static DynamicObject getRebateAccountInfo(AccountRecord accountRecord) {
        DynamicObject accountInfo = IncentiveBalanceHelper.queryRebateAccount(accountRecord);
        if (accountInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8d44\u91d1\u8d26\u6237\u3002", (String)"IncentiveBalanceHelper_2", (String)"occ-occba-business", (Object[])new Object[0]));
        }
        return accountInfo;
    }

    @Deprecated
    public static DynamicObject queryRebateAccountInfo(long orgId, long customerId, long channelId, long accountTypeId, long currencyId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and(new QFilter("customer", "=", (Object)customerId));
        filter.and(new QFilter("channel", "=", (Object)channelId));
        filter.and(new QFilter("accounttype", "=", (Object)accountTypeId));
        filter.and(new QFilter("setcurrency", "=", (Object)currencyId));
        return ORM.create().queryOne("ocdbd_rebateaccount", filter.toArray());
    }

    private static DynamicObject queryRebateAccount(AccountRecord accountRecord) {
        QFilter filter = new QFilter("org", "=", (Object)accountRecord.getOrgId());
        filter.and(new QFilter("channel", "=", (Object)accountRecord.getChannelId()));
        filter.and(new QFilter("customer", "=", (Object)accountRecord.getCustomerId()));
        filter.and(new QFilter("setcurrency", "=", (Object)accountRecord.getCurrencyId()));
        filter.and(new QFilter("accounttype", "=", (Object)accountRecord.getAccountType()));
        filter.and(new QFilter("receivechannel", "=", (Object)accountRecord.getReceiveChannelId()));
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_rebateaccount", (String)"id,org,customer,number,channel,accounttype,currency,setcurrency,occupyamount,balance,updatedatetime,availablebalance,receivechannel,type", (QFilter[])filter.toArray());
    }

    public static DynamicObject queryRebateAccount(long orgId, long customerId, long channelId, long receiveChannelId, long accountTypeId, long currencyId) {
        QFilter filter = new QFilter("accounttype", "=", (Object)accountTypeId);
        filter.and("setcurrency", "=", (Object)currencyId);
        filter.and("channel", "=", (Object)channelId);
        if (receiveChannelId > 0L) {
            filter.and("receivechannel", "=", (Object)receiveChannelId);
        } else {
            filter.and("org", "=", (Object)orgId);
            filter.and("customer", "=", (Object)customerId);
        }
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_rebateaccount", (String)"id,org,customer,number,channel,accounttype,currency,setcurrency,occupyamount,balance,updatedatetime,availablebalance,receivechannel,type", (QFilter[])filter.toArray());
    }
}

