/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.business.rebate;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.entity.AccountRecord;
import kd.occ.ocbase.common.entity.RebateAccount;
import kd.occ.ocbase.common.entity.ServiceResult;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.occba.business.rebate.IncentiveBalanceHelper;
import kd.occ.occba.business.rebate.RebateServiceCheckHelper;
import kd.occ.occba.common.enums.CalculationTypeEnum;
import kd.occ.occba.common.enums.RecordUpdateTypeEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;

public class IncentiveServiceHelper {
    private static final long WITH_TIME = 180000L;
    private static Log logger = LogFactory.getLog(IncentiveBalanceHelper.class);

    public static List<ServiceResult> useIncentiveBalance(List<AccountRecord> accountRecordList) {
        if (CollectionUtils.isEmpty(accountRecordList)) {
            return new ArrayList<ServiceResult>(0);
        }
        RebateServiceCheckHelper.bacthCheckSourceBillValues(accountRecordList);
        List<ServiceResult> serviceResultList = IncentiveServiceHelper.getUseIncentiveBalanceResultList(accountRecordList);
        return serviceResultList;
    }

    public static ServiceResult useIncentiveBalanceByAccountRecord(AccountRecord accountRecord) {
        if (accountRecord == null) {
            return new ServiceResult();
        }
        RebateServiceCheckHelper.checkSourceBillValues(accountRecord, false);
        ServiceResult serviceResult = IncentiveServiceHelper.getUseIncentiveBalanceResult(accountRecord);
        return serviceResult;
    }

    public static ServiceResult getRebateAccountInfo(long orgId, long customerId, long channelId, long accountTypeId, long currencyId) {
        DynamicObject accountInfo = IncentiveBalanceHelper.queryRebateAccountInfo(orgId, customerId, channelId, accountTypeId, currencyId);
        if (accountInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u67e5\u8be2\u7684\u8d44\u91d1\u8d26\u6237\u4e0d\u5b58\u5728\u3002", (String)"IncentiveServiceHelper_0", (String)"occ-occba-business", (Object[])new Object[0]));
        }
        return IncentiveServiceHelper.buildSuccessResultByAccount(accountInfo);
    }

    public static JSONObject getRebateAccountAmountInfo(long orgId, long customerId, long channelId, long accountTypeId, long currencyId) {
        DynamicObject accountInfo = IncentiveBalanceHelper.queryRebateAccountInfo(orgId, customerId, channelId, accountTypeId, currencyId);
        if (accountInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u67e5\u8be2\u7684\u8d44\u91d1\u8d26\u6237\u4e0d\u5b58\u5728\u3002", (String)"IncentiveServiceHelper_0", (String)"occ-occba-business", (Object[])new Object[0]));
        }
        ServiceResult serviceResult = IncentiveServiceHelper.buildSuccessResultByAccount(accountInfo);
        return serviceResult.toJSONString();
    }

    public static List<ServiceResult> getUseIncentiveBalanceResultList(List<AccountRecord> accountRecordList) {
        ArrayList<ServiceResult> serviceResultList = new ArrayList<ServiceResult>(accountRecordList.size());
        List<AccountRecord> mergeList = IncentiveServiceHelper.mergeAccountRecordList(accountRecordList);
        for (AccountRecord accountRecord : mergeList) {
            ServiceResult serviceResult = IncentiveServiceHelper.getUseIncentiveBalanceResult(accountRecord);
            serviceResultList.add(serviceResult);
        }
        return serviceResultList;
    }

    private static ServiceResult getUseIncentiveBalanceResult(AccountRecord accountRecord) {
        RecordUpdateTypeEnum recordUpdateType = RecordUpdateTypeEnum.JLSY;
        if ("C".equalsIgnoreCase(accountRecord.getBillType()) || "occba_balanceadjust".equalsIgnoreCase(accountRecord.getBillType())) {
            recordUpdateType = RecordUpdateTypeEnum.YETZ;
        }
        ServiceResult serviceResult = IncentiveServiceHelper.rebateAccountUseServiceWithDLock(accountRecord, recordUpdateType, CalculationTypeEnum.USEAMOUNT);
        return serviceResult;
    }

    private static ServiceResult rebateAccountUseServiceWithDLock(AccountRecord accountRecord, RecordUpdateTypeEnum recordUpdateType, CalculationTypeEnum calculationType) {
        DLock lock = IncentiveServiceHelper.createAccountRecordDlock(accountRecord, IncentiveServiceHelper.getUpdateRebateFlowRecordDLOCKDesc());
        if (lock.tryLock(180000L)) {
            try {
                ServiceResult serviceResult;
                DynamicObject rebateAccount = IncentiveBalanceHelper.calculateBalanceAndOccupyAmount(accountRecord, recordUpdateType, calculationType);
                ServiceResult serviceResult2 = serviceResult = IncentiveServiceHelper.buildSuccessResultByAccount(rebateAccount);
                return serviceResult2;
            }
            catch (Exception e) {
                logger.error("\u66f4\u65b0\u6fc0\u52b1\u4f59\u989d\u4f7f\u7528\u670d\u52a1\u5931\u8d25\uff1a" + e);
                throw new KDBizException(e.getMessage());
            }
            finally {
                lock.unlock();
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u6fc0\u52b1\u4f59\u989d\u4f7f\u7528\u670d\u52a1\u7b49\u5f85\u8d85\u65f6\u3010%1$s ms\u3011\uff0c\u5efa\u8bae\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"IncentiveServiceHelper_1", (String)"occ-occba-business", (Object[])new Object[0]), 180000L));
    }

    public static ServiceResult updateRebateAccountAmountAndRecord(AccountRecord accountRecord) {
        DLock lock = IncentiveServiceHelper.createAccountRecordDlock(accountRecord, IncentiveServiceHelper.getUpdateRebateFlowRecordDLOCKDesc());
        if (lock.tryLock(180000L)) {
            try {
                DynamicObject accountInfo = IncentiveBalanceHelper.adjustRebateAccountAmountAndRecord(accountRecord);
                ServiceResult serviceResult = IncentiveServiceHelper.buildSuccessResultByAccount(accountInfo);
                return serviceResult;
            }
            catch (Exception e) {
                logger.error("\u66f4\u65b0\u8d44\u91d1\u8d26\u6237\u4f59\u989d\u4e0e\u8bb0\u5f55\u6d41\u6c34\u5931\u8d25\uff0c\u539f\u56e0\u662f" + e);
                throw new KDBizException(e.getMessage());
            }
            finally {
                lock.unlock();
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u6fc0\u52b1\u4f59\u989d\u4e0e\u6d41\u6c34\u670d\u52a1\u7b49\u5f85\u8d85\u65f6\u3010%1$s ms\u3011\uff0c\u5efa\u8bae\u7a0d\u540e\u91cd\u8bd5", (String)"IncentiveServiceHelper_2", (String)"occ-occba-business", (Object[])new Object[0]), 180000L));
    }

    public static ServiceResult updateRebateAccountApplyAndRecord(AccountRecord accountRecord) {
        DLock lock = IncentiveServiceHelper.createAccountRecordDlock(accountRecord, IncentiveServiceHelper.getUpdateRebateFlowRecordDLOCKDesc());
        if (lock.tryLock(180000L)) {
            try {
                ServiceResult serviceResult;
                DynamicObject accountInfo = IncentiveBalanceHelper.adjustRebateAccountApplyAndRecord(accountRecord);
                ServiceResult serviceResult2 = serviceResult = IncentiveServiceHelper.buildSuccessResultByAccount(accountInfo);
                return serviceResult2;
            }
            catch (Exception e) {
                logger.error("\u66f4\u65b0\u8d44\u91d1\u4f7f\u7528\u8d26\u6237\u4f59\u989d\u4e0e\u8bb0\u5f55\u6d41\u6c34\u5931\u8d25\uff0c\u539f\u56e0:" + e);
                throw new KDBizException(e.getMessage());
            }
            finally {
                lock.unlock();
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u8d44\u91d1\u4f7f\u7528\u4f59\u989d\u4e0e\u6d41\u6c34\u670d\u52a1\u7b49\u5f85\u8d85\u65f6\u3010%1$s ms\u3011\uff0c\u5efa\u8bae\u7a0d\u540e\u91cd\u8bd5", (String)"IncentiveServiceHelper_4", (String)"occ-occba-business", (Object[])new Object[0]), 180000L));
    }

    public static ServiceResult adjustOccupyAmountAndRecord(AccountRecord accountRecord) {
        DLock lock = IncentiveServiceHelper.createAccountRecordDlock(accountRecord, IncentiveServiceHelper.getUpdateRebateFlowRecordDLOCKDesc());
        if (lock.tryLock(180000L)) {
            try {
                ServiceResult serviceResult;
                DynamicObject accountInfo = IncentiveBalanceHelper.adjustOccupyAmountAndRecord(accountRecord);
                ServiceResult serviceResult2 = serviceResult = IncentiveServiceHelper.buildSuccessResultByAccount(accountInfo);
                return serviceResult2;
            }
            catch (Exception e) {
                logger.error("\u66f4\u65b0\u8d44\u91d1\u8d26\u6237\u5360\u7528\u91d1\u989d\u4e0e\u8bb0\u5f55\u6d41\u6c34\u5931\u8d25\uff0c\u539f\u56e0\u662f" + e);
                throw new KDBizException(e.getMessage());
            }
            finally {
                lock.unlock();
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u6fc0\u52b1\u4f59\u989d\u4e0e\u6d41\u6c34\u670d\u52a1\u7b49\u5f85\u8d85\u65f6\u3010%1$s ms\u3011\uff0c\u5efa\u8bae\u7a0d\u540e\u91cd\u8bd5", (String)"IncentiveServiceHelper_2", (String)"occ-occba-business", (Object[])new Object[0]), 180000L));
    }

    public static List<ServiceResult> batchUpdateOccupyAmountAndRecord(List<AccountRecord> accountRecordList) {
        if (CollectionUtils.isEmpty(accountRecordList)) {
            return new ArrayList<ServiceResult>(0);
        }
        RebateServiceCheckHelper.bacthCheckSourceBillValues(accountRecordList);
        List<ServiceResult> serviceResultList = IncentiveServiceHelper.updateOccupyAmountAndRecordList(accountRecordList);
        return serviceResultList;
    }

    private static List<ServiceResult> updateOccupyAmountAndRecordList(List<AccountRecord> accountRecordList) {
        ArrayList<ServiceResult> serviceResultList = new ArrayList<ServiceResult>(accountRecordList.size());
        List<AccountRecord> mergeList = IncentiveServiceHelper.mergeAccountRecordList(accountRecordList);
        for (AccountRecord accountRecord : mergeList) {
            ServiceResult serviceResult = IncentiveServiceHelper.adjustOccupyAmountAndRecord(accountRecord);
            serviceResultList.add(serviceResult);
        }
        return serviceResultList;
    }

    public static List<ServiceResult> batchUpdateAccountAmountAndRecord(List<AccountRecord> accountRecordList) {
        if (CollectionUtils.isEmpty(accountRecordList)) {
            return new ArrayList<ServiceResult>(0);
        }
        RebateServiceCheckHelper.bacthCheckSourceBillValues(accountRecordList);
        List<ServiceResult> serviceResultList = IncentiveServiceHelper.updateAccountAmountAndRecordList(accountRecordList);
        return serviceResultList;
    }

    public static List<ServiceResult> batchUpdateAccountApplyAndRecord(List<AccountRecord> accountRecordList) {
        if (CollectionUtils.isEmpty(accountRecordList)) {
            return new ArrayList<ServiceResult>(0);
        }
        RebateServiceCheckHelper.bacthCheckSourceBillValues(accountRecordList);
        List<ServiceResult> serviceResultList = IncentiveServiceHelper.updateAccountApplyAndRecordList(accountRecordList);
        return serviceResultList;
    }

    private static List<ServiceResult> updateAccountAmountAndRecordList(List<AccountRecord> accountRecordList) {
        ArrayList<ServiceResult> serviceResultList = new ArrayList<ServiceResult>(accountRecordList.size());
        List<AccountRecord> mergeList = IncentiveServiceHelper.mergeAccountRecordList(accountRecordList);
        for (AccountRecord accountRecord : mergeList) {
            ServiceResult serviceResult = IncentiveServiceHelper.updateRebateAccountAmountAndRecord(accountRecord);
            serviceResultList.add(serviceResult);
        }
        return serviceResultList;
    }

    private static List<ServiceResult> updateAccountApplyAndRecordList(List<AccountRecord> accountRecordList) {
        ArrayList<ServiceResult> serviceResultList = new ArrayList<ServiceResult>(accountRecordList.size());
        for (AccountRecord accountRecord : accountRecordList) {
            ServiceResult serviceResult = IncentiveServiceHelper.updateRebateAccountApplyAndRecord(accountRecord);
            serviceResultList.add(serviceResult);
        }
        return serviceResultList;
    }

    private static List<AccountRecord> mergeAccountRecordList(List<AccountRecord> accountRecordList) {
        if (CollectionUtils.isEmpty(accountRecordList)) {
            return new ArrayList<AccountRecord>(0);
        }
        ArrayList<AccountRecord> mergeList = new ArrayList<AccountRecord>(accountRecordList.size());
        Map<String, List<AccountRecord>> groupMap = accountRecordList.stream().collect(Collectors.groupingBy(accountRecord -> IncentiveServiceHelper.getGroupKey(accountRecord)));
        for (Map.Entry<String, List<AccountRecord>> entry : groupMap.entrySet()) {
            List<AccountRecord> mapValueList = entry.getValue();
            BigDecimal totalAmont = mapValueList.stream().map(AccountRecord::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            AccountRecord mergeAccountRecord = (AccountRecord)SerializationUtils.clone((Serializable)((Serializable)mapValueList.get(0)));
            mergeAccountRecord.setAmount(totalAmont);
            mergeList.add(mergeAccountRecord);
        }
        return mergeList;
    }

    private static String getGroupKey(AccountRecord accountRecord) {
        if (StringUtils.isNotEmpty((String)accountRecord.getBillType())) {
            return String.format("%s_%s_%s_%s_%s_%s", accountRecord.getOrgId(), accountRecord.getChannelId(), accountRecord.getCustomerId(), accountRecord.getBillType(), accountRecord.getAccountType(), accountRecord.getReceiveChannelId());
        }
        return String.format("%s_%s_%s_%s_%s_%s", accountRecord.getOrgId(), accountRecord.getChannelId(), accountRecord.getCustomerId(), accountRecord.getBillEntity(), accountRecord.getAccountType(), accountRecord.getReceiveChannelId());
    }

    private static String getUpdateRebateFlowRecordDLOCKDesc() {
        return ResManager.loadKDString((String)"\u66f4\u65b0\u8fd4\u5229\u8d26\u6237\u4f59\u989d\u4e0e\u6d41\u6c34", (String)"IncentiveServiceHelper_3", (String)"occ-occba-business", (Object[])new Object[0]);
    }

    private static DLock createAccountRecordDlock(AccountRecord accountRecord, String description) {
        return DLock.createReentrant((String)IncentiveServiceHelper.getDLockKey(accountRecord.getOrgId(), accountRecord.getCustomerId(), accountRecord.getChannelId(), accountRecord.getAccountType(), accountRecord.getCurrencyId(), accountRecord.getReceiveChannelId()), (String)description);
    }

    private static String getDLockKey(long orgId, long customerId, long channelId, long accountTypeId, long currencyId, long receiveChannelId) {
        return String.format("%d%d%d%d%d%d", orgId, customerId, channelId, accountTypeId, currencyId, receiveChannelId);
    }

    public static ServiceResult buildSuccessResultByAccount(DynamicObject rebateAccount) {
        RebateAccount accountInfo = IncentiveServiceHelper.buildRebateAccountInfo(rebateAccount);
        return IncentiveServiceHelper.buildSuccessServiceResult(accountInfo);
    }

    private static RebateAccount buildRebateAccountInfo(DynamicObject rebateAccount) {
        RebateAccount accountInfo = new RebateAccount();
        accountInfo.setOrgId(DynamicObjectUtils.getPkValue((DynamicObject)rebateAccount, (String)"org"));
        accountInfo.setCustomerId(DynamicObjectUtils.getPkValue((DynamicObject)rebateAccount, (String)"customer"));
        accountInfo.setChannelId(DynamicObjectUtils.getPkValue((DynamicObject)rebateAccount, (String)"channel"));
        accountInfo.setAccountTypeId(DynamicObjectUtils.getPkValue((DynamicObject)rebateAccount, (String)"accounttype"));
        accountInfo.setCurrencyId(DynamicObjectUtils.getPkValue((DynamicObject)rebateAccount, (String)"setcurrency"));
        BigDecimal accupyAmount = rebateAccount.getBigDecimal("occupyamount");
        BigDecimal balance = rebateAccount.getBigDecimal("balance");
        BigDecimal availableAmount = balance.subtract(accupyAmount);
        accountInfo.setOccupyAmount(accupyAmount);
        accountInfo.setBalance(balance);
        accountInfo.setAvailableAmount(availableAmount);
        return accountInfo;
    }

    private static ServiceResult buildSuccessServiceResult(Object data) {
        ServiceResult serviceResult = new ServiceResult();
        serviceResult.setCode(200);
        serviceResult.setData(data);
        serviceResult.setSuccess(true);
        return serviceResult;
    }

    public static ServiceResult getCollectAccountAmount(String channelId, String accountSign) {
        Map<String, Object> map = IncentiveServiceHelper.queryRebateAccountInfo(channelId, accountSign);
        return IncentiveServiceHelper.buildSuccessServiceResult(map);
    }

    private static Map<String, Object> queryRebateAccountInfo(String channelId, String accountSign) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Long> accountTypeList = IncentiveServiceHelper.queryAccount(accountSign);
        QFilter filter = new QFilter("channel", "=", (Object)Long.valueOf(channelId));
        filter.and(new QFilter("accounttype", "in", accountTypeList));
        DynamicObject[] accountList = BusinessDataServiceHelper.load((String)"ocdbd_rebateaccount", (String)"id,balance,occupyamount", (QFilter[])filter.toArray());
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject account : accountList) {
            BigDecimal subAmount = account.getBigDecimal("balance").subtract(account.getBigDecimal("occupyamount"));
            totalAmount = totalAmount.add(subAmount);
        }
        map.put("channelId", channelId);
        map.put("accountSign", accountSign);
        map.put("totalAmount", totalAmount);
        return map;
    }

    public static List<Long> queryAccount(String accountSign) {
        DynamicObject[] incccountList;
        ArrayList<Long> accountList = new ArrayList<Long>(2);
        QFilter qfilter = new QFilter("accounttype", "=", (Object)accountSign);
        for (DynamicObject incccount : incccountList = BusinessDataServiceHelper.load((String)"ocdbd_incentiveaccount", (String)"id,name", (QFilter[])qfilter.toArray())) {
            accountList.add((Long)incccount.getPkValue());
        }
        return accountList;
    }
}

