/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.business.rebate;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.entity.AccountRecord;
import kd.occ.ocbase.common.entity.ItemSup;
import kd.occ.ocbase.common.entity.itemsup.ItemSuppParam;
import kd.occ.ocbase.common.enums.AccountPoolTypeEnum;
import kd.occ.ocbase.common.util.CodeRuleUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.occba.business.itemsupplement.ItemSupplementPoolHelper;
import kd.occ.occba.business.rebate.IncentiveBalanceHelper;
import kd.occ.occba.business.rebate.RebateServiceCheckHelper;
import kd.occ.occba.common.enums.CalculationTypeEnum;
import kd.occ.occba.common.enums.RecordUpdateTypeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;

public class RebateAccountHelper {
    public static void settlementPayment(List<AccountRecord> paramList) {
        RebateServiceCheckHelper.bacthCheckAccountRecordValues(paramList);
        List<DynamicObject> accountList = RebateAccountHelper.queryRebateAccountList(paramList);
        RebateAccountHelper.createAndUpdateRebateAccount(paramList, accountList);
    }

    public static void balanceOccupyOrRelease(List<AccountRecord> paramList, RecordUpdateTypeEnum recordUpdateType, CalculationTypeEnum calculationType) {
        RebateServiceCheckHelper.bacthCheckAccountRecordValues(paramList);
        List<DynamicObject> accountList = RebateAccountHelper.queryRebateAccountList(paramList);
        if (CollectionUtils.isEmpty(accountList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u8d44\u91d1\u6c60\u670d\u52a1\u5931\u8d25\uff0c\u5165\u53c2\u5bf9\u5e94\u7684\u8d44\u91d1\u6c60\u8d26\u6237\u5747\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"RebateAccountHelper_1", (String)"occ-occba-business", (Object[])new Object[0]));
        }
        if (recordUpdateType == RecordUpdateTypeEnum.DJSF || recordUpdateType == RecordUpdateTypeEnum.YESF) {
            for (AccountRecord accountRecord : paramList) {
                accountRecord.setAmount(accountRecord.getAmount().negate());
            }
        }
        RebateAccountHelper.updateRebateAccount(paramList, accountList, recordUpdateType, calculationType);
    }

    public static void balanceAdjustment(List<AccountRecord> paramList, RecordUpdateTypeEnum recordUpdateType) {
        RebateServiceCheckHelper.bacthCheckAccountRecordValues(paramList);
        List<DynamicObject> accountList = RebateAccountHelper.queryRebateAccountList(paramList);
        if (CollectionUtils.isEmpty(accountList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u8d44\u91d1\u6c60\u670d\u52a1\u5931\u8d25\uff0c\u5165\u53c2\u5bf9\u5e94\u7684\u8d44\u91d1\u6c60\u8d26\u6237\u5747\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"RebateAccountHelper_1", (String)"occ-occba-business", (Object[])new Object[0]));
        }
        RebateAccountHelper.updateRebateAccount(paramList, accountList, recordUpdateType, CalculationTypeEnum.ONLYUPDATEACCOUNT);
    }

    private static void updateRebateAccount(List<AccountRecord> paramList, List<DynamicObject> accountList, RecordUpdateTypeEnum recordUpdateType, CalculationTypeEnum calculationType) {
        Map<String, DynamicObject> acMap = accountList.stream().collect(Collectors.toMap(a -> RebateAccountHelper.getAccountKey(a), a -> a, (k1, k2) -> k1));
        ArrayList<DynamicObject> updateAccountList = new ArrayList<DynamicObject>(paramList.size());
        ArrayList<DynamicObject> saveRecordList = new ArrayList<DynamicObject>(paramList.size());
        ArrayList<ItemSuppParam> itemParamList = new ArrayList<ItemSuppParam>(8);
        for (AccountRecord accountRecord : paramList) {
            DynamicObject rebateAccount = acMap.get(accountRecord.getKey());
            accountRecord.setId(DynamicObjectUtils.getPkValue((DynamicObject)rebateAccount));
            DynamicObject rebateRecord = RebateAccountHelper.buildAccountRecord(accountRecord, recordUpdateType);
            if (rebateAccount == null) {
                throw new KDBizException(RebateAccountHelper.buildAccountNotExistMsg(accountRecord));
            }
            boolean isSupportItem = DynamicObjectUtils.getBoolean((DynamicObject)rebateAccount.getDynamicObject("accounttype"), (String)"issupportitem");
            if (isSupportItem) {
                if (CollectionUtils.isEmpty((Collection)accountRecord.getSupList())) {
                    throw new KDBizException(RebateAccountHelper.buildAccountParamErrorMsg(rebateAccount));
                }
                itemParamList.addAll(RebateAccountHelper.buildItemSuppParam(accountRecord));
            }
            rebateRecord.set("beforeamount", (Object)rebateAccount.getBigDecimal("balance"));
            IncentiveBalanceHelper.reCalculateForAccountInfo(accountRecord, rebateAccount, calculationType);
            rebateRecord.set("afteramount", (Object)rebateAccount.getBigDecimal("balance"));
            updateAccountList.add(rebateAccount);
            saveRecordList.add(rebateRecord);
        }
        SaveServiceHelper.save((DynamicObject[])saveRecordList.toArray(new DynamicObject[0]));
        SaveServiceHelper.update((DynamicObject[])updateAccountList.toArray(new DynamicObject[0]));
        RebateAccountHelper.invokeItemSupplementPoolService(calculationType, recordUpdateType, itemParamList);
    }

    private static void invokeItemSupplementPoolService(CalculationTypeEnum calculationType, RecordUpdateTypeEnum recordUpdateType, List<ItemSuppParam> itemParamList) {
        if (CalculationTypeEnum.ONLYUPDATEACCOUNT == calculationType) {
            ItemSupplementPoolHelper.balanceAdjust(itemParamList);
        } else if (CalculationTypeEnum.USEAMOUNT == calculationType && RecordUpdateTypeEnum.DJSF == recordUpdateType) {
            ItemSupplementPoolHelper.orderReduceRelease(itemParamList);
        } else if (CalculationTypeEnum.USEAMOUNT == calculationType && RecordUpdateTypeEnum.APPLY == recordUpdateType) {
            ItemSupplementPoolHelper.orderReduce(itemParamList);
        } else if (CalculationTypeEnum.OCCUPYAMOUNT == calculationType && RecordUpdateTypeEnum.YEDJ == recordUpdateType) {
            ItemSupplementPoolHelper.updateOccupyQty(itemParamList);
        } else if (CalculationTypeEnum.OCCUPYAMOUNT == calculationType && RecordUpdateTypeEnum.YESF == recordUpdateType) {
            ItemSupplementPoolHelper.releaseOccypyQty(itemParamList);
        }
    }

    private static void createAndUpdateRebateAccount(List<AccountRecord> paramList, List<DynamicObject> accountList) {
        Map<String, DynamicObject> accountMap = accountList.stream().collect(Collectors.toMap(a -> RebateAccountHelper.getAccountKey(a), a -> a, (k1, k2) -> k1));
        int paramSize = paramList.size();
        ArrayList<AccountRecord> addAccountList = new ArrayList<AccountRecord>(2);
        ArrayList<DynamicObject> updateAccountList = new ArrayList<DynamicObject>(paramSize);
        ArrayList<DynamicObject> saveRecordList = new ArrayList<DynamicObject>(paramSize);
        ArrayList<ItemSuppParam> itemParamList = new ArrayList<ItemSuppParam>(8);
        for (AccountRecord param : paramList) {
            DynamicObject rebateAccount = accountMap.get(param.getKey());
            if (rebateAccount != null) {
                RebateAccountHelper.dealExistRebateAccount(param, rebateAccount, updateAccountList, saveRecordList, itemParamList);
                continue;
            }
            addAccountList.add(param);
        }
        RebateAccountHelper.createRebateAccountAndRecord(addAccountList, RecordUpdateTypeEnum.JSZF);
        SaveServiceHelper.update((DynamicObject[])updateAccountList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])saveRecordList.toArray(new DynamicObject[0]));
        ItemSupplementPoolHelper.reimbursement(itemParamList);
    }

    private static void dealExistRebateAccount(AccountRecord param, DynamicObject rebateAccount, List<DynamicObject> updateAccountList, List<DynamicObject> saveRecordList, List<ItemSuppParam> itemParamList) {
        DynamicObject rebateRecord = RebateAccountHelper.buildAccountRecord(param, RecordUpdateTypeEnum.JSZF);
        if (RebateAccountHelper.isSupportItem(rebateAccount)) {
            if (CollectionUtils.isEmpty((Collection)param.getSupList())) {
                throw new KDBizException(RebateAccountHelper.buildAccountParamErrorMsg(rebateAccount));
            }
            param.setId(DynamicObjectUtils.getPkValue((DynamicObject)rebateAccount));
            itemParamList.addAll(RebateAccountHelper.buildItemSuppParam(param));
        }
        RebateAccountHelper.reCalculateAccountAndRecordAmount(param, rebateRecord, rebateAccount);
        saveRecordList.add(rebateRecord);
        updateAccountList.add(rebateAccount);
    }

    private static void reCalculateAccountAndRecordAmount(AccountRecord accountRecord, DynamicObject rebateRecord, DynamicObject rebateAccount) {
        rebateRecord.set("beforeamount", (Object)rebateAccount.getBigDecimal("balance"));
        IncentiveBalanceHelper.reCalculateForAccountInfo(accountRecord, rebateAccount, CalculationTypeEnum.ONLYUPDATEACCOUNT);
        rebateRecord.set("afteramount", (Object)rebateAccount.getBigDecimal("balance"));
    }

    public static boolean isSupportItem(DynamicObject rebateAccount) {
        return DynamicObjectUtils.getBoolean((DynamicObject)rebateAccount.getDynamicObject("accounttype"), (String)"issupportitem");
    }

    private static void createRebateAccountAndRecord(List<AccountRecord> paramList, RecordUpdateTypeEnum updateType) {
        if (CollectionUtils.isEmpty(paramList)) {
            return;
        }
        List<DynamicObject> saveAccountList = RebateAccountHelper.buildRebateAccountList(paramList);
        ArrayList<DynamicObject> saveRecordList = new ArrayList<DynamicObject>(paramList.size());
        ArrayList<ItemSuppParam> itemParamList = new ArrayList<ItemSuppParam>(8);
        HashMap<String, BigDecimal> recordAmountMap = new HashMap<String, BigDecimal>(8);
        BusinessDataServiceHelper.loadRefence((Object[])saveAccountList.toArray(), (IDataEntityType)saveAccountList.get(0).getDynamicObjectType());
        Map<String, DynamicObject> accountMap = saveAccountList.stream().collect(Collectors.toMap(a -> RebateAccountHelper.getAccountKey(a), a -> a, (k1, k2) -> k1));
        for (AccountRecord accountRecord : paramList) {
            DynamicObject accountInfo = accountMap.get(accountRecord.getKey());
            if (accountInfo == null) continue;
            accountRecord.setId(DynamicObjectUtils.getPkValue((DynamicObject)accountInfo));
            if (RebateAccountHelper.isSupportItem(accountInfo)) {
                if (CollectionUtils.isEmpty((Collection)accountRecord.getSupList())) {
                    throw new KDBizException(RebateAccountHelper.buildAccountParamErrorMsg(accountInfo));
                }
                itemParamList.addAll(RebateAccountHelper.buildItemSuppParam(accountRecord));
            }
            DynamicObject rebateRecord = RebateAccountHelper.calculateRebateRecordAmount(accountRecord, recordAmountMap, updateType);
            saveRecordList.add(rebateRecord);
        }
        SaveServiceHelper.save((DynamicObject[])saveAccountList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])saveRecordList.toArray(new DynamicObject[0]));
        ItemSupplementPoolHelper.reimbursement(itemParamList);
    }

    private static DynamicObject calculateRebateRecordAmount(AccountRecord accountRecord, Map<String, BigDecimal> recordAmountMap, RecordUpdateTypeEnum updateType) {
        DynamicObject rebateRecord = RebateAccountHelper.buildAccountRecord(accountRecord, updateType);
        BigDecimal beforeAmount = recordAmountMap.get(accountRecord.getKey());
        if (beforeAmount == null) {
            beforeAmount = BigDecimal.ZERO;
        }
        rebateRecord.set("beforeamount", (Object)beforeAmount);
        rebateRecord.set("afteramount", (Object)beforeAmount.add(accountRecord.getAmount()));
        recordAmountMap.put(accountRecord.getKey(), rebateRecord.getBigDecimal("afteramount"));
        return rebateRecord;
    }

    public static List<ItemSuppParam> buildItemSuppParam(AccountRecord accountRecord) {
        ArrayList<ItemSuppParam> paramList = new ArrayList<ItemSuppParam>(accountRecord.getSupList().size());
        for (ItemSup sup : accountRecord.getSupList()) {
            ItemSuppParam param = new ItemSuppParam();
            param.setSettOrgId(accountRecord.getOrgId());
            param.setChannelId(accountRecord.getChannelId());
            param.setItemId(sup.getItemId());
            param.setMaterialId(sup.getMaterialId());
            param.setUnitId(sup.getUnitId());
            param.setAuxptyId(sup.getAuxptyId());
            param.setSourceBillNo(accountRecord.getSourceBillNo());
            param.setSourceBillEntity(accountRecord.getBillEntity());
            param.setUpdateQty(sup.getUpdateQty());
            param.setRebateAccountId(accountRecord.getId());
            paramList.add(param);
        }
        return paramList;
    }

    public static String buildAccountParamErrorMsg(DynamicObject accountInfo) {
        ArrayList<String> nameList = new ArrayList<String>(5);
        String name = DynamicObjectUtils.getString((DynamicObject)accountInfo.getDynamicObject("org"), (String)"name");
        if (StringUtils.isNotEmpty((String)name)) {
            nameList.add(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%1$s\u3011", (String)"RebateAccountHelper_15", (String)"occ-occba-business", (Object[])new Object[0]), name));
        }
        if (StringUtils.isNotEmpty((String)(name = DynamicObjectUtils.getString((DynamicObject)accountInfo.getDynamicObject("customer"), (String)"name")))) {
            nameList.add(String.format(ResManager.loadKDString((String)"\u5ba2\u6237\u3010%1$s\u3011", (String)"RebateAccountHelper_16", (String)"occ-occba-business", (Object[])new Object[0]), name));
        }
        if (StringUtils.isNotEmpty((String)(name = DynamicObjectUtils.getString((DynamicObject)accountInfo.getDynamicObject("channel"), (String)"name")))) {
            nameList.add(String.format(ResManager.loadKDString((String)"\u6e20\u9053\u3010%1$s\u3011", (String)"RebateAccountHelper_17", (String)"occ-occba-business", (Object[])new Object[0]), name));
        }
        if (StringUtils.isNotEmpty((String)(name = DynamicObjectUtils.getString((DynamicObject)accountInfo.getDynamicObject("accounttype"), (String)"name")))) {
            nameList.add(String.format(ResManager.loadKDString((String)"\u8d26\u6237\u7c7b\u578b\u3010%1$s\u3011", (String)"RebateAccountHelper_18", (String)"occ-occba-business", (Object[])new Object[0]), name));
        }
        if (StringUtils.isNotEmpty((String)(name = DynamicObjectUtils.getString((DynamicObject)accountInfo.getDynamicObject("setcurrency"), (String)"name")))) {
            nameList.add(String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u522b\u3010%1$s\u3011", (String)"RebateAccountHelper_19", (String)"occ-occba-business", (Object[])new Object[0]), name));
        }
        return String.format(ResManager.loadKDString((String)"%1$s\u7684\u8d44\u91d1\u6c60\u8d26\u6237\uff0c\u5bf9\u5e94\u7684\u8d44\u91d1\u8d26\u6237\u5df2\u5f00\u542f\u4e86\u201c\u652f\u6301\u5546\u54c1\u660e\u7ec6\u8d26\u201d\uff0c\u4f20\u5165\u53c2\u6570\u9700\u5305\u542b\u5546\u54c1\u660e\u7ec6\u3002", (String)"RebateAccountHelper_21", (String)"occ-occba-business", (Object[])new Object[0]), StringUtils.join(nameList, (char)'\uff0c'));
    }

    private static String buildAccountNotExistMsg(AccountRecord accountRecord) {
        DynamicObject accountInfo = BusinessDataServiceHelper.newDynamicObject((String)"ocdbd_rebateaccount");
        accountInfo.set(String.join((CharSequence)"_", "org", "id"), (Object)accountRecord.getOrgId());
        accountInfo.set(String.join((CharSequence)"_", "channel", "id"), (Object)accountRecord.getChannelId());
        accountInfo.set(String.join((CharSequence)"_", "customer", "id"), (Object)accountRecord.getCustomerId());
        accountInfo.set(String.join((CharSequence)"_", "setcurrency", "id"), (Object)accountRecord.getCurrencyId());
        accountInfo.set(String.join((CharSequence)"_", "accounttype", "id"), (Object)accountRecord.getAccountType());
        BusinessDataServiceHelper.loadRefence((Object[])new Object[]{accountInfo}, (IDataEntityType)accountInfo.getDynamicObjectType());
        ArrayList<String> nameList = new ArrayList<String>(5);
        String name = DynamicObjectUtils.getString((DynamicObject)accountInfo.getDynamicObject("org"), (String)"name");
        if (StringUtils.isNotEmpty((String)name)) {
            nameList.add(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%1$s\u3011", (String)"RebateAccountHelper_15", (String)"occ-occba-business", (Object[])new Object[0]), name));
        }
        if (StringUtils.isNotEmpty((String)(name = DynamicObjectUtils.getString((DynamicObject)accountInfo.getDynamicObject("customer"), (String)"name")))) {
            nameList.add(String.format(ResManager.loadKDString((String)"\u5ba2\u6237\u3010%1$s\u3011", (String)"RebateAccountHelper_16", (String)"occ-occba-business", (Object[])new Object[0]), name));
        }
        if (StringUtils.isNotEmpty((String)(name = DynamicObjectUtils.getString((DynamicObject)accountInfo.getDynamicObject("channel"), (String)"name")))) {
            nameList.add(String.format(ResManager.loadKDString((String)"\u6e20\u9053\u3010%1$s\u3011", (String)"RebateAccountHelper_17", (String)"occ-occba-business", (Object[])new Object[0]), name));
        }
        if (StringUtils.isNotEmpty((String)(name = DynamicObjectUtils.getString((DynamicObject)accountInfo.getDynamicObject("accounttype"), (String)"name")))) {
            nameList.add(String.format(ResManager.loadKDString((String)"\u8d26\u6237\u7c7b\u578b\u3010%1$s\u3011", (String)"RebateAccountHelper_18", (String)"occ-occba-business", (Object[])new Object[0]), name));
        }
        if (StringUtils.isNotEmpty((String)(name = DynamicObjectUtils.getString((DynamicObject)accountInfo.getDynamicObject("setcurrency"), (String)"name")))) {
            nameList.add(String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u522b\u3010%1$s\u3011", (String)"RebateAccountHelper_19", (String)"occ-occba-business", (Object[])new Object[0]), name));
        }
        return String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684\u8d44\u91d1\u6c60\u8d26\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"RebateAccountHelper_20", (String)"occ-occba-business", (Object[])new Object[0]), StringUtils.join(nameList, (char)'\uff0c'));
    }

    public static List<DynamicObject> queryRebateAccountList(List<AccountRecord> paramList) {
        if (CollectionUtils.isEmpty(paramList)) {
            return new ArrayList<DynamicObject>(0);
        }
        QFilter filters = new QFilter("1", "!=", (Object)1);
        int index = 0;
        HashSet<Long> billIds = new HashSet<Long>(0);
        for (AccountRecord account : paramList) {
            QFilter filter = new QFilter("org", "=", (Object)account.getOrgId());
            filter.and("channel", "=", (Object)account.getChannelId());
            filter.and("customer", "=", (Object)account.getCustomerId());
            filter.and("setcurrency", "=", (Object)account.getCurrencyId());
            filter.and("accounttype", "=", (Object)account.getAccountType());
            filter.and("receivechannel", "=", (Object)account.getReceiveChannelId());
            filters.or(filter);
            if (++index != 300) continue;
            RebateAccountHelper.queryRebateAccountIds(filters, billIds);
            index = 0;
            filters = new QFilter("1", "!=", (Object)1);
        }
        RebateAccountHelper.queryRebateAccountIds(filters, billIds);
        QFilter qFilter = new QFilter("id", "in", billIds);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ocdbd_rebateaccount", (String)"id,org,customer,number,channel,accounttype,currency,setcurrency,occupyamount,balance,updatedatetime,availablebalance,receivechannel,type", (QFilter[])qFilter.toArray());
        return DynamicObjectUtils.convertDynamicObjList((DynamicObject[])result);
    }

    private static void queryRebateAccountIds(QFilter qFilter, Set<Long> billIds) {
        DynamicObjectCollection rebateAccountColl = QueryServiceHelper.query((String)"ocdbd_rebateaccount", (String)"id", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)rebateAccountColl)) {
            rebateAccountColl.forEach(x -> billIds.add(x.getLong("id")));
        }
    }

    public static DynamicObject buildAccountRecord(AccountRecord account, RecordUpdateTypeEnum recordUpdateType) {
        DynamicObject rebateRecord = BusinessDataServiceHelper.newDynamicObject((String)"occba_flowrecord");
        String billEntity = StringUtils.isEmpty((String)account.getBillEntity()) ? RebateAccountHelper.getBillEntityByBillType(account.getBillType()) : account.getBillEntity();
        rebateRecord.set("billentity", (Object)billEntity);
        rebateRecord.set("billtype", (Object)account.getBillType());
        rebateRecord.set("sourcebillno", (Object)account.getSourceBillNo());
        rebateRecord.set("sourcebillid", (Object)account.getSourceBillId());
        rebateRecord.set("afteramount", (Object)account.getAmount());
        if (RecordUpdateTypeEnum.DDGB == recordUpdateType) {
            rebateRecord.set("changeamount", (Object)account.getAmount().negate());
        } else {
            rebateRecord.set("changeamount", (Object)account.getAmount());
        }
        rebateRecord.set("createtime", (Object)TimeServiceHelper.now());
        rebateRecord.set("transaction", (Object)recordUpdateType.getValue());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateRecord, (String)"org", (long)account.getOrgId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateRecord, (String)"office", (long)account.getOfficeId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateRecord, (String)"channel", (long)account.getChannelId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateRecord, (String)"country", (long)account.getCountryId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateRecord, (String)"accout", (long)account.getAccountType());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateRecord, (String)"customer", (long)account.getCustomerId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateRecord, (String)"areadept", (long)account.getAreaDeptId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateRecord, (String)"stmcurrency", (long)account.getCurrencyId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateRecord, (String)"creator", (long)RequestContext.get().getCurrUserId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateRecord, (String)"receivechannel", (long)account.getReceiveChannelId());
        return rebateRecord;
    }

    private static String getAccountKey(DynamicObject account) {
        return String.format("%d_%d_%d_%d_%d_%d", DynamicObjectUtils.getPkValue((DynamicObject)account, (String)"org"), DynamicObjectUtils.getPkValue((DynamicObject)account, (String)"channel"), DynamicObjectUtils.getPkValue((DynamicObject)account, (String)"customer"), DynamicObjectUtils.getPkValue((DynamicObject)account, (String)"setcurrency"), DynamicObjectUtils.getPkValue((DynamicObject)account, (String)"accounttype"), DynamicObjectUtils.getPkValue((DynamicObject)account, (String)"receivechannel"));
    }

    private static String getBillEntityByBillType(String billType) {
        String billEntity = "";
        switch (billType) {
            case "A": {
                billEntity = "occpic_rebatestatement";
                break;
            }
            case "B": {
                billEntity = "ocbsoc_saleorder";
                break;
            }
            case "C": {
                billEntity = "occba_balanceadjust";
                break;
            }
            case "D": {
                billEntity = "ocbsoc_xsaleorder";
                break;
            }
            case "E": {
                billEntity = "occba_moneyincome";
                break;
            }
            case "F": {
                billEntity = "ocmem_mc_reimburse";
                break;
            }
        }
        return billEntity;
    }

    private static List<DynamicObject> buildRebateAccountList(List<AccountRecord> paramList) {
        List<AccountRecord> groupList = RebateAccountHelper.getSaveRebateAccountList(paramList);
        int size = groupList.size();
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(size);
        long[] longIdList = RebateAccountHelper.getLongIdList(size);
        String[] numberArray = CodeRuleUtil.batchCreateNumber((String)"ocdbd_rebateaccount", (int)size);
        for (int i = 0; i < groupList.size(); ++i) {
            AccountRecord accountRecord = groupList.get(i);
            DynamicObject rebateAccount = BusinessDataServiceHelper.newDynamicObject((String)"ocdbd_rebateaccount");
            rebateAccount.set("number", (Object)numberArray[i]);
            rebateAccount.set("id", (Object)longIdList[i]);
            accountRecord.setId(longIdList[i]);
            rebateAccount.set("balance", (Object)accountRecord.getAmount());
            rebateAccount.set("availablebalance", (Object)accountRecord.getAmount());
            rebateAccount.set("updatedatetime", (Object)TimeServiceHelper.now());
            String poolType = StringUtils.isEmpty((String)accountRecord.getPoolType()) ? AccountPoolTypeEnum.BRANDS.getValue() : accountRecord.getPoolType();
            rebateAccount.set("type", (Object)poolType);
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateAccount, (String)"org", (long)accountRecord.getOrgId());
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateAccount, (String)"customer", (long)accountRecord.getCustomerId());
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateAccount, (String)"channel", (long)accountRecord.getChannelId());
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateAccount, (String)"accounttype", (long)accountRecord.getAccountType());
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateAccount, (String)"setcurrency", (long)accountRecord.getCurrencyId());
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateAccount, (String)"receivechannel", (long)accountRecord.getReceiveChannelId());
            saveList.add(rebateAccount);
        }
        return saveList;
    }

    private static List<AccountRecord> getSaveRebateAccountList(List<AccountRecord> paramList) {
        if (CollectionUtils.isEmpty(paramList)) {
            return new ArrayList<AccountRecord>(0);
        }
        ArrayList<AccountRecord> groupList = new ArrayList<AccountRecord>(paramList.size());
        Map<String, List<AccountRecord>> groupBy = paramList.stream().collect(Collectors.groupingBy(AccountRecord::getKey));
        for (Map.Entry<String, List<AccountRecord>> entry : groupBy.entrySet()) {
            BigDecimal totalAmount = entry.getValue().stream().map(AccountRecord::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            AccountRecord addAccount = (AccountRecord)SerializationUtils.clone((Serializable)((Serializable)entry.getValue().get(0)));
            addAccount.setAmount(totalAmount);
            groupList.add(addAccount);
        }
        return groupList;
    }

    private static long[] getLongIdList(int size) {
        long[] longIdList = DBServiceHelper.genLongIds((String)"t_ocdbd_rebateaccount", (int)size);
        if (longIdList == null || longIdList.length == 0 || longIdList.length != size) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6279\u91cf\u751f\u6210ID\u5931\u8d25\u3002", (String)"RebateAccountHelper_9", (String)"occ-occba-business", (Object[])new Object[0]));
        }
        return longIdList;
    }

    public static Map<String, DynamicObject> getQueryRebateAccountInfoMap(List<AccountRecord> paramList) {
        List<DynamicObject> queryAccountList = RebateAccountHelper.queryRebateAccountList(paramList);
        return queryAccountList.stream().collect(Collectors.toMap(a -> RebateAccountHelper.getAccountKey(a), a -> a, (k1, k2) -> k1));
    }
}

