/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.business.rebate;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocbase.common.entity.AccountRecord;
import kd.occ.ocbase.common.entity.ServiceResult;
import kd.occ.occba.business.rebate.RebateAccountHelper;
import kd.occ.occba.common.enums.CalculationTypeEnum;
import kd.occ.occba.common.enums.RecordUpdateTypeEnum;

public class RebateAccountPoolHelper {
    private static final long WITH_TIME = 180000L;
    private static Log logger = LogFactory.getLog(RebateAccountPoolHelper.class);
    private static String DLOCK_KEY = "kd.occ.occba.business.rebate.RebateAccountPoolHelper";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceResult useBalance(List<AccountRecord> paramList) {
        block7: {
            DLock dLock = null;
            try {
                dLock = RebateAccountPoolHelper.createDLock();
                if (dLock.tryLock(180000L)) {
                    RebateAccountHelper.balanceOccupyOrRelease(paramList, RecordUpdateTypeEnum.APPLY, CalculationTypeEnum.USEAMOUNT);
                    break block7;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u6240\u5931\u8d25", (String)"RebateAccountPoolHelper_0", (String)"occ-occba-business", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                ServiceResult serviceResult = RebateAccountPoolHelper.buildErrorResult(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u8ba2\u5355\u4f7f\u7528\u63a5\u53e3\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a%1$s", (String)"RebateAccountPoolHelper_14", (String)"occ-occba-business", (Object[])new Object[0]), e.getMessage()));
                return serviceResult;
            }
            finally {
                if (dLock != null) {
                    dLock.unlock();
                }
            }
        }
        return RebateAccountPoolHelper.buildSuccessfulResult(ResManager.loadKDString((String)"\u8c03\u7528\u8ba2\u5355\u4f7f\u7528\u63a5\u53e3\u6210\u529f\u3002", (String)"RebateAccountPoolHelper_2", (String)"occ-occba-business", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceResult useBalanceRelease(List<AccountRecord> paramList) {
        block7: {
            DLock dLock = null;
            try {
                dLock = RebateAccountPoolHelper.createDLock();
                if (dLock.tryLock(180000L)) {
                    RebateAccountHelper.balanceOccupyOrRelease(paramList, RecordUpdateTypeEnum.DJSF, CalculationTypeEnum.USEAMOUNT);
                    break block7;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u6240\u5931\u8d25", (String)"RebateAccountPoolHelper_0", (String)"occ-occba-business", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                ServiceResult serviceResult = RebateAccountPoolHelper.buildErrorResult(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u5355\u636e\u91ca\u653e\u63a5\u53e3\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a%1$s", (String)"RebateAccountPoolHelper_15", (String)"occ-occba-business", (Object[])new Object[0]), e.getMessage()));
                return serviceResult;
            }
            finally {
                if (dLock != null) {
                    dLock.unlock();
                }
            }
        }
        return RebateAccountPoolHelper.buildSuccessfulResult(ResManager.loadKDString((String)"\u8c03\u7528\u5355\u636e\u91ca\u653e\u63a5\u53e3\u6210\u529f\u3002", (String)"RebateAccountPoolHelper_4", (String)"occ-occba-business", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceResult balanceAdjustment(List<AccountRecord> paramList) {
        block7: {
            DLock dLock = null;
            try {
                dLock = RebateAccountPoolHelper.createDLock();
                if (dLock.tryLock(180000L)) {
                    RebateAccountHelper.balanceAdjustment(paramList, RecordUpdateTypeEnum.YETZ);
                    break block7;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u6240\u5931\u8d25", (String)"RebateAccountPoolHelper_0", (String)"occ-occba-business", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                ServiceResult serviceResult = RebateAccountPoolHelper.buildErrorResult(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4f59\u989d\u8c03\u6574\u63a5\u53e3\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a%1$s", (String)"RebateAccountPoolHelper_16", (String)"occ-occba-business", (Object[])new Object[0]), e.getMessage()));
                return serviceResult;
            }
            finally {
                if (dLock != null) {
                    dLock.unlock();
                }
            }
        }
        return RebateAccountPoolHelper.buildSuccessfulResult(ResManager.loadKDString((String)"\u8c03\u7528\u4f59\u989d\u8c03\u6574\u63a5\u53e3\u6210\u529f\u3002", (String)"RebateAccountPoolHelper_6", (String)"occ-occba-business", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceResult balanceOccupy(List<AccountRecord> paramList) {
        block7: {
            DLock dLock = null;
            try {
                dLock = RebateAccountPoolHelper.createDLock();
                if (dLock.tryLock(180000L)) {
                    RebateAccountHelper.balanceOccupyOrRelease(paramList, RecordUpdateTypeEnum.YEDJ, CalculationTypeEnum.OCCUPYAMOUNT);
                    break block7;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u6240\u5931\u8d25", (String)"RebateAccountPoolHelper_0", (String)"occ-occba-business", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                ServiceResult serviceResult = RebateAccountPoolHelper.buildErrorResult(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4f59\u989d\u51bb\u7ed3\u63a5\u53e3\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a%1$s", (String)"RebateAccountPoolHelper_17", (String)"occ-occba-business", (Object[])new Object[0]), e.getMessage()));
                return serviceResult;
            }
            finally {
                if (dLock != null) {
                    dLock.unlock();
                }
            }
        }
        return RebateAccountPoolHelper.buildSuccessfulResult(ResManager.loadKDString((String)"\u8c03\u7528\u4f59\u989d\u51bb\u7ed3\u63a5\u53e3\u6210\u529f\u3002", (String)"RebateAccountPoolHelper_8", (String)"occ-occba-business", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceResult releaseOccupy(List<AccountRecord> paramList) {
        block7: {
            DLock dLock = null;
            try {
                dLock = RebateAccountPoolHelper.createDLock();
                if (dLock.tryLock(180000L)) {
                    RebateAccountHelper.balanceOccupyOrRelease(paramList, RecordUpdateTypeEnum.YESF, CalculationTypeEnum.OCCUPYAMOUNT);
                    break block7;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u6240\u5931\u8d25", (String)"RebateAccountPoolHelper_0", (String)"occ-occba-business", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                ServiceResult serviceResult = RebateAccountPoolHelper.buildErrorResult(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4f59\u989d\u91ca\u653e\u63a5\u53e3\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a%1$s", (String)"RebateAccountPoolHelper_18", (String)"occ-occba-business", (Object[])new Object[0]), e.getMessage()));
                return serviceResult;
            }
            finally {
                if (dLock != null) {
                    dLock.unlock();
                }
            }
        }
        return RebateAccountPoolHelper.buildSuccessfulResult(ResManager.loadKDString((String)"\u8c03\u7528\u4f59\u989d\u91ca\u653e\u63a5\u53e3\u6210\u529f\u3002", (String)"RebateAccountPoolHelper_10", (String)"occ-occba-business", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceResult settlementPayment(List<AccountRecord> paramList) {
        block7: {
            DLock dLock = null;
            try {
                dLock = RebateAccountPoolHelper.createDLock();
                if (dLock.tryLock(180000L)) {
                    RebateAccountHelper.settlementPayment(paramList);
                    break block7;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u6240\u5931\u8d25", (String)"RebateAccountPoolHelper_0", (String)"occ-occba-business", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                ServiceResult serviceResult = RebateAccountPoolHelper.buildErrorResult(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u7ed3\u7b97\u652f\u4ed8\u63a5\u53e3\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a%1$s", (String)"RebateAccountPoolHelper_19", (String)"occ-occba-business", (Object[])new Object[0]), e.getMessage()));
                return serviceResult;
            }
            finally {
                if (dLock != null) {
                    dLock.unlock();
                }
            }
        }
        return RebateAccountPoolHelper.buildSuccessfulResult(ResManager.loadKDString((String)"\u8c03\u7528\u7ed3\u7b97\u652f\u4ed8\u63a5\u53e3\u6210\u529f\u3002", (String)"RebateAccountPoolHelper_12", (String)"occ-occba-business", (Object[])new Object[0]));
    }

    private static ServiceResult buildSuccessfulResult(String data) {
        ServiceResult serviceResult = new ServiceResult();
        serviceResult.setCode(200);
        serviceResult.setSuccess(true);
        serviceResult.setData((Object)data);
        return serviceResult;
    }

    private static ServiceResult buildErrorResult(String errorMessage) {
        ServiceResult serviceResult = new ServiceResult();
        serviceResult.setCode(500);
        serviceResult.setSuccess(false);
        serviceResult.setErrorMsg(errorMessage);
        return serviceResult;
    }

    private static DLock createDLock() {
        return DLock.create((String)DLOCK_KEY, (String)ResManager.loadKDString((String)"\u5168\u6e20\u9053\u4e91\u9884\u7b97\u8d39\u7528\u5206\u5e03\u5f0f\u9501", (String)"RebateAccountPoolHelper_13", (String)"occ-occba-business", (Object[])new Object[0]));
    }
}

