/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.business.rebate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DataSetDataType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.helper.saleorder.SaleOrderBusinessHelper;
import kd.occ.ocbase.common.constants.BigDecimalConstants;
import kd.occ.ocbase.common.entity.OcdbdMoneyRuleParam;
import kd.occ.ocbase.common.entity.OcdbdMoneyRuleResult;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.util.BigDecimalUtil;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.Convert;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FilterConditionUtil;
import kd.occ.ocbase.common.util.StringUtils;

public class RebateAccountUseHelper {
    private RebateAccountUseHelper() {
    }

    public static DynamicObject createUseEntityByUseRecord(DynamicObject useRecordDynObj, String billFormId) {
        if (useRecordDynObj == null || StringUtils.isEmpty((String)billFormId)) {
            return null;
        }
        if ("ocbsoc_xsaleorder".equals(billFormId)) {
            billFormId = "ocbsoc_saleorder";
        }
        QFilter qFilter = new QFilter("useentity", "=", (Object)billFormId);
        qFilter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        DynamicObject ruleSchemeDnObj = BusinessDataServiceHelper.loadSingle((String)"occba_balusescheme", (QFilter[])qFilter.toArray());
        DynamicObjectCollection entryEntityColl = ruleSchemeDnObj.getDynamicObjectCollection("wbackentity");
        DynamicObjectCollection useRecordEntryColl = useRecordDynObj.getDynamicObjectCollection("entryentity");
        if (CommonUtils.isNull((Object)entryEntityColl) || CommonUtils.isNull((Object)useRecordEntryColl)) {
            return null;
        }
        List useRecordEntryLst = useRecordEntryColl.stream().filter(x -> x.getBoolean("isselect")).collect(Collectors.toList());
        List<DynamicObject> billFieldList = entryEntityColl.stream().filter(o -> StringUtils.isNotEmpty((String)o.getString("wuserecordfullcol"))).collect(Collectors.toList());
        DynamicObject billDynObj = BusinessDataServiceHelper.newDynamicObject((String)billFormId);
        HashSet<Long> chashPoolIdSet = new HashSet<Long>(16);
        for (DynamicObject useRecordEntryDynObj : useRecordEntryLst) {
            DynamicObjectCollection subEntityColl = useRecordEntryDynObj.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subEntityDynObj : subEntityColl) {
                BigDecimal subUsedAmount;
                long cashPoolId = subEntityDynObj.getLong("cashpoolid");
                if (cashPoolId > 0L) {
                    chashPoolIdSet.add(cashPoolId);
                }
                if ((subUsedAmount = subEntityDynObj.getBigDecimal("subusedamount")).compareTo(BigDecimal.ZERO) == 0) continue;
                DynamicObject addEntryDynObj = RebateAccountUseHelper.createBillEntryDynObj(billDynObj, billFieldList);
                for (DynamicObject mapEntryDynObj : billFieldList) {
                    List<Object> entryValuList;
                    List<Object> valuList;
                    String destProperty = mapEntryDynObj.getString("wusefullcol");
                    String srcProperty = mapEntryDynObj.getString("wuserecordfullcol");
                    String[] fieldKeys = destProperty.split("\\.");
                    if (fieldKeys.length == 1 && !CommonUtils.isNull(valuList = RebateAccountUseHelper.getBillFieldValue(useRecordDynObj, srcProperty, 0, 0))) {
                        RebateAccountUseHelper.setUseEntityDynObj(billDynObj, destProperty, valuList.get(0));
                    }
                    if (addEntryDynObj == null || CommonUtils.isNull(entryValuList = RebateAccountUseHelper.getBillFieldValue(useRecordDynObj, srcProperty, useRecordEntryDynObj.getInt("seq"), subEntityDynObj.getInt("seq")))) continue;
                    RebateAccountUseHelper.setUseEntityDynObj(addEntryDynObj, destProperty, entryValuList.get(0));
                }
            }
        }
        if (chashPoolIdSet.isEmpty()) {
            return null;
        }
        BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{billDynObj}, (IDataEntityType)billDynObj.getDynamicObjectType());
        return billDynObj;
    }

    private static DynamicObject createBillEntryDynObj(DynamicObject billDynObj, List<DynamicObject> billFieldList) {
        DynamicObject addEntryDynObj = null;
        for (DynamicObject mapEntryDynObj : billFieldList) {
            DynamicProperty property;
            String propertyName = mapEntryDynObj.getString("wusefullcol");
            String[] fieldKeys = propertyName.split("\\.");
            if (fieldKeys.length != 2 || !((property = billDynObj.getDynamicObjectType().getProperty(fieldKeys[0])) instanceof EntryProp)) continue;
            DynamicObjectCollection entryDynColl = billDynObj.getDynamicObjectCollection(fieldKeys[0]);
            addEntryDynObj = entryDynColl.addNew();
            break;
        }
        return addEntryDynObj;
    }

    private static void setUseEntityDynObj(DynamicObject useEntityDynObj, String destProperty, Object value) {
        String[] fieldKeys = destProperty.split("\\.");
        if (fieldKeys.length == 1) {
            DynamicProperty property = useEntityDynObj.getDynamicObjectType().getProperty(destProperty);
            if (property != null) {
                if (property instanceof BasedataProp) {
                    useEntityDynObj.set(destProperty + "_id", value);
                } else if (property instanceof MulBasedataProp) {
                    List list = DynamicObjectUtils.getBaseDataIds((DynamicObjectCollection)useEntityDynObj.getDynamicObjectCollection(destProperty));
                    DynamicObjectCollection dynColl = useEntityDynObj.getDynamicObjectCollection(destProperty);
                    for (Object pkValue : list) {
                        DynamicObject dataDynObj = dynColl.addNew();
                        dataDynObj.set("fbasedataid_id", pkValue);
                    }
                } else {
                    useEntityDynObj.set(destProperty, value);
                }
            }
        } else if (fieldKeys.length == 2) {
            String filedKey2 = fieldKeys[1];
            RebateAccountUseHelper.setUseEntityDynObj(useEntityDynObj, filedKey2, value);
        } else if (fieldKeys.length == 3) {
            String filedKey2 = fieldKeys[1];
            String filedKey3 = fieldKeys[2];
            RebateAccountUseHelper.setUseEntityDynObj(useEntityDynObj, String.join((CharSequence)".", filedKey2, filedKey3), value);
        }
    }

    public static DynamicObject createUseRecordByBill(long billId, String billFormId) {
        DynamicObject billDynObj;
        if (billId == 0L || StringUtils.isEmpty((String)billFormId)) {
            return null;
        }
        String useEntityId = billFormId;
        if ("ocbsoc_xsaleorder".equals(billFormId)) {
            useEntityId = "ocbsoc_saleorder";
        }
        QFilter qFilter = new QFilter("useentity", "=", (Object)useEntityId);
        qFilter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        DynamicObject ruleSchemeDnObj = BusinessDataServiceHelper.loadSingle((String)"occba_balusescheme", (QFilter[])qFilter.toArray());
        if (ruleSchemeDnObj == null) {
            return null;
        }
        DynamicObjectCollection entryEntityColl = ruleSchemeDnObj.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection valeEntityColl = ruleSchemeDnObj.getDynamicObjectCollection("valentity");
        if (CommonUtils.isNull((Object)entryEntityColl) || CommonUtils.isNull((Object)valeEntityColl)) {
            return null;
        }
        List valeEntityList = valeEntityColl.stream().filter(o -> StringUtils.isNotEmpty((String)o.getString("sourcefullcol"))).collect(Collectors.toList());
        if (CommonUtils.isNull(valeEntityList)) {
            return null;
        }
        QFilter filter = FilterConditionUtil.translateInfoSqlFilter((String)billFormId, (String)ruleSchemeDnObj.getString("filterscheme"));
        QFilter billFilter = new QFilter("id", "=", (Object)billId);
        if (filter != null) {
            billFilter.and(filter);
        }
        if ((billDynObj = BusinessDataServiceHelper.loadSingle((String)billFormId, (QFilter[])billFilter.toArray())) == null) {
            return null;
        }
        DynamicObjectCollection balanceDynObjColl = RebateAccountUseHelper.queryAccountBalance(billDynObj, entryEntityColl, valeEntityColl);
        if (CommonUtils.isNull((Object)balanceDynObjColl)) {
            return null;
        }
        Set groupByFieldSet = valeEntityList.stream().filter(o -> "B".equals(o.getString("calculatefield")) && o.getString("recordfullcol").contains(String.join((CharSequence)".", "entryentity")) && !o.getString("recordfullcol").contains(String.join((CharSequence)".", "subentryentity"))).map(o -> o.getString("recordfullcol")).collect(Collectors.toSet());
        LinkedHashMap<String, List<DynamicObject>> balanceDynObjMap = new LinkedHashMap<String, List<DynamicObject>>(16);
        for (DynamicObject balanceDynObj : balanceDynObjColl) {
            StringBuilder strBuilder = new StringBuilder();
            for (String fieldKey : groupByFieldSet) {
                strBuilder.append(balanceDynObj.get(fieldKey)).append("_");
            }
            String keyStr = strBuilder.toString();
            ArrayList<DynamicObject> balanceDynObjList = (ArrayList<DynamicObject>)balanceDynObjMap.get(keyStr);
            if (CommonUtils.isNull((Object)balanceDynObjList)) {
                balanceDynObjList = new ArrayList<DynamicObject>(16);
            }
            balanceDynObjList.add(balanceDynObj);
            balanceDynObjMap.put(keyStr, balanceDynObjList);
        }
        return RebateAccountUseHelper.createUseRecordByMap(balanceDynObjMap, valeEntityColl, billDynObj);
    }

    private static DynamicObjectCollection queryAccountBalance(DynamicObject billDynObj, DynamicObjectCollection entryEntityColl, DynamicObjectCollection valeEntityColl) {
        QFilter qFilter = new QFilter(String.join((CharSequence)".", "accounttype", "accounttype"), "in", (Object)new String[]{"A", "B"});
        qFilter.and(new QFilter(String.join((CharSequence)".", "accounttype", "issupportitem"), "=", (Object)Boolean.FALSE));
        List mapList = entryEntityColl.stream().filter(o -> StringUtils.isNotEmpty((String)o.getString("usefullcol")) || StringUtils.isNotEmpty((String)o.getString("fieldformula"))).collect(Collectors.toList());
        if (!CommonUtils.isNull(mapList)) {
            for (DynamicObject mapDynObj : mapList) {
                String queryParamType = mapDynObj.getString("matchmode");
                String string = mapDynObj.getString("valuetype");
                if ("0".equals(string)) {
                    List<Object> valueList = RebateAccountUseHelper.getBillFieldValue(billDynObj, mapDynObj.getString("usefullcol"), 0, 0);
                    String cp = "in";
                    if ("!=".equals(queryParamType)) {
                        cp = "not in";
                    }
                    qFilter.and(new QFilter(mapDynObj.getString("usetargetfullcol"), cp, valueList));
                    continue;
                }
                if (!"3".equals(string)) continue;
                String cp = "in";
                if ("!=".equals(queryParamType)) {
                    cp = "not in";
                }
                String useTargetFullCol = mapDynObj.getString("usetargetfullcol");
                DynamicObject accountDynObj = BusinessDataServiceHelper.newDynamicObject((String)"ocdbd_rebateaccount");
                DynamicProperty property = accountDynObj.getDynamicObjectType().getProperty(useTargetFullCol);
                String fieldValue = mapDynObj.getString("fieldformula");
                if (!StringUtils.isNotEmpty((String)fieldValue)) continue;
                String[] fieldValueStrs = fieldValue.split(",");
                ArrayList<Object> objValueList = new ArrayList<Object>(fieldValueStrs.length);
                for (String str : fieldValueStrs) {
                    Object objValue = str;
                    DataType fieldDataType = DataSetDataType.getDataType((Class)property.getPropertyType());
                    if (property instanceof BasedataProp && !(((BasedataProp)property).getRefIdProp() instanceof VarcharProp)) {
                        objValue = Convert.toLong((String)fieldValue);
                    } else if (DataType.BooleanType.equals((Object)fieldDataType)) {
                        objValue = Boolean.valueOf(fieldValue);
                    } else if (DataType.IntegerType.equals((Object)fieldDataType)) {
                        objValue = Integer.valueOf(fieldValue);
                    } else if (DataType.LongType.equals((Object)fieldDataType)) {
                        objValue = Convert.toLong((String)fieldValue);
                    } else if (DataType.DoubleType.equals((Object)fieldDataType) || DataType.BigDecimalType.equals((Object)fieldDataType)) {
                        objValue = Convert.toBigDecimal((Object)fieldValue);
                    } else if (DataType.DateType.equals((Object)fieldDataType) || DataType.TimestampType.equals((Object)fieldDataType)) {
                        objValue = Convert.toDate((String)fieldValue);
                    }
                    objValueList.add(objValue);
                }
                qFilter.and(new QFilter(useTargetFullCol, cp, objValueList));
            }
        }
        Map<String, String> srcColMap = RebateAccountUseHelper.getBalanceFieldList(valeEntityColl).stream().collect(Collectors.toMap(obj -> obj.getString("recordfullcol"), obj -> obj.getString("sourcefullcol"), (r1, r2) -> r1));
        HashSet<String> selectFieldSet = new HashSet<String>(30);
        for (Map.Entry entry : srcColMap.entrySet()) {
            selectFieldSet.add((String)entry.getValue() + " " + (String)entry.getKey());
        }
        selectFieldSet.add("availablebalance");
        String selectors = String.join((CharSequence)",", selectFieldSet);
        return QueryServiceHelper.query((String)"ocdbd_rebateaccount", (String)selectors, (QFilter[])qFilter.toArray());
    }

    private static List<DynamicObject> getBalanceFieldList(DynamicObjectCollection valeEntityColl) {
        return valeEntityColl.stream().filter(o -> !"A".equals(o.getString("calculatefield")) && "A".equals(o.getString("valmode")) && (o.getString("recordfullcol").contains(String.join((CharSequence)".", "entryentity")) || o.getString("recordfullcol").contains(String.join((CharSequence)".", "subentryentity"))) && StringUtils.isNotEmpty((String)o.getString("sourcefullcol"))).collect(Collectors.toList());
    }

    private static List<DynamicObject> getBillFieldList(DynamicObjectCollection valeEntityColl) {
        return valeEntityColl.stream().filter(o -> !"A".equals(o.getString("calculatefield")) && "A".equals(o.getString("valmode")) && !o.getString("recordfullcol").contains(String.join((CharSequence)".", "entryentity")) && !o.getString("recordfullcol").contains(String.join((CharSequence)".", "subentryentity")) && StringUtils.isNotEmpty((String)o.getString("sourcefullcol"))).collect(Collectors.toList());
    }

    private static List<DynamicObject> getAccountUseFieldList(DynamicObjectCollection valeEntityColl) {
        return valeEntityColl.stream().filter(o -> "A".equals(o.getString("calculatefield")) && StringUtils.isNotEmpty((String)o.getString("sourcefullcol"))).collect(Collectors.toList());
    }

    private static DynamicObject createUseRecordByMap(Map<String, List<DynamicObject>> balanceDynObjMap, DynamicObjectCollection valeEtityColl, DynamicObject billDynObj) {
        if (CommonUtils.isNull(balanceDynObjMap)) {
            return null;
        }
        DynamicObject useRecordDynObj = BusinessDataServiceHelper.newDynamicObject((String)"occba_rebateaccountuse");
        List<DynamicObject> billFieldList = RebateAccountUseHelper.getBillFieldList(valeEtityColl);
        for (DynamicObject mapEntryDynObj : billFieldList) {
            String propertyName = mapEntryDynObj.getString("recordfullcol");
            RebateAccountUseHelper.setUseRecordDynObj(useRecordDynObj, billDynObj, propertyName, mapEntryDynObj.getString("sourcefullcol"));
        }
        List<DynamicObject> balanceFieldList = RebateAccountUseHelper.getBalanceFieldList(valeEtityColl);
        DynamicObjectCollection entityColl = useRecordDynObj.getDynamicObjectCollection("entryentity");
        int seq = 1;
        LinkedList<Map.Entry<String, List<DynamicObject>>> balanceList = new LinkedList<Map.Entry<String, List<DynamicObject>>>(balanceDynObjMap.entrySet());
        balanceList.sort((o1, o2) -> ((List)o1.getValue()).stream().map(dynObj -> dynObj.getBigDecimal("availablebalance")).reduce(BigDecimal.ZERO, BigDecimal::add).compareTo(((List)o2.getValue()).stream().map(dynObj -> dynObj.getBigDecimal("availablebalance")).reduce(BigDecimal.ZERO, BigDecimal::add)));
        for (Map.Entry entry : balanceList) {
            List list = (List)entry.getValue();
            list.sort(Comparator.comparing(o -> o.getBigDecimal("availablebalance")));
            DynamicObject useEntryDynObj = entityColl.addNew();
            for (DynamicObject mapEntryDynObj : balanceFieldList) {
                String propertyName = mapEntryDynObj.getString("recordfullcol");
                DynamicObject srcDataDynObj = (DynamicObject)list.get(0);
                RebateAccountUseHelper.setUseRecordDynObj(useRecordDynObj, srcDataDynObj, propertyName, propertyName);
                RebateAccountUseHelper.setUseRecordDynObj(useEntryDynObj, srcDataDynObj, propertyName, propertyName);
            }
            useEntryDynObj.set("seq", (Object)seq++);
            DynamicObjectCollection subEntityColl = useEntryDynObj.getDynamicObjectCollection("subentryentity");
            int subSeq = 1;
            for (DynamicObject detailDynObj : list) {
                DynamicObject subEntryDynObj = subEntityColl.addNew();
                for (DynamicObject mapEntryDynObj : balanceFieldList) {
                    String propertyName = mapEntryDynObj.getString("recordfullcol");
                    RebateAccountUseHelper.setUseRecordDynObj(subEntryDynObj, detailDynObj, propertyName, propertyName);
                }
                subEntryDynObj.set("seq", (Object)subSeq++);
            }
        }
        List<DynamicObject> accountUseFieldList = RebateAccountUseHelper.getAccountUseFieldList(valeEtityColl);
        for (DynamicObject useEntryDynObj : entityColl) {
            for (DynamicObject mapEntryDynObj : accountUseFieldList) {
                String propertyName = mapEntryDynObj.getString("recordfullcol");
                if (!propertyName.contains(String.join((CharSequence)".", "entryentity"))) continue;
                List<Object> valueList = RebateAccountUseHelper.getBillFieldValue(useRecordDynObj, mapEntryDynObj.getString("sourcefullcol"), useEntryDynObj.getInt("seq"), 0);
                BigDecimal sumValue = valueList.stream().map(o -> BigDecimalUtil.toBigDecimal((Object)o)).reduce(BigDecimal.ZERO, BigDecimal::add);
                String[] fieldKeys = propertyName.split("\\.");
                useEntryDynObj.set(fieldKeys[1], (Object)sumValue);
            }
        }
        BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{useRecordDynObj}, (IDataEntityType)useRecordDynObj.getDynamicObjectType());
        String string = billDynObj.getDynamicObjectType().getName();
        if ("ocbsoc_saleorder".equals(string) || "ocbsoc_xsaleorder".equals(string) || "ocbsoc_debitorder".equals(string)) {
            RebateAccountUseHelper.setUsePercentBySaleOrder(billDynObj, useRecordDynObj);
        }
        return useRecordDynObj;
    }

    private static void setUsePercentBySaleOrder(DynamicObject billDynObj, DynamicObject useRecordDynObj) {
        Map resultMap = SaleOrderBusinessHelper.getMoneyRuleResultMapBySaleOrder((DynamicObject[])new DynamicObject[]{billDynObj}, (DynamicObject)useRecordDynObj, (boolean)false);
        BigDecimal orderAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)useRecordDynObj, (String)"orderamount");
        OcdbdMoneyRuleParam ruleParam = new OcdbdMoneyRuleParam(DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"settleorgid"), DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"orderchannelid"), billDynObj.getDate("orderdate"), 0L, orderAmount);
        OcdbdMoneyRuleResult ruleResult = SaleOrderBusinessHelper.getMoneyRuleResultByParam((Map)resultMap, (OcdbdMoneyRuleParam)ruleParam);
        BigDecimal usePercent = ruleResult.getAmountRate();
        if (useRecordDynObj.getBigDecimal("orderamount").compareTo(ruleResult.getAmount()) < 0) {
            usePercent = BigDecimal.ZERO;
        }
        useRecordDynObj.set("usepercent", (Object)usePercent);
        int amountPrecision = 2;
        if (useRecordDynObj.getDynamicObject("currency") != null) {
            amountPrecision = DynamicObjectUtils.getInt((DynamicObject)useRecordDynObj.getDynamicObject("currency"), (String)"amtprecision");
        }
        BigDecimal availableAmount = useRecordDynObj.getBigDecimal("orderamount").multiply(usePercent.divide(BigDecimalConstants.ONEHUNDRED)).setScale(amountPrecision, 4);
        useRecordDynObj.set("availableamount", (Object)availableAmount);
    }

    private static void setUseRecordDynObj(DynamicObject useRecordynObj, DynamicObject balanceDynObj, String propertyName, String rowFieldName) {
        String[] fieldKeys = propertyName.split("\\.");
        if (fieldKeys.length == 1) {
            DynamicProperty property = useRecordynObj.getDynamicObjectType().getProperty(propertyName);
            if (property != null) {
                if (property instanceof BasedataProp) {
                    useRecordynObj.set(propertyName + "_id", balanceDynObj.get(rowFieldName));
                } else if (property instanceof MulBasedataProp) {
                    List list = DynamicObjectUtils.getBaseDataIds((DynamicObjectCollection)useRecordynObj.getDynamicObjectCollection(propertyName));
                    DynamicObjectCollection dynColl = useRecordynObj.getDynamicObjectCollection(propertyName);
                    for (Object pkValue : list) {
                        DynamicObject dataDynObj = dynColl.addNew();
                        dataDynObj.set("fbasedataid_id", pkValue);
                    }
                } else {
                    useRecordynObj.set(propertyName, balanceDynObj.get(rowFieldName));
                }
            }
        } else if (fieldKeys.length == 2) {
            String filedKey2 = fieldKeys[1];
            RebateAccountUseHelper.setUseRecordDynObj(useRecordynObj, balanceDynObj, filedKey2, rowFieldName);
        } else if (fieldKeys.length == 3) {
            String filedKey2 = fieldKeys[1];
            String filedKey3 = fieldKeys[2];
            RebateAccountUseHelper.setUseRecordDynObj(useRecordynObj, balanceDynObj, String.join((CharSequence)".", filedKey2, filedKey3), rowFieldName);
        }
    }

    private static List<Object> getBillFieldValue(DynamicObject billDynObj, String fieldKey, int rowSeq, int subRowSeq) {
        ArrayList<Object> valueList;
        block25: {
            String[] fieldKeys;
            block24: {
                valueList = new ArrayList<Object>(10);
                fieldKeys = fieldKey.split("\\.");
                if (fieldKeys.length != 1) break block24;
                DynamicProperty property = billDynObj.getDynamicObjectType().getProperty(fieldKey);
                if (property == null) break block25;
                if (property instanceof BasedataProp) {
                    if (((BasedataProp)property).getRefIdProp() instanceof VarcharProp) {
                        RebateAccountUseHelper.addListValue(valueList, DynamicObjectUtils.getStrPkValue((DynamicObject)billDynObj, (String)fieldKey));
                    } else {
                        RebateAccountUseHelper.addListValue(valueList, DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)fieldKey));
                    }
                } else if (property instanceof MulBasedataProp) {
                    RebateAccountUseHelper.addListCollValue(valueList, DynamicObjectUtils.getBaseDataIds((DynamicObjectCollection)billDynObj.getDynamicObjectCollection(fieldKey)));
                } else if (DataType.StringType.equals((Object)DataSetDataType.getDataType((Class)property.getPropertyType()))) {
                    RebateAccountUseHelper.addListValue(valueList, DynamicObjectUtils.getString((DynamicObject)billDynObj, (String)fieldKey));
                } else {
                    RebateAccountUseHelper.addListValue(valueList, billDynObj.get(fieldKey));
                }
                break block25;
            }
            if (billDynObj != null) {
                DataEntityPropertyCollection properties = billDynObj.getDynamicObjectType().getProperties();
                if (fieldKeys.length == 2) {
                    String filedKey1 = fieldKeys[0];
                    String filedKey2 = fieldKeys[1];
                    for (IDataEntityProperty propertity : properties) {
                        if (!propertity.getName().equals(filedKey1)) continue;
                        if (propertity instanceof BasedataProp) {
                            RebateAccountUseHelper.addListValue(valueList, DynamicObjectUtils.getPkValue((DynamicObject)billDynObj.getDynamicObject(filedKey1), (String)filedKey2));
                            continue;
                        }
                        if (propertity instanceof EntryProp) {
                            DynamicObjectCollection entryDynColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)billDynObj, (String)filedKey1);
                            for (DynamicObject entryDynObj : entryDynColl) {
                                if (rowSeq != 0 && (rowSeq <= 0 || entryDynObj.getInt("seq") != rowSeq)) continue;
                                RebateAccountUseHelper.addListCollValue(valueList, RebateAccountUseHelper.getBillFieldValue(entryDynObj, filedKey2, subRowSeq, 0));
                            }
                            continue;
                        }
                        if (!DataType.StringType.equals((Object)DataSetDataType.getDataType((Class)propertity.getPropertyType()))) continue;
                        RebateAccountUseHelper.addListValue(valueList, DynamicObjectUtils.getString((DynamicObject)billDynObj, (String)fieldKey));
                    }
                } else if (fieldKeys.length == 3) {
                    String filedKey1 = fieldKeys[0];
                    String filedKey2 = fieldKeys[1];
                    String filedKey3 = fieldKeys[2];
                    for (IDataEntityProperty propertity : properties) {
                        if (!propertity.getName().equals(filedKey1)) continue;
                        if (propertity instanceof BasedataProp) {
                            RebateAccountUseHelper.addListCollValue(valueList, RebateAccountUseHelper.getBillFieldValue(billDynObj.getDynamicObject(filedKey1), String.join((CharSequence)".", filedKey2, filedKey3), rowSeq, subRowSeq));
                            continue;
                        }
                        if (!(propertity instanceof EntryProp)) continue;
                        DynamicObjectCollection entryDynColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)billDynObj, (String)filedKey1);
                        for (DynamicObject entryDynObj : entryDynColl) {
                            if (rowSeq != 0 && (rowSeq <= 0 || entryDynObj.getInt("seq") != rowSeq)) continue;
                            RebateAccountUseHelper.addListCollValue(valueList, RebateAccountUseHelper.getBillFieldValue(entryDynObj, String.join((CharSequence)".", filedKey2, filedKey3), subRowSeq, 0));
                        }
                    }
                } else if (fieldKeys.length == 4) {
                    String filedKey1 = fieldKeys[0];
                    String filedKey2 = fieldKeys[1];
                    String filedKey3 = fieldKeys[2];
                    String filedKey4 = fieldKeys[3];
                    for (IDataEntityProperty propertity : properties) {
                        if (!propertity.getName().equals(filedKey1)) continue;
                        if (propertity instanceof BasedataProp) {
                            RebateAccountUseHelper.addListCollValue(valueList, RebateAccountUseHelper.getBillFieldValue(billDynObj.getDynamicObject(filedKey1), String.join((CharSequence)".", filedKey2, filedKey3, filedKey4), rowSeq, 0));
                            continue;
                        }
                        if (!(propertity instanceof EntryProp)) continue;
                        DynamicObjectCollection entryDynColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)billDynObj, (String)filedKey1);
                        for (DynamicObject entryDynObj : entryDynColl) {
                            if (rowSeq != 0 && (rowSeq <= 0 || entryDynObj.getInt("seq") != rowSeq)) continue;
                            RebateAccountUseHelper.addListCollValue(valueList, RebateAccountUseHelper.getBillFieldValue(entryDynObj, String.join((CharSequence)".", filedKey2, filedKey3, filedKey4), 0, 0));
                        }
                    }
                }
            }
        }
        return valueList;
    }

    private static void addListValue(List<Object> valueList, Object value) {
        if (!CommonUtils.isNull((Object)value) && !valueList.contains(value)) {
            valueList.add(value);
        }
    }

    private static void addListCollValue(List<Object> valueList, List<Object> value) {
        if (!CommonUtils.isNull(value)) {
            valueList.addAll(value);
        }
    }
}

