/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.business.rebate;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.occba.business.rebate.RebateProcessor;

public class RebateHelper {
    private static final String CONS_NAME = ".name";
    private static final RebateProcessor processor = new RebateProcessor();

    public static BigDecimal getAccountBalance4Order(long ownerId, long customerId, long accountTypeId, long currencyId) {
        return processor.getAccountBalance4Order(ownerId, customerId, accountTypeId, currencyId);
    }

    @Deprecated
    public static DynamicObject getRebateAccount(long orgId, long customerId, long channelId, long accountTypeId, long currencyId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and(new QFilter("customer", "=", (Object)customerId));
        filter.and(new QFilter("channel", "=", (Object)channelId));
        filter.and(new QFilter("accounttype", "=", (Object)accountTypeId));
        filter.and(new QFilter("setcurrency", "=", (Object)currencyId));
        return ORM.create().queryOne("ocdbd_rebateaccount", filter.toArray());
    }

    public static DynamicObject getRebateAccount(long orgId, long customerId, long channelId, long accountTypeId, long currencyId, long receiveChannelId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and(new QFilter("customer", "=", (Object)customerId));
        filter.and(new QFilter("channel", "=", (Object)channelId));
        filter.and(new QFilter("accounttype", "=", (Object)accountTypeId));
        filter.and(new QFilter("setcurrency", "=", (Object)currencyId));
        filter.and(new QFilter("receivechannel", "=", (Object)receiveChannelId));
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_rebateaccount", (String)"id,org,customer,number,channel,accounttype,currency,setcurrency,occupyamount,balance,updatedatetime,availablebalance,receivechannel,type", (QFilter[])filter.toArray());
    }

    public static String getAdjustAccountInfoCheckMsg(DynamicObject adjustBill) {
        String adjustType = DynamicObjectUtils.getString((DynamicObject)adjustBill, (String)"adjusttype");
        DynamicObject org = DynamicObjectUtils.getDynamicObject((DynamicObject)adjustBill, (String)"org");
        DynamicObject receiveChannel = DynamicObjectUtils.getDynamicObject((DynamicObject)adjustBill, (String)"receivechannel");
        DynamicObjectCollection entryInfoList = adjustBill.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryInfo : entryInfoList) {
            boolean isExists = RebateHelper.checkAccountInfoExist(entryInfo, DynamicObjectUtils.getPkValue((DynamicObject)adjustBill, (String)"org"), DynamicObjectUtils.getPkValue((DynamicObject)adjustBill, (String)"receivechannel"), DynamicObjectUtils.getPkValue((DynamicObject)adjustBill), adjustType);
            if (!isExists) continue;
            if ("B".equalsIgnoreCase(adjustType)) {
                return RebateHelper.buildChannelErrorMessage(entryInfo, receiveChannel);
            }
            return RebateHelper.buildOrgErrorMessage(entryInfo, org);
        }
        return "";
    }

    private static String buildOrgErrorMessage(DynamicObject entryInfo, DynamicObject org) {
        return String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e3a\u3010%1$s\u3011\uff0c\u5ba2\u6237\u4e3a\u3010%2$s\u3011\uff0c\u6e20\u9053\u4e3a\u3010%3$s\u3011\uff0c\u8d26\u6237\u7c7b\u578b\u4e3a\u3010%4$s\u3011\uff0c\u5e01\u522b\u4e3a\u3010%5$s\u3011\u7684\u6fc0\u52b1\u8d26\u6237\u5df2\u5b58\u5728\u4e8e\u63d0\u4ea4\u72b6\u6001\u7684\u8c03\u6574\u5355\u4e2d\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u8c03\u6574\u3002", (String)"RebateHelper_0", (String)"occ-occba-business", (Object[])new Object[0]), DynamicObjectUtils.getString((DynamicObject)org, (String)"name"), entryInfo.getString("customer.name"), entryInfo.getString("channel.name"), entryInfo.getString("accounttype.name"), entryInfo.getString("currency.name"));
    }

    private static String buildChannelErrorMessage(DynamicObject entryInfo, DynamicObject receiveChannel) {
        return String.format(ResManager.loadKDString((String)"\u6e20\u9053\u4e3a\u3010%1$s\u3011\uff0c\u8d26\u6237\u7c7b\u578b\u4e3a\u3010%2$s\u3011\uff0c\u5e01\u522b\u4e3a\u3010%3$s\u3011\u7684\u6fc0\u52b1\u8d26\u6237\u5df2\u5b58\u5728\u4e8e\u63d0\u4ea4\u72b6\u6001\u7684\u8c03\u6574\u5355\u4e2d\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u8c03\u6574\u3002", (String)"RebateHelper_1", (String)"occ-occba-business", (Object[])new Object[0]), entryInfo.getString("channel.name"), entryInfo.getString("accounttype.name"), entryInfo.getString("currency.name"));
    }

    private static boolean checkOrgTypeForAdjustEntry(DynamicObject entryInfo, long orgId, long billId) {
        long customerId = DynamicObjectUtils.getPkValue((DynamicObject)entryInfo.getDynamicObject("customer"));
        long accountTypeId = DynamicObjectUtils.getPkValue((DynamicObject)entryInfo.getDynamicObject("accounttype"));
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)entryInfo.getDynamicObject("currency"));
        long channelId = DynamicObjectUtils.getPkValue((DynamicObject)entryInfo.getDynamicObject("channel"));
        QFilter filters = new QFilter("id", "!=", (Object)billId);
        filters.and("org", "=", (Object)orgId);
        filters.and("billstatus", "=", (Object)"B");
        filters.and("adjusttype", "=", (Object)"A");
        filters.and("entryentity.customer", "=", (Object)customerId);
        filters.and("entryentity.channel", "=", (Object)channelId);
        filters.and("entryentity.accounttype", "=", (Object)accountTypeId);
        filters.and("entryentity.currency", "=", (Object)currencyId);
        return QueryServiceHelper.exists((String)"occba_balanceadjust", (QFilter[])filters.toArray());
    }

    private static boolean checkChannelTypeForAdjustEntry(DynamicObject entryInfo, long receiveChannelId, long billId) {
        long accountTypeId = DynamicObjectUtils.getPkValue((DynamicObject)entryInfo.getDynamicObject("accounttype"));
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)entryInfo.getDynamicObject("currency"));
        long channelId = DynamicObjectUtils.getPkValue((DynamicObject)entryInfo.getDynamicObject("channel"));
        QFilter filters = new QFilter("id", "!=", (Object)billId);
        filters.and("billstatus", "=", (Object)"B");
        filters.and("adjusttype", "=", (Object)"B");
        filters.and("receivechannel", "=", (Object)receiveChannelId);
        filters.and("entryentity.channel", "=", (Object)channelId);
        filters.and("entryentity.accounttype", "=", (Object)accountTypeId);
        filters.and("entryentity.currency", "=", (Object)currencyId);
        return QueryServiceHelper.exists((String)"occba_balanceadjust", (QFilter[])filters.toArray());
    }

    private static boolean checkAccountInfoExist(DynamicObject entryInfo, long orgId, long receiveChannelId, long pkValue, String adjustType) {
        if ("B".equalsIgnoreCase(adjustType)) {
            return RebateHelper.checkChannelTypeForAdjustEntry(entryInfo, receiveChannelId, pkValue);
        }
        return RebateHelper.checkOrgTypeForAdjustEntry(entryInfo, orgId, pkValue);
    }

    @Deprecated
    public static void checkAdjustAccountExist(long pkValue, long orgId, long customerId, long accountTypeId, long currencyId, long channelId, String ... args) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and(new QFilter("entryentity.customer", "=", (Object)customerId));
        filter.and(new QFilter("entryentity.channel", "=", (Object)channelId));
        filter.and(new QFilter("entryentity.accounttype", "=", (Object)accountTypeId));
        filter.and(new QFilter("entryentity.currency", "=", (Object)currencyId));
        filter.and(new QFilter("billstatus", "=", (Object)"B"));
        filter.and(new QFilter("id", "!=", (Object)pkValue));
        DynamicObject adjustBill = BusinessDataServiceHelper.loadSingle((String)"occba_balanceadjust", (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,billtype,remark,org,adjusttime,signparty,areadept,rptoffice,country,receivechannel,adjusttype,entryentity.id,entryentity.seq,entryentity.customer,entryentity.channel,entryentity.accounttype,entryentity.currency,entryentity.accountamount,entryentity.adjustedamount,entryentity.adjustamount", (QFilter[])filter.toArray());
        String billTypeStr = "";
        if (args != null && args.length > 0) {
            billTypeStr = args[0];
        }
        if (adjustBill != null) {
            DynamicObject balanceAdjust = BusinessDataServiceHelper.newDynamicObject((String)"occba_balanceadjust");
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)balanceAdjust, (String)"org", (long)orgId);
            DynamicObjectCollection entryList = balanceAdjust.getDynamicObjectCollection("entryentity");
            DynamicObject entry = entryList.addNew();
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)entry, (String)"customer", (long)customerId);
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)entry, (String)"channel", (long)channelId);
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)entry, (String)"accounttype", (long)accountTypeId);
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)entry, (String)"currency", (long)currencyId);
            BusinessDataServiceHelper.loadRefence((Object[])new Object[]{balanceAdjust}, (IDataEntityType)balanceAdjust.getDynamicObjectType());
            String errorMsg = "";
            errorMsg = billTypeStr.startsWith("occba_cus") ? String.format(ResManager.loadKDString((String)"\u6e20\u9053\u4e3a\u3010%1$s\u3011\uff0c\u8d26\u6237\u7c7b\u578b\u4e3a\u3010%2$s\u3011\uff0c\u5e01\u522b\u4e3a\u3010%3$s\u3011\u7684\u6fc0\u52b1\u8d26\u6237\u5df2\u5b58\u5728\u4e8e\u63d0\u4ea4\u72b6\u6001\u7684\u8c03\u6574\u5355\u4e2d\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u8c03\u6574\u3002", (String)"RebateHelper_1", (String)"occ-occba-business", (Object[])new Object[0]), entry.getString("channel.name"), entry.getString("accounttype.name"), entry.getString("currency.name")) : String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e3a\u3010%1$s\u3011\uff0c\u5ba2\u6237\u4e3a\u3010%2$s\u3011\uff0c\u6e20\u9053\u4e3a\u3010%3$s\u3011\uff0c\u8d26\u6237\u7c7b\u578b\u4e3a\u3010%4$s\u3011\uff0c\u5e01\u522b\u4e3a\u3010%5$s\u3011\u7684\u6fc0\u52b1\u8d26\u6237\u5df2\u5b58\u5728\u4e8e\u63d0\u4ea4\u72b6\u6001\u7684\u8c03\u6574\u5355\u4e2d\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u8c03\u6574\u3002", (String)"RebateHelper_0", (String)"occ-occba-business", (Object[])new Object[0]), balanceAdjust.getString("org.name"), entry.getString("customer.name"), entry.getString("channel.name"), entry.getString("accounttype.name"), entry.getString("currency.name"));
            throw new KDBizException(errorMsg);
        }
    }
}

