/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.business.rebate;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.occ.ocbase.common.entity.AccountRecord;
import kd.occ.ocbase.common.enums.AccountPoolTypeEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class RebateServiceCheckHelper {
    public static void bacthCheckSourceBillValues(List<AccountRecord> accountRecordList) {
        if (CollectionUtils.isEmpty(accountRecordList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u8d44\u91d1\u6c60\u670d\u52a1\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a\u5165\u53c2\u5206\u5f55\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"RebateServiceCheckHelper_10", (String)"occ-occba-business", (Object[])new Object[0]));
        }
        for (AccountRecord accountRecord : accountRecordList) {
            RebateServiceCheckHelper.checkSourceBillValues(accountRecord, false);
        }
    }

    public static void bacthCheckAccountRecordValues(List<AccountRecord> accountRecordList) {
        if (CollectionUtils.isEmpty(accountRecordList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u8d44\u91d1\u6c60\u670d\u52a1\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a\u5165\u53c2\u5206\u5f55\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"RebateServiceCheckHelper_10", (String)"occ-occba-business", (Object[])new Object[0]));
        }
        for (AccountRecord accountRecord : accountRecordList) {
            RebateServiceCheckHelper.checkSourceBillValues(accountRecord, true);
        }
    }

    public static void checkSourceBillValues(AccountRecord accountRecord, boolean allowAmountZero) {
        String checkMessage = RebateServiceCheckHelper.getErrorMessage(accountRecord, allowAmountZero);
        if (StringUtils.isNotEmpty((String)checkMessage)) {
            throw new KDBizException(checkMessage);
        }
    }

    public static String getErrorMessage(AccountRecord accountRecord, boolean allowAmountZero) {
        if (accountRecord == null) {
            return ResManager.loadKDString((String)"\u8c03\u7528\u8d44\u91d1\u6c60\u670d\u52a1\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a\u4f20\u53c2\u6709\u8bef\u3002", (String)"RebateServiceCheckHelper_11", (String)"occ-occba-business", (Object[])new Object[0]);
        }
        if (accountRecord.getSourceBillId() == 0L || accountRecord.getSourceEntryId() == 0L) {
            return ResManager.loadKDString((String)"\u8c03\u7528\u8d44\u91d1\u6c60\u670d\u52a1\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a\u6765\u6e90\u5355\u636eID\u548c\u6765\u6e90\u5355\u636e\u5206\u5f55ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RebateServiceCheckHelper_12", (String)"occ-occba-business", (Object[])new Object[0]);
        }
        StringBuilder errMsg = new StringBuilder();
        ArrayList<String> nameList = new ArrayList<String>(6);
        if (AccountPoolTypeEnum.CHANNEL.getValue().equalsIgnoreCase(accountRecord.getPoolType())) {
            if (accountRecord.getReceiveChannelId() == 0L) {
                nameList.add(ResManager.loadKDString((String)"\u6536\u6b3e\u6e20\u9053", (String)"RebateServiceCheckHelper_13", (String)"occ-occba-business", (Object[])new Object[0]));
            }
        } else if (accountRecord.getOrgId() == 0L) {
            nameList.add(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7", (String)"RebateServiceCheckHelper_3", (String)"occ-occba-business", (Object[])new Object[0]));
        }
        if (accountRecord.getAccountType() == 0L) {
            nameList.add(ResManager.loadKDString((String)"\u8d26\u6237\u7c7b\u578b", (String)"RebateServiceCheckHelper_4", (String)"occ-occba-business", (Object[])new Object[0]));
        }
        if (accountRecord.getCurrencyId() == 0L) {
            nameList.add(ResManager.loadKDString((String)"\u5e01\u522b", (String)"RebateServiceCheckHelper_5", (String)"occ-occba-business", (Object[])new Object[0]));
        }
        if (accountRecord.getChannelId() == 0L) {
            nameList.add(ResManager.loadKDString((String)"\u6e20\u9053", (String)"RebateServiceCheckHelper_6", (String)"occ-occba-business", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)accountRecord.getBillType()) && StringUtils.isEmpty((String)accountRecord.getBillEntity())) {
            nameList.add(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u7c7b\u578b", (String)"RebateServiceCheckHelper_7", (String)"occ-occba-business", (Object[])new Object[0]));
        }
        if (CollectionUtils.isNotEmpty(nameList)) {
            errMsg.append(StringUtils.join(nameList, (char)'\u3001')).append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a", (String)"RebateServiceCheckHelper_8", (String)"occ-occba-business", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)errMsg.toString())) {
            return String.format(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636eID\u4e3a[%1$s]\uff0c\u6765\u6e90\u5355\u636e\u5206\u5f55ID\u4e3a[%2$s]\uff1a%3$s\u3002", (String)"RebateServiceCheckHelper_9", (String)"occ-occba-business", (Object[])new Object[0]), accountRecord.getSourceBillId(), accountRecord.getSourceEntryId(), errMsg.toString());
        }
        return "";
    }
}

