/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.business.rebateservice;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class Lock {
    private static final Log logger = LogFactory.getLog(Lock.class);
    private static final long WAIT_TIME = 300L;
    private static final int MAX_TRY_LOCK_NUM = 10;
    private final List<String> successfulLockKeys = new LinkedList<String>();

    public void lock(String lockKey) {
        DLock reentrantLock = DLock.createReentrant((String)lockKey);
        reentrantLock.fastMode();
        reentrantLock.lock();
        this.successfulLockKeys.add(lockKey);
    }

    public boolean tryLock(String lockKey) {
        long createReeLockStartTime = System.currentTimeMillis();
        logger.info("\u8d44\u91d1\u6c60\u5206\u5e03\u5f0f\u9501\u521b\u5efa\u5f00\u59cbDLock.createReentrant Start\uff1a" + createReeLockStartTime + "({})", (Object)new Date(createReeLockStartTime));
        DLock reentrantLock = DLock.createReentrant((String)lockKey);
        reentrantLock.fastMode();
        logger.info("\u8d44\u91d1\u6c60\u5206\u5e03\u5f0f\u9501\u521b\u5efa\u5f00\u59cbDLock.createReentrant(lockKey)\uff1a{ } ", (Object)lockKey);
        long createReeLockEndTime = System.currentTimeMillis();
        logger.info("\u8d44\u91d1\u6c60\u5206\u5e03\u5f0f\u9501\u521b\u5efa\u5f00\u59cbDLock.createReentrant End\uff1a" + createReeLockEndTime + "({})", (Object)new Date(createReeLockEndTime));
        logger.info("\u8d44\u91d1\u6c60\u5206\u5e03\u5f0f\u9501\u521b\u5efa\u5f00\u59cbDLock.createReentrant \u8017\u65f6\uff1a {}  ms", (Object)(createReeLockEndTime - createReeLockStartTime));
        logger.info("\u8d44\u91d1\u6c60\u5c1d\u8bd5\u83b7\u53d6\u9501 reentrantLock.tryLock Start!");
        boolean getLockSuccess = false;
        for (int num = 0; num < 10; ++num) {
            logger.info("\u8d44\u91d1\u6c60\u5c1d\u8bd5\u83b7\u53d6\u9501 reentrantLock.tryLock \u7b2c{}\u6b21\uff1a", (Object)(num + 1));
            getLockSuccess = reentrantLock.tryLock(300L);
            if (getLockSuccess) {
                this.successfulLockKeys.add(lockKey);
                logger.info("\u8d44\u91d1\u6c60\u5c1d\u8bd5\u83b7\u53d6\u9501 reentrantLock.tryLock \u7b2c{}\u6b21 \u7ed3\u679c\uff1a \u6210\u529f\uff01", (Object)(num + 1));
                logger.info("\u8d44\u91d1\u6c60\u5c1d\u8bd5\u83b7\u53d6\u9501 reentrantLock.tryLock lockKey\uff1a{} ", (Object)lockKey);
                break;
            }
            logger.info("\u8d44\u91d1\u6c60\u5c1d\u8bd5\u83b7\u53d6\u9501 reentrantLock.tryLock \u7b2c{}\u6b21 \u7ed3\u679c\uff1a \u5931\u8d25\uff01", (Object)(num + 1));
        }
        long tryLockEndTime = System.currentTimeMillis();
        logger.info("\u8d44\u91d1\u6c60\u5206\u5e03\u5f0f\u9501\u521b\u5efa\u5f00\u59cbreentrantLock.tryLock End\uff1a" + tryLockEndTime + "({})", (Object)new Date(tryLockEndTime));
        return getLockSuccess;
    }

    public void unlockAll() {
        for (String lockKey : this.successfulLockKeys) {
            DLock reentrantLock = DLock.createReentrant((String)lockKey);
            reentrantLock.unlock();
            logger.info("\u8d44\u91d1\u6c60\u5206\u5e03\u5f0f\u9501\u9501\u91ca\u653elockKey\uff1a " + lockKey);
        }
    }

    public void unLock(String key) {
        DLock reentrantLock = DLock.createReentrant((String)key);
        reentrantLock.unlock();
    }

    public void close() {
        this.unlockAll();
        long closeTime = System.currentTimeMillis();
        logger.info("\u8d44\u91d1\u6c60\u5206\u5e03\u5f0f\u9501\u91ca\u653ecloseTime End\uff1a" + closeTime + "{}", (Object)new Date(closeTime));
    }
}

