/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.business.rebateservice;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.codec.DataType;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.occba.business.rebateservice.Lock;

public class RebateAccountServiceHelper {
    private static final Log logger = LogFactory.getLog(RebateAccountServiceHelper.class);

    public static List<Map<String, Object>> balanceUpdate(DynamicObject[] bills, String operationKey, Map<String, Object> params) {
        List<Map<String, Object>> results = new ArrayList<Map<String, Object>>(0);
        HashMap<String, Object> result = new HashMap<String, Object>(0);
        if (bills == null || bills.length == 0) {
            result.put("success", Boolean.FALSE);
            result.put("messagetype", "fail");
            results.add(result);
            return results;
        }
        result.put("success", Boolean.TRUE);
        result.put("messagetype", "success");
        result.put("billno", bills[0].getString("billno"));
        results.add(result);
        ArrayList<Long> billIds = new ArrayList<Long>(0);
        for (DynamicObject entity : bills) {
            billIds.add(entity.getLong("id"));
        }
        logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:\u5355\u636eId:" + StringUtils.join((Object[])billIds.toArray(), (String)","));
        results = RebateAccountServiceHelper.update(bills, operationKey, params);
        return results;
    }

    private static Map<String, Object> tryLock(String entityKey, String operateKey, DynamicObject balUpdateRule, List<Map<String, Object>> dataList, Lock lock, List<Map<String, Object>> resultList) {
        HashMap<String, Object> checkResult = null;
        String updateType = DynamicObjectUtils.getString((DynamicObject)balUpdateRule, (String)"updatetype");
        DynamicObjectCollection dimColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)balUpdateRule, (String)"dimdataentity");
        DynamicObjectCollection updateColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)balUpdateRule, (String)"updatedataentity");
        ArrayList<String> localKeys = new ArrayList<String>(0);
        for (Map<String, Object> dataRow : dataList) {
            Object dimension2;
            String billNo = CommonUtils.convertObjectToString((Object)dataRow.get("billno"));
            StringBuilder dimensionValue = new StringBuilder();
            for (Object dimension2 : dimColl) {
                String dimBillCol = DynamicObjectUtils.getString((DynamicObject)dimension2, (String)"dimbillcol");
                String dimValType = DynamicObjectUtils.getString((DynamicObject)dimension2, (String)"dimvaltype");
                if (StringUtils.equals((CharSequence)dimValType, (CharSequence)"0") || !dataRow.containsKey(dimBillCol)) continue;
                dimensionValue.append(dimBillCol).append(":").append(dataRow.get(dimBillCol)).append(";");
            }
            StringBuilder updateValue = new StringBuilder();
            dimension2 = updateColl.iterator();
            while (dimension2.hasNext()) {
                DynamicObject updateItem = (DynamicObject)dimension2.next();
                String updateBalCol = DynamicObjectUtils.getString((DynamicObject)updateItem, (String)"updatebalcol");
                String updateValType = DynamicObjectUtils.getString((DynamicObject)updateItem, (String)"updatevaltype");
                if (StringUtils.equals((CharSequence)updateValType, (CharSequence)"0") || !dataRow.containsKey(updateBalCol)) continue;
                updateValue.append(updateBalCol).append(":").append(dataRow.get(updateBalCol)).append(";");
            }
            String lockKey = dimensionValue.toString();
            if (!localKeys.contains(lockKey)) {
                if (!lock.tryLock(lockKey)) {
                    checkResult = new HashMap<String, Object>(0);
                    checkResult.put("success", false);
                    checkResult.put("billno", billNo);
                    String messageTemplate = ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u5e94\u7684\u8d44\u91d1\u6c60\u4f59\u989d\u5b58\u5728\u5e76\u53d1\u9501\uff08%1$s\uff09\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"RebateAccountServiceHelper_0", (String)"occ-occba-business", (Object[])new Object[0]);
                    checkResult.put("message", String.format(messageTemplate, lockKey));
                    logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:BalanceService.tryLock\u83b7\u53d6\u9501\u5931\u8d25: {}", (Object)messageTemplate);
                    logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:BalanceService.tryLock\u5b58\u5728\u5e76\u53d1\u9501\uff0c\u6392\u9664\u6b64\u5355\u66f4\u65b0\u8d44\u91d1\u6c60\u64cd\u4f5c--\u5355\u636e\u7c7b\u578b\uff1a{} , \u5355\u636e\u7f16\u53f7 \uff1a{} ", (Object)entityKey, (Object)billNo);
                    break;
                }
                logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:BalanceService.tryLock\u4e0d\u5b58\u5728\u5e76\u53d1\u9501\uff0c\u5355\u636e\u4fe1\u606f\u5982\u4e0b\uff1a");
                logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:\u5355\u636e\u7c7b\u578b\uff1a{} \uff0c\u5355\u636e\u7f16\u53f7\uff1a{} \uff0c\u64cd\u4f5c\uff1a{} \uff0c\u66f4\u65b0\u65b9\u5411\uff1a{} \uff0c\u672c\u6b21\u8d44\u91d1\u6c60\u66f4\u65b0\u6570\u636e\uff1a{} ", new Object[]{entityKey, billNo, operateKey, updateType, updateValue.toString()});
                logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:BalanceService.tryLock\u6784\u9020lockkey\u7528\u4e8e\u5224\u65ad\u662f\u5426\u5b58\u5728\u5e76\u53d1\u9501\uff0clockkey(billno:dimensionvalue) \uff1a {}:{}", (Object)billNo, (Object)lockKey);
                localKeys.add(lockKey);
            }
            resultList.add(dataRow);
        }
        return checkResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Map<String, Object>> update(DynamicObject[] bills, String operateKey, Map<String, Object> params) {
        long beginUpdateTime = System.currentTimeMillis();
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>(0);
        logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:update begin:" + beginUpdateTime);
        if (bills == null || bills.length == 0) {
            return results;
        }
        String entityKey = bills[0].getDataEntityType().getName();
        Lock lock = new Lock();
        try {
            if (params != null && !params.isEmpty()) {
                RebateAccountServiceHelper.updateRollbackEx(params);
            } else {
                HashSet<Long> billIds = new HashSet<Long>(0);
                HashSet<DynamicObject> billDatas = new HashSet<DynamicObject>(0);
                for (DynamicObject bill : bills) {
                    billDatas.add(bill);
                    billIds.add(DynamicObjectUtils.getPkValue((DynamicObject)bill));
                    if (billIds.size() != 3) continue;
                    logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3: update billIds: {}", (Object)StringUtils.join((Object[])billIds.toArray(), (String)","));
                    RebateAccountServiceHelper.update(entityKey, operateKey, billIds, billDatas, lock, results);
                    billIds.clear();
                    billDatas.clear();
                }
                if (billIds.size() > 0 && billDatas.size() > 0) {
                    logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3: update billIds: {}", (Object)StringUtils.join((Object[])billIds.toArray(), (String)","));
                    RebateAccountServiceHelper.update(entityKey, operateKey, billIds, billDatas, lock, results);
                }
            }
        }
        finally {
            lock.close();
            long closeUpdateTime = System.currentTimeMillis();
            logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3: update-- end \u8017\u65f6 \uff1a {} ms\u3002", (Object)(closeUpdateTime - beginUpdateTime));
        }
        return results;
    }

    private static void update(String entityKey, String operateKey, Set<Long> billIds, Set<DynamicObject> billDatas, Lock lock, List<Map<String, Object>> results) {
        try {
            long currentUpdateTime = System.currentTimeMillis();
            logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:\u83b7\u53d6\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u89c4\u5219 begin\uff1a{}", (Object)currentUpdateTime);
            List<DynamicObject> balUpdateRuleColl = RebateAccountServiceHelper.getBalUpdateRule(entityKey, operateKey);
            long closeUpdateTime = System.currentTimeMillis();
            logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:\u83b7\u53d6\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u89c4\u5219 end\uff1a{} \u8017\u65f6\uff1a{} ms", (Object)closeUpdateTime, (Object)(closeUpdateTime - currentUpdateTime));
            currentUpdateTime = System.currentTimeMillis();
            logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:\u83b7\u53d6\u66f4\u65b0\u8d44\u91d1\u6c60\u6d41\u6c34 begin\uff1a{}", (Object)currentUpdateTime);
            DynamicObjectCollection flowRecordColl = RebateAccountServiceHelper.getFlowRecordData(billIds, "", entityKey, 0L);
            closeUpdateTime = System.currentTimeMillis();
            logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:\u83b7\u53d6\u66f4\u65b0\u8d44\u91d1\u6c60\u6d41\u6c34 end\uff1a{} \u8017\u65f6\uff1a{} ms", (Object)closeUpdateTime, (Object)(closeUpdateTime - currentUpdateTime));
            HashMap<Long, Map<String, Map<String, String>>> hasFieldMap = new HashMap<Long, Map<String, Map<String, String>>>(0);
            currentUpdateTime = System.currentTimeMillis();
            logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:\u6309\u7167\u4f59\u989d\u66f4\u65b0\u89c4\u5219\u83b7\u53d6\u6e90\u5355\u6570\u636e begin\uff1a{}", (Object)currentUpdateTime);
            List<Map<String, Object>> resultList = RebateAccountServiceHelper.getDataList(billIds, billDatas.toArray(new DynamicObject[0]), entityKey, balUpdateRuleColl, flowRecordColl, operateKey, hasFieldMap, results);
            closeUpdateTime = System.currentTimeMillis();
            logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:\u6309\u7167\u4f59\u989d\u66f4\u65b0\u89c4\u5219\u83b7\u53d6\u6e90\u5355\u6570\u636e end\uff1a{} \u8017\u65f6\uff1a{} ms", (Object)closeUpdateTime, (Object)(closeUpdateTime - currentUpdateTime));
            if (resultList.size() == 0) {
                return;
            }
            String operateName = RebateAccountServiceHelper.getOperationItem(entityKey, operateKey);
            for (DynamicObject bill : billDatas) {
                long billId = DynamicObjectUtils.getPkValue((DynamicObject)bill);
                String billNo = DynamicObjectUtils.getString((DynamicObject)bill, (String)"billno");
                logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:\u5355\u636e\u7f16\u7801\uff1a%s,\u5355\u636eID:%d", billNo, billId));
                TXHandle handle = TX.requiresNew();
                Throwable throwable = null;
                try {
                    for (DynamicObject balUpdateRule : balUpdateRuleColl) {
                        long balUpdateRuleId = DynamicObjectUtils.getPkValue((DynamicObject)balUpdateRule);
                        String updateOpVal = DynamicObjectUtils.getString((DynamicObject)balUpdateRule, (String)"updateopval");
                        List<String> updateOps = Arrays.asList(updateOpVal.split(","));
                        String rollbackOpVal = DynamicObjectUtils.getString((DynamicObject)balUpdateRule, (String)"rollbackopval");
                        List<String> rollbackOps = Arrays.asList(rollbackOpVal.split(","));
                        List<Map<String, Object>> dataList = resultList.stream().filter(x -> CommonUtils.stringToLong(x.get("id")) == billId && CommonUtils.stringToLong(x.get("balupdateruleid")) == balUpdateRuleId).collect(Collectors.toList());
                        if (dataList.size() == 0) continue;
                        ArrayList<Map<String, Object>> dataResultList = new ArrayList<Map<String, Object>>(0);
                        currentUpdateTime = System.currentTimeMillis();
                        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%s update---tryLock begin : %s(%s)", billNo, currentUpdateTime, new Date(currentUpdateTime)));
                        Map<String, Object> checkResult = RebateAccountServiceHelper.tryLock(entityKey, operateKey, balUpdateRule, dataList, lock, dataResultList);
                        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%s update---tryLock end : %s", billNo, System.currentTimeMillis()));
                        if (checkResult != null) {
                            results.add(checkResult);
                            resultList.clear();
                            continue;
                        }
                        if (dataResultList.size() == 0) continue;
                        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"delete") && StringUtils.equals((CharSequence)rollbackOpVal, (CharSequence)"delete")) {
                            logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:\u8fdb\u5165\u5220\u9664\u56de\u6eda\u64cd\u4f5c");
                            boolean isSuccess = RebateAccountServiceHelper.deleteRollback(handle, entityKey, operateKey, operateName, billId, billNo, balUpdateRule, results);
                            logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:\u5220\u9664\u56de\u6eda\u64cd\u4f5c\u5b8c\u6210");
                            if (isSuccess) continue;
                            return;
                        }
                        boolean isUpdateOp = updateOps.contains(operateKey);
                        boolean isRollbackOp = rollbackOps.contains(operateKey);
                        if (!isUpdateOp && !isRollbackOp) continue;
                        List<DynamicObject> flowRecords = flowRecordColl.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"sourcebillid") == billId && updateOps.contains(DynamicObjectUtils.getString((DynamicObject)x, (String)"operation")) && DynamicObjectUtils.getString((DynamicObject)x, (String)"billentity").equals(entityKey) && DynamicObjectUtils.getLong((DynamicObject)x, (String)"balupdaterule") == balUpdateRuleId).collect(Collectors.toList());
                        boolean isSuccess = RebateAccountServiceHelper.updateRebateAccount(handle, entityKey, billId, billNo, dataResultList, flowRecords, hasFieldMap, operateKey, operateName, balUpdateRule, isUpdateOp, isRollbackOp, results);
                        if (isSuccess) continue;
                        return;
                    }
                    handle.commit();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (handle == null) continue;
                    if (throwable != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    handle.close();
                }
            }
        }
        catch (Exception ex) {
            logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:\u66f4\u65b0\u5f02\u5e38,\u5f02\u5e38\u6d88\u606f\uff1a{}", (Object)ex.getMessage());
        }
    }

    private static boolean updateRebateAccount(TXHandle handle, String entityKey, Long billId, String billNo, List<Map<String, Object>> dataResultList, List<DynamicObject> flowRecords, Map<Long, Map<String, Map<String, String>>> hasFieldMap, String operateKey, String operateName, DynamicObject balUpdateRule, boolean isUpdateOp, boolean isRollbackOp, List<Map<String, Object>> results) {
        try {
            List<Map<String, Object>> checkResults;
            long balUpdateRuleId = DynamicObjectUtils.getPkValue((DynamicObject)balUpdateRule);
            Map<String, Map<String, String>> hasFields = hasFieldMap.get(balUpdateRuleId);
            if (hasFields == null || hasFields.isEmpty()) {
                logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%s \u83b7\u53d6\u5b57\u6bb5\u914d\u7f6e\u5931\u8d25", billNo));
                return false;
            }
            Map hasDimFieldMap = hasFields.getOrDefault("hasdimfield", new HashMap(0));
            if (hasDimFieldMap.size() == 0) {
                logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%s hasdimfield\u83b7\u53d6\u7ef4\u5ea6\u5b57\u6bb5\u914d\u7f6e\u5931\u8d25", billNo));
                return false;
            }
            Map hasUpdateFieldMap = hasFields.getOrDefault("hasupdatefield", new HashMap(0));
            if (hasUpdateFieldMap.size() == 0) {
                logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%s hasupdatefield\u83b7\u53d6\u66f4\u65b0\u6570\u636e\u5b57\u6bb5\u914d\u7f6e\u5931\u8d25", billNo));
                return false;
            }
            Map hasFlowFieldMap = hasFields.getOrDefault("hasflowfield", new HashMap(0));
            if (hasFlowFieldMap.size() == 0) {
                logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%s hasflowfield\u83b7\u53d6\u6d41\u6c34\u5b57\u6bb5\u914d\u7f6e\u5931\u8d25", billNo));
                return false;
            }
            boolean autoReOpRollback = DynamicObjectUtils.getBoolean((DynamicObject)balUpdateRule, (String)"autoreoprollback");
            if (flowRecords != null && flowRecords.size() > 0 && (isRollbackOp || isUpdateOp && autoReOpRollback)) {
                Object[] flowRecordIds = flowRecords.stream().map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"id")).distinct().toArray();
                String updateType = isUpdateOp && autoReOpRollback ? "1" : "2";
                checkResults = RebateAccountServiceHelper.rollbackRebateAccount(entityKey, billId, billNo, balUpdateRule, flowRecordIds, isUpdateOp, updateType, operateKey, operateName);
                results.addAll(checkResults);
                if (checkResults.size() == 0 || checkResults.stream().anyMatch(x -> (Boolean)x.get("success") == false)) {
                    handle.markRollback();
                    return false;
                }
            }
            if (isUpdateOp) {
                checkResults = RebateAccountServiceHelper.saveRebateAccount(billId, entityKey, balUpdateRule, dataResultList, hasDimFieldMap, hasUpdateFieldMap, hasFlowFieldMap, operateKey, operateName);
                results.addAll(checkResults);
                if (checkResults.size() == 0 || checkResults.stream().anyMatch(x -> (Boolean)x.get("success") == false)) {
                    handle.markRollback();
                    return false;
                }
            }
        }
        catch (Exception ex) {
            HashMap<String, Object> result = new HashMap<String, Object>(0);
            result.put("success", false);
            result.put("billno", billNo);
            result.put("message", ex.getMessage());
            result.put("messagetype", "fail");
            results.add(result);
            logger.error(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%s update---updateRebateAccount catch error :%s", billNo, ex.getMessage()));
            handle.markRollback();
            return false;
        }
        return true;
    }

    private static void updateRollbackEx(Map<String, Object> params) {
        HashSet flowRecordIdSet = new HashSet(0);
        HashSet rollbackFlowRecordIdSet = new HashSet(0);
        if (params.containsKey("i_flowrecordids")) {
            Set flowRecordIds = (Set)params.get("i_flowrecordids");
            flowRecordIdSet.addAll(flowRecordIds);
        }
        if (params.containsKey("i_rollbackflowrecordids")) {
            Set rollbackFlowRecordIds = (Set)params.get("i_rollbackflowrecordids");
            rollbackFlowRecordIdSet.addAll(rollbackFlowRecordIds);
        }
        HashSet allFlowRecordId = new HashSet(0);
        allFlowRecordId.addAll(flowRecordIdSet);
        allFlowRecordId.addAll(rollbackFlowRecordIdSet);
        if (allFlowRecordId.size() > 0) {
            try (TXHandle handle = TX.requiresNew();){
                MainEntityType flowRecordType = EntityMetadataCache.getDataEntityType((String)"occba_flowrecord");
                DynamicObject[] flowRecordData = BusinessDataServiceHelper.load((Object[])allFlowRecordId.toArray(), (DynamicObjectType)flowRecordType);
                if (flowRecordData == null || flowRecordData.length == 0) {
                    return;
                }
                boolean isSuccess = RebateAccountServiceHelper.saveRollbackRebateAccountEx(flowRecordData);
                if (!isSuccess) {
                    handle.markRollback();
                    return;
                }
                QFilter qFilter = new QFilter("id", "in", (Object)flowRecordIdSet.toArray());
                DeleteServiceHelper.delete((String)"occba_flowrecord", (QFilter[])qFilter.toArray());
                DynamicObject[] rollbackFlowRecords = (DynamicObject[])Arrays.stream(flowRecordData).filter(x -> rollbackFlowRecordIdSet.contains(DynamicObjectUtils.getPkValue((DynamicObject)x))).distinct().toArray(DynamicObject[]::new);
                RebateAccountServiceHelper.saveFlowRecord(rollbackFlowRecords, "A");
                handle.commit();
            }
        }
    }

    private static boolean deleteRollback(TXHandle handle, String entityKey, String operateKey, String rollbackOpName, long billId, String billNo, DynamicObject balUpdateRule, List<Map<String, Object>> results) {
        try {
            long balUpdateRuleId = DynamicObjectUtils.getPkValue((DynamicObject)balUpdateRule);
            DynamicObjectCollection flowRecordColl = RebateAccountServiceHelper.getFlowRecordData(Collections.singleton(billId), null, entityKey, balUpdateRuleId);
            if (flowRecordColl != null && flowRecordColl.size() > 0) {
                logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:rollbackRebateAccount\u8fdb\u5165\u56de\u6eda\u5904\u7406");
                List<Map<String, Object>> checkResults = RebateAccountServiceHelper.rollbackRebateAccount(entityKey, billId, billNo, balUpdateRule, flowRecordColl, operateKey, rollbackOpName);
                if (checkResults.size() > 0 && checkResults.stream().anyMatch(x -> (Boolean)x.get("success") == false)) {
                    results.addAll(checkResults);
                    handle.markRollback();
                    return false;
                }
            }
        }
        catch (Exception ex) {
            HashMap<String, Object> result = new HashMap<String, Object>(0);
            result.put("success", false);
            result.put("billno", billNo);
            result.put("message", ex.getMessage());
            result.put("messagetype", "fail");
            results.add(result);
            logger.error(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%s update---deleteRollback catch error : %s", billNo, ex.getMessage()));
            handle.markRollback();
            return false;
        }
        return true;
    }

    private static List<Map<String, Object>> getDataList(Set<Long> billIds, DynamicObject[] bills, String entityKey, List<DynamicObject> balUpdateRuleColl, DynamicObjectCollection flowRecordColl, String operateKey, Map<Long, Map<String, Map<String, String>>> hasFieldMap, List<Map<String, Object>> results) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(0);
        String strBillId = StringUtils.join((Object[])billIds.toArray(), (String)",");
        for (DynamicObject balUpdateRule : balUpdateRuleColl) {
            try {
                boolean isRollbackOp;
                long balUpdateRuleId = DynamicObjectUtils.getPkValue((DynamicObject)balUpdateRule);
                String updateOpVal = DynamicObjectUtils.getString((DynamicObject)balUpdateRule, (String)"updateopval");
                List<String> updateOps = Arrays.asList(updateOpVal.split(","));
                String rollbackOpVal = DynamicObjectUtils.getString((DynamicObject)balUpdateRule, (String)"rollbackopval");
                List<String> rollbackOps = Arrays.asList(rollbackOpVal.split(","));
                if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"delete") && rollbackOps.contains("delete")) {
                    List<Map<String, Object>> dataList = RebateAccountServiceHelper.getBillData(balUpdateRule, bills, entityKey);
                    if (dataList.size() <= 0) continue;
                    resultList.addAll(dataList);
                    continue;
                }
                boolean isUpdateOp = updateOps.contains(operateKey);
                boolean bl = isRollbackOp = rollbackOps.contains(operateKey) || StringUtils.equals((CharSequence)"rollback", (CharSequence)operateKey);
                if (!isUpdateOp && !isRollbackOp) continue;
                boolean isRollback = !isUpdateOp;
                HashMap<String, String> hasDimFieldMap = new HashMap<String, String>(0);
                HashMap<String, String> hasUpdateFieldMap = new HashMap<String, String>(0);
                HashMap<String, String> hasUpdateFieldNameMap = new HashMap<String, String>(0);
                HashMap<String, String> hasFlowFieldMap = new HashMap<String, String>(0);
                HashMap<String, String> hasFlowFieldNameMap = new HashMap<String, String>(0);
                HashSet<Long> removeBillIds = new HashSet<Long>(0);
                if (isRollback) {
                    for (Long billId : billIds) {
                        boolean isUpdate = flowRecordColl.stream().anyMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"sourcebillid") == billId && updateOps.contains(DynamicObjectUtils.getString((DynamicObject)x, (String)"operation")));
                        if (isUpdate) continue;
                        removeBillIds.add(billId);
                    }
                }
                billIds.removeAll(removeBillIds);
                DataSet billData = RebateAccountServiceHelper.getBillData(balUpdateRule, operateKey, billIds, hasDimFieldMap, hasUpdateFieldMap, hasUpdateFieldNameMap, hasFlowFieldMap, hasFlowFieldNameMap, isRollback);
                HashMap<String, HashMap<String, String>> hasFields = new HashMap<String, HashMap<String, String>>(0);
                hasFields.put("hasdimfield", hasDimFieldMap);
                hasFields.put("hasupdatefield", hasUpdateFieldMap);
                hasFields.put("hasupdatefieldname", hasUpdateFieldNameMap);
                hasFields.put("hasflowfield", hasFlowFieldMap);
                hasFields.put("hasflowfieldname", hasFlowFieldNameMap);
                hasFieldMap.put(balUpdateRuleId, hasFields);
                if (billData == null || billData.isEmpty()) continue;
                List<Map<String, Object>> dataList = RebateAccountServiceHelper.getDataList(billData, balUpdateRuleId);
                resultList.addAll(dataList);
            }
            catch (Exception ex) {
                HashMap<String, Object> result = new HashMap<String, Object>(0);
                result.put("success", false);
                result.put("billno", strBillId);
                result.put("message", ex.getMessage());
                result.put("messagetype", "fail");
                results.add(result);
                logger.error(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%s update---getDataList catch error : %s", strBillId, ex.getMessage()));
            }
        }
        return resultList;
    }

    public static List<Map<String, Object>> rollbackRebateAccount(String entityKey, long billId, String billNo, DynamicObject balUpdateRule, Object[] flowRecordIds, boolean isUpdate, String updateType, String operateKey, String operateName) {
        List<Object> checkResults = new ArrayList(0);
        if (isUpdate) {
            operateName = String.format(ResManager.loadKDString((String)"%1$s\u56de\u6eda", (String)"RebateAccountServiceHelper_1", (String)"occ-occba-business", (Object[])new Object[0]), operateName);
        }
        try {
            DynamicObject[] flowRecordData = RebateAccountServiceHelper.loadFlowRecord(flowRecordIds);
            checkResults = RebateAccountServiceHelper.saveRollbackRebateAccount(entityKey, billId, balUpdateRule, flowRecordData, operateKey, operateName, updateType);
            if (checkResults.size() > 0 && checkResults.stream().anyMatch(x -> (Boolean)x.get("success"))) {
                RebateAccountServiceHelper.saveFlowRecord(flowRecordData, "B");
            }
        }
        catch (Exception ex) {
            HashMap<String, Object> result = new HashMap<String, Object>(0);
            result.put("success", false);
            result.put("billno", billNo);
            result.put("message", ex.getMessage());
            result.put("messagetype", "fail");
            logger.error("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3: update---rollbackRebateAccount catch error : " + ex.getMessage());
            checkResults.add(result);
        }
        return checkResults;
    }

    private static DynamicObject[] loadFlowRecord(Object[] flowRecordIds) {
        ArrayList<DynamicObject> flowRecords = new ArrayList<DynamicObject>(0);
        if (flowRecordIds == null || flowRecordIds.length == 0) {
            return flowRecords.toArray(new DynamicObject[0]);
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"occba_flowrecord");
        HashSet<Object> flowRecordIdSet = new HashSet<Object>(0);
        for (Object flowRecordId : flowRecordIds) {
            flowRecordIdSet.add(flowRecordId);
            if (flowRecordIdSet.size() != 5000) continue;
            DynamicObject[] flowRecordData = BusinessDataServiceHelper.load((Object[])flowRecordIdSet.toArray(), (DynamicObjectType)entityType);
            flowRecords.addAll(Arrays.asList(flowRecordData));
            flowRecordIdSet.clear();
        }
        if (flowRecordIdSet.size() > 0) {
            DynamicObject[] flowRecordData = BusinessDataServiceHelper.load((Object[])flowRecordIdSet.toArray(), (DynamicObjectType)entityType);
            flowRecords.addAll(Arrays.asList(flowRecordData));
        }
        return flowRecords.toArray(new DynamicObject[0]);
    }

    private static DynamicObjectCollection queryBalFlowType(Set<Long> balFlowTypeIds) {
        DynamicObjectCollection flowTypes = null;
        if (balFlowTypeIds.size() > 0) {
            String selectFields = "id,updatetrans,rollbackflowtype,rollbacktrans";
            QFilter qFilter = new QFilter("id", "in", balFlowTypeIds);
            flowTypes = QueryServiceHelper.query((String)"ocdbd_balflowtype", (String)selectFields, (QFilter[])qFilter.toArray());
        }
        return flowTypes;
    }

    private static List<Map<String, Object>> rollbackRebateAccount(String entityKey, long billId, String billNo, DynamicObject balUpdateRule, DynamicObjectCollection flowRecordColl, String operateKey, String operateName) {
        List<Object> checkResults = new ArrayList(0);
        try {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"occba_flowrecord");
            Object[] flowRecordIds = flowRecordColl.stream().map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"id")).distinct().toArray();
            DynamicObject[] flowRecordData = BusinessDataServiceHelper.load((Object[])flowRecordIds, (DynamicObjectType)entityType);
            logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:saveRollbackRebateAccount\u8fdb\u5165\u56de\u6eda\u5904\u7406");
            checkResults = RebateAccountServiceHelper.saveRollbackRebateAccount(entityKey, billId, balUpdateRule, flowRecordData, operateKey, operateName, "3");
            logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:saveRollbackRebateAccount\u56de\u6eda\u5904 \u7406\u5b8c\u6210" + CommonUtils.convertObjectToString(checkResults));
            if (checkResults.size() > 0 && checkResults.stream().anyMatch(x -> (Boolean)x.get("success"))) {
                logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:saveFlowRecord\u8fdb\u5165\u4fdd\u5b58\u6d41\u6c34\u5904\u7406");
                RebateAccountServiceHelper.saveFlowRecord(flowRecordData, "B");
            }
        }
        catch (Exception ex) {
            HashMap<String, Object> result = new HashMap<String, Object>(0);
            result.put("success", false);
            result.put("billno", billNo);
            result.put("message", ex.getMessage());
            result.put("messagetype", "fail");
            logger.error("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3: update---rollbackRebateAccount catch error : " + ex.getMessage());
            checkResults.add(result);
        }
        return checkResults;
    }

    private static DataSet getBillData(DynamicObject balUpdateRule, String operateKey, Set<Long> billIds, Map<String, String> hasDimFieldMap, Map<String, String> hasUpdateFieldMap, Map<String, String> hasUpdateFieldNameMap, Map<String, String> hasFlowFieldMap, Map<String, String> hasFlowFieldNameMap, boolean isRollback) {
        Object[] qFilters;
        long beginUpdateLockTime = System.currentTimeMillis();
        long balUpdateRuleId = DynamicObjectUtils.getPkValue((DynamicObject)balUpdateRule);
        String strBillIds = StringUtils.join((Object[])billIds.toArray(), (String)",");
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%s update lock begin time: %s", strBillIds, new Date(beginUpdateLockTime)));
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%s update loop rule id : %s -----\u672c\u6b21\u66f4\u65b0\u64cd\u4f5c :%s", strBillIds, balUpdateRuleId, operateKey));
        DynamicObject srcBill = DynamicObjectUtils.getDynamicObject((DynamicObject)balUpdateRule, (String)"srcbill");
        if (srcBill == null) {
            logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%s srcbill is null", strBillIds));
            return null;
        }
        String srcBillKey = srcBill.getString("id");
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%s \u83b7\u53d6\u6e90\u5355\u6807\u8bc6 : %s", strBillIds, srcBillKey));
        DynamicObject balObj = DynamicObjectUtils.getDynamicObject((DynamicObject)balUpdateRule, (String)"balobj");
        if (balObj == null) {
            logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3: balobj is null");
            return null;
        }
        String balObjKey = balObj.getString("id");
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3: \u83b7\u53d6\u4f59\u989d\u8868\u6807\u8bc6 : %s", balObjKey));
        String updateType = DynamicObjectUtils.getString((DynamicObject)balUpdateRule, (String)"updatetype");
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3: \u4f59\u989d\u66f4\u65b0\u89c4\u5219\u66f4\u65b0\u65b9\u5411 : %s", updateType));
        if (!isRollback) {
            String dataFilterFormula = DynamicObjectUtils.getString((DynamicObject)balUpdateRule, (String)"datafilterformula");
            QFilter dataFilter = RebateAccountServiceHelper.filterStringToQFilter(srcBillKey, dataFilterFormula);
            QFilter billIdQFilter = new QFilter("id", "in", billIds);
            qFilters = new QFilter[]{billIdQFilter, dataFilter};
        } else {
            QFilter billIdQFilter = new QFilter("id", "in", billIds);
            qFilters = new QFilter[]{billIdQFilter};
        }
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3: \u6570\u636e\u8fc7\u6ee4\u6761\u4ef6\uff1a%s", Arrays.toString(qFilters)));
        DynamicObjectCollection dimDataColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)balUpdateRule, (String)"dimdataentity");
        if (dimDataColl == null || dimDataColl.size() == 0) {
            logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%s \u7ef4\u5ea6\u6620\u5c04\u914d\u7f6e\u4e3a\u7a7a", strBillIds));
            return null;
        }
        MainEntityType srcEntity = MetadataServiceHelper.getDataEntityType((String)srcBillKey);
        StringBuilder dimFullColKeys = new StringBuilder();
        dimFullColKeys.append("id,billno");
        dimFullColKeys.append(",").append((CharSequence)RebateAccountServiceHelper.getDimensionConfig(srcEntity, dimDataColl, hasDimFieldMap));
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%s \u7ef4\u5ea6\u914d\u7f6e dimFullColKeys\uff1a%s", strBillIds, dimFullColKeys));
        DynamicObjectCollection updateDataColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)balUpdateRule, (String)"updatedataentity");
        if (updateDataColl == null || updateDataColl.size() == 0) {
            logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%s \u66f4\u65b0\u6570\u636e\u914d\u7f6e\u4e3a\u7a7a", strBillIds));
            return null;
        }
        String updateFullColKeys = RebateAccountServiceHelper.getUpdateFieldConfig(srcEntity, updateDataColl, hasUpdateFieldMap, hasUpdateFieldNameMap);
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%s \u66f4\u65b0\u6570\u636e\u914d\u7f6e updateFullColKeys\uff1a%s", strBillIds, updateFullColKeys));
        DynamicObjectCollection flowDataColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)balUpdateRule, (String)"flowdataentity");
        if (flowDataColl == null || flowDataColl.size() == 0) {
            logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%s \u6d41\u6c34\u6570\u636e\u914d\u7f6e\u4e3a\u7a7a", strBillIds));
            return null;
        }
        String flowFullColKeys = RebateAccountServiceHelper.getFlowFieldConfig(srcEntity, flowDataColl, hasFlowFieldMap, hasFlowFieldNameMap);
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%s \u6d41\u6c34\u6570\u636e\u914d\u7f6e updateFullColKeys\uff1a%s", strBillIds, updateFullColKeys));
        if (StringUtils.isNotEmpty((CharSequence)updateFullColKeys)) {
            dimFullColKeys.append(",").append(updateFullColKeys);
        }
        if (StringUtils.isNotEmpty((CharSequence)flowFullColKeys)) {
            dimFullColKeys.append(",").append(flowFullColKeys);
        }
        String fullColKeyStr = dimFullColKeys.toString();
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%s \u67e5\u8be2\u5b57\u6bb5 fullColKey\uff1a%s", fullColKeyStr, strBillIds));
        return QueryServiceHelper.queryDataSet((String)("algo_" + srcBillKey), (String)srcBillKey, (String)fullColKeyStr, (QFilter[])qFilters, (String)"");
    }

    private static StringBuilder getDimensionConfig(MainEntityType srcEntity, DynamicObjectCollection dimDataColl, Map<String, String> hasDimFieldMap) {
        StringBuilder dimFullColKeys = new StringBuilder();
        ArrayList<String> dimBillCols = new ArrayList<String>(0);
        for (DynamicObject dimData : dimDataColl) {
            String dimFixedValue;
            String dimValType = DynamicObjectUtils.getString((DynamicObject)dimData, (String)"dimvaltype");
            String dimBalCol = DynamicObjectUtils.getString((DynamicObject)dimData, (String)"dimbalcol");
            if (StringUtils.equals((CharSequence)dimValType, (CharSequence)"1")) {
                String colFullColKey;
                String dimBillCol = DynamicObjectUtils.getString((DynamicObject)dimData, (String)"dimbillcol");
                if (StringUtils.isEmpty((CharSequence)dimBalCol) || StringUtils.isEmpty((CharSequence)(colFullColKey = RebateAccountServiceHelper.getColFullColKey(srcEntity, dimBillCol)))) continue;
                hasDimFieldMap.put(dimBalCol, dimBillCol);
                if (dimBillCols.contains(dimBillCol)) continue;
                if (!dimBillCol.equals("id") && !dimBillCol.equals("billno")) {
                    if (StringUtils.isEmpty((CharSequence)dimFullColKeys)) {
                        dimFullColKeys.append(colFullColKey).append(" as ").append(dimBillCol);
                    } else {
                        dimFullColKeys.append(",").append(colFullColKey).append(" as ").append(dimBillCol);
                    }
                }
                dimBillCols.add(dimBillCol);
                continue;
            }
            if (!StringUtils.equals((CharSequence)dimValType, (CharSequence)"4") || StringUtils.isEmpty((CharSequence)(dimFixedValue = DynamicObjectUtils.getString((DynamicObject)dimData, (String)"dimfixedvalue")))) continue;
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)dimFixedValue, CRFormula.class);
            String expression = formula.getExpression();
            hasDimFieldMap.put(dimBalCol, dimBalCol);
            if (dimBillCols.contains(dimBalCol)) continue;
            if (StringUtils.isEmpty((CharSequence)dimFullColKeys)) {
                dimFullColKeys.append("'").append(expression).append("' as ").append(dimBalCol);
            } else {
                dimFullColKeys.append(",'").append(expression).append("' as ").append(dimBalCol);
            }
            dimBillCols.add(dimBalCol);
        }
        return dimFullColKeys;
    }

    private static String getUpdateFieldConfig(MainEntityType srcEntity, DynamicObjectCollection updateDataColl, Map<String, String> hasUpdateFieldMap, Map<String, String> hasUpdateFieldNameMap) {
        StringBuilder updateFullColKeys = new StringBuilder();
        ArrayList<String> updateBillCols = new ArrayList<String>(0);
        for (DynamicObject updateData : updateDataColl) {
            String updateValType = DynamicObjectUtils.getString((DynamicObject)updateData, (String)"updatevaltype");
            if (!StringUtils.equals((CharSequence)updateValType, (CharSequence)"1")) continue;
            String updateBalCol = DynamicObjectUtils.getString((DynamicObject)updateData, (String)"updatebalcol");
            String updateBalColName = DynamicObjectUtils.getString((DynamicObject)updateData, (String)"updatebalcolname");
            String updateBillCol = DynamicObjectUtils.getString((DynamicObject)updateData, (String)"updatebillcol");
            if (StringUtils.isEmpty((CharSequence)updateBalCol)) continue;
            hasUpdateFieldMap.put(updateBalCol, updateBillCol);
            hasUpdateFieldNameMap.put(updateBalCol, updateBalColName);
            if (updateBillCols.contains(updateBillCol)) continue;
            String colFullColKey = RebateAccountServiceHelper.getColFullColKey(srcEntity, updateBillCol);
            updateBillCols.add(updateBillCol);
            if (StringUtils.isEmpty((CharSequence)colFullColKey)) continue;
            if (StringUtils.isEmpty((CharSequence)updateFullColKeys)) {
                updateFullColKeys.append(colFullColKey).append(" as ").append(updateBillCol);
                continue;
            }
            updateFullColKeys.append(",").append(colFullColKey).append(" as ").append(updateBillCol);
        }
        return updateFullColKeys.toString();
    }

    private static String getFlowFieldConfig(MainEntityType srcEntity, DynamicObjectCollection flowDataColl, Map<String, String> hasFlowFieldMap, Map<String, String> hasFlowFieldNameMap) {
        StringBuilder flowFullColKeys = new StringBuilder();
        ArrayList<String> flowBillCols = new ArrayList<String>(0);
        for (DynamicObject flowData : flowDataColl) {
            String flowFixedValue;
            String colKey;
            String flowCol = DynamicObjectUtils.getString((DynamicObject)flowData, (String)"flowcol");
            String flowColName = DynamicObjectUtils.getString((DynamicObject)flowData, (String)"flowcolname");
            String flowBillCol = DynamicObjectUtils.getString((DynamicObject)flowData, (String)"flowbillcol");
            if (StringUtils.isEmpty((CharSequence)flowCol)) continue;
            hasFlowFieldNameMap.put(flowCol, flowColName);
            String flowValType = DynamicObjectUtils.getString((DynamicObject)flowData, (String)"flowvaltype");
            if (StringUtils.equals((CharSequence)flowValType, (CharSequence)"1")) {
                String colFullColKey = RebateAccountServiceHelper.getColFullColKey(srcEntity, flowBillCol);
                if (StringUtils.isEmpty((CharSequence)colFullColKey)) continue;
                if (StringUtils.isEmpty((CharSequence)flowFullColKeys)) {
                    if (StringUtils.equals((CharSequence)flowCol, (CharSequence)"entry")) {
                        colKey = flowCol + "_flow";
                        hasFlowFieldMap.put(flowCol, colKey);
                        if (flowBillCols.contains(colKey)) continue;
                        flowBillCols.add(colKey);
                        flowFullColKeys.append(colFullColKey).append(" as ").append(colKey);
                        continue;
                    }
                    if (StringUtils.isEmpty((CharSequence)flowBillCol)) continue;
                    colKey = flowBillCol + "_flow";
                    hasFlowFieldMap.put(flowCol, colKey);
                    if (flowBillCols.contains(colKey)) continue;
                    flowBillCols.add(colKey);
                    flowFullColKeys.append(colFullColKey).append(" as ").append(flowBillCol).append("_flow");
                    continue;
                }
                if (StringUtils.equals((CharSequence)flowCol, (CharSequence)"entry")) {
                    colKey = flowCol + "_flow";
                    hasFlowFieldMap.put(flowCol, colKey);
                    if (flowBillCols.contains(colKey)) continue;
                    flowBillCols.add(colKey);
                    flowFullColKeys.append(",").append(colFullColKey).append(" as ").append(flowCol).append("_flow");
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)flowBillCol)) continue;
                colKey = flowBillCol + "_flow";
                hasFlowFieldMap.put(flowCol, colKey);
                if (flowBillCols.contains(colKey)) continue;
                flowBillCols.add(colKey);
                flowFullColKeys.append(",").append(colFullColKey).append(" as ").append(colKey);
                continue;
            }
            if (!StringUtils.equals((CharSequence)flowValType, (CharSequence)"2") || StringUtils.isEmpty((CharSequence)(flowFixedValue = DynamicObjectUtils.getString((DynamicObject)flowData, (String)"flowfixedvalue")))) continue;
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)flowFixedValue, CRFormula.class);
            String expression = formula.getExpression();
            if (!StringUtils.equals((CharSequence)flowCol, (CharSequence)"balflowtype")) {
                colKey = flowCol + "_fixed";
                hasFlowFieldMap.put(flowCol, colKey);
                if (flowBillCols.contains(colKey)) continue;
                flowBillCols.add(colKey);
                if (StringUtils.isEmpty((CharSequence)flowFullColKeys)) {
                    flowFullColKeys.append("'").append(expression).append("' as ").append(colKey);
                    continue;
                }
                flowFullColKeys.append(",'").append(expression).append("' as ").append(colKey);
                continue;
            }
            hasFlowFieldMap.put(flowCol, flowCol);
            if (flowBillCols.contains(flowCol)) continue;
            flowBillCols.add(flowCol);
            if (StringUtils.isEmpty((CharSequence)flowFullColKeys)) {
                flowFullColKeys.append("'").append(expression).append("' as ").append(flowCol);
                continue;
            }
            flowFullColKeys.append(",'").append(expression).append("' as ").append(flowCol);
        }
        return flowFullColKeys.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static List<Map<String, Object>> saveRebateAccount(long billId, String entityKey, DynamicObject balUpdateRule, List<Map<String, Object>> resultList, Map<String, String> hasDimFieldMap, Map<String, String> hasUpdateFieldMap, Map<String, String> hasFlowFieldMap, String operateKey, String operateName) {
        ArrayList<Map<String, Object>> checkResults = new ArrayList<Map<String, Object>>(0);
        long balUpdateRuleId = DynamicObjectUtils.getPkValue((DynamicObject)balUpdateRule);
        String updateType = DynamicObjectUtils.getString((DynamicObject)balUpdateRule, (String)"updatetype");
        String negativeCtrl = DynamicObjectUtils.getString((DynamicObject)balUpdateRule, (String)"negativectrl");
        HashMap<String, Long> rebateAccountIdMap = new HashMap<String, Long>(0);
        ArrayList<DynamicObject> rebateAccountList = new ArrayList<DynamicObject>(0);
        ArrayList<DynamicObject> rebateStatementList = new ArrayList<DynamicObject>(0);
        HashMap<String, DynamicObject> rebateAccountMap = new HashMap<String, DynamicObject>(0);
        ArrayList<DynamicObject> saveFlowRecordList = new ArrayList<DynamicObject>(0);
        long beginUpdateTime = System.currentTimeMillis();
        HashSet<Long> balFlowTypeIds = new HashSet<Long>(0);
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%d \u6309\u7ef4\u5ea6\u5339\u914d\u8d44\u91d1\u6c60 begin:%d", billId, beginUpdateTime));
        for (Map<String, Object> dataRow : resultList) {
            DynamicObject rebateAccount;
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(0);
            String rebateAccountType = "";
            if (hasDimFieldMap.containsKey("type")) {
                String srcFieldKey = hasDimFieldMap.get("type");
                rebateAccountType = CommonUtils.convertObjectToString((Object)dataRow.get(srcFieldKey));
            }
            for (Map.Entry entry : hasDimFieldMap.entrySet()) {
                String balFieldKey = (String)entry.getKey();
                String srcFieldKey = (String)entry.getValue();
                if (rebateAccountType.equals("A") && balFieldKey.equals("receivechannel") || rebateAccountType.equals("B") && (balFieldKey.equals("org") || balFieldKey.equals("customer"))) continue;
                QFilter qFilter = new QFilter(balFieldKey, "=", dataRow.get(srcFieldKey));
                String dimValue = CommonUtils.convertObjectToString((Object)dataRow.get(srcFieldKey));
                if (StringUtils.isEmpty((CharSequence)dimValue) || StringUtils.equals((CharSequence)dimValue, (CharSequence)"0")) {
                    qFilter.or(balFieldKey, "is null", null);
                }
                qFilters.add(qFilter);
            }
            long balFlowTypeId = CommonUtils.stringToLong((Object)dataRow.get("balflowtype"));
            balFlowTypeIds.add(balFlowTypeId);
            String filterKey = ((Object)qFilters).toString();
            if (rebateAccountIdMap.containsKey(filterKey) || (rebateAccount = QueryServiceHelper.queryOne((String)"ocdbd_rebateaccount", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]))) == null) continue;
            long rebateAccountId = DynamicObjectUtils.getLong((DynamicObject)rebateAccount, (String)"id");
            rebateAccountIdMap.put(filterKey, rebateAccountId);
        }
        long closeUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%d \u6309\u7ef4\u5ea6\u5339\u914d\u8d44\u91d1\u6c60 end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
        beginUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%d load\u8d44\u91d1\u6c60 begin:%d", billId, beginUpdateTime));
        if (rebateAccountIdMap.size() > 0) {
            MainEntityType rebateAccountType = EntityMetadataCache.getDataEntityType((String)"ocdbd_rebateaccount");
            DynamicObject[] rebateAccounts = BusinessDataServiceHelper.load((Object[])rebateAccountIdMap.values().toArray(), (DynamicObjectType)rebateAccountType);
            rebateAccountList.addAll(Arrays.asList(rebateAccounts));
        }
        closeUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%d load\u8d44\u91d1\u6c60 end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
        beginUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%d query\u6d41\u6c34\u7c7b\u578b begin:%d", billId, beginUpdateTime));
        DynamicObjectCollection flowTypes = RebateAccountServiceHelper.queryBalFlowType(balFlowTypeIds);
        closeUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%d query\u6d41\u6c34\u7c7b\u578b end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
        beginUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%d \u66f4\u65b0\u8d44\u91d1\u6c60 begin:%d", billId, beginUpdateTime));
        for (Map<String, Object> dataRow : resultList) {
            String billNo;
            Map<String, Object> checkResult;
            DynamicObject rebateAccount;
            void var28_33;
            String string = "";
            if (hasDimFieldMap.containsKey("type")) {
                String srcFieldKey = hasDimFieldMap.get("type");
                String string2 = CommonUtils.convertObjectToString((Object)dataRow.get(srcFieldKey));
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(0);
            for (Map.Entry<String, String> dimField : hasDimFieldMap.entrySet()) {
                String balFieldKey = dimField.getKey();
                String srcFieldKey = dimField.getValue();
                if (var28_33.equals("A") && balFieldKey.equals("receivechannel") || var28_33.equals("B") && (balFieldKey.equals("org") || balFieldKey.equals("customer"))) continue;
                QFilter qFilter = new QFilter(balFieldKey, "=", dataRow.get(srcFieldKey));
                String dimValue = CommonUtils.convertObjectToString((Object)dataRow.get(srcFieldKey));
                if (StringUtils.isEmpty((CharSequence)dimValue) || StringUtils.equals((CharSequence)dimValue, (CharSequence)"0")) {
                    qFilter.or(balFieldKey, "is null", null);
                }
                qFilters.add(qFilter);
            }
            boolean bIsNew = false;
            String filterKey = ((Object)qFilters).toString();
            if (rebateAccountMap.containsKey(filterKey)) {
                rebateAccount = (DynamicObject)rebateAccountMap.get(filterKey);
            } else if (rebateAccountIdMap.get(filterKey) == null) {
                rebateAccount = BusinessDataServiceHelper.newDynamicObject((String)"ocdbd_rebateaccount");
                rebateAccount.set("number", (Object)RebateAccountServiceHelper.getRebateAccountCode());
                for (Map.Entry entry : hasDimFieldMap.entrySet()) {
                    String balFieldKey = (String)entry.getKey();
                    String srcFieldKey = (String)entry.getValue();
                    if (var28_33.equals("A") && balFieldKey.equals("receivechannel") || var28_33.equals("B") && (balFieldKey.equals("org") || balFieldKey.equals("customer"))) continue;
                    Object dimValue = dataRow.get(srcFieldKey);
                    rebateAccount.set(balFieldKey, dimValue);
                }
                bIsNew = true;
            } else {
                long rebateAccountId = (Long)rebateAccountIdMap.get(filterKey);
                rebateAccount = rebateAccountList.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == rebateAccountId).findFirst().orElse(null);
            }
            if (rebateAccount == null) continue;
            JSONObject amountValue = new JSONObject();
            BigDecimal bigDecimal = DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)"balance");
            RebateAccountServiceHelper.getRebateAccount(dataRow, hasDimFieldMap, hasUpdateFieldMap, rebateAccount, updateType, amountValue);
            BigDecimal afterAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)"balance");
            if (StringUtils.equals((CharSequence)negativeCtrl, (CharSequence)"1") && (checkResult = RebateAccountServiceHelper.checkRebateAccount(rebateAccount, billNo = CommonUtils.convertObjectToString((Object)dataRow.get("billno")))) != null) {
                checkResults.add(checkResult);
                break;
            }
            if (bIsNew) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rebateAccount});
            }
            long rebateAccountId = DynamicObjectUtils.getPkValue((DynamicObject)rebateAccount);
            DynamicObject flowRecord = RebateAccountServiceHelper.getFlowRecord(dataRow, balUpdateRuleId, rebateAccountId, hasFlowFieldMap, operateKey, operateName, bigDecimal, afterAmount, amountValue, flowTypes);
            saveFlowRecordList.add(flowRecord);
            DynamicObject rebateStatement = RebateAccountServiceHelper.writeOffRebateStatement(rebateAccount, entityKey, billId);
            if (rebateStatement != null) {
                rebateStatementList.add(rebateStatement);
            }
            rebateAccountMap.put(filterKey, rebateAccount);
        }
        closeUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%d \u66f4\u65b0\u8d44\u91d1\u6c60 end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
        if (rebateAccountMap.size() > 0) {
            beginUpdateTime = System.currentTimeMillis();
            logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%d \u4fdd\u5b58\u8d44\u91d1\u6c60\u4f59\u989d begin:%d", billId, beginUpdateTime));
            SaveServiceHelper.update((DynamicObject[])rebateAccountMap.values().toArray(new DynamicObject[0]));
            closeUpdateTime = System.currentTimeMillis();
            logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%d \u4fdd\u5b58\u8d44\u91d1\u6c60\u4f59\u989d end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
            if (rebateStatementList.size() > 0) {
                beginUpdateTime = System.currentTimeMillis();
                logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%d \u53cd\u5199\u8fd4\u5229\u8ba1\u7b97\u5355 begin:%d", billId, beginUpdateTime));
                SaveServiceHelper.update((DynamicObject[])rebateStatementList.toArray(new DynamicObject[0]));
                closeUpdateTime = System.currentTimeMillis();
                logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%d \u53cd\u5199\u8fd4\u5229\u8ba1\u7b97\u5355 end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
            }
            beginUpdateTime = System.currentTimeMillis();
            logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%d \u4fdd\u5b58\u8d44\u91d1\u6c60\u6d41\u6c34 begin:%d", billId, beginUpdateTime));
            beginUpdateTime = System.currentTimeMillis();
            SaveServiceHelper.save((DynamicObject[])saveFlowRecordList.toArray(new DynamicObject[0]));
            closeUpdateTime = System.currentTimeMillis();
            logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%d \u4fdd\u5b58\u8d44\u91d1\u6c60\u6d41\u6c34 end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
            for (DynamicObject flowRecord : saveFlowRecordList) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>(0);
                hashMap.put("success", true);
                hashMap.put("messagetype", "success");
                hashMap.put("message", ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"RebateAccountServiceHelper_2", (String)"occ-occba-business", (Object[])new Object[0]));
                hashMap.put("rebateaccountid", DynamicObjectUtils.getPkValue((DynamicObject)flowRecord, (String)"rebateaccount"));
                hashMap.put("flowtype", "new");
                hashMap.put("flowrecordid", DynamicObjectUtils.getPkValue((DynamicObject)flowRecord));
                checkResults.add(hashMap);
            }
        }
        return checkResults;
    }

    private static DynamicObject writeOffRebateStatement(DynamicObject rebateAccount, String entityKey, long billId) {
        DynamicObject rebateStatement = null;
        long beginUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%d \u53cd\u5199\u8fd4\u5229\u7ed3\u7b97\u5355 begin:%d", billId, beginUpdateTime));
        try {
            DynamicObject entryItem;
            DynamicObjectCollection entryEntity;
            String sourceBill = "";
            logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%d \u53cd\u5199\u8fd4\u5229\u7ed3\u7b97\u5355 \u89e3\u6790\u524dsourcebill:%s", billId, rebateAccount.get("sourcebill") != null ? rebateAccount.get("sourcebill").toString() : null));
            if (entityKey.equals("occpic_rebatestatement") || rebateAccount.get("sourcebill") == null) {
                return null;
            }
            if (rebateAccount.get("sourcebill") instanceof DynamicObject) {
                DynamicObject sourceBillObj = DynamicObjectUtils.getDynamicObject((DynamicObject)rebateAccount, (String)"sourcebill");
                if (sourceBillObj != null) {
                    sourceBill = CommonUtils.convertObjectToString((Object)sourceBillObj.getPkValue());
                }
            } else {
                sourceBill = CommonUtils.convertObjectToString((Object)rebateAccount.get("sourcebill"));
            }
            logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%d \u53cd\u5199\u8fd4\u5229\u7ed3\u7b97\u5355 \u89e3\u6790\u540esourcebill:%s", billId, sourceBill));
            long sourceBillId = DynamicObjectUtils.getLong((DynamicObject)rebateAccount, (String)"sourcebillid");
            long sourceEntryId = DynamicObjectUtils.getLong((DynamicObject)rebateAccount, (String)"sourceentryid");
            if (sourceBill.equals("occpic_rebatestatement") && sourceBillId > 0L && sourceEntryId > 0L && (entryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)(rebateStatement = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"occpic_rebatestatement")), (String)"entryentity")) != null && (entryItem = (DynamicObject)entryEntity.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == sourceEntryId).findFirst().orElse(null)) != null) {
                entryItem.set("availablebalance", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)"availablebalance"));
                entryItem.set("occupyamount", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)"occupyamount"));
                entryItem.set("hasbudgetamount", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"rebateamount").subtract(DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)"balance")));
            }
        }
        catch (Exception ex) {
            logger.error(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:\u53cd\u5199\u8fd4\u5229\u7ed3\u7b97\u5355\u5931\u8d25\uff0c\u8d44\u91d1\u6c60\uff1a%s,\u5931\u8d25\u539f\u56e0:%s", DynamicObjectUtils.getString((DynamicObject)rebateAccount, (String)"number"), ex.getMessage()));
        }
        long closeUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%d \u53cd\u5199\u8fd4\u5229\u7ed3\u7b97\u5355 end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
        return rebateStatement;
    }

    private static void getRebateAccount(Map<String, Object> dataRow, Map<String, String> hasDimFieldMap, Map<String, String> hasUpdateFieldMap, DynamicObject rebateAccount, String updateType, JSONObject amountValue) {
        for (Map.Entry<String, String> entry : hasDimFieldMap.entrySet()) {
            String string = entry.getKey();
            String srcFieldKey = entry.getValue();
            rebateAccount.set(string, dataRow.get(srcFieldKey));
        }
        for (Map.Entry<String, String> entry : hasUpdateFieldMap.entrySet()) {
            BigDecimal value;
            String balFieldKey = entry.getKey();
            String srcFieldKey = entry.getValue();
            BigDecimal balValue = DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)balFieldKey);
            BigDecimal updateValue = BigDecimal.ZERO;
            if (dataRow.get(srcFieldKey) != null) {
                updateValue = (BigDecimal)dataRow.get(srcFieldKey);
            }
            if (StringUtils.equals((CharSequence)updateType, (CharSequence)"0")) {
                value = balValue.add(updateValue);
                amountValue.put(balFieldKey, (Object)updateValue);
            } else {
                value = balValue.subtract(updateValue);
                amountValue.put(balFieldKey, (Object)BigDecimal.ZERO.subtract(updateValue));
            }
            rebateAccount.set(balFieldKey, (Object)value);
        }
        BigDecimal bigDecimal = DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)"balance");
        BigDecimal bigDecimal2 = DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)"occupyamount");
        rebateAccount.set("availablebalance", (Object)bigDecimal.subtract(bigDecimal2));
        rebateAccount.set("updatedatetime", (Object)TimeServiceHelper.now());
    }

    private static DynamicObject getFlowRecord(Map<String, Object> dataRow, long balUpdateRuleId, long rebateAccountId, Map<String, String> hasFlowFieldMap, String operateKey, String operateName, BigDecimal beforeAmount, BigDecimal afterAmount, JSONObject amountValue, DynamicObjectCollection flowTypes) {
        DynamicObject flowType;
        DynamicObject flowRecord = BusinessDataServiceHelper.newDynamicObject((String)"occba_flowrecord");
        flowRecord.set("balupdaterule", (Object)balUpdateRuleId);
        for (Map.Entry<String, String> flowField : hasFlowFieldMap.entrySet()) {
            String flowFieldKey = flowField.getKey();
            String srcFieldKey = flowField.getValue();
            Object flowValue = dataRow.get(srcFieldKey);
            flowRecord.set(flowFieldKey, flowValue);
        }
        flowRecord.set("beforeamount", (Object)beforeAmount);
        flowRecord.set("afteramount", (Object)afterAmount);
        flowRecord.set("amountvalue", (Object)amountValue.toJSONString());
        flowRecord.set("createtime", (Object)TimeServiceHelper.now());
        flowRecord.set("creator", (Object)RequestContext.get().getCurrUserId());
        long balFlowTypeId = CommonUtils.stringToLong((Object)dataRow.get("balflowtype"));
        if (balFlowTypeId > 0L && flowTypes != null && (flowType = (DynamicObject)flowTypes.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"id") == balFlowTypeId).findFirst().orElse(null)) != null) {
            Object updateTrans = flowType.get("updatetrans");
            flowRecord.set("transaction", updateTrans);
        }
        flowRecord.set("flowstatus", (Object)"A");
        flowRecord.set("operation", (Object)operateKey);
        flowRecord.set("operationname", (Object)operateName);
        flowRecord.set("rebateaccount", (Object)rebateAccountId);
        return flowRecord;
    }

    private static DynamicObject getFlowRecord(DynamicObject originFlowRecord, long rebateAccountId, String operateKey, String operateName, BigDecimal beforeAmount, BigDecimal afterAmount, JSONObject newAmountValue, DynamicObjectCollection flowTypes) {
        DynamicObject flowType;
        DynamicObject flowRecord = BusinessDataServiceHelper.newDynamicObject((String)"occba_flowrecord");
        DataEntityPropertyCollection flowProperties = flowRecord.getDynamicObjectType().getProperties();
        for (IDataEntityProperty flowProperty : flowProperties) {
            String colKey = flowProperty.getName();
            if (StringUtils.equals((CharSequence)colKey, (CharSequence)"id")) continue;
            flowRecord.set(colKey, originFlowRecord.get(colKey));
        }
        flowRecord.set("beforeamount", (Object)beforeAmount);
        flowRecord.set("afteramount", (Object)afterAmount);
        flowRecord.set("amountvalue", (Object)newAmountValue.toJSONString());
        flowRecord.set("createtime", (Object)TimeServiceHelper.now());
        flowRecord.set("creator", (Object)RequestContext.get().getCurrUserId());
        long balFlowTypeId = DynamicObjectUtils.getPkValue((DynamicObject)originFlowRecord, (String)"balflowtype");
        if (balFlowTypeId > 0L && flowTypes != null && (flowType = (DynamicObject)flowTypes.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"id") == balFlowTypeId).findFirst().orElse(null)) != null) {
            Object rollbackTrans = flowType.get("rollbacktrans");
            Long rollbackFlowTypeId = (Long)flowType.get("rollbackflowtype");
            if (rollbackFlowTypeId > 0L) {
                flowRecord.set("balflowtype", (Object)rollbackFlowTypeId);
            }
            flowRecord.set("transaction", rollbackTrans);
            BigDecimal changeAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)flowRecord, (String)"changeamount");
            flowRecord.set("changeamount", (Object)changeAmount.multiply(new BigDecimal(-1)));
        }
        flowRecord.set("flowstatus", (Object)"B");
        flowRecord.set("operation", (Object)operateKey);
        flowRecord.set("operationname", (Object)operateName);
        flowRecord.set("rebateaccount", (Object)rebateAccountId);
        return flowRecord;
    }

    private static List<Map<String, Object>> saveRollbackRebateAccount(String entityKey, long billId, DynamicObject balUpdateRule, DynamicObject[] flowRecordData, String operateKey, String operateName, String updateType) {
        long beginRollbackTime = System.currentTimeMillis();
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3-\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d begin:%d", billId, beginRollbackTime));
        ArrayList<Map<String, Object>> checkResults = new ArrayList<Map<String, Object>>(0);
        String negativeCtrl = DynamicObjectUtils.getString((DynamicObject)balUpdateRule, (String)"negativectrl");
        HashSet<Long> rebateAccountIds = new HashSet<Long>(0);
        HashSet<Long> balFlowTypeIds = new HashSet<Long>(0);
        for (DynamicObject flowRecordItem : flowRecordData) {
            long rebateAccountId = DynamicObjectUtils.getPkValue((DynamicObject)flowRecordItem, (String)"rebateaccount");
            rebateAccountIds.add(rebateAccountId);
            long balFlowTypeId = DynamicObjectUtils.getPkValue((DynamicObject)flowRecordItem, (String)"balflowtype");
            balFlowTypeIds.add(balFlowTypeId);
        }
        long beginUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3-\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d load\u8d44\u91d1\u6c60\u4f59\u989d begin:%d", billId, beginUpdateTime));
        ArrayList<DynamicObject> rebateAccountList = new ArrayList<DynamicObject>(0);
        if (rebateAccountIds.size() > 0) {
            MainEntityType rebateAccountType = EntityMetadataCache.getDataEntityType((String)"ocdbd_rebateaccount");
            DynamicObject[] rebateAccounts = BusinessDataServiceHelper.load((Object[])rebateAccountIds.toArray(), (DynamicObjectType)rebateAccountType);
            rebateAccountList.addAll(Arrays.asList(rebateAccounts));
        }
        long closeUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3-\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d load\u8d44\u91d1\u6c60\u4f59\u989d end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
        beginUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3-\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d query\u8d44\u91d1\u6c60\u6d41\u6c34\u7c7b\u578b begin:%d", billId, beginUpdateTime));
        DynamicObjectCollection flowTypes = RebateAccountServiceHelper.queryBalFlowType(balFlowTypeIds);
        closeUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3-\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d query\u8d44\u91d1\u6c60\u6d41\u6c34\u7c7b\u578b end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
        beginUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3-\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d \u66f4\u65b0\u8d44\u91d1\u6c60 begin:%d", billId, beginUpdateTime));
        ArrayList<DynamicObject> flowRecordList = new ArrayList<DynamicObject>(0);
        ArrayList<DynamicObject> rebateStatementList = new ArrayList<DynamicObject>(0);
        DynamicObjectCollection updateEntryColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)balUpdateRule, (String)"updatedataentity");
        for (DynamicObject flowRecordItem : flowRecordData) {
            Map<String, Object> checkResult;
            long rebateAccountId = DynamicObjectUtils.getPkValue((DynamicObject)flowRecordItem, (String)"rebateaccount");
            DynamicObject rebateAccount = rebateAccountList.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == rebateAccountId).findFirst().orElse(null);
            if (rebateAccount == null) {
                return checkResults;
            }
            DataEntityPropertyCollection properties = rebateAccount.getDynamicObjectType().getProperties();
            BigDecimal beforeAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)"balance");
            String amountValueStr = DynamicObjectUtils.getString((DynamicObject)flowRecordItem, (String)"amountvalue");
            JSONObject amountValue = JSONObject.parseObject((String)amountValueStr);
            JSONObject newAmountValue = new JSONObject();
            if (amountValue == null || amountValue.isEmpty()) continue;
            for (String amountKey : amountValue.keySet()) {
                boolean isRollback;
                DynamicObject updateEntry;
                if (!properties.containsKey((Object)amountKey)) continue;
                if (updateType.equals("2") && (updateEntry = (DynamicObject)updateEntryColl.stream().filter(x -> amountKey.equals(DynamicObjectUtils.getString((DynamicObject)x, (String)"updatebalcol"))).findFirst().orElse(null)) != null && !(isRollback = DynamicObjectUtils.getBoolean((DynamicObject)updateEntry, (String)"isrollback"))) {
                    logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3-\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d %s\u4e0d\u652f\u6301\u56de\u6eda", billId, amountKey));
                    continue;
                }
                BigDecimal amount = DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)amountKey);
                BigDecimal updateAmount = new BigDecimal(CommonUtils.convertObjectToString((Object)amountValue.get((Object)amountKey)));
                if (updateAmount.compareTo(BigDecimal.ZERO) >= 0) {
                    rebateAccount.set(amountKey, (Object)amount.subtract(updateAmount.abs()));
                    newAmountValue.put(amountKey, (Object)BigDecimal.ZERO.subtract(updateAmount.abs()));
                    continue;
                }
                rebateAccount.set(amountKey, (Object)amount.add(updateAmount.abs()));
                newAmountValue.put(amountKey, (Object)updateAmount.abs());
            }
            if (newAmountValue.isEmpty()) continue;
            BigDecimal balance = DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)"balance");
            BigDecimal occupyAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)"occupyamount");
            rebateAccount.set("availablebalance", (Object)balance.subtract(occupyAmount));
            BigDecimal afterAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)"balance");
            rebateAccount.set("updatedatetime", (Object)TimeServiceHelper.now());
            if (StringUtils.equals((CharSequence)negativeCtrl, (CharSequence)"1") && (checkResult = RebateAccountServiceHelper.checkRebateAccount(rebateAccount, DynamicObjectUtils.getString((DynamicObject)flowRecordItem, (String)"sourcebillno"))) != null) {
                checkResults.add(checkResult);
                continue;
            }
            DynamicObject flowRecord = RebateAccountServiceHelper.getFlowRecord(flowRecordItem, rebateAccountId, operateKey, operateName, beforeAmount, afterAmount, newAmountValue, flowTypes);
            flowRecordList.add(flowRecord);
            DynamicObject rebateStatement = RebateAccountServiceHelper.writeOffRebateStatement(rebateAccount, entityKey, billId);
            if (rebateStatement == null) continue;
            rebateStatementList.add(rebateStatement);
        }
        closeUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3-\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d \u66f4\u65b0\u8d44\u91d1\u6c60 end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
        if (rebateAccountList.size() > 0) {
            beginUpdateTime = System.currentTimeMillis();
            logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3-\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d \u4fdd\u5b58\u8d44\u91d1\u6c60\u4f59\u989d begin:%d", billId, beginUpdateTime));
            SaveServiceHelper.update((DynamicObject[])rebateAccountList.toArray(new DynamicObject[0]));
            closeUpdateTime = System.currentTimeMillis();
            logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3-\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d \u4fdd\u5b58\u8d44\u91d1\u6c60\u4f59\u989d end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
            if (rebateStatementList.size() > 0) {
                beginUpdateTime = System.currentTimeMillis();
                logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3-\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d \u53cd\u5199\u8fd4\u5229\u8ba1\u7b97\u5355 begin:%d", billId, beginUpdateTime));
                SaveServiceHelper.update((DynamicObject[])rebateStatementList.toArray(new DynamicObject[0]));
                closeUpdateTime = System.currentTimeMillis();
                logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3-\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d \u53cd\u5199\u8fd4\u5229\u8ba1\u7b97\u5355 end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
            }
            beginUpdateTime = System.currentTimeMillis();
            logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3-\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d \u4fdd\u5b58\u8d44\u91d1\u6c60\u6d41\u6c34 begin:%d", billId, beginUpdateTime));
            SaveServiceHelper.save((DynamicObject[])flowRecordList.toArray(new DynamicObject[0]));
            closeUpdateTime = System.currentTimeMillis();
            logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3-\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d \u4fdd\u5b58\u8d44\u91d1\u6c60\u6d41\u6c34 end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
            for (DynamicObject flowRecord : flowRecordList) {
                HashMap<String, Object> result = new HashMap<String, Object>(0);
                long rollbackFlowRecordId = 0L;
                long rebateAccountId = DynamicObjectUtils.getPkValue((DynamicObject)flowRecord, (String)"rebateaccount");
                long entryId = DynamicObjectUtils.getLong((DynamicObject)flowRecord, (String)"entry");
                DynamicObject rollbackFlowRecord = Arrays.stream(flowRecordData).filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"entry") == entryId).findFirst().orElse(null);
                if (rollbackFlowRecord != null) {
                    rollbackFlowRecordId = DynamicObjectUtils.getLong((DynamicObject)rollbackFlowRecord, (String)"id");
                }
                result.put("success", true);
                result.put("messagetype", "success");
                result.put("message", ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"RebateAccountServiceHelper_2", (String)"occ-occba-business", (Object[])new Object[0]));
                result.put("rebateaccountid", rebateAccountId);
                result.put("flowtype", "new");
                result.put("flowrecordid", DynamicObjectUtils.getPkValue((DynamicObject)flowRecord));
                result.put("rollbackflowrecordid", rollbackFlowRecordId);
                checkResults.add(result);
            }
        }
        closeUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:%d \u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginRollbackTime));
        return checkResults;
    }

    private static boolean saveRollbackRebateAccountEx(DynamicObject[] flowRecordData) {
        try {
            Object[] balUpdateRuleIds = Arrays.stream(flowRecordData).map(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"balupdaterule")).distinct().toArray();
            MainEntityType balUpdateRuleType = EntityMetadataCache.getDataEntityType((String)"ocdbd_balupdaterule");
            DynamicObject[] balUpdateRuleData = BusinessDataServiceHelper.load((Object[])balUpdateRuleIds, (DynamicObjectType)balUpdateRuleType);
            if (balUpdateRuleData == null || balUpdateRuleData.length == 0) {
                return false;
            }
            for (DynamicObject flowRecordItem : flowRecordData) {
                boolean exist;
                long rebateAccountId = DynamicObjectUtils.getPkValue((DynamicObject)flowRecordItem, (String)"rebateaccount");
                long balUpdateRuleId = DynamicObjectUtils.getPkValue((DynamicObject)flowRecordItem, (String)"balupdaterule");
                DynamicObject balUpdateRule = Arrays.stream(balUpdateRuleData).filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == balUpdateRuleId).findFirst().orElse(null);
                if (balUpdateRule == null || !(exist = QueryServiceHelper.exists((String)"ocdbd_rebateaccount", (Object)rebateAccountId))) continue;
                DynamicObject rebateAccount = BusinessDataServiceHelper.loadSingle((Object)rebateAccountId, (String)"ocdbd_rebateaccount");
                DataEntityPropertyCollection properties = rebateAccount.getDynamicObjectType().getProperties();
                String amountValueStr = DynamicObjectUtils.getString((DynamicObject)flowRecordItem, (String)"amountvalue");
                JSONObject amountValue = JSONObject.parseObject((String)amountValueStr);
                if (amountValue == null || amountValue.isEmpty()) continue;
                for (String amountKey : amountValue.keySet()) {
                    if (!properties.containsKey((Object)amountKey)) continue;
                    BigDecimal amount = DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)amountKey);
                    BigDecimal updateAmount = new BigDecimal(CommonUtils.convertObjectToString((Object)amountValue.get((Object)amountKey)));
                    if (updateAmount.compareTo(BigDecimal.ZERO) >= 0) {
                        rebateAccount.set(amountKey, (Object)amount.subtract(updateAmount.abs()));
                        continue;
                    }
                    rebateAccount.set(amountKey, (Object)amount.add(updateAmount));
                }
                BigDecimal balance = DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)"balance");
                BigDecimal occupyAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)"occupyamount");
                rebateAccount.set("availablebalance", (Object)balance.subtract(occupyAmount));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rebateAccount});
            }
        }
        catch (Exception ex) {
            logger.error(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3: saveRollbackRebateAccountEx \uff1a %s", ex.getMessage()));
            return false;
        }
        return true;
    }

    private static void saveFlowRecord(DynamicObject[] flowRecords, String flowStatus) {
        if (flowRecords != null && flowRecords.length > 0) {
            for (DynamicObject flowRecordItem : flowRecords) {
                flowRecordItem.set("flowstatus", (Object)flowStatus);
            }
            SaveServiceHelper.save((DynamicObject[])flowRecords);
        }
    }

    private static Map<String, Object> checkRebateAccount(DynamicObject rebateAccount, String billNo) {
        HashMap<String, Object> checkResult = null;
        BigDecimal availableBalance = DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)"availablebalance");
        if (availableBalance.compareTo(BigDecimal.ZERO) < 0) {
            checkResult = new HashMap<String, Object>(0);
            checkResult.put("success", false);
            checkResult.put("billno", billNo);
            String message = String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u6c60\u4f59\u989d\u8868-\u53ef\u7528\u4f59\u989d\u4e0d\u8db3\uff0c\u53ef\u7528\u4f59\u989d\u77ed\u7f3a\uff1a%1$s", (String)"RebateAccountServiceHelper_3", (String)"occ-occba-business", (Object[])new Object[0]), availableBalance);
            checkResult.put("message", message);
            checkResult.put("messagetype", "error");
            logger.info(String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3: checkRebateAccount \uff1a %s", message));
        }
        return checkResult;
    }

    private static DynamicObjectCollection getFlowRecordData(Set<Long> billIds, String updateOpKey, String entityKey, long balUpdateRuleId) {
        QFilter qFilter = new QFilter("sourcebillid", "in", billIds);
        qFilter.and("flowstatus", "=", (Object)"A");
        qFilter.and("billentity", "=", (Object)entityKey);
        if (StringUtils.isNotEmpty((CharSequence)updateOpKey)) {
            qFilter.and("operation", "=", (Object)updateOpKey);
        }
        if (balUpdateRuleId > 0L) {
            qFilter.and("balupdaterule", "=", (Object)balUpdateRuleId);
        }
        String selectFields = "id,operation,operationname,sourcebillid,billentity,flowstatus,balupdaterule,rebateaccount,balflowtype,entry";
        logger.info("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3:getFlowRecordData\u67e5\u8be2\u8d44\u91d1\u6c60\u6d41\u6c34");
        return QueryServiceHelper.query((String)"occba_flowrecord", (String)selectFields, (QFilter[])qFilter.toArray());
    }

    private static Map<String, Object> getDataRowMap(List<String> fieldKeys, Row row, long balUpdateRuleId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(0);
        try {
            for (String fieldKey : fieldKeys) {
                resultMap.put(fieldKey, row.get(fieldKey));
            }
            resultMap.put("balupdateruleid", balUpdateRuleId);
        }
        catch (Exception ex) {
            logger.error("\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u63a5\u53e3: getDataRowMap\uff0c\u9519\u8bef\u539f\u56e0:" + ex.getMessage());
        }
        return resultMap;
    }

    private static List<Map<String, Object>> getDataList(DataSet data, long balUpdateRuleId) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(0);
        List<String> fieldKeys = Arrays.asList(data.getRowMeta().getFieldNames());
        for (Row row : data) {
            dataList.add(RebateAccountServiceHelper.getDataRowMap(fieldKeys, row, balUpdateRuleId));
        }
        return dataList;
    }

    public static void getConfigCol(MainEntityType srcEntityType, DynamicObjectCollection dataColl, Set<String> headCol, Set<String> entryCol, Set<String> subEntryCol, Map<String, String> entryKeySet, String billColKey, String valTypeKey) {
        for (DynamicObject data : dataColl) {
            IDataEntityType proParent;
            String[] proCols;
            IDataEntityProperty pro;
            String billCol = DynamicObjectUtils.getString((DynamicObject)data, (String)billColKey);
            String valType = DynamicObjectUtils.getString((DynamicObject)data, (String)valTypeKey);
            if (!StringUtils.equals((CharSequence)valType, (CharSequence)"1") || !StringUtils.isNotEmpty((CharSequence)billCol) || (pro = srcEntityType.findProperty((proCols = billCol.split("\\."))[0])) == null || (proParent = pro.getParent()) == null) continue;
            String proName = proParent.getName();
            if (pro instanceof EntryProp) {
                entryCol.add(billCol);
                entryKeySet.put("entry", pro.getName());
                continue;
            }
            if (proParent instanceof MainEntityType) {
                headCol.add(billCol);
                continue;
            }
            if (proParent instanceof SubEntryType) {
                subEntryCol.add(billCol);
                entryKeySet.put("subentry", proName);
                continue;
            }
            if (!(proParent instanceof EntryType)) continue;
            entryCol.add(billCol);
            entryKeySet.put("entry", proName);
        }
    }

    private static void getColValue(IDataEntityProperty pro, Map<String, Object> map, DynamicObject data, String colKey, String fullColKey) {
        if (pro instanceof BasedataProp) {
            DynamicObject baseDyn = data.getDynamicObject(colKey);
            int dbType = ((BasedataProp)pro).getDbType();
            if (baseDyn == null) {
                if (dbType == DataType.LONG.getJdbcType()) {
                    map.put(colKey, 0L);
                } else {
                    map.put(colKey, Character.valueOf(' '));
                }
            } else {
                map.put(colKey, baseDyn.getPkValue());
            }
        } else {
            map.put(fullColKey, data.get(colKey));
        }
    }

    private static Map<String, Object> getEntryValue(Set<String> entryCol, DynamicObject data, DataEntityPropertyCollection properties, String entityKey) {
        HashMap<String, Object> mapData = new HashMap<String, Object>(0);
        for (String fullCol : entryCol) {
            String[] cols;
            for (String col : cols = StringUtils.split((String)fullCol, (String)".")) {
                if (entityKey.equals("ocdma_saleorder_add") && col.equals("accounttypeid")) {
                    col = "accounttype";
                }
                String finalCol = col;
                IDataEntityProperty entryProperty = properties.stream().filter(x -> StringUtils.equals((CharSequence)x.getName(), (CharSequence)finalCol)).findFirst().orElse(null);
                if (entryProperty == null) continue;
                RebateAccountServiceHelper.getColValue(entryProperty, mapData, data, col, fullCol);
            }
        }
        return mapData;
    }

    public static void getBalUpdateBillData(MainEntityType srcEntityType, DynamicObject bill, Map<String, Object> mapHead, List<Map<String, Object>> mapEntry, List<Map<String, Object>> mapSubEntry, Set<String> headCol, Set<String> entryCol, Set<String> subEntryCol, String entryKey, String subEntryKey) {
        DynamicObjectCollection entryData;
        String entityKey = bill.getDataEntityType().getName();
        mapHead.put("id", bill.getString("billno"));
        for (String col : headCol) {
            Object property;
            if (col.contains(".")) {
                String[] proCols = col.split("\\.");
                property = srcEntityType.findProperty(proCols[0]);
            } else {
                property = srcEntityType.findProperty(col);
            }
            if (property == null) continue;
            RebateAccountServiceHelper.getColValue((IDataEntityProperty)property, mapHead, bill, col, col);
        }
        if (StringUtils.isNotEmpty((CharSequence)entryKey) && (entryData = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)bill, (String)entryKey)) != null) {
            int seq = 1;
            for (DynamicObject entryItem : entryData) {
                entryItem.set("seq", (Object)seq);
                ++seq;
            }
            DataEntityPropertyCollection entryProperties = entryData.getDynamicObjectType().getProperties();
            for (DynamicObject entryItem : entryData) {
                DynamicObjectCollection subEntryData;
                Map<String, Object> dimEntryItem = RebateAccountServiceHelper.getEntryValue(entryCol, entryItem, entryProperties, entityKey);
                String billNo = bill.getString("billno");
                dimEntryItem.put("id", billNo);
                String entrySeq = entryItem.getString("seq");
                String entryId = String.join((CharSequence)"_", billNo, entrySeq);
                dimEntryItem.put("entryid", entryId);
                mapEntry.add(dimEntryItem);
                if (!StringUtils.isNotEmpty((CharSequence)subEntryKey) || (subEntryData = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryItem, (String)subEntryKey)) == null) continue;
                int subSeq = 1;
                for (DynamicObject subEntryItem : subEntryData) {
                    subEntryItem.set("seq", (Object)subSeq);
                    ++subSeq;
                }
                DataEntityPropertyCollection subEntryProperties = subEntryData.getDynamicObjectType().getProperties();
                for (DynamicObject subEntryItem : subEntryData) {
                    Map<String, Object> dimSubItem = RebateAccountServiceHelper.getEntryValue(subEntryCol, subEntryItem, subEntryProperties, entityKey);
                    dimSubItem.put("id", billNo);
                    dimSubItem.put("entryid", entryId);
                    String subEntrySeq = subEntryItem.getString("seq");
                    String detailId = String.join((CharSequence)"_", entryId, subEntrySeq);
                    dimSubItem.put("detailid", detailId);
                    mapSubEntry.add(dimSubItem);
                }
            }
        }
    }

    private static void getBalUpdateBillData(List<Map<String, Object>> resultList, DynamicObject bill, DynamicObjectCollection dataColl, String entityKey, String valTypeKey, String balColKey, String billColKey, String fixedValueKey) {
        HashSet<String> headCol = new HashSet<String>(0);
        HashSet<String> entryCol = new HashSet<String>(0);
        HashSet<String> subEntryCol = new HashSet<String>(0);
        HashMap<String, Object> mapHead = new HashMap<String, Object>(0);
        HashMap<String, String> entryKeySet = new HashMap<String, String>(0);
        ArrayList<Map<String, Object>> mapEntry = new ArrayList<Map<String, Object>>(0);
        ArrayList<Map<String, Object>> mapSubEntry = new ArrayList<Map<String, Object>>(0);
        MainEntityType srcEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        if (dataColl != null && dataColl.size() > 0) {
            RebateAccountServiceHelper.getConfigCol(srcEntityType, dataColl, headCol, entryCol, subEntryCol, entryKeySet, billColKey, valTypeKey);
            String entryKey = null;
            if (entryKeySet.containsKey("entry")) {
                entryKey = (String)entryKeySet.get("entry");
            }
            String subEntryKey = null;
            if (entryKeySet.containsKey("subentry")) {
                subEntryKey = (String)entryKeySet.get("subentry");
            }
            RebateAccountServiceHelper.getBalUpdateBillData(srcEntityType, bill, mapHead, mapEntry, mapSubEntry, headCol, entryCol, subEntryCol, entryKey, subEntryKey);
            RebateAccountServiceHelper.getBillData(resultList, dataColl, mapHead, mapEntry, mapSubEntry, valTypeKey, balColKey, billColKey, fixedValueKey);
        }
    }

    public static void getBillData(List<Map<String, Object>> resultList, DynamicObjectCollection cfgColl, Map<String, Object> mapHead, List<Map<String, Object>> mapEntry, List<Map<String, Object>> mapSubEntry, String valTypeKey, String balColKey, String billColKey, String fixedValueKey) {
        if (!mapSubEntry.isEmpty()) {
            for (Map<String, Object> mapSubItem : mapSubEntry) {
                Map mapEntryItem;
                if (mapEntry.isEmpty()) continue;
                Object billId = mapSubItem.get("id");
                Object entryId = mapSubItem.get("entryid");
                Object detailId = mapSubItem.get("detailid");
                HashMap<String, Object> dataItem = resultList.stream().filter(x -> x.get("detailid").equals(detailId)).findFirst().orElse(null);
                if (dataItem == null) {
                    dataItem = new HashMap<String, Object>(0);
                }
                if ((mapEntryItem = (Map)mapEntry.stream().filter(x -> x.get("entryid").equals(entryId)).findFirst().orElse(null)) == null) continue;
                RebateAccountServiceHelper.setDataItem(cfgColl, dataItem, mapHead, mapEntryItem, mapSubItem, valTypeKey, balColKey, billColKey, fixedValueKey);
                if (!resultList.stream().noneMatch(x -> x.get("detailid").equals(detailId))) continue;
                dataItem.put("id", billId);
                dataItem.put("entryid", entryId);
                dataItem.put("detailid", detailId);
                resultList.add(dataItem);
            }
        } else if (!mapEntry.isEmpty()) {
            for (Map<String, Object> mapEntryItem : mapEntry) {
                HashMap<String, Object> mapSubItem = new HashMap<String, Object>(0);
                Object billId = mapEntryItem.get("id");
                Object entryId = mapEntryItem.get("entryid");
                HashMap<String, Object> dataItem = resultList.stream().filter(x -> x.get("entryid").equals(entryId)).findFirst().orElse(null);
                if (dataItem == null) {
                    dataItem = new HashMap<String, Object>(0);
                }
                RebateAccountServiceHelper.setDataItem(cfgColl, dataItem, mapHead, mapEntryItem, mapSubItem, valTypeKey, balColKey, billColKey, fixedValueKey);
                if (!resultList.stream().noneMatch(x -> x.get("entryid").equals(entryId))) continue;
                dataItem.put("id", billId);
                dataItem.put("entryid", entryId);
                resultList.add(dataItem);
            }
        } else if (!mapHead.isEmpty()) {
            HashMap<String, Object> mapEntryItem = new HashMap<String, Object>(0);
            HashMap<String, Object> mapSubItem = new HashMap<String, Object>(0);
            Object id = mapHead.get("id");
            HashMap<String, Object> dataItem = resultList.stream().filter(x -> x.get("id").equals(id)).findFirst().orElse(null);
            if (dataItem == null) {
                dataItem = new HashMap<String, Object>(0);
            }
            RebateAccountServiceHelper.setDataItem(cfgColl, dataItem, mapHead, mapEntryItem, mapSubItem, valTypeKey, balColKey, billColKey, fixedValueKey);
            if (resultList.stream().noneMatch(x -> x.get("id").equals(id))) {
                dataItem.put("id", id);
                resultList.add(dataItem);
            }
        }
    }

    public static List<Map<String, Object>> getBillData(DynamicObject balUpdateRule, DynamicObject[] bills, String entityKey) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(0);
        for (DynamicObject bill : bills) {
            long billId = DynamicObjectUtils.getPkValue((DynamicObject)bill);
            QFilter qFilter = new QFilter("sourcebillid", "=", (Object)billId);
            if (!QueryServiceHelper.exists((String)"occba_flowrecord", (QFilter[])qFilter.toArray())) {
                return resultList;
            }
            long balUpdateRuleId = DynamicObjectUtils.getPkValue((DynamicObject)balUpdateRule);
            DynamicObjectCollection dimDataColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)balUpdateRule, (String)"dimdataentity");
            RebateAccountServiceHelper.getBalUpdateBillData(resultList, bill, dimDataColl, entityKey, "dimvaltype", "dimbalcol", "dimbillcol", "dimfixedvalue");
            DynamicObjectCollection updateDataColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)balUpdateRule, (String)"updatedataentity");
            RebateAccountServiceHelper.getBalUpdateBillData(resultList, bill, updateDataColl, entityKey, "updatevaltype", "updatebalcol", "updatebillcol", null);
            DynamicObjectCollection flowDataColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)balUpdateRule, (String)"flowdataentity");
            RebateAccountServiceHelper.getBalUpdateBillData(resultList, bill, flowDataColl, entityKey, "flowvaltype", "flowcol", "flowbillcol", "flowfixedvalue");
            for (Map map : resultList) {
                map.put("balupdateruleid", balUpdateRuleId);
            }
        }
        return resultList;
    }

    public static void setDataItem(Map<String, Object> mapData, Map<String, Object> dataItem, String colName, String billCol) {
        if (!mapData.isEmpty() && mapData.containsKey(billCol)) {
            dataItem.put(colName, mapData.get(billCol));
        }
    }

    public static void setDataItem(DynamicObjectCollection cfgColl, Map<String, Object> dataItem, Map<String, Object> billHead, Map<String, Object> billEntry, Map<String, Object> billSubEntry, String valTypeKey, String colKey, String billColKey, String fixedValueKey) {
        String entryName = cfgColl.getDynamicObjectType().getName();
        for (DynamicObject cfg : cfgColl) {
            String valType = DynamicObjectUtils.getString((DynamicObject)cfg, (String)valTypeKey);
            String colName = DynamicObjectUtils.getString((DynamicObject)cfg, (String)colKey);
            String billCol = DynamicObjectUtils.getString((DynamicObject)cfg, (String)billColKey);
            if (StringUtils.equals((CharSequence)valType, (CharSequence)"1")) {
                RebateAccountServiceHelper.setDataItem(billHead, dataItem, colName, billCol);
                RebateAccountServiceHelper.setDataItem(billEntry, dataItem, colName, billCol);
                RebateAccountServiceHelper.setDataItem(billSubEntry, dataItem, colName, billCol);
                continue;
            }
            if ((!StringUtils.equals((CharSequence)valType, (CharSequence)"4") || !StringUtils.isNotEmpty((CharSequence)fixedValueKey)) && (!StringUtils.equals((CharSequence)valType, (CharSequence)"2") || !StringUtils.isNotEmpty((CharSequence)fixedValueKey) || !StringUtils.equals((CharSequence)entryName, (CharSequence)"flowdataentity"))) continue;
            String fixedValue = DynamicObjectUtils.getString((DynamicObject)cfg, (String)fixedValueKey);
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)fixedValue, CRFormula.class);
            String expression = formula.getExpression();
            dataItem.put(colName, expression);
        }
    }

    private static QFilter filterStringToQFilter(String entityKey, String filterString) {
        if (StringUtils.isEmpty((CharSequence)filterString)) {
            return QFilter.of((String)"1=1", (Object[])new Object[0]);
        }
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)filterString, CRCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityKey), condition.getFilterCondition());
        UserService userService = new UserService();
        fb.setUserService((IUserService)userService);
        fb.buildFilter(false);
        return fb.getQFilter();
    }

    private static List<DynamicObject> getBalUpdateRule(String entityKey, String operateKey) {
        QFilter qFilter = new QFilter("srcbill", "=", (Object)entityKey);
        qFilter.and("status", "=", (Object)BillStatus.C);
        qFilter.and("enable", "=", (Object)"1");
        QFilter qFilter1 = new QFilter("updateopval", "like", (Object)("%," + operateKey + ",%"));
        qFilter1.or("rollbackopval", "like", (Object)("%," + operateKey + ",%"));
        qFilter.and(qFilter1);
        List<String> fieldsKeys = RebateAccountServiceHelper.getBalUpdateRuleFieldKeys();
        String selectFields = StringUtils.join((Object[])fieldsKeys.toArray(), (String)",");
        DynamicObject[] updateRules = BusinessDataServiceHelper.load((String)"ocdbd_balupdaterule", (String)selectFields, (QFilter[])qFilter.toArray());
        return Arrays.stream(updateRules).sorted(Comparator.comparing(x -> x.getInt("priority"))).collect(Collectors.toList());
    }

    public static String getRebateAccountCode() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"ocdbd_rebateaccount");
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)dynamicObject.getDataEntityType().getName(), (DynamicObject)dynamicObject, null);
        if (codeRule != null) {
            return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)dynamicObject);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u542f\u7528\u7f16\u7801\u89c4\u5219", (String)"RebateAccountServiceHelper_4", (String)"occ-occba-business", (Object[])new Object[0]));
    }

    public static String getColFullColKey(MainEntityType entity, String col) {
        if (StringUtils.isBlank((CharSequence)col)) {
            return null;
        }
        String[] proCols = col.split("\\.");
        IDataEntityProperty pro = entity.findProperty(proCols[0]);
        if (pro == null) {
            return "";
        }
        return RebateAccountServiceHelper.getFullColKey(pro.getParent(), col);
    }

    public static String getFullColKey(IDataEntityType parent, String colKey) {
        if (parent instanceof MainEntityType) {
            return colKey;
        }
        return RebateAccountServiceHelper.getFullColKey(parent.getParent(), parent.getName() + "." + colKey);
    }

    private static List<String> getBalUpdateRuleFieldKeys() {
        ArrayList<String> fieldKeys = new ArrayList<String>(0);
        fieldKeys.add("id");
        fieldKeys.add("number");
        fieldKeys.add("name");
        fieldKeys.add("srcbill");
        fieldKeys.add("balobj");
        fieldKeys.add("updatetype");
        fieldKeys.add("updateopval");
        fieldKeys.add("updateopname");
        fieldKeys.add("rollbackopval");
        fieldKeys.add("rollbackopname");
        fieldKeys.add("status");
        fieldKeys.add("enable");
        fieldKeys.add("negativectrl");
        fieldKeys.add("datafilterformula");
        fieldKeys.add("priority");
        fieldKeys.add("autoreoprollback");
        fieldKeys.add("dimdataentity.id");
        fieldKeys.add("dimdataentity.seq");
        fieldKeys.add("dimdataentity.dimbalcol");
        fieldKeys.add("dimdataentity.dimbalcolname");
        fieldKeys.add("dimdataentity.dimvaltype");
        fieldKeys.add("dimdataentity.dimbillcolname");
        fieldKeys.add("dimdataentity.dimbillcol");
        fieldKeys.add("dimdataentity.dimfixedvalue");
        fieldKeys.add("dimdataentity.dimfixedvaluetext");
        fieldKeys.add("updatedataentity.id");
        fieldKeys.add("updatedataentity.seq");
        fieldKeys.add("updatedataentity.updatebalcol");
        fieldKeys.add("updatedataentity.updatebalcolname");
        fieldKeys.add("updatedataentity.updatevaltype");
        fieldKeys.add("updatedataentity.updatebillcolname");
        fieldKeys.add("updatedataentity.updatebillcol");
        fieldKeys.add("updatedataentity.isrollback");
        fieldKeys.add("flowdataentity.id");
        fieldKeys.add("flowdataentity.seq");
        fieldKeys.add("flowdataentity.flowcol");
        fieldKeys.add("flowdataentity.flowcolname");
        fieldKeys.add("flowdataentity.flowvaltype");
        fieldKeys.add("flowdataentity.flowbillcolname");
        fieldKeys.add("flowdataentity.flowbillcol");
        fieldKeys.add("flowdataentity.flowfixedvalue");
        fieldKeys.add("flowdataentity.flowfixedvaluetext");
        return fieldKeys;
    }

    public static String getOperationItem(String entityKey, String opValue) {
        String opName = null;
        if (StringUtils.isEmpty((CharSequence)entityKey)) {
            return null;
        }
        List ops = EntityMetadataCache.getDataEntityOperate((String)entityKey);
        for (Map op : ops) {
            Map map;
            String opType;
            if (!op.containsKey("type") || !OperationTypeCache.isEntityOperation((String)(opType = (String)op.get("type")))) continue;
            String opItemKey = (String)op.get("key");
            if (!op.containsKey("name") || !opItemKey.equals(opValue) || (map = (Map)op.get("name")) == null) continue;
            opName = LocaleString.fromMap((Map)map).getLocaleValue();
        }
        return opName;
    }
}

