/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.business.rebateservice;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.entity.AccountRecord;
import kd.occ.ocbase.common.entity.ServiceResult;
import kd.occ.ocbase.common.entity.itemsup.ItemSuppParam;
import kd.occ.ocbase.common.enums.AccountPoolTypeEnum;
import kd.occ.ocbase.common.enums.AccountUpdateTypeEnum;
import kd.occ.ocbase.common.util.CodeRuleUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.occba.business.itemsupplement.ItemSupplementProvider;
import kd.occ.occba.business.rebate.RebateAccountHelper;
import kd.occ.occba.business.rebate.RebateServiceCheckHelper;
import kd.occ.occba.common.enums.ItemSupUpdateTypeEnum;
import kd.occ.occba.common.enums.RecordUpdateTypeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class RebateCalculateHelper {
    private static Log logger = LogFactory.getLog(RebateCalculateHelper.class);
    private static final BigDecimal MAX_BIGDECIMAL = new BigDecimal(BigInteger.TEN.pow(13));

    public static List<AccountRecord> getCalculateAccountParams(List<AccountRecord> paramList, List<ServiceResult> serviceResultList, boolean isThrowException) {
        if (CollectionUtils.isEmpty(paramList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u91d1\u6c60\u63a5\u53e3\u5165\u53c2\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"RebateCalculateHelper_0", (String)"occ-occba-business", (Object[])new Object[0]));
        }
        ArrayList<AccountRecord> calculateList = new ArrayList<AccountRecord>(paramList.size());
        for (AccountRecord param : paramList) {
            String errorMessage = RebateServiceCheckHelper.getErrorMessage(param, true);
            if (StringUtils.isNotEmpty((String)errorMessage)) {
                if (isThrowException) {
                    throw new KDBizException(errorMessage);
                }
                serviceResultList.add(RebateCalculateHelper.buildErrorServiceResult(param, errorMessage));
                continue;
            }
            calculateList.add(param);
        }
        return calculateList;
    }

    public static List<AccountRecord> getSatisfiedCalculateRebateList(Map<String, DynamicObject> rebateAccountMap, Map<String, DynamicObject> suppMap, List<AccountRecord> calculateList, List<ServiceResult> serviceResultList, boolean isThrowException) {
        if (CollectionUtils.isEmpty(calculateList)) {
            return calculateList;
        }
        Map<String, DynamicObject> calRebateMap = RebateCalculateHelper.deepCopy(rebateAccountMap);
        Map<String, DynamicObject> calSuppMap = RebateCalculateHelper.deepCopy(suppMap);
        ArrayList<AccountRecord> satisfiedList = new ArrayList<AccountRecord>(calculateList.size());
        Map<String, List<AccountRecord>> accountMap = calculateList.stream().collect(Collectors.groupingBy(AccountRecord::getSourceBillNo));
        HashMap addAllAccuntMap = new HashMap(2);
        for (Map.Entry<String, List<AccountRecord>> entry : accountMap.entrySet()) {
            List<AccountRecord> calList = entry.getValue();
            int rollbackiIndex = -1;
            Map<String, DynamicObject> copySuppMap = RebateCalculateHelper.deepCopy(calSuppMap);
            Map<String, DynamicObject> copyRebateAccountMap = RebateCalculateHelper.deepCopy(calRebateMap);
            HashMap<String, DynamicObject> addAccuntMap = new HashMap<String, DynamicObject>(2);
            for (int i = 0; i < calList.size(); ++i) {
                HashSet<Object> newItemSupRecordIds;
                HashSet<Object> newItemSuppIds;
                String errorMsg;
                AccountRecord param = calList.get(i);
                DynamicObject rebateAccount = calRebateMap.get(param.getKey());
                boolean isAddNew = false;
                if (rebateAccount == null) {
                    if (param.getIsAutoCreateRebateAccount()) {
                        isAddNew = true;
                        rebateAccount = RebateCalculateHelper.createRebateAccount(param);
                        param.setId(DynamicObjectUtils.getPkValue((DynamicObject)rebateAccount));
                        addAccuntMap.put(param.getKey(), rebateAccount);
                    } else {
                        if (isThrowException) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\u4e3a%1$s\uff1a\u5165\u53c2\u6570\u636e\u5bf9\u5e94\u7684\u8d44\u91d1\u6c60\u8d26\u6237\u4e0d\u5b58\u5728\u3002", (String)"RebateCalculateHelper_1", (String)"occ-occba-business", (Object[])new Object[0]), param.getSourceBillNo()));
                        }
                        rollbackiIndex = i;
                        calSuppMap = copySuppMap;
                        calRebateMap = copyRebateAccountMap;
                        serviceResultList.add(RebateCalculateHelper.buildErrorServiceResult(param, ResManager.loadKDString((String)"\u5bf9\u5e94\u8d44\u91d1\u6c60\u8d26\u6237\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"RebateCalculateHelper_2", (String)"occ-occba-business", (Object[])new Object[0])));
                        break;
                    }
                }
                if (param.getId() == 0L) {
                    param.setId(DynamicObjectUtils.getPkValue((DynamicObject)rebateAccount));
                }
                if (StringUtils.isNotEmpty((String)(errorMsg = RebateCalculateHelper.checkRebateAccountAndSuppItem(rebateAccount, suppMap, calSuppMap, param, newItemSuppIds = new HashSet<Object>(0), newItemSupRecordIds = new HashSet<Object>(0))))) {
                    ServiceResult serviceResult = RebateCalculateHelper.buildErrorServiceResult(param, errorMsg);
                    if (isThrowException) {
                        throw new KDBizException(serviceResult.getErrorMsg());
                    }
                    rollbackiIndex = i;
                    calSuppMap = copySuppMap;
                    calRebateMap = copyRebateAccountMap;
                    serviceResultList.add(serviceResult);
                    RebateCalculateHelper.rollbackItemSuppData(newItemSuppIds, newItemSupRecordIds);
                    break;
                }
                if (!isAddNew) continue;
                calRebateMap.put(param.getKey(), rebateAccount);
            }
            if (rollbackiIndex != -1) continue;
            for (Map.Entry addInfo : addAccuntMap.entrySet()) {
                addAllAccuntMap.put(addInfo.getKey(), addInfo.getValue());
            }
            satisfiedList.addAll(calList);
        }
        for (Map.Entry<String, List<Object>> entry : addAllAccuntMap.entrySet()) {
            DynamicObject addAccount = (DynamicObject)entry.getValue();
            addAccount.set("balance", (Object)BigDecimal.ZERO);
            addAccount.set("occupyamount", (Object)BigDecimal.ZERO);
            rebateAccountMap.put(entry.getKey(), addAccount);
        }
        return satisfiedList;
    }

    private static DynamicObject createRebateAccount(AccountRecord param) {
        DynamicObject rebateAccount = BusinessDataServiceHelper.newDynamicObject((String)"ocdbd_rebateaccount");
        rebateAccount.set("number", (Object)CodeRuleUtil.getCodeRule((String)"ocdbd_rebateaccount"));
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateAccount, (String)"org", (long)param.getOrgId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateAccount, (String)"customer", (long)param.getCustomerId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateAccount, (String)"channel", (long)param.getChannelId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateAccount, (String)"accounttype", (long)param.getAccountType());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateAccount, (String)"setcurrency", (long)param.getCurrencyId());
        String pooltType = StringUtils.isEmpty((String)param.getPoolType()) ? AccountPoolTypeEnum.BRANDS.getValue() : param.getPoolType();
        rebateAccount.set("type", (Object)pooltType);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rebateAccount, (String)"receivechannel", (long)param.getReceiveChannelId());
        rebateAccount.set("updatedatetime", (Object)KDDateUtils.now());
        DynamicObject[] saveRebateAccount = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rebateAccount});
        QFilter filters = new QFilter("id", "=", saveRebateAccount[0].getPkValue());
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_rebateaccount", (String)"id,org,customer,number,channel,accounttype,currency,setcurrency,occupyamount,balance,updatedatetime,availablebalance,receivechannel,type", (QFilter[])filters.toArray());
    }

    private static String checkRebateAccountAndSuppItem(DynamicObject rebateAccount, Map<String, DynamicObject> suppItemMap, Map<String, DynamicObject> calSuppItemMap, AccountRecord param, Set<Object> newItemSuppIds, Set<Object> newItemSupRecordIds) {
        boolean isNeedCheckSupporItem;
        String errorMsg = RebateCalculateHelper.checkRebateAmountByUpdteType(param, rebateAccount, param.getUpdateType());
        if (StringUtils.isEmpty((String)errorMsg) && (isNeedCheckSupporItem = RebateCalculateHelper.isNeedCheckSupporItem(rebateAccount, param))) {
            if (CollectionUtils.isEmpty((Collection)param.getSupList())) {
                return RebateAccountHelper.buildAccountParamErrorMsg(rebateAccount);
            }
            errorMsg = RebateCalculateHelper.checkSuppItemParam(suppItemMap, calSuppItemMap, param, newItemSuppIds, newItemSupRecordIds);
        }
        return errorMsg;
    }

    private static boolean isNeedCheckSupporItem(DynamicObject rebateAccount, AccountRecord param) {
        return RebateAccountHelper.isSupportItem(rebateAccount) && !"C".equalsIgnoreCase(param.getBillType()) && !"occba_balanceadjust".equalsIgnoreCase(param.getBillEntity());
    }

    private static String checkSuppItemParam(Map<String, DynamicObject> suppItemMap, Map<String, DynamicObject> calSuppItemMap, AccountRecord param, Set<Object> newItemSuppIds, Set<Object> newItemSupRecordIds) {
        List<ItemSuppParam> itemSuppParamList = RebateAccountHelper.buildItemSuppParam(param);
        String updateType = param.getUpdateType();
        if (param.getIsAutoCreateItemSupp()) {
            ArrayList<ItemSuppParam> newItemSuppParamList = new ArrayList<ItemSuppParam>(0);
            ItemSupUpdateTypeEnum itemSupUpdateTypeEnum = RebateCalculateHelper.getItemSupUpdateType(updateType);
            for (ItemSuppParam itemSuppParam : itemSuppParamList) {
                DynamicObject itemSuppInfo = calSuppItemMap.get(itemSuppParam.getKey());
                if (itemSuppInfo != null) continue;
                itemSuppParam.setUpdateQty(BigDecimal.ZERO);
                newItemSuppParamList.add(itemSuppParam);
            }
            if (newItemSuppParamList.size() > 0) {
                ItemSupplementProvider.insertItemSupplementList(newItemSuppParamList, itemSupUpdateTypeEnum, newItemSuppIds, newItemSupRecordIds, false);
                if (newItemSuppIds.size() > 0) {
                    Map<String, DynamicObject> newSuppItemMap = ItemSupplementProvider.getExistSupplementInfoMap(newItemSuppIds);
                    suppItemMap.putAll(newSuppItemMap);
                    calSuppItemMap.putAll(newSuppItemMap);
                }
            }
        }
        for (ItemSuppParam itemSuppParam : itemSuppParamList) {
            BigDecimal afterOccupyQty;
            BigDecimal afterAvailableQty;
            BigDecimal afterSupQty;
            DynamicObject itemSuppInfo = calSuppItemMap.get(itemSuppParam.getKey());
            if (itemSuppInfo == null) continue;
            if (AccountUpdateTypeEnum.balanceAdjust.getValue().equalsIgnoreCase(updateType) || AccountUpdateTypeEnum.billClose.getValue().equalsIgnoreCase(updateType) || AccountUpdateTypeEnum.useAmountRelease.getValue().equalsIgnoreCase(updateType)) {
                afterSupQty = itemSuppInfo.getBigDecimal("supqty").add(itemSuppParam.getUpdateQty());
                afterAvailableQty = afterSupQty.subtract(itemSuppInfo.getBigDecimal("occupyqty"));
                if (afterAvailableQty.compareTo(BigDecimal.ZERO) < 0) {
                    return ItemSupplementProvider.buildItemSupErrorMsg(itemSuppInfo);
                }
                itemSuppInfo.set("supqty", (Object)afterSupQty);
                itemSuppInfo.set("availableqty", (Object)afterAvailableQty);
                continue;
            }
            if (AccountUpdateTypeEnum.useAmount.getValue().equalsIgnoreCase(updateType)) {
                afterOccupyQty = itemSuppInfo.getBigDecimal("occupyqty").subtract(itemSuppParam.getUpdateQty());
                BigDecimal afterSupQty2 = itemSuppInfo.getBigDecimal("supqty").subtract(itemSuppParam.getUpdateQty());
                BigDecimal afterAvailableQty2 = afterSupQty2.subtract(afterOccupyQty);
                if (afterAvailableQty2.compareTo(BigDecimal.ZERO) < 0) {
                    return ItemSupplementProvider.buildItemSupErrorMsg(itemSuppInfo);
                }
                itemSuppInfo.set("occupyqty", (Object)afterOccupyQty);
                itemSuppInfo.set("supqty", (Object)afterSupQty2);
                itemSuppInfo.set("availableqty", (Object)afterAvailableQty2);
                continue;
            }
            if (AccountUpdateTypeEnum.amountOccupy.getValue().equalsIgnoreCase(updateType)) {
                afterOccupyQty = itemSuppInfo.getBigDecimal("occupyqty").add(itemSuppParam.getUpdateQty());
                afterAvailableQty = itemSuppInfo.getBigDecimal("supqty").subtract(afterOccupyQty);
                if (afterAvailableQty.compareTo(BigDecimal.ZERO) < 0) {
                    return ItemSupplementProvider.buildItemSupErrorMsg(itemSuppInfo);
                }
                itemSuppInfo.set("occupyqty", (Object)afterOccupyQty);
                itemSuppInfo.set("availableqty", (Object)afterAvailableQty);
                continue;
            }
            if (AccountUpdateTypeEnum.amountRelease.getValue().equalsIgnoreCase(updateType)) {
                itemSuppParam.setUpdateQty(itemSuppParam.getUpdateQty().negate());
                afterOccupyQty = itemSuppInfo.getBigDecimal("occupyqty").add(itemSuppParam.getUpdateQty());
                afterAvailableQty = itemSuppInfo.getBigDecimal("supqty").subtract(afterOccupyQty);
                if (afterAvailableQty.compareTo(BigDecimal.ZERO) >= 0) continue;
                return ItemSupplementProvider.buildItemSupErrorMsg(itemSuppInfo);
            }
            if (!AccountUpdateTypeEnum.billUnClose.getValue().equalsIgnoreCase(updateType)) continue;
            afterSupQty = itemSuppInfo.getBigDecimal("supqty").subtract(itemSuppParam.getUpdateQty());
            afterAvailableQty = afterSupQty.subtract(itemSuppInfo.getBigDecimal("occupyqty"));
            if (afterAvailableQty.compareTo(BigDecimal.ZERO) < 0) {
                return ItemSupplementProvider.buildItemSupErrorMsg(itemSuppInfo);
            }
            itemSuppInfo.set("supqty", (Object)afterSupQty);
            itemSuppInfo.set("availableqty", (Object)afterAvailableQty);
        }
        return "";
    }

    private static ServiceResult buildErrorServiceResult(AccountRecord accountRecord, String errorMessage) {
        ServiceResult serviceResult = new ServiceResult();
        serviceResult.setSuccess(false);
        serviceResult.setCode(500);
        serviceResult.setBillNo(accountRecord.getSourceBillNo());
        serviceResult.setBillId(accountRecord.getSourceBillId());
        errorMessage = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\u4e3a%1$s:%2$s", (String)"RebateCalculateHelper_3", (String)"occ-occba-business", (Object[])new Object[0]), accountRecord.getSourceBillNo(), errorMessage);
        serviceResult.setErrorMsg(errorMessage);
        return serviceResult;
    }

    private static ServiceResult buildSuccessServiceResult(AccountRecord accountRecord) {
        ServiceResult serviceResult = new ServiceResult();
        serviceResult.setSuccess(true);
        serviceResult.setCode(200);
        serviceResult.setBillNo(accountRecord.getSourceBillNo());
        serviceResult.setBillId(accountRecord.getSourceBillId());
        return serviceResult;
    }

    private static String checkRebateAmountByUpdteType(AccountRecord accountRecord, DynamicObject rebateAccount, String updateType) {
        String checkResult = "";
        if (AccountUpdateTypeEnum.balanceAdjust.getValue().equalsIgnoreCase(updateType)) {
            checkResult = RebateCalculateHelper.validateAccountForAdjust(accountRecord, rebateAccount);
        } else if (AccountUpdateTypeEnum.amountOccupy.getValue().equalsIgnoreCase(updateType)) {
            checkResult = RebateCalculateHelper.validateAccountForOccupy(accountRecord, rebateAccount);
        } else if (AccountUpdateTypeEnum.amountRelease.getValue().equalsIgnoreCase(updateType)) {
            checkResult = RebateCalculateHelper.validateAccountForRelease(accountRecord, rebateAccount);
        } else if (AccountUpdateTypeEnum.useAmount.getValue().equalsIgnoreCase(updateType)) {
            checkResult = RebateCalculateHelper.validateAccountForUse(accountRecord, rebateAccount);
        } else if (AccountUpdateTypeEnum.useAmountRelease.getValue().equalsIgnoreCase(updateType)) {
            checkResult = RebateCalculateHelper.validateAccountForUseRelease(accountRecord, rebateAccount);
        } else if (AccountUpdateTypeEnum.billClose.getValue().equalsIgnoreCase(updateType)) {
            checkResult = RebateCalculateHelper.validateAccountForBillClose(accountRecord, rebateAccount);
        } else if (AccountUpdateTypeEnum.billUnClose.getValue().equalsIgnoreCase(updateType)) {
            checkResult = RebateCalculateHelper.validateAccountForBillUnClose(accountRecord, rebateAccount);
        } else if (AccountUpdateTypeEnum.amountfrozen.getValue().equalsIgnoreCase(updateType)) {
            checkResult = RebateCalculateHelper.validateAccountForAmountFrozen(accountRecord, rebateAccount);
        } else if (AccountUpdateTypeEnum.amountunfrozen.getValue().equalsIgnoreCase(updateType)) {
            checkResult = RebateCalculateHelper.validateAccountForAmountUnFrozen(accountRecord, rebateAccount);
        } else if (AccountUpdateTypeEnum.settlementPayment.getValue().equalsIgnoreCase(updateType)) {
            checkResult = RebateCalculateHelper.validateAccountForSettlementPayment(accountRecord, rebateAccount);
        }
        return checkResult;
    }

    private static String validateAccountForAmountUnFrozen(AccountRecord accountRecord, DynamicObject rebateAccount) {
        BigDecimal balance = rebateAccount.getBigDecimal("balance");
        BigDecimal newOccupyAmount = rebateAccount.getBigDecimal("occupyamount").subtract(accountRecord.getAmount());
        if (newOccupyAmount.compareTo(BigDecimal.ZERO) < 0) {
            return ResManager.loadKDString((String)"\u89e3\u51bb\u540e\u8d26\u6237\u5360\u7528\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e0\u3002", (String)"RebateCalculateHelper_4", (String)"occ-occba-business", (Object[])new Object[0]);
        }
        BigDecimal newAvailableAmount = balance.subtract(newOccupyAmount);
        if (newAvailableAmount.compareTo(BigDecimal.ZERO) < 0) {
            return ResManager.loadKDString((String)"\u89e3\u51bb\u540e\u8d26\u6237\u53ef\u7528\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e0\u3002", (String)"RebateCalculateHelper_5", (String)"occ-occba-business", (Object[])new Object[0]);
        }
        accountRecord.setAdvance(true);
        rebateAccount.set("occupyamount", (Object)newOccupyAmount);
        rebateAccount.set("availablebalance", (Object)newAvailableAmount);
        return "";
    }

    private static String validateAccountForAmountFrozen(AccountRecord accountRecord, DynamicObject rebateAccount) {
        BigDecimal balance = rebateAccount.getBigDecimal("balance");
        if (balance.compareTo(BigDecimal.ZERO) <= 0) {
            return ResManager.loadKDString((String)"\u8d26\u6237\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u4e0d\u53ef\u51bb\u7ed3\u3002", (String)"RebateCalculateHelper_6", (String)"occ-occba-business", (Object[])new Object[0]);
        }
        BigDecimal newOccupyAmount = rebateAccount.getBigDecimal("occupyamount").add(accountRecord.getAmount());
        BigDecimal newAvailableAmount = balance.subtract(newOccupyAmount);
        if (newAvailableAmount.compareTo(BigDecimal.ZERO) < 0) {
            return ResManager.loadKDString((String)"\u51bb\u7ed3\u540e\u8d26\u6237\u53ef\u7528\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e0\u3002", (String)"RebateCalculateHelper_7", (String)"occ-occba-business", (Object[])new Object[0]);
        }
        accountRecord.setAdvance(true);
        rebateAccount.set("occupyamount", (Object)newOccupyAmount);
        rebateAccount.set("availablebalance", (Object)newAvailableAmount);
        return "";
    }

    private static String validateAccountForBillUnClose(AccountRecord accountRecord, DynamicObject rebateAccount) {
        boolean isReduce;
        BigDecimal afterAmount = rebateAccount.getBigDecimal("balance").subtract(accountRecord.getAmount());
        if (RebateCalculateHelper.isAllowOrderAmountNegative(accountRecord)) {
            accountRecord.setAdvance(true);
            rebateAccount.set("balance", (Object)afterAmount);
            return "";
        }
        boolean bl = isReduce = afterAmount.subtract(rebateAccount.getBigDecimal("balance")).compareTo(BigDecimal.ZERO) < 0;
        if (isReduce && afterAmount.compareTo(BigDecimal.ZERO) < 0) {
            return ResManager.loadKDString((String)"\u5355\u636e\u53cd\u5173\u95ed\u540e\u7684\u8d26\u6237\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e0\u3002", (String)"RebateCalculateHelper_8", (String)"occ-occba-business", (Object[])new Object[0]);
        }
        BigDecimal occupyAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)"occupyamount");
        if (afterAmount.subtract(occupyAmount).compareTo(BigDecimal.ZERO) < 0) {
            return ResManager.loadKDString((String)"\u5355\u636e\u53cd\u5173\u95ed\u540e\u7684\u8d26\u6237\u53ef\u7528\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e0\u3002", (String)"RebateCalculateHelper_19", (String)"occ-occba-business", (Object[])new Object[0]);
        }
        accountRecord.setAdvance(true);
        rebateAccount.set("balance", (Object)afterAmount);
        return "";
    }

    private static String validateAccountForBillClose(AccountRecord accountRecord, DynamicObject rebateAccount) {
        boolean isReduce;
        BigDecimal afterAmount = rebateAccount.getBigDecimal("balance").add(accountRecord.getAmount());
        if (RebateCalculateHelper.isAllowOrderAmountNegative(accountRecord)) {
            accountRecord.setAdvance(true);
            rebateAccount.set("balance", (Object)afterAmount);
            return "";
        }
        boolean bl = isReduce = afterAmount.subtract(rebateAccount.getBigDecimal("balance")).compareTo(BigDecimal.ZERO) < 0;
        if (isReduce && afterAmount.compareTo(BigDecimal.ZERO) < 0) {
            return ResManager.loadKDString((String)"\u5355\u636e\u5173\u95ed\u540e\u7684\u8d26\u6237\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e0\u3002", (String)"RebateCalculateHelper_20", (String)"occ-occba-business", (Object[])new Object[0]);
        }
        BigDecimal occupyAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)"occupyamount");
        if (afterAmount.subtract(occupyAmount).compareTo(BigDecimal.ZERO) < 0) {
            return ResManager.loadKDString((String)"\u5355\u636e\u5173\u95ed\u540e\u7684\u8d26\u6237\u53ef\u7528\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e0\u3002", (String)"RebateCalculateHelper_21", (String)"occ-occba-business", (Object[])new Object[0]);
        }
        accountRecord.setAdvance(true);
        rebateAccount.set("balance", (Object)afterAmount);
        return "";
    }

    private static String validateAccountForUseRelease(AccountRecord accountRecord, DynamicObject rebateAccount) {
        BigDecimal afterAccountAmount = rebateAccount.getBigDecimal("balance").add(accountRecord.getAmount());
        if (RebateCalculateHelper.isAllowOrderAmountNegative(accountRecord)) {
            accountRecord.setAdvance(true);
            rebateAccount.set("balance", (Object)afterAccountAmount);
            return "";
        }
        if (afterAccountAmount.compareTo(BigDecimal.ZERO) < 0 && accountRecord.getAmount().compareTo(BigDecimal.ZERO) < 0) {
            return ResManager.loadKDString((String)"\u8d44\u91d1\u8d26\u6237\u4f59\u989d\u4e0d\u8db3\uff0c\u5355\u636e\u91ca\u653e\u5931\u8d25\u3002", (String)"RebateCalculateHelper_9", (String)"occ-occba-business", (Object[])new Object[0]);
        }
        BigDecimal occupyAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)"occupyamount");
        if (afterAccountAmount.subtract(occupyAmount).compareTo(BigDecimal.ZERO) < 0 && accountRecord.getAmount().compareTo(BigDecimal.ZERO) < 0) {
            return ResManager.loadKDString((String)"\u8d44\u91d1\u8d26\u6237\u53ef\u7528\u4f59\u989d\u4e0d\u8db3\uff0c\u5355\u636e\u91ca\u653e\u5931\u8d25\u3002", (String)"RebateCalculateHelper_22", (String)"occ-occba-business", (Object[])new Object[0]);
        }
        accountRecord.setAdvance(true);
        rebateAccount.set("balance", (Object)afterAccountAmount);
        return "";
    }

    private static String validateAccountForUse(AccountRecord accountRecord, DynamicObject rebateAccount) {
        BigDecimal occupyAmount;
        boolean isNeedUpdateOccupy;
        BigDecimal afterAccountAmount = rebateAccount.getBigDecimal("balance").subtract(accountRecord.getAmount());
        boolean bl = isNeedUpdateOccupy = accountRecord.getAmount().compareTo(BigDecimal.ZERO) > 0 && accountRecord.isUpdateOccupy();
        if (RebateCalculateHelper.isAllowOrderAmountNegative(accountRecord)) {
            if (isNeedUpdateOccupy) {
                BigDecimal occupyAmount2 = rebateAccount.getBigDecimal("occupyamount").subtract(accountRecord.getAmount());
                rebateAccount.set("occupyamount", (Object)occupyAmount2);
            }
            accountRecord.setAdvance(true);
            rebateAccount.set("balance", (Object)afterAccountAmount);
            return "";
        }
        if (afterAccountAmount.compareTo(BigDecimal.ZERO) < 0) {
            return ResManager.loadKDString((String)"\u8d44\u91d1\u8d26\u6237\u4f59\u989d\u4e0d\u8db3\uff0c\u6263\u51cf\u5931\u8d25\u3002", (String)"RebateCalculateHelper_10", (String)"occ-occba-business", (Object[])new Object[0]);
        }
        if (isNeedUpdateOccupy) {
            occupyAmount = rebateAccount.getBigDecimal("occupyamount").subtract(accountRecord.getAmount());
            if (occupyAmount.compareTo(BigDecimal.ZERO) < 0) {
                return String.format(ResManager.loadKDString((String)"\u539f\u8d26\u6237\u5360\u7528\u91d1\u989d\u4e3a%1$s\uff0c\u672c\u6b21\u91ca\u653e\u5360\u7528\u91d1\u989d\u4e3a%2$s\uff0c\u5360\u7528\u603b\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e0\u3002", (String)"RebateCalculateHelper_11", (String)"occ-occba-business", (Object[])new Object[0]), rebateAccount.getBigDecimal("occupyamount").toPlainString(), accountRecord.getAmount().toPlainString());
            }
            rebateAccount.set("occupyamount", (Object)occupyAmount);
        }
        if (afterAccountAmount.subtract(occupyAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)"occupyamount")).compareTo(BigDecimal.ZERO) < 0) {
            return ResManager.loadKDString((String)"\u8d44\u91d1\u8d26\u6237\u53ef\u7528\u4f59\u989d\u4e0d\u8db3\uff0c\u6263\u51cf\u5931\u8d25\u3002", (String)"RebateCalculateHelper_17", (String)"occ-occba-business", (Object[])new Object[0]);
        }
        accountRecord.setAdvance(true);
        rebateAccount.set("balance", (Object)afterAccountAmount);
        return "";
    }

    private static String validateAccountForRelease(AccountRecord accountRecord, DynamicObject rebateAccount) {
        BigDecimal afterOccupyAmount = rebateAccount.getBigDecimal("occupyamount").subtract(accountRecord.getAmount());
        if (RebateCalculateHelper.isAllowOrderAmountNegative(accountRecord)) {
            accountRecord.setAdvance(true);
            rebateAccount.set("occupyamount", (Object)afterOccupyAmount);
            return "";
        }
        if (afterOccupyAmount.compareTo(BigDecimal.ZERO) < 0) {
            return ResManager.loadKDString((String)"\u91ca\u653e\u540e\u7684\u5360\u7528\u91d1\u989d\u540e\u4e0d\u5141\u8bb8\u5c0f\u4e8e0\u3002", (String)"RebateCalculateHelper_12", (String)"occ-occba-business", (Object[])new Object[0]);
        }
        accountRecord.setAdvance(true);
        rebateAccount.set("occupyamount", (Object)afterOccupyAmount);
        return "";
    }

    private static String validateAccountForOccupy(AccountRecord accountRecord, DynamicObject rebateAccount) {
        boolean isAllowNegative;
        BigDecimal afterOccupyAmount = rebateAccount.getBigDecimal("occupyamount").add(accountRecord.getAmount());
        if (RebateCalculateHelper.isAllowOrderAmountNegative(accountRecord)) {
            accountRecord.setAdvance(true);
            rebateAccount.set("occupyamount", (Object)afterOccupyAmount);
            return "";
        }
        boolean bl = isAllowNegative = "C".equalsIgnoreCase(accountRecord.getBillType()) || "occba_balanceadjust".equalsIgnoreCase(accountRecord.getBillEntity());
        if (!isAllowNegative && rebateAccount.getBigDecimal("balance").compareTo(afterOccupyAmount) < 0) {
            return ResManager.loadKDString((String)"\u66f4\u65b0\u540e\u7684\u5360\u7528\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u8d26\u6237\u91d1\u989d\u3002", (String)"RebateCalculateHelper_13", (String)"occ-occba-business", (Object[])new Object[0]);
        }
        accountRecord.setAdvance(true);
        rebateAccount.set("occupyamount", (Object)afterOccupyAmount);
        return "";
    }

    private static String validateAccountForAdjust(AccountRecord accountRecord, DynamicObject rebateAccount) {
        BigDecimal afterAmount = rebateAccount.getBigDecimal("balance").add(accountRecord.getAmount());
        if (afterAmount.compareTo(MAX_BIGDECIMAL) >= 0) {
            return ResManager.loadKDString((String)"\u8c03\u6574\u540e\u7684\u8d26\u6237\u91d1\u989d\u5df2\u8d85\u8fc7\u6700\u5927\u503c\u3002", (String)"RebateCalculateHelper_14", (String)"occ-occba-business", (Object[])new Object[0]);
        }
        accountRecord.setAdvance(true);
        rebateAccount.set("balance", (Object)afterAmount);
        return "";
    }

    private static String validateAccountForSettlementPayment(AccountRecord accountRecord, DynamicObject rebateAccount) {
        BigDecimal afterAmount = rebateAccount.getBigDecimal("balance").add(accountRecord.getAmount());
        if (afterAmount.compareTo(BigDecimal.ZERO) < 0) {
            return ResManager.loadKDString((String)"\u7ed3\u7b97\u540e\u7684\u8d26\u6237\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"RebateCalculateHelper_15", (String)"occ-occba-business", (Object[])new Object[0]);
        }
        BigDecimal occupyAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)"occupyamount");
        if (afterAmount.subtract(occupyAmount).compareTo(BigDecimal.ZERO) < 0) {
            return ResManager.loadKDString((String)"\u7ed3\u7b97\u540e\u7684\u8d26\u6237\u53ef\u7528\u4f59\u989d\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"RebateCalculateHelper_18", (String)"occ-occba-business", (Object[])new Object[0]);
        }
        accountRecord.setAdvance(true);
        rebateAccount.set("balance", (Object)afterAmount);
        return "";
    }

    private static boolean getIsAllowNegativeForAdjust(AccountRecord accountRecord, String accountType) {
        return ("C".equalsIgnoreCase(accountRecord.getBillType()) || "occba_balanceadjust".equalsIgnoreCase(accountRecord.getBillEntity())) && ("C".equalsIgnoreCase(accountType) || "A".equalsIgnoreCase(accountType)) || "E".equalsIgnoreCase(accountRecord.getBillType()) || "occba_moneyincome".equalsIgnoreCase(accountRecord.getBillEntity()) || "A".equalsIgnoreCase(accountRecord.getBillType()) || "occpic_rebatestatement".equalsIgnoreCase(accountRecord.getBillEntity());
    }

    private static boolean isAllowOrderAmountNegative(AccountRecord accountRecord) {
        return ("B".equalsIgnoreCase(accountRecord.getBillType()) || "ocbsoc_saleorder".equalsIgnoreCase(accountRecord.getBillEntity())) && !SysParamsUtil.isAllowOrderNegative();
    }

    private static RecordUpdateTypeEnum getRecordUpdateType(String accountUpdateType) {
        if (AccountUpdateTypeEnum.balanceAdjust.getValue().equalsIgnoreCase(accountUpdateType)) {
            return RecordUpdateTypeEnum.YETZ;
        }
        if (AccountUpdateTypeEnum.amountOccupy.getValue().equalsIgnoreCase(accountUpdateType)) {
            return RecordUpdateTypeEnum.YEDJ;
        }
        if (AccountUpdateTypeEnum.amountRelease.getValue().equalsIgnoreCase(accountUpdateType)) {
            return RecordUpdateTypeEnum.YESF;
        }
        if (AccountUpdateTypeEnum.useAmount.getValue().equalsIgnoreCase(accountUpdateType)) {
            return RecordUpdateTypeEnum.APPLY;
        }
        if (AccountUpdateTypeEnum.useAmountRelease.getValue().equalsIgnoreCase(accountUpdateType)) {
            return RecordUpdateTypeEnum.DJSF;
        }
        if (AccountUpdateTypeEnum.billClose.getValue().equalsIgnoreCase(accountUpdateType)) {
            return RecordUpdateTypeEnum.DDGB;
        }
        if (AccountUpdateTypeEnum.billUnClose.getValue().equalsIgnoreCase(accountUpdateType)) {
            return RecordUpdateTypeEnum.DDFGB;
        }
        if (AccountUpdateTypeEnum.amountfrozen.getValue().equalsIgnoreCase(accountUpdateType)) {
            return RecordUpdateTypeEnum.JEDJ;
        }
        if (AccountUpdateTypeEnum.amountunfrozen.getValue().equalsIgnoreCase(accountUpdateType)) {
            return RecordUpdateTypeEnum.JEJD;
        }
        return RecordUpdateTypeEnum.JSZF;
    }

    public static Map<String, DynamicObject> getSupplementInfoMap(List<AccountRecord> calculateList) {
        ArrayList<ItemSuppParam> itemSuppParamList = new ArrayList<ItemSuppParam>(calculateList.size());
        for (AccountRecord account : calculateList) {
            if (!CollectionUtils.isNotEmpty((Collection)account.getSupList())) continue;
            itemSuppParamList.addAll(RebateAccountHelper.buildItemSuppParam(account));
        }
        return ItemSupplementProvider.getExistSupplementInfoMap(itemSuppParamList);
    }

    private static Map<String, DynamicObject> deepCopy(Map<String, DynamicObject> map) {
        try {
            HashMap<String, DynamicObject> copyMap = new HashMap<String, DynamicObject>(map.size());
            CloneUtils cloneUtils = new CloneUtils(false, false);
            for (Map.Entry<String, DynamicObject> copyObject : map.entrySet()) {
                DynamicObject dynamicObjectNew = (DynamicObject)cloneUtils.clone((IDataEntityBase)copyObject.getValue());
                copyMap.put(copyObject.getKey(), dynamicObjectNew);
            }
            return copyMap;
        }
        catch (Exception ex) {
            logger.error("deep copy error:" + ex);
            return new HashMap<String, DynamicObject>(0);
        }
    }

    public static void updateAccountAndSuppItem(Map<String, DynamicObject> rebateAccountMap, Map<String, DynamicObject> suppMap, List<AccountRecord> satisfiedAccountList) {
        int size = rebateAccountMap.size();
        ArrayList<DynamicObject> updateRebateAccountList = new ArrayList<DynamicObject>(size);
        ArrayList<DynamicObject> accountRecordList = new ArrayList<DynamicObject>(size);
        ArrayList<DynamicObject> updateSuppItemList = new ArrayList<DynamicObject>(size);
        ArrayList<DynamicObject> suppRecordList = new ArrayList<DynamicObject>(size);
        Map<String, List<AccountRecord>> accountMap = satisfiedAccountList.stream().collect(Collectors.groupingBy(AccountRecord::getKey));
        for (Map.Entry<String, List<AccountRecord>> calculateAccount : accountMap.entrySet()) {
            DynamicObject account = rebateAccountMap.get(calculateAccount.getKey());
            if (CollectionUtils.isEmpty((Collection)calculateAccount.getValue()) || account == null) continue;
            RebateCalculateHelper.calculateRebateAccount(calculateAccount.getValue(), account, updateRebateAccountList, accountRecordList);
            if (!RebateAccountHelper.isSupportItem(account)) continue;
            RebateCalculateHelper.calculateSuppmentItem(calculateAccount.getValue(), suppMap, updateSuppItemList, suppRecordList);
        }
        if (CollectionUtils.isNotEmpty(updateRebateAccountList) && CollectionUtils.isNotEmpty(accountRecordList)) {
            SaveServiceHelper.save((DynamicObject[])accountRecordList.toArray(new DynamicObject[0]));
            SaveServiceHelper.update((DynamicObject[])updateRebateAccountList.toArray(new DynamicObject[0]));
        }
        if (CollectionUtils.isNotEmpty(updateSuppItemList) && CollectionUtils.isNotEmpty(suppRecordList)) {
            SaveServiceHelper.save((DynamicObject[])suppRecordList.toArray(new DynamicObject[0]));
            SaveServiceHelper.update((DynamicObject[])updateSuppItemList.toArray(new DynamicObject[0]));
        }
    }

    private static void calculateSuppmentItem(List<AccountRecord> paramList, Map<String, DynamicObject> suppItemMap, List<DynamicObject> updateSuppItemList, List<DynamicObject> suppRecordList) {
        HashMap<String, DynamicObject> updateItemMap = new HashMap<String, DynamicObject>(8);
        for (AccountRecord param : paramList) {
            if ("C".equalsIgnoreCase(param.getBillType()) || "occba_balanceadjust".equalsIgnoreCase(param.getBillEntity())) continue;
            List<ItemSuppParam> itemSuppParamList = RebateAccountHelper.buildItemSuppParam(param);
            String updateType = param.getUpdateType();
            for (ItemSuppParam itemSuppParam : itemSuppParamList) {
                DynamicObject itemSuppInfo = suppItemMap.get(itemSuppParam.getKey());
                if (itemSuppInfo == null) continue;
                ItemSupUpdateTypeEnum itemSupUpdateTypeEnum = RebateCalculateHelper.getItemSupUpdateType(updateType);
                DynamicObject itemSupRecord = ItemSupplementProvider.buildItemSupRecord(itemSuppParam, itemSupUpdateTypeEnum);
                itemSupRecord.set("beforeqty", (Object)itemSuppInfo.getBigDecimal("supqty"));
                ItemSupplementProvider.updateSupplementItemQty(itemSuppInfo, itemSuppParam, itemSupUpdateTypeEnum);
                itemSuppInfo.set("lastupdatetime", (Object)TimeServiceHelper.now());
                itemSupRecord.set("afterqty", (Object)itemSuppInfo.getBigDecimal("supqty"));
                itemSupRecord.set("updateqty", (Object)itemSuppParam.getUpdateQty());
                itemSupRecord.set("supplement", (Object)DynamicObjectUtils.getPkValue((DynamicObject)itemSuppInfo));
                suppRecordList.add(itemSupRecord);
                updateItemMap.put(itemSuppParam.getKey(), itemSuppInfo);
            }
        }
        if (updateItemMap.size() > 0) {
            updateSuppItemList.addAll(updateItemMap.values());
        }
    }

    private static ItemSupUpdateTypeEnum getItemSupUpdateType(String updateType) {
        if (AccountUpdateTypeEnum.useAmount.getValue().equalsIgnoreCase(updateType)) {
            return ItemSupUpdateTypeEnum.orderreduce;
        }
        if (AccountUpdateTypeEnum.useAmountRelease.getValue().equalsIgnoreCase(updateType)) {
            return ItemSupUpdateTypeEnum.orderreducerelease;
        }
        if (AccountUpdateTypeEnum.amountOccupy.getValue().equalsIgnoreCase(updateType)) {
            return ItemSupUpdateTypeEnum.orderoccupy;
        }
        if (AccountUpdateTypeEnum.amountRelease.getValue().equalsIgnoreCase(updateType)) {
            return ItemSupUpdateTypeEnum.orderrelease;
        }
        if (AccountUpdateTypeEnum.billClose.getValue().equalsIgnoreCase(updateType)) {
            return ItemSupUpdateTypeEnum.closebill;
        }
        if (AccountUpdateTypeEnum.billUnClose.getValue().equalsIgnoreCase(updateType)) {
            return ItemSupUpdateTypeEnum.unclosebill;
        }
        if (AccountUpdateTypeEnum.settlementPayment.getValue().equalsIgnoreCase(updateType)) {
            return ItemSupUpdateTypeEnum.reimbursement;
        }
        return ItemSupUpdateTypeEnum.balanceadjust;
    }

    private static void calculateRebateAccount(List<AccountRecord> calculateList, DynamicObject account, List<DynamicObject> updateRebateAccountList, List<DynamicObject> accountRecordList) {
        for (AccountRecord param : calculateList) {
            String updateType = param.getUpdateType();
            if (AccountUpdateTypeEnum.useAmountRelease.getValue().equalsIgnoreCase(updateType)) {
                param.setAmount(param.getAmount().negate());
            }
            DynamicObject rebateRecord = RebateCalculateHelper.buildRebateRecord(param, account, updateType);
            RebateCalculateHelper.updateRebateAccountAmount(param, account, updateType);
            rebateRecord.set("afteramount", (Object)account.getBigDecimal("balance"));
            accountRecordList.add(rebateRecord);
        }
        updateRebateAccountList.add(account);
    }

    private static DynamicObject buildRebateRecord(AccountRecord param, DynamicObject account, String updateType) {
        RecordUpdateTypeEnum recordUpdateType = RebateCalculateHelper.getRecordUpdateType(updateType);
        if (AccountUpdateTypeEnum.balanceAdjust.getValue().equalsIgnoreCase(updateType) && ("A".equalsIgnoreCase(param.getBillType()) || "E".equalsIgnoreCase(param.getBillType()) || "name".equalsIgnoreCase(param.getBillEntity()) || "occpic_rebatestatement".equalsIgnoreCase(param.getBillEntity()))) {
            recordUpdateType = RecordUpdateTypeEnum.JSZF;
        }
        DynamicObject rebateRecord = RebateAccountHelper.buildAccountRecord(param, recordUpdateType);
        rebateRecord.set("beforeamount", (Object)account.getBigDecimal("balance"));
        return rebateRecord;
    }

    private static void updateRebateAccountAmount(AccountRecord param, DynamicObject account, String updateType) {
        if (AccountUpdateTypeEnum.balanceAdjust.getValue().equalsIgnoreCase(updateType)) {
            BigDecimal balance = account.getBigDecimal("balance").add(param.getAmount());
            if (param.isUpdateOccupy() && ("occba_balanceadjust".equalsIgnoreCase(param.getBillEntity()) || "C".equalsIgnoreCase(param.getBillType()))) {
                BigDecimal occupyAmount = account.getBigDecimal("occupyamount").subtract(param.getAmount().abs());
                account.set("occupyamount", (Object)occupyAmount);
            }
            account.set("balance", (Object)balance);
        } else if (AccountUpdateTypeEnum.amountOccupy.getValue().equalsIgnoreCase(updateType)) {
            BigDecimal afterOccupyAmount = account.getBigDecimal("occupyamount").add(param.getAmount());
            account.set("occupyamount", (Object)afterOccupyAmount);
        } else if (AccountUpdateTypeEnum.amountRelease.getValue().equalsIgnoreCase(updateType)) {
            BigDecimal afterOccupyAmount = account.getBigDecimal("occupyamount").subtract(param.getAmount());
            account.set("occupyamount", (Object)afterOccupyAmount);
        } else if (AccountUpdateTypeEnum.useAmount.getValue().equalsIgnoreCase(updateType)) {
            BigDecimal afterAccountAmount = account.getBigDecimal("balance").subtract(param.getAmount());
            if (param.getAmount().compareTo(BigDecimal.ZERO) > 0 && param.isUpdateOccupy()) {
                BigDecimal occupyAmount = account.getBigDecimal("occupyamount").subtract(param.getAmount());
                account.set("occupyamount", (Object)occupyAmount);
            }
            account.set("balance", (Object)afterAccountAmount);
        } else if (AccountUpdateTypeEnum.useAmountRelease.getValue().equalsIgnoreCase(updateType)) {
            BigDecimal afterAccountAmount = account.getBigDecimal("balance").subtract(param.getAmount());
            account.set("balance", (Object)afterAccountAmount);
        } else if (AccountUpdateTypeEnum.billClose.getValue().equalsIgnoreCase(updateType)) {
            BigDecimal balance = account.getBigDecimal("balance").add(param.getAmount());
            account.set("balance", (Object)balance);
        } else if (AccountUpdateTypeEnum.billUnClose.getValue().equalsIgnoreCase(updateType)) {
            BigDecimal balance = account.getBigDecimal("balance").subtract(param.getAmount());
            account.set("balance", (Object)balance);
        } else if (AccountUpdateTypeEnum.amountfrozen.getValue().equalsIgnoreCase(updateType)) {
            BigDecimal newOccupyAmount = account.getBigDecimal("occupyamount").add(param.getAmount());
            account.set("occupyamount", (Object)newOccupyAmount);
        } else if (AccountUpdateTypeEnum.amountunfrozen.getValue().equalsIgnoreCase(updateType)) {
            BigDecimal newOccupyAmount = account.getBigDecimal("occupyamount").subtract(param.getAmount());
            account.set("occupyamount", (Object)newOccupyAmount);
        } else if (AccountUpdateTypeEnum.settlementPayment.getValue().equalsIgnoreCase(updateType)) {
            BigDecimal balance = account.getBigDecimal("balance").add(param.getAmount());
            account.set("balance", (Object)balance);
        }
        account.set("updatedatetime", (Object)TimeServiceHelper.now());
        account.set("availablebalance", (Object)account.getBigDecimal("balance").subtract(account.getBigDecimal("occupyamount")));
    }

    public static void buildSuccessServiceResultList(List<AccountRecord> satisfiedAccountList, List<ServiceResult> serviceResultList) {
        Map<String, List<AccountRecord>> accountMap = satisfiedAccountList.stream().collect(Collectors.groupingBy(AccountRecord::getSourceBillNo));
        for (Map.Entry<String, List<AccountRecord>> calculateAccount : accountMap.entrySet()) {
            serviceResultList.add(RebateCalculateHelper.buildSuccessServiceResult(calculateAccount.getValue().get(0)));
        }
    }

    public static Map<String, DynamicObject> getQueryRebateAccountInfoMap(List<AccountRecord> satisfiedAccountList) {
        Map<String, DynamicObject> rebateAccountMap = RebateAccountHelper.getQueryRebateAccountInfoMap(satisfiedAccountList);
        for (AccountRecord accountRecord : satisfiedAccountList) {
            DynamicObject accountInfo = rebateAccountMap.get(accountRecord.getKey());
            accountRecord.setId(DynamicObjectUtils.getPkValue((DynamicObject)accountInfo));
        }
        return rebateAccountMap;
    }

    private static boolean isNeedAddNew(AccountRecord param) {
        return "E".equalsIgnoreCase(param.getBillType()) || "occba_moneyincome".equalsIgnoreCase(param.getBillEntity()) || "A".equalsIgnoreCase(param.getBillType()) || "occpic_rebatestatement".equalsIgnoreCase(param.getBillEntity()) || "C".equalsIgnoreCase(param.getBillType()) || "occba_balanceadjust".equalsIgnoreCase(param.getBillEntity());
    }

    private static void rollbackItemSuppData(Set<Object> newItemSuppIds, Set<Object> newItemSupRecordIds) {
        QFilter qFilter = new QFilter("id", "in", newItemSuppIds);
        DeleteServiceHelper.delete((String)"occba_supplement", (QFilter[])qFilter.toArray());
        qFilter = new QFilter("id", "in", newItemSupRecordIds);
        DeleteServiceHelper.delete((String)"occba_suprecord", (QFilter[])qFilter.toArray());
    }
}

