/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.business.rebateservice;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.operate.EnumBillStatus;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.entity.AccountRecord;
import kd.occ.ocbase.common.entity.ServiceResult;
import kd.occ.ocbase.common.enums.AccountUpdateTypeEnum;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.occba.business.rebateservice.RebateAccountServiceHelper;
import kd.occ.occba.business.rebateservice.RebateCalculateHelper;
import org.apache.commons.collections.CollectionUtils;

public class RebateServiceHelper {
    private static final long WITH_TIME = 120000L;
    private static Log logger = LogFactory.getLog(RebateServiceHelper.class);

    public static List<ServiceResult> getCalculateResults(List<AccountRecord> paramList, AccountUpdateTypeEnum updateType, boolean isThrowException) {
        return RebateServiceHelper.calculateRebateAccount(paramList, isThrowException);
    }

    public static List<ServiceResult> getCalculateResults(List<AccountRecord> paramList, boolean isThrowException) {
        return RebateServiceHelper.calculateRebateAccount(paramList, isThrowException);
    }

    private static List<ServiceResult> calculateRebateAccount(List<AccountRecord> paramList, boolean isThrowException) {
        int size = CollectionUtils.isEmpty(paramList) ? 0 : paramList.size();
        ArrayList<ServiceResult> serviceResultList = new ArrayList<ServiceResult>(size);
        Map<String, DynamicObject> rebateAccountMap = RebateCalculateHelper.getQueryRebateAccountInfoMap(paramList);
        Map<String, DynamicObject> suppMap = RebateCalculateHelper.getSupplementInfoMap(paramList);
        paramList = RebateCalculateHelper.getSatisfiedCalculateRebateList(rebateAccountMap, suppMap, paramList, serviceResultList, isThrowException);
        RebateCalculateHelper.updateAccountAndSuppItem(rebateAccountMap, suppMap, paramList);
        RebateCalculateHelper.buildSuccessServiceResultList(paramList, serviceResultList);
        return serviceResultList;
    }

    public static DynamicObject[] queryRebateAccount(DynamicObject bill, long balRuleId) {
        String entityKey = bill.getDataEntityType().getName();
        if (entityKey.equals("ocbsoc_returnmobedit")) {
            entityKey = "ocbsoc_returnorder";
        } else if (entityKey.equals("ocdma_saleorder_add")) {
            entityKey = "ocbsoc_saleorder";
        }
        QFilter qFilter = new QFilter("balobj", "=", (Object)"ocdbd_rebateaccount");
        qFilter.and("status", "=", (Object)EnumBillStatus.C);
        qFilter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        qFilter.and("srcbill", "=", (Object)entityKey);
        if (balRuleId > 0L) {
            qFilter.and("id", "=", (Object)balRuleId);
        }
        DynamicObject balUpdateRule = QueryServiceHelper.queryOne((String)"ocdbd_balupdaterule", (String)"id", (QFilter[])qFilter.toArray());
        long balUpdateRuleId = DynamicObjectUtils.getLong((DynamicObject)balUpdateRule, (String)"id");
        qFilter = new QFilter("id", "=", (Object)balUpdateRuleId);
        String selectFields = "id,dimdataentity.dimbalcol as dimbalcol,dimdataentity.dimbillcol as dimbillcol,dimdataentity.dimvaltype as dimvaltype,dimdataentity.dimfixedvalue as dimfixedvalue";
        DynamicObjectCollection dimDataColl = QueryServiceHelper.query((String)"ocdbd_balupdaterule", (String)selectFields, (QFilter[])qFilter.toArray());
        return RebateServiceHelper.queryRebateAccount(dimDataColl, bill, entityKey);
    }

    private static DynamicObject[] queryRebateAccount(DynamicObjectCollection dimDataColl, DynamicObject bill, String entityKey) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(0);
        RebateServiceHelper.getBalUpdateBillData(resultList, bill, dimDataColl, entityKey);
        HashSet<Long> rebateAccountIds = new HashSet<Long>(0);
        for (Map map : resultList) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(0);
            String rebateAccountType = "";
            if (dimDataColl.stream().anyMatch(x -> DynamicObjectUtils.getString((DynamicObject)x, (String)"dimbalcol").equals("type")) && map.containsKey("type")) {
                rebateAccountType = CommonUtils.convertObjectToString(map.get("type"));
            }
            for (DynamicObject dimData : dimDataColl) {
                QFilter qFilter;
                String dimBalCol = DynamicObjectUtils.getString((DynamicObject)dimData, (String)"dimbalcol");
                String dimValType = DynamicObjectUtils.getString((DynamicObject)dimData, (String)"dimvaltype");
                if (dimValType.equals("4")) {
                    String fixedValue = DynamicObjectUtils.getString((DynamicObject)dimData, (String)"dimfixedvalue");
                    CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)fixedValue, CRFormula.class);
                    String expression = formula.getExpression();
                    QFilter qFilter2 = new QFilter(dimBalCol, "=", (Object)expression);
                    qFilters.add(qFilter2);
                    continue;
                }
                if (!dimValType.equals("1") || rebateAccountType.equals("A") && dimBalCol.equals("receivechannel") || rebateAccountType.equals("B") && (dimBalCol.equals("org") || dimBalCol.equals("customer"))) continue;
                if (map.containsKey(dimBalCol)) {
                    qFilter = new QFilter(dimBalCol, "=", map.get(dimBalCol));
                    String dimValue = CommonUtils.convertObjectToString(map.get(dimBalCol));
                    if (StringUtils.isEmpty((CharSequence)dimValue) || StringUtils.equals((CharSequence)dimValue, (CharSequence)"0")) {
                        qFilter.or(dimBalCol, "is null", null);
                    }
                } else {
                    qFilter = new QFilter(dimBalCol, "=", (Object)0L);
                    qFilter.or(dimBalCol, "is null", null);
                }
                qFilters.add(qFilter);
            }
            if (qFilters.size() <= 0) continue;
            String filterKey = ((Object)qFilters).toString();
            logger.info(String.format("\u6309\u7ef4\u5ea6\u67e5\u8be2\u8d44\u91d1\u6c60\u8fc7\u6ee4\u6761\u4ef6\uff1a%s", filterKey));
            List rebateAccountList = QueryServiceHelper.queryPrimaryKeys((String)"ocdbd_rebateaccount", (QFilter[])qFilters.toArray(new QFilter[0]), null, (int)1000);
            if (rebateAccountList.size() == 0) continue;
            for (Object rebateAccountId : rebateAccountList) {
                rebateAccountIds.add(CommonUtils.stringToLong(rebateAccountId));
            }
        }
        MainEntityType rebateAccountType = EntityMetadataCache.getDataEntityType((String)"ocdbd_rebateaccount");
        return BusinessDataServiceHelper.load((Object[])rebateAccountIds.toArray(), (DynamicObjectType)rebateAccountType);
    }

    private static void getBillData(List<Map<String, Object>> resultList, DynamicObjectCollection cfgColl, Map<String, Object> mapHead, List<Map<String, Object>> mapEntry, List<Map<String, Object>> mapSubEntry, String entityKey) {
        if (!mapSubEntry.isEmpty()) {
            for (Map<String, Object> mapSubItem : mapSubEntry) {
                Map mapEntryItem;
                if (mapEntry.isEmpty()) continue;
                Object billId = mapSubItem.get("id");
                Object entryId = mapSubItem.get("entryid");
                Object detailId = mapSubItem.get("detailid");
                HashMap<String, Object> dataItem = resultList.stream().filter(x -> x.get("detailid").equals(detailId)).findFirst().orElse(null);
                if (dataItem == null) {
                    dataItem = new HashMap<String, Object>(0);
                }
                if ((mapEntryItem = (Map)mapEntry.stream().filter(x -> x.get("entryid").equals(entryId)).findFirst().orElse(null)) == null) continue;
                RebateServiceHelper.setDataItem(cfgColl, dataItem, mapHead, mapEntryItem, mapSubItem, entityKey);
                if (!resultList.stream().noneMatch(x -> x.get("detailid").equals(detailId))) continue;
                dataItem.put("id", billId);
                dataItem.put("entryid", entryId);
                dataItem.put("detailid", detailId);
                resultList.add(dataItem);
            }
        } else if (!mapEntry.isEmpty()) {
            for (Map<String, Object> mapEntryItem : mapEntry) {
                HashMap<String, Object> mapSubItem = new HashMap<String, Object>(0);
                Object billId = mapEntryItem.get("id");
                Object entryId = mapEntryItem.get("entryid");
                HashMap<String, Object> dataItem = resultList.stream().filter(x -> x.get("entryid").equals(entryId)).findFirst().orElse(null);
                if (dataItem == null) {
                    dataItem = new HashMap<String, Object>(0);
                }
                RebateServiceHelper.setDataItem(cfgColl, dataItem, mapHead, mapEntryItem, mapSubItem, entityKey);
                if (!resultList.stream().noneMatch(x -> x.get("entryid").equals(entryId))) continue;
                dataItem.put("id", billId);
                dataItem.put("entryid", entryId);
                resultList.add(dataItem);
            }
        } else if (!mapHead.isEmpty()) {
            HashMap<String, Object> mapEntryItem = new HashMap<String, Object>(0);
            HashMap<String, Object> mapSubItem = new HashMap<String, Object>(0);
            Object id = mapHead.get("id");
            HashMap<String, Object> dataItem = resultList.stream().filter(x -> x.get("id").equals(id)).findFirst().orElse(null);
            if (dataItem == null) {
                dataItem = new HashMap<String, Object>(0);
            }
            RebateServiceHelper.setDataItem(cfgColl, dataItem, mapHead, mapEntryItem, mapSubItem, entityKey);
            if (resultList.stream().noneMatch(x -> x.get("id").equals(id))) {
                dataItem.put("id", id);
                resultList.add(dataItem);
            }
        }
    }

    private static void setDataItem(DynamicObjectCollection cfgColl, Map<String, Object> dataItem, Map<String, Object> billHead, Map<String, Object> billEntry, Map<String, Object> billSubEntry, String entityKey) {
        String entryName = cfgColl.getDynamicObjectType().getName();
        for (DynamicObject cfg : cfgColl) {
            String valType = DynamicObjectUtils.getString((DynamicObject)cfg, (String)"dimvaltype");
            String colName = DynamicObjectUtils.getString((DynamicObject)cfg, (String)"dimbalcol");
            String billCol = DynamicObjectUtils.getString((DynamicObject)cfg, (String)"dimbillcol");
            if (StringUtils.equals((CharSequence)valType, (CharSequence)"1")) {
                RebateServiceHelper.setDataItem(billHead, dataItem, colName, billCol, entityKey);
                RebateServiceHelper.setDataItem(billEntry, dataItem, colName, billCol, entityKey);
                RebateServiceHelper.setDataItem(billSubEntry, dataItem, colName, billCol, entityKey);
                continue;
            }
            if ((!StringUtils.equals((CharSequence)valType, (CharSequence)"4") || !StringUtils.isNotEmpty((CharSequence)"dimfixedvalue")) && (!StringUtils.equals((CharSequence)valType, (CharSequence)"2") || !StringUtils.isNotEmpty((CharSequence)"dimfixedvalue") || !StringUtils.equals((CharSequence)entryName, (CharSequence)"flowdataentity"))) continue;
            String fixedValue = DynamicObjectUtils.getString((DynamicObject)cfg, (String)"dimfixedvalue");
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)fixedValue, CRFormula.class);
            String expression = formula.getExpression();
            dataItem.put(colName, expression);
        }
    }

    private static void setDataItem(Map<String, Object> mapData, Map<String, Object> dataItem, String colName, String billCol, String entityKey) {
        if (!mapData.isEmpty()) {
            if (entityKey.equals("ocdma_saleorder_add") && billCol.equals("accounttypeid")) {
                billCol = "accounttype";
            }
            if (mapData.containsKey(billCol)) {
                dataItem.put(colName, mapData.get(billCol));
            }
        }
    }

    private static void getBalUpdateBillData(List<Map<String, Object>> resultList, DynamicObject bill, DynamicObjectCollection dataColl, String entityKey) {
        HashSet<String> headCol = new HashSet<String>(0);
        HashSet<String> entryCol = new HashSet<String>(0);
        HashSet<String> subEntryCol = new HashSet<String>(0);
        HashMap<String, Object> mapHead = new HashMap<String, Object>(0);
        HashMap<String, String> entryKeySet = new HashMap<String, String>(0);
        ArrayList<Map<String, Object>> mapEntry = new ArrayList<Map<String, Object>>(0);
        ArrayList<Map<String, Object>> mapSubEntry = new ArrayList<Map<String, Object>>(0);
        MainEntityType srcEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        if (dataColl != null && dataColl.size() > 0) {
            RebateServiceHelper.getConfigCol(srcEntityType, dataColl, headCol, entryCol, subEntryCol, entryKeySet);
            String entryKey = null;
            if (entryKeySet.containsKey("entry")) {
                entryKey = (String)entryKeySet.get("entry");
            }
            String subEntryKey = null;
            if (entryKeySet.containsKey("subentry")) {
                subEntryKey = (String)entryKeySet.get("subentry");
            }
            RebateAccountServiceHelper.getBalUpdateBillData(srcEntityType, bill, mapHead, mapEntry, mapSubEntry, headCol, entryCol, subEntryCol, entryKey, subEntryKey);
            RebateServiceHelper.getBillData(resultList, dataColl, mapHead, mapEntry, mapSubEntry, bill.getDataEntityType().getName());
        }
    }

    private static void getConfigCol(MainEntityType srcEntityType, DynamicObjectCollection dataColl, Set<String> headCol, Set<String> entryCol, Set<String> subEntryCol, Map<String, String> entryKeySet) {
        for (DynamicObject data : dataColl) {
            IDataEntityType proParent;
            String[] proCols;
            IDataEntityProperty pro;
            String billCol = DynamicObjectUtils.getString((DynamicObject)data, (String)"dimbillcol");
            String valType = DynamicObjectUtils.getString((DynamicObject)data, (String)"dimvaltype");
            if (!StringUtils.equals((CharSequence)valType, (CharSequence)"1") || !StringUtils.isNotEmpty((CharSequence)billCol) || (pro = srcEntityType.findProperty((proCols = billCol.split("\\."))[0])) == null || (proParent = pro.getParent()) == null) continue;
            String proName = proParent.getName();
            if (pro instanceof EntryProp) {
                entryCol.add(billCol);
                entryKeySet.put("entry", pro.getName());
                continue;
            }
            if (proParent instanceof MainEntityType) {
                headCol.add(billCol);
                continue;
            }
            if (proParent instanceof SubEntryType) {
                subEntryCol.add(billCol);
                entryKeySet.put("subentry", proName);
                continue;
            }
            if (!(proParent instanceof EntryType)) continue;
            entryCol.add(billCol);
            entryKeySet.put("entry", proName);
        }
    }

    public static List<DLock> batchCreateDLockList(List<AccountRecord> paramList) {
        if (CollectionUtils.isEmpty(paramList)) {
            return new ArrayList<DLock>(0);
        }
        Map<String, AccountRecord> paramMap = paramList.stream().collect(Collectors.toMap(a -> a.getKey(), a -> a, (k1, k2) -> k1));
        ArrayList<DLock> lockList = new ArrayList<DLock>(paramMap.size());
        logger.info("---------------\u6279\u91cf\u83b7\u53d6\u8d44\u91d1\u9501\u4fe1\u606f\u5f00\u59cb----------------------------");
        List needDlockList = paramMap.values().stream().sorted(Comparator.comparingLong(AccountRecord::getOrgId).thenComparing(AccountRecord::getChannelId).thenComparing(AccountRecord::getCustomerId).thenComparing(AccountRecord::getCurrencyId).thenComparing(AccountRecord::getAccountType).thenComparing(AccountRecord::getReceiveChannelId)).collect(Collectors.toList());
        for (AccountRecord paramInfo : needDlockList) {
            DLock dLock = DLock.create((String)paramInfo.getKey());
            try {
                if (dLock.tryLock(120000L)) {
                    lockList.add(dLock);
                    continue;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u5728\u89c4\u5b9a\u65f6\u95f4\u5185\u83b7\u53d6\u5230\u8d44\u91d1\u9501\u3002", (String)"RebateServiceHelper_0", (String)"occ-occba-business", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.error(String.format("\u6279\u91cf\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff0c\u5931\u8d25\u7684\u539f\u56e0\u662f\uff1a%s", e.getMessage()));
                String errorMessage = String.format(ResManager.loadKDString((String)"\u6279\u91cf\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff0c\u5931\u8d25\u7684\u539f\u56e0\u662f\uff1a%1$s", (String)"RebateServiceHelper_2", (String)"occ-occba-business", (Object[])new Object[0]), e.getMessage());
                RebateServiceHelper.batchReleaseDLockList(lockList);
                throw new KDBizException(errorMessage);
            }
        }
        logger.info("---------------\u6279\u91cf\u83b7\u53d6\u8d44\u91d1\u9501\u4fe1\u606f\u7ed3\u675f----------------------------");
        return lockList;
    }

    public static void batchReleaseDLockList(List<DLock> dLockList) {
        if (CollectionUtils.isEmpty(dLockList)) {
            return;
        }
        logger.info("---------------\u6279\u91cf\u91ca\u653e\u8d44\u91d1\u9501\u5f00\u59cb----------------------------");
        for (DLock lock : dLockList) {
            if (lock == null) continue;
            lock.unlock();
        }
        logger.info("---------------\u6279\u91cf\u91ca\u653e\u8d44\u91d1\u9501\u7ed3\u675f----------------------------");
    }
}

