/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.formplugin.accountuse;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.occ.ocbase.common.util.BigDecimalUtil;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.Convert;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.formplugin.base.OcbaseFormPlugin;
import kd.occ.occba.business.rebate.RebateAccountUseHelper;

public class RebateAccountUsePlugin
extends OcbaseFormPlugin {
    public void beforeBindData(EventObject e) {
        Object value;
        Map cashPoolIdMap;
        super.beforeBindData(e);
        long billId = CommonUtils.getLongCustomParamValue((IFormView)this.getView(), (String)"billid");
        String billFormId = CommonUtils.getStringCustomParamValue((IFormView)this.getView(), (String)"billformid");
        DynamicObject useDynObj = RebateAccountUseHelper.createUseRecordByBill((long)billId, (String)billFormId);
        if (useDynObj != null) {
            DynamicObjectUtils.copyPropertiesWithOutId((DynamicObject)this.getModel().getDataEntity(true), (DynamicObject)useDynObj);
        }
        if (!CommonUtils.isNull((Object)(cashPoolIdMap = (Map)(value = CommonUtils.getCustomParamValue((IFormView)this.getView(), (String)"cashpoolids"))))) {
            DynamicObjectCollection useEntryColl = this.getView().getModel().getEntryEntity("entryentity");
            BigDecimal totalUsedAmount = BigDecimal.ZERO;
            for (DynamicObject useEntryDynObj : useEntryColl) {
                DynamicObjectCollection useSubEntryColl = useEntryDynObj.getDynamicObjectCollection("subentryentity");
                BigDecimal sumUsedAmount = BigDecimal.ZERO;
                for (DynamicObject subEntryDynObj : useSubEntryColl) {
                    long cashPoolId = subEntryDynObj.getLong("cashpoolid");
                    BigDecimal usedAmount = Convert.toBigDecimal(cashPoolIdMap.get(cashPoolId));
                    subEntryDynObj.set("subusedamount", (Object)usedAmount);
                    sumUsedAmount = sumUsedAmount.add(usedAmount);
                }
                useEntryDynObj.set("usedamount", (Object)sumUsedAmount);
                boolean isSelect = sumUsedAmount.compareTo(BigDecimal.ZERO) != 0;
                useEntryDynObj.set("isselect", (Object)isSelect);
                totalUsedAmount = totalUsedAmount.add(useEntryDynObj.getBigDecimal("usedamount"));
            }
            BigDecimal availableAmount = Convert.toBigDecimal((Object)this.getValue("availableamount"));
            this.setValue("totalunusedamount", availableAmount.subtract(totalUsedAmount));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.triggerChangeEvent) {
            return;
        }
        String key = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = this.getRowIndex(e);
        switch (key) {
            case "usedamount": {
                BigDecimal usedAmount = BigDecimalUtil.toBigDecimal((Object)this.getValue("usedamount", rowIndex));
                BigDecimal balanceAmount = BigDecimalUtil.toBigDecimal((Object)this.getValue("balamount", rowIndex));
                if (balanceAmount.compareTo(BigDecimal.ZERO) > 0 && usedAmount.compareTo(BigDecimal.ZERO) < 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u4f7f\u7528\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u8d44\u91d1\u4f59\u989d\u4e14\u4e0d\u5141\u8bb8\u5c0f\u4e8e0\u3002", (String)"RebateAccountUsePlugin_0", (String)"occ-occba-formplugin", (Object[])new Object[0]));
                    this.setValue("usedamount", oldValue, rowIndex, false);
                    return;
                }
                if (balanceAmount.compareTo(BigDecimal.ZERO) < 0 && (usedAmount.compareTo(BigDecimal.ZERO) > 0 || balanceAmount.abs().compareTo(usedAmount.abs()) < 0)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u4f7f\u7528\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e\u8d44\u91d1\u4f59\u989d\u4e14\u4e0d\u5141\u8bb8\u5927\u4e8e0\u3002", (String)"RebateAccountUsePlugin_1", (String)"occ-occba-formplugin", (Object[])new Object[0]));
                    this.setValue("usedamount", oldValue, rowIndex, false);
                    return;
                }
                if (usedAmount.compareTo(balanceAmount.abs()) > 0) {
                    this.setValue("usedamount", oldValue, rowIndex, false);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u4f7f\u7528\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4f59\u989d\u3002", (String)"RebateAccountUsePlugin_2", (String)"occ-occba-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject useEntryDynObj = this.getModel().getEntryRowEntity("entryentity", rowIndex);
                this.calcSubUsedAmount(useEntryDynObj);
                boolean select = useEntryDynObj.getBigDecimal("usedamount").compareTo(BigDecimal.ZERO) != 0;
                this.setValue("isselect", select, rowIndex, false);
                if (!select) {
                    this.selectChange(false, rowIndex);
                }
                this.triggerChangeEvent = true;
                break;
            }
            case "isselect": {
                boolean isSelect = this.getBooleanValue("isselect", rowIndex);
                this.selectChange(isSelect, rowIndex);
                DynamicObject useEntryDynObj = this.getModel().getEntryRowEntity("entryentity", rowIndex);
                if (isSelect) {
                    this.calcSubUsedAmount(useEntryDynObj);
                    break;
                }
                if (useEntryDynObj == null) {
                    return;
                }
                DynamicObjectCollection useSubEntryColl = useEntryDynObj.getDynamicObjectCollection("subentryentity");
                for (DynamicObject subEntryDynObj : useSubEntryColl) {
                    subEntryDynObj.set("subusedamount", (Object)BigDecimal.ZERO);
                }
                this.getView().updateView("subentryentity");
                break;
            }
            case "totalusedamount": {
                BigDecimal totalUsedAmount = Convert.toBigDecimal((Object)this.getValue("totalusedamount"));
                BigDecimal availableAmount = Convert.toBigDecimal((Object)this.getValue("availableamount"));
                this.setValue("totalunusedamount", availableAmount.subtract(totalUsedAmount));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("confirm".equals(key) && e.getOperationResult().isSuccess()) {
            String billFormId = CommonUtils.getStringCustomParamValue((IFormView)this.getView(), (String)"billformid");
            DynamicObject billDynObj = RebateAccountUseHelper.createUseEntityByUseRecord((DynamicObject)this.getModel().getDataEntity(true), (String)billFormId);
            this.getView().returnDataToParent((Object)billDynObj);
            this.getView().close();
        }
    }

    private void calcSubUsedAmount(DynamicObject useEntryDynObj) {
        if (useEntryDynObj == null) {
            return;
        }
        DynamicObjectCollection useSubEntryColl = useEntryDynObj.getDynamicObjectCollection("subentryentity");
        for (DynamicObject subEntryDynObj : useSubEntryColl) {
            subEntryDynObj.set("subusedamount", (Object)BigDecimal.ZERO);
        }
        BigDecimal sumUsedAmount = useEntryDynObj.getBigDecimal("usedamount");
        BigDecimal sumBalAmount = useEntryDynObj.getBigDecimal("balamount");
        for (DynamicObject subEntryDynObj : useSubEntryColl) {
            BigDecimal subAmount = BigDecimal.ZERO;
            BigDecimal subBalanceAmount = subEntryDynObj.getBigDecimal("subbalamount");
            if (sumBalAmount.compareTo(sumUsedAmount) == 0) {
                subAmount = subBalanceAmount;
            } else {
                int rlt;
                if (sumUsedAmount.compareTo(BigDecimal.ZERO) == 0) break;
                if (sumUsedAmount.compareTo(BigDecimal.ZERO) > 0) {
                    if (subBalanceAmount.compareTo(BigDecimal.ZERO) < 0) {
                        subAmount = subBalanceAmount;
                        sumUsedAmount = sumUsedAmount.subtract(subBalanceAmount);
                    } else if (subBalanceAmount.compareTo(BigDecimal.ZERO) > 0) {
                        rlt = sumUsedAmount.subtract(subBalanceAmount).compareTo(BigDecimal.ZERO);
                        if (rlt > 0) {
                            subAmount = subBalanceAmount;
                            sumUsedAmount = sumUsedAmount.subtract(subBalanceAmount);
                        } else {
                            subAmount = sumUsedAmount;
                            sumUsedAmount = BigDecimal.ZERO;
                        }
                    }
                } else if (sumUsedAmount.compareTo(BigDecimal.ZERO) < 0) {
                    if (subBalanceAmount.compareTo(BigDecimal.ZERO) > 0) {
                        subAmount = subBalanceAmount;
                        sumUsedAmount = sumUsedAmount.subtract(subBalanceAmount);
                    } else if (subBalanceAmount.compareTo(BigDecimal.ZERO) < 0) {
                        rlt = sumUsedAmount.subtract(subBalanceAmount).compareTo(BigDecimal.ZERO);
                        if (rlt < 0) {
                            subAmount = subBalanceAmount;
                            sumUsedAmount = sumUsedAmount.subtract(subBalanceAmount);
                        } else {
                            subAmount = sumUsedAmount;
                            sumUsedAmount = BigDecimal.ZERO;
                        }
                    }
                }
            }
            subEntryDynObj.set("subusedamount", (Object)subAmount);
        }
        this.getView().updateView("subentryentity");
    }

    private void selectChange(boolean isSelect, int rowIndex) {
        BigDecimal usedAmount;
        BigDecimal defaultUsedAmount = BigDecimal.ZERO;
        if (isSelect) {
            defaultUsedAmount = Convert.toBigDecimal((Object)this.getValue("balamount", rowIndex));
        }
        if ((usedAmount = Convert.toBigDecimal((Object)this.getValue("usedamount", rowIndex))).compareTo(BigDecimal.ZERO) == 0) {
            this.setValue("usedamount", defaultUsedAmount, rowIndex, false);
        }
    }
}

