/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.formplugin.amountadjust;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.enums.AccountPoolTypeEnum;
import kd.occ.ocbase.common.util.BillTypeParameterHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.IsBusinessOrgUtil;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.ocbase.formplugin.base.OcbaseBillPlugin;
import kd.occ.occba.business.rebate.IncentiveBalanceHelper;
import kd.occ.occba.business.rebateservice.RebateServiceHelper;

public class AmountAdjFormPlugin
extends OcbaseBillPlugin {
    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject signparty;
        super.propertyChanged(e);
        String cname = e.getProperty().getName();
        ChangeData[] data = e.getChangeSet();
        int index = data[0].getRowIndex();
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        if ("signparty".equals(cname) && (signparty = (DynamicObject)this.getModel().getValue("signparty")) != null) {
            this.getModel().setValue("org", (Object)signparty.getDynamicObject("frepresentativeorg"));
        }
        if ("org".equals(cname) && !entry.isEmpty()) {
            if (SysParamsUtil.isUseRebateAmount()) {
                for (int i = 0; i < entry.size(); ++i) {
                    this.getModel().setValue("accountamount", (Object)this.getAccountBalance((DynamicObject)entry.get(i)), i);
                }
            }
            if (SysParamsUtil.isEnableBalModel()) {
                this.getAccountBalance();
            }
        }
        if ("channel".equals(cname)) {
            String adjustType = this.getStringValue("adjusttype");
            if (AccountPoolTypeEnum.BRANDS.getValue().equalsIgnoreCase(adjustType)) {
                DynamicObject channel = data[0].getDataEntity().getDynamicObject("channel");
                if (null != channel) {
                    Long channelid = channel.getLong("id");
                    DynamicObject chanl = BusinessDataServiceHelper.loadSingle((Object)channelid, (String)"ocdbd_channel");
                    DynamicObject customer = chanl.getDynamicObject("customer");
                    if (null != customer) {
                        this.getModel().setValue("customer", customer.get("id"), index);
                    } else {
                        this.getModel().setValue("customer", null, index);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6e20\u9053\u6ca1\u6709\u76f4\u63a5\u5ba2\u6237,\u8bf7\u91cd\u65b0\u9009\u62e9\u6e20\u9053\u3002", (String)"AmountAdjFormPlugin_0", (String)"occ-occba-formplugin", (Object[])new Object[0]));
                    }
                }
            } else {
                this.getModel().setValue("customer", null, index);
            }
            DynamicObject channelInfo = this.getF7Value("channel", index);
            if (channelInfo != null) {
                this.getModel().setValue("currency", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channelInfo.getDynamicObject("currency")), index);
            } else {
                this.getModel().setValue("currency", null, index);
            }
            DynamicObject billType = this.getF7Value("billtype");
            DynamicObject billTypeParam = BillTypeParameterHelper.getBillTypeParameter((String)"occba_balanceadjust", (long)DynamicObjectUtils.getPkValue((DynamicObject)billType));
            long defaultAccountTypeId = DynamicObjectUtils.getPkValue((DynamicObject)billTypeParam.getDynamicObject("accounttype"));
            this.getModel().setValue("accounttype", (Object)defaultAccountTypeId, index);
        }
        if (index >= 0 && ("channel".equals(cname) || "currency".equals(cname) || "customer".equals(cname))) {
            BigDecimal accountAmount = BigDecimal.ZERO;
            if (SysParamsUtil.isUseRebateAmount()) {
                accountAmount = this.getAccountBalance((DynamicObject)entry.get(index));
                this.getModel().setValue("accountamount", (Object)accountAmount, index);
                BigDecimal addAmount = ((DynamicObject)entry.get(index)).getBigDecimal("adjustamount");
                this.getModel().setValue("adjustedamount", (Object)accountAmount.add(addAmount), index);
            }
            if (SysParamsUtil.isEnableBalModel()) {
                this.getAccountBalance();
            }
        }
        if ("adjustamount".equals(cname) || "accountamount".equals(cname)) {
            BigDecimal addAmount = ((DynamicObject)entry.get(index)).getBigDecimal("adjustamount");
            BigDecimal beforeAmount = ((DynamicObject)entry.get(index)).getBigDecimal("accountamount");
            this.getModel().setValue("adjustedamount", (Object)addAmount.add(beforeAmount), index);
        }
        if ("billtype".equalsIgnoreCase(cname)) {
            DynamicObject billType = this.getF7Value("billtype");
            if (null == billType) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AmountAdjFormPlugin_2", (String)"occ-occba-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject billTypeParam = BillTypeParameterHelper.getBillTypeParameter((String)"occba_balanceadjust", (long)DynamicObjectUtils.getPkValue((DynamicObject)billType));
            long defaultAccountTypeId = DynamicObjectUtils.getPkValue((DynamicObject)billTypeParam.getDynamicObject("accounttype"));
            if (entry.isEmpty()) {
                return;
            }
            for (int i = 0; i < entry.size(); ++i) {
                this.getModel().setValue("accounttype", (Object)defaultAccountTypeId, i);
            }
        }
    }

    private BigDecimal getAccountBalance(DynamicObject entry) {
        DynamicObject receiveChannel = this.getF7Value("receivechannel");
        long receiveChannelId = AccountPoolTypeEnum.CHANNEL.getValue().equalsIgnoreCase(this.getStringValue("adjusttype")) ? DynamicObjectUtils.getPkValue((DynamicObject)receiveChannel) : 0L;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject channel = entry.getDynamicObject("channel");
        DynamicObject customer = entry.getDynamicObject("customer");
        DynamicObject accounttype = entry.getDynamicObject("accounttype");
        DynamicObject currency = entry.getDynamicObject("currency");
        DynamicObject rebateAccount = IncentiveBalanceHelper.queryRebateAccount((long)DynamicObjectUtils.getPkValue((DynamicObject)org), (long)DynamicObjectUtils.getPkValue((DynamicObject)customer), (long)DynamicObjectUtils.getPkValue((DynamicObject)channel), (long)receiveChannelId, (long)DynamicObjectUtils.getPkValue((DynamicObject)accounttype), (long)DynamicObjectUtils.getPkValue((DynamicObject)currency));
        return rebateAccount == null ? BigDecimal.ZERO : rebateAccount.getBigDecimal("balance");
    }

    private void getAccountBalance() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
        if (entryEntity == null || entryEntity.size() == 0) {
            return;
        }
        DynamicObject[] balanceDynObjs = RebateServiceHelper.queryRebateAccount((DynamicObject)dataEntity, (long)0L);
        if (balanceDynObjs == null || balanceDynObjs.length == 0) {
            for (DynamicObject entryItem : entryEntity) {
                BigDecimal addAmount = entryItem.getBigDecimal("adjustamount");
                entryItem.set("accountamount", (Object)BigDecimal.ZERO);
                entryItem.set("adjustedamount", (Object)BigDecimal.ZERO.add(addAmount));
            }
            return;
        }
        String adjustType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"adjusttype");
        List<DynamicObject> balanceObjLst = Arrays.asList(balanceDynObjs);
        for (DynamicObject entryItem : entryEntity) {
            BigDecimal balanceAmount = BigDecimal.ZERO;
            long accountTypeId = DynamicObjectUtils.getPkValue((DynamicObject)entryItem, (String)"accounttype");
            long customerId = DynamicObjectUtils.getPkValue((DynamicObject)entryItem, (String)"customer");
            long channelId = DynamicObjectUtils.getPkValue((DynamicObject)entryItem, (String)"channel");
            long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)entryItem, (String)"currency");
            DynamicObject balanceDynObj = adjustType.equals("A") ? (DynamicObject)balanceObjLst.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"accounttype") == accountTypeId && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"customer") == customerId && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"channel") == channelId && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"setcurrency") == currencyId).findFirst().orElse(null) : (DynamicObject)balanceObjLst.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"accounttype") == accountTypeId && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"channel") == channelId && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"setcurrency") == currencyId).findFirst().orElse(null);
            BigDecimal addAmount = entryItem.getBigDecimal("adjustamount");
            if (balanceDynObj == null) {
                entryItem.set("accountamount", (Object)BigDecimal.ZERO);
                entryItem.set("adjustedamount", (Object)BigDecimal.ZERO.add(addAmount));
                continue;
            }
            if (accountTypeId == DynamicObjectUtils.getPkValue((DynamicObject)balanceDynObj, (String)"accounttype")) {
                balanceAmount = balanceAmount.add(balanceDynObj.getBigDecimal("balance"));
            }
            entryItem.set("accountamount", (Object)balanceAmount);
            entryItem.set("adjustedamount", (Object)balanceAmount.add(addAmount));
        }
        this.getView().updateView("entryentity");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        DynamicObject billType = this.getF7Value("billtype");
        DynamicObject billTypeParam = BillTypeParameterHelper.getBillTypeParameter((String)"occba_balanceadjust", (long)DynamicObjectUtils.getPkValue((DynamicObject)billType));
        long defaultAccountTypeId = DynamicObjectUtils.getPkValue((DynamicObject)billTypeParam.getDynamicObject("accounttype"));
        DynamicObjectCollection entryList = this.getModel().getEntryEntity("entryentity");
        if (entryList.isEmpty()) {
            return;
        }
        for (int i = 0; i < entryList.size(); ++i) {
            this.getModel().setValue("accounttype", (Object)defaultAccountTypeId, i);
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObject dataEntity;
        DynamicObjectCollection billHeadLk;
        super.afterBindData(e);
        if ((this.getModel().getValue("billstatus").toString().equals("A") || this.getModel().getValue("billstatus").toString().equals("B")) && ((billHeadLk = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)(dataEntity = this.getView().getModel().getDataEntity(true)), (String)"billhead_lk")) == null || billHeadLk.size() == 0)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            if (SysParamsUtil.isUseRebateAmount()) {
                for (int index = 0; index < entryEntity.getRowCount(); ++index) {
                    this.getModel().setValue("accountamount", (Object)this.getAccountBalance((DynamicObject)entryEntity.get(index)), index);
                }
            }
            if (SysParamsUtil.isEnableBalModel()) {
                this.getAccountBalance();
            }
        }
        this.hideBusinessOrg();
        String adjustType = this.getStringValue("adjusttype");
        if (AccountPoolTypeEnum.BRANDS.getValue().equalsIgnoreCase(adjustType)) {
            this.setMustInput("org", true);
            this.setMustInput("customer", true);
            this.setMustInput("receivechannel", false);
        } else {
            this.setMustInput("org", false);
            this.setMustInput("customer", false);
            this.setMustInput("receivechannel", true);
        }
    }

    private void hideBusinessOrg() {
        boolean isbusinessorg = SysParamsUtil.isBusinessOrg();
        if (!isbusinessorg) {
            DynamicObject[] promotiondeployList;
            for (DynamicObject promotiondeploy : promotiondeployList = IsBusinessOrgUtil.hideBusinessOrg()) {
                String number = promotiondeploy.getString("number");
                if ("001".equals(number)) {
                    this.setValue("areadept", promotiondeploy);
                }
                if ("00101".equals(number)) {
                    this.setValue("rptoffice", promotiondeploy);
                }
                if (!"0010101".equals(number)) continue;
                this.setValue("country", promotiondeploy.getDynamicObject("countryarea"));
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"areadept"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"rptoffice"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"country"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setValue("adjusttime", KDDateUtils.now());
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map paramMap = showParameter.getCustomParams();
        Object isFromReportValue = paramMap == null ? null : paramMap.get("isFromReport");
        boolean isFromReport = false;
        if (isFromReportValue != null) {
            isFromReport = isFromReportValue;
        }
        if (isFromReport) {
            DynamicObject[] rebateAccountList;
            this.getModel().setValue("billtype", (Object)1184064738158648320L);
            this.getModel().setValue("org", paramMap.get("orgId"));
            this.getModel().setValue("adjusttype", (Object)"A");
            DynamicObjectCollection entry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            List rebateAccountIdList = (List)paramMap.get("rebateAccountIdList");
            String selectProperties = String.join((CharSequence)",", "org", "balance", "channel", "receivechannel", "customer", "availablebalance", "setcurrency", "availablebalance", "accounttype");
            QFilter filter = new QFilter("id", "in", (Object)rebateAccountIdList);
            for (DynamicObject account : rebateAccountList = BusinessDataServiceHelper.load((String)"ocdbd_rebateaccount", (String)selectProperties, (QFilter[])filter.toArray())) {
                DynamicObject addNew = entry.addNew();
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)addNew, (String)"customer", (long)DynamicObjectUtils.getPkValue((DynamicObject)account, (String)"customer"));
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)addNew, (String)"channel", (long)DynamicObjectUtils.getPkValue((DynamicObject)account, (String)"channel"));
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)addNew, (String)"accounttype", (long)DynamicObjectUtils.getPkValue((DynamicObject)account, (String)"accounttype"));
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)addNew, (String)"currency", (long)DynamicObjectUtils.getPkValue((DynamicObject)account, (String)"setcurrency"));
                BigDecimal adjustAmount = (BigDecimal)paramMap.get("adjustAmount");
                addNew.set("adjustamount", (Object)adjustAmount);
                addNew.set("accountamount", (Object)account.getBigDecimal("balance"));
                addNew.set("adjustedamount", (Object)account.getBigDecimal("balance").add(adjustAmount));
            }
            BusinessDataServiceHelper.loadRefence((Object[])entry.toArray(), (IDataEntityType)entry.getDynamicObjectType());
            this.getView().updateView("entryentity");
        }
    }
}

