/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.formplugin.amountadjust;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.common.enums.channel.ChannelSupplyRelation;
import kd.occ.ocbase.common.util.BillTypeParameterHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.formplugin.base.OcbaseBillPlugin;
import org.apache.commons.collections.CollectionUtils;

public class CusAmountAdjFormPlugin
extends OcbaseBillPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setValue("adjusttype", "B");
        this.setValue("receivechannel", B2BUserHelper.getLoginChannelId());
        this.getModel().setValue("accounttype", (Object)this.getAmountAccount(), 0);
    }

    private long getAmountAccount() {
        DynamicObject billType = this.getF7Value("billtype");
        DynamicObject billTypeParam = BillTypeParameterHelper.getBillTypeParameter((String)"occba_cusbalancadjust_b2b", (long)DynamicObjectUtils.getPkValue((DynamicObject)billType));
        return DynamicObjectUtils.getPkValue((DynamicObject)billTypeParam.getDynamicObject("accounttype"));
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntity;
        if ("entryentity".equals(e.getEntryProp().getName()) && (rowDataEntity = e.getRowDataEntities()) != null && rowDataEntity.length > 0) {
            long amountAccount = this.getAmountAccount();
            for (RowDataEntity rowData : rowDataEntity) {
                this.setValue("accounttype", amountAccount, rowData.getRowIndex());
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"channel"});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "channel": {
                long receiveChannelId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("receivechannel"));
                if (receiveChannelId > 0L) {
                    DynamicObjectCollection resultCol = QueryServiceHelper.query((String)"ocdbd_channel_authorize", (String)"orderchannel", (QFilter[])F7Utils.getEnableFilter().and("supplyrelation", "=", (Object)ChannelSupplyRelation.SUPPLY_CHANNEL.getValue()).and("salechannel", "=", (Object)receiveChannelId).toArray());
                    if (CollectionUtils.isNotEmpty((Collection)resultCol)) {
                        HashSet channelIdSet = new HashSet(100);
                        channelIdSet.addAll(resultCol.stream().map(r -> r.getLong("orderchannel")).collect(Collectors.toSet()));
                        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", channelIdSet));
                        break;
                    }
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)0L));
                    break;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)0L));
                break;
            }
        }
    }
}

