/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.formplugin.balanceoccupy;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.ocbase.formplugin.base.OcbaseBillPlugin;
import kd.occ.occba.business.rebate.IncentiveBalanceHelper;
import kd.occ.occba.business.rebateservice.RebateServiceHelper;

public class BalanceOccupyEdit
extends OcbaseBillPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"channel"});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "channel": {
                List channelIdList = CUserHelper.getAuthorizedChannelIdList((long)UserUtil.getCurrUserId(), (boolean)false);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)channelIdList));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String cname = e.getProperty().getName();
        ChangeData[] data = e.getChangeSet();
        int index = data[0].getRowIndex();
        DynamicObject dataEntity = data[0].getDataEntity();
        switch (cname) {
            case "org": {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                if (SysParamsUtil.isUseRebateAmount()) {
                    for (int i = 0; i < entryEntity.getRowCount(); ++i) {
                        this.recalculateEntryAmount((DynamicObject)entryEntity.get(i), i);
                    }
                }
                if (SysParamsUtil.isEnableBalModel()) {
                    this.getAccountBalance();
                }
                this.getView().updateView("entryentity");
                break;
            }
            case "channel": {
                String occupyType = this.getStringValue("occupytype");
                DynamicObject channel = data[0].getDataEntity().getDynamicObject("channel");
                if ("B".equalsIgnoreCase(occupyType) || channel == null) {
                    this.getModel().setValue("customer", (Object)0L, index);
                } else {
                    this.getModel().setValue("customer", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channel, (String)"customer"), index);
                }
                if (channel == null) {
                    this.getModel().setValue("currency", (Object)0L, index);
                } else {
                    this.getModel().setValue("currency", (Object)DynamicObjectUtils.getPkValue((DynamicObject)channel, (String)"currency"), index);
                }
                if (SysParamsUtil.isUseRebateAmount()) {
                    this.recalculateEntryAmount(dataEntity, index);
                }
                if (!SysParamsUtil.isEnableBalModel()) break;
                this.getAccountBalance();
                this.getView().updateView("entryentity");
                break;
            }
            case "occupyamount": {
                BigDecimal occupyAmount = dataEntity.getBigDecimal("occupyamount");
                BigDecimal oldAvailableAmount = dataEntity.getBigDecimal("oldavailableamount");
                this.getModel().setValue("newavailableamount", (Object)oldAvailableAmount.subtract(occupyAmount), index);
                break;
            }
        }
    }

    private void recalculateEntryAmount(DynamicObject dataEntity, int index) {
        DynamicObject balanceAccount = this.queryBalanceAccountAmount(dataEntity);
        BigDecimal occupyAmount = dataEntity.getBigDecimal("occupyamount");
        if (balanceAccount == null) {
            this.getModel().setValue("accountamount", (Object)BigDecimal.ZERO, index);
            this.getModel().setValue("oldavailableamount", (Object)BigDecimal.ZERO, index);
            this.getModel().setValue("newavailableamount", (Object)occupyAmount.negate(), index);
            return;
        }
        BigDecimal balance = balanceAccount.getBigDecimal("balance");
        BigDecimal oldAvailableAmount = balanceAccount.getBigDecimal("availablebalance");
        BigDecimal newAvailableAmount = oldAvailableAmount.add(occupyAmount);
        this.getModel().setValue("accountamount", (Object)balance, index);
        this.getModel().setValue("oldavailableamount", (Object)oldAvailableAmount, index);
        this.getModel().setValue("newavailableamount", (Object)newAvailableAmount, index);
    }

    private void getAccountBalance() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
        if (entryEntity == null || entryEntity.size() == 0) {
            return;
        }
        String occupyType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"occupytype");
        DynamicObject[] balanceDynObjs = RebateServiceHelper.queryRebateAccount((DynamicObject)dataEntity, (long)0L);
        if (balanceDynObjs == null || balanceDynObjs.length == 0) {
            for (DynamicObject entryItem : entryEntity) {
                BigDecimal occupyAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"occupyamount");
                entryItem.set("accountamount", (Object)BigDecimal.ZERO);
                entryItem.set("oldavailableamount", (Object)BigDecimal.ZERO);
                entryItem.set("newavailableamount", (Object)occupyAmount.negate());
            }
            return;
        }
        List<DynamicObject> balanceObjLst = Arrays.asList(balanceDynObjs);
        for (DynamicObject entryItem : entryEntity) {
            BigDecimal balanceAmount = BigDecimal.ZERO;
            BigDecimal oldAvailableAmount = BigDecimal.ZERO;
            BigDecimal occupyAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"occupyamount");
            long accountTypeId = DynamicObjectUtils.getPkValue((DynamicObject)entryItem, (String)"accounttype");
            long customerId = DynamicObjectUtils.getPkValue((DynamicObject)entryItem, (String)"customer");
            long channelId = DynamicObjectUtils.getPkValue((DynamicObject)entryItem, (String)"channel");
            long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)entryItem, (String)"currency");
            DynamicObject balanceDynObj = occupyType.equals("A") ? (DynamicObject)balanceObjLst.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"accounttype") == accountTypeId && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"customer") == customerId && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"channel") == channelId && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"currency") == currencyId).findFirst().orElse(null) : (DynamicObject)balanceObjLst.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"accounttype") == accountTypeId && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"channel") == channelId && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"currency") == currencyId).findFirst().orElse(null);
            if (balanceDynObj != null) {
                balanceAmount = balanceAmount.add(balanceDynObj.getBigDecimal("balance"));
                oldAvailableAmount = oldAvailableAmount.add(balanceDynObj.getBigDecimal("availablebalance"));
                BigDecimal newAvailableAmount = oldAvailableAmount.add(occupyAmount);
                entryItem.set("accountamount", (Object)balanceAmount);
                entryItem.set("oldavailableamount", (Object)oldAvailableAmount);
                entryItem.set("newavailableamount", (Object)newAvailableAmount);
                continue;
            }
            entryItem.set("accountamount", (Object)BigDecimal.ZERO);
            entryItem.set("oldavailableamount", (Object)BigDecimal.ZERO);
            entryItem.set("newavailableamount", (Object)occupyAmount.negate());
        }
    }

    private DynamicObject queryBalanceAccountAmount(DynamicObject dataEntity) {
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("org"));
        long customerId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity.getDynamicObject("customer"));
        long receiveChannelId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("receivechannel"));
        long chanelId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity.getDynamicObject("channel"));
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity.getDynamicObject("currency"));
        long accountTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity.getDynamicObject("accounttype"));
        return IncentiveBalanceHelper.queryRebateAccount((long)orgId, (long)customerId, (long)chanelId, (long)receiveChannelId, (long)accountTypeId, (long)currencyId);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }
}

