/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.formplugin.balanceoccupy;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.BillTypeParameterHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.formplugin.base.OcbaseBillPlugin;

public class BrandBalanceOccupyEdit
extends OcbaseBillPlugin {
    public void afterAddRow(AfterAddRowEventArgs e) {
        DynamicObject billType = this.getF7Value("billtype");
        long accountTypeId = this.getDefaultAccountTypeId(billType);
        for (RowDataEntity rowDataEntity : e.getRowDataEntities()) {
            int index = rowDataEntity.getRowIndex();
            this.getModel().setValue("accounttype", (Object)accountTypeId, index);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.updateEntryBillTypeValues();
    }

    private void updateEntryBillTypeValues() {
        DynamicObject billType = this.getF7Value("billtype");
        long accountTypeId = this.getDefaultAccountTypeId(billType);
        DynamicObjectCollection entry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entry.size(); ++i) {
            this.getModel().setValue("accounttype", (Object)accountTypeId, i);
        }
    }

    private long getDefaultAccountTypeId(DynamicObject billType) {
        DynamicObject billTypeParam = BillTypeParameterHelper.getBillTypeParameter((String)"occba_occupybalance_pp", (long)DynamicObjectUtils.getPkValue((DynamicObject)billType));
        return DynamicObjectUtils.getPkValue((DynamicObject)billTypeParam.getDynamicObject("accounttype"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String key = op.getOperateKey();
        OperationResult opResult = e.getOperationResult();
        if (opResult == null || !opResult.isSuccess()) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (StringUtils.equals((CharSequence)key, (CharSequence)"submit")) {
            dataEntity.set("occupystatus", (Object)"B");
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)key, (CharSequence)"unaudit")) {
            dataEntity.set("occupystatus", (Object)"A");
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"releaseoccupy")) {
            dataEntity.set("occupystatus", (Object)"C");
            dataEntity.set("releaseuser", (Object)RequestContext.get().getCurrUserId());
            dataEntity.set("releasedate", (Object)KDDateUtils.now());
        } else {
            return;
        }
        SaveServiceHelper.update((DynamicObject)dataEntity);
        this.getView().getModel().setDataChanged(false);
        this.getView().updateView();
    }
}

