/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.formplugin.botp.baladjust;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildDrawFilterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.occ.ocbase.common.util.BillTypeParameterHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;

public class RebateAccountPushBalAdjustConvertPlugin
extends AbstractConvertPlugIn {
    private static final String P_bos_billtype = "bos_billtype";
    private static final String F_billformid = "billformid";

    public void afterBuildDrawFilter(AfterBuildDrawFilterEventArgs e) {
        DynamicObject targetDataEntity = e.getTargetDataEntity();
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)targetDataEntity, (String)"billtype");
        DynamicObject dynObj = BillTypeParameterHelper.getBillTypeParameter((String)"occba_balanceadjust", (long)billTypeId);
        if (dynObj != null) {
            String adjustType;
            long receiveChannelId;
            long accountTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dynObj, (String)"accounttype");
            QFilter qFilter = new QFilter("accounttype", "=", (Object)accountTypeId);
            long orgId = DynamicObjectUtils.getPkValue((DynamicObject)targetDataEntity, (String)"org");
            if (orgId > 0L) {
                qFilter.and("org", "=", (Object)orgId);
            }
            if ((receiveChannelId = DynamicObjectUtils.getPkValue((DynamicObject)targetDataEntity, (String)"receivechannel")) > 0L) {
                qFilter.and("receivechannel", "=", (Object)receiveChannelId);
            }
            if (StringUtils.isNotEmpty((String)(adjustType = DynamicObjectUtils.getString((DynamicObject)targetDataEntity, (String)"adjusttype")))) {
                qFilter.and("type", "=", (Object)adjustType);
            }
            e.setPlugFilter(qFilter);
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] extendedDataEntities = entitySet.FindByEntityKey(tgtMainType);
        QFilter qFilter = new QFilter(F_billformid, "=", (Object)"occba_balanceadjust");
        DynamicObjectCollection billTypes = QueryServiceHelper.query((String)P_bos_billtype, (String)"id", (QFilter[])qFilter.toArray());
        HashMap<Long, Long> hasAccountType = new HashMap<Long, Long>(0);
        if (billTypes != null && billTypes.size() > 0) {
            for (DynamicObject billType : billTypes) {
                long accountTypeId;
                long billTypeId = DynamicObjectUtils.getLong((DynamicObject)billType, (String)"id");
                DynamicObject dynObj = BillTypeParameterHelper.getBillTypeParameter((String)"occba_balanceadjust", (long)billTypeId);
                if (dynObj == null || (accountTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dynObj, (String)"accounttype")) <= 0L) continue;
                hasAccountType.put(accountTypeId, billTypeId);
            }
        }
        if (hasAccountType.size() == 0) {
            return;
        }
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            long accountTypeId;
            DynamicObject billDynObj = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entryColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)billDynObj, (String)"entryentity");
            if (entryColl == null || entryColl.size() <= 0 || hasAccountType.get(accountTypeId = DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)entryColl.get(0)), (String)"accounttype")) == null) continue;
            long billTypeId = (Long)hasAccountType.get(accountTypeId);
            String selectFields = String.join((CharSequence)",", "id", "number", "name");
            qFilter = new QFilter("id", "=", (Object)billTypeId);
            DynamicObject billType = BusinessDataServiceHelper.loadSingle((String)P_bos_billtype, (String)selectFields, (QFilter[])qFilter.toArray());
            billDynObj.set("billtype", (Object)billType);
        }
    }
}

