/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.formplugin.channelbalance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.ocbase.formplugin.base.OcbaseListPlugin;
import kd.occ.ocbase.formplugin.template.BeForeF7Template;

public class ChannelBalanceList
extends OcbaseListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        CommonFilterColumn col = (CommonFilterColumn)args.getFilterColumn("channelid.name");
        List<ComboItem> comboItems = this.getComboItems();
        col.setComboItems(comboItems);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        String key;
        switch (key = e.getFieldName()) {
            case "channelid.name": 
            case "channelid.id": {
                if (!SysParamsUtil.isByChannelUser()) break;
                e.getQfilters().clear();
                BeForeF7Template.fastAddListF7Filter((BeforeFilterF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)CUserHelper.getAuthorizedChannelIdList()));
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (SysParamsUtil.isByChannelUser()) {
            e.addCustomQFilter(CUserHelper.getAuthorizedChannelFilter((String)"channelid", (boolean)false));
        }
    }

    private List<ComboItem> getComboItems() {
        List orderChannelIds = CUserHelper.getAuthorizedChannelIdList();
        if (CommonUtils.isNull((Object)orderChannelIds)) {
            return new ArrayList<ComboItem>(0);
        }
        Map orderChannel = BusinessDataServiceHelper.loadFromCache((Object[])orderChannelIds.toArray(), (String)"ocdbd_channel");
        if (orderChannel != null && orderChannel.size() > 0) {
            Collection collection = orderChannel.values();
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(collection.size());
            ComboItem channel = null;
            for (DynamicObject object : orderChannel.values()) {
                channel = new ComboItem();
                channel.setId(String.valueOf(object.get("id")));
                channel.setValue(String.valueOf(object.get("id")));
                channel.setCaption(new LocaleString(object.getString("name")));
                comboItems.add(channel);
            }
            return comboItems;
        }
        return new ArrayList<ComboItem>(0);
    }
}

