/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.formplugin.checkaccount;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.CodeRuleUtil;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.ocbase.formplugin.base.OcbaseFormPlugin;
import kd.sdk.occ.occba.extpoint.CheckAccountCreate;
import kd.sdk.occ.occba.extpoint.ICheckAccountCreate;

public class CheckAccountCheckList
extends OcbaseFormPlugin {
    public static final String DATE_DEFAULT_FORMAT = "yyyyMMdd";
    public static final String CREATECHECKACCOUNT = "createcheckaccount";
    private static final String LINETYPE_TOTAL = "1";
    private static final String LINETYPE_OTHER = "0";
    PluginProxy<ICheckAccountCreate> pluginProxy = PluginProxy.create((Object)new CheckAccountCreate(), ICheckAccountCreate.class, (String)"occ.occba.occba_checkaccountlist.ext", null);

    public void afterCreateNewData(EventObject e) {
        ReportList reportList = (ReportList)this.getView().getParentView().getControl("reportlistap");
        HashMap<String, String> checkListMap = new HashMap<String, String>();
        String dataRange = this.getDateRange();
        int totalRecord = reportList.getTotalRecords();
        DynamicObjectCollection reportDataList = reportList.getReportModel().getRowData(0, totalRecord, false);
        for (DynamicObject reportData : reportDataList) {
            String key;
            if (reportData == null || reportData.get("settleorgid") == null || reportData.get("balancecustomerid") == null || !LINETYPE_OTHER.equals(reportData.getString("linetype")) || checkListMap.containsKey(key = reportData.getLong("settleorgid_id") + "_" + reportData.getLong("balancechannelid_id") + "_" + reportData.getLong("balancecustomerid_id") + "_" + reportData.getLong("currencyid_id"))) continue;
            checkListMap.put(key, reportData.getString("settleorgid.name") + " + " + reportData.getString("balancechannelid.name") + " + " + reportData.getString("balancecustomerid.name") + " (" + dataRange + ")");
        }
        if (checkListMap.size() == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("entryentity", checkListMap.size());
        AtomicInteger atomicInteger = new AtomicInteger();
        long periodId = (Long)this.getView().getParentView().getModel().getValue("period_id");
        for (Map.Entry entry : checkListMap.entrySet()) {
            int index = atomicInteger.getAndIncrement();
            String[] keySplit = ((String)entry.getKey()).split("_");
            this.setValue("settleorg", keySplit[0], index);
            this.setValue("channel", keySplit[1], index);
            this.setValue("customer", keySplit[2], index);
            this.setValue("currency", keySplit[3], index);
            this.setValue("period", periodId, index);
            this.setValue("name", entry.getValue(), index);
        }
        super.afterCreateNewData(e);
    }

    private String getDateRange() {
        String periodType = (String)this.getView().getParentView().getModel().getValue("periodtype");
        if (LINETYPE_TOTAL.equals(periodType)) {
            DynamicObject period = (DynamicObject)this.getView().getParentView().getModel().getValue("period");
            return period != null ? period.getString("monthname") : "";
        }
        Date startDate = (Date)this.getView().getParentView().getModel().getValue("startdate");
        Date endDate = (Date)this.getView().getParentView().getModel().getValue("enddate");
        if (startDate != null && endDate != null) {
            return DateUtil.getDateFormat((Date)startDate, (String)DATE_DEFAULT_FORMAT) + " - " + DateUtil.getDateFormat((Date)endDate, (String)DATE_DEFAULT_FORMAT);
        }
        return "";
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (key = operate.getOperateKey()) {
            case "createcheckaccount": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryEntity");
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u751f\u6210\u7684\u5bf9\u8d26\u5355", (String)"CheckAccountCheckList_0", (String)"occ-occba-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                ArrayList<DynamicObject> checkAccountList = new ArrayList<DynamicObject>(selectRows.length);
                ReportList reportList = (ReportList)this.getView().getParentView().getControl("reportlistap");
                long periodId = (Long)this.getView().getParentView().getModel().getValue("period_id");
                Date startDate = (Date)this.getView().getParentView().getModel().getValue("startdate");
                Date endDate = (Date)this.getView().getParentView().getModel().getValue("enddate");
                boolean showbilldetail = (Boolean)this.getView().getParentView().getModel().getValue("showbilldetail");
                String[] billNoNew = CodeRuleUtil.batchCreateNumber((String)"occba_checkaccount", (int)selectRows.length);
                HashMap<String, DynamicObject> checkAccountNewRecord = new HashMap<String, DynamicObject>(selectRows.length);
                ArrayList<String> existBillName = new ArrayList<String>();
                AtomicInteger atoIndex = new AtomicInteger();
                for (int index : selectRows) {
                    DynamicObject entry = (DynamicObject)entryEntity.get(index);
                    long settleOrgId = entry.getLong("settleorg_id");
                    long channelId = entry.getLong("channel_id");
                    long customerId = entry.getLong("customer_id");
                    long currencyId = entry.getLong("currency_id");
                    String name = entry.getString("name");
                    boolean isExist = this.checkIfExistCheckAccount(settleOrgId, channelId, customerId, currencyId, periodId);
                    if (isExist) {
                        existBillName.add(name);
                        continue;
                    }
                    DynamicObject checkAccount = BusinessDataServiceHelper.newDynamicObject((String)"occba_checkaccount");
                    checkAccount.set("billno", (Object)billNoNew[atoIndex.getAndIncrement()]);
                    checkAccount.set("name", (Object)name);
                    checkAccount.set("settleorg", (Object)settleOrgId);
                    checkAccount.set("settlechannel", (Object)channelId);
                    checkAccount.set("customer", (Object)customerId);
                    checkAccount.set("currency", (Object)currencyId);
                    checkAccount.set("period", (Object)periodId);
                    checkAccount.set("startdate", (Object)startDate);
                    checkAccount.set("enddate", (Object)endDate);
                    checkAccount.set("isdetail", (Object)showbilldetail);
                    checkAccount.set("billstatus", (Object)"A");
                    checkAccount.set("checkstatus", (Object)"A");
                    checkAccount.set("invalidstatus", (Object)"A");
                    checkAccount.set("creator", (Object)UserUtil.getCurrUserId());
                    checkAccount.set("openingbalance", (Object)BigDecimal.ZERO);
                    checkAccount.set("payamount", (Object)BigDecimal.ZERO);
                    checkAccount.set("payableamount", (Object)BigDecimal.ZERO);
                    checkAccount.set("balance", (Object)BigDecimal.ZERO);
                    checkAccountNewRecord.put(settleOrgId + "_" + customerId + "_" + currencyId, checkAccount);
                    checkAccountList.add(checkAccount);
                }
                this.createCheckAccount(reportList, checkAccountNewRecord);
                SaveServiceHelper.save((DynamicObject[])checkAccountList.toArray(new DynamicObject[checkAccountList.size()]));
                StringBuilder message = new StringBuilder();
                message.append(String.format(ResManager.loadKDString((String)"\u6210\u529f\u751f\u6210%1$s\u5f20\u5bf9\u8d26\u5355", (String)"CheckAccountCheckList_1", (String)"occ-occba-formplugin", (Object[])new Object[0]), checkAccountList.size()));
                if (!existBillName.isEmpty()) {
                    message.append(',');
                    message.append(String.format(ResManager.loadKDString((String)"\u5931\u8d25\u7684\u6709%1$s\u5f20\u3002\u4e0d\u80fd\u91cd\u590d\u751f\u6210\u7684\u5355\u5982\u4e0b:%n", (String)"CheckAccountCheckList_3", (String)"occ-occba-formplugin", (Object[])new Object[0]), existBillName.size()));
                    for (String billName : existBillName) {
                        message.append(billName).append("\n");
                    }
                }
                this.getView().showMessage(message.toString());
                this.getView().close();
                break;
            }
        }
        super.beforeDoOperation(args);
    }

    private boolean checkIfExistCheckAccount(long settleOrgId, long channelId, long customerId, long currencyId, long periodId) {
        QFilter filter = new QFilter("settleorg", "=", (Object)settleOrgId);
        filter.and("settlechannel", "=", (Object)channelId);
        filter.and("customer", "=", (Object)customerId);
        filter.and("currency", "=", (Object)currencyId);
        filter.and("period", "=", (Object)periodId);
        filter.and("invalidstatus", "=", (Object)"A");
        return QueryServiceHelper.exists((String)"occba_checkaccount", (QFilter[])filter.toArray());
    }

    private void createCheckAccount(ReportList reportList, Map<String, DynamicObject> checkAccountNewRecord) {
        int totalRecord = reportList.getTotalRecords();
        DynamicObjectCollection reportDataList = reportList.getReportModel().getRowData(0, totalRecord, false);
        for (DynamicObject reportData : reportDataList) {
            String key = reportData.getLong("settleorgid_id") + "_" + reportData.getLong("balancecustomerid_id") + "_" + reportData.getLong("currencyid_id");
            if (!checkAccountNewRecord.containsKey(key)) continue;
            DynamicObject checkAccount = checkAccountNewRecord.get(key);
            switch (reportData.getString("linetype")) {
                case "1": {
                    checkAccount.set("payamount", (Object)reportData.getBigDecimal("paymentamount"));
                    checkAccount.set("payableamount", (Object)reportData.getBigDecimal("payableamount"));
                    checkAccount.set("adjustamount", (Object)reportData.getBigDecimal("ajustamount"));
                    checkAccount.set("balance", (Object)reportData.getBigDecimal("balanceamount"));
                    this.pluginProxy.callAfter(p -> {
                        p.beforCreateCheckAccount(reportData, checkAccount);
                        return null;
                    });
                    break;
                }
                case "0": {
                    DynamicObject entry = checkAccount.getDynamicObjectCollection("entryentity").addNew();
                    this.setValueFromReport(entry, reportData, "summary", "remark");
                    this.setValueFromReport(entry, reportData, "srcbillid", "srcbillid");
                    this.setValueFromReport(entry, reportData, "srcbillentity", "srcbillentity");
                    this.setValueFromReport(entry, reportData, "srcbilltype", "srcbilltype");
                    this.setValueFromReport(entry, reportData, "srcbillno", "srcbillno");
                    this.setValueFromReport(entry, reportData, "srcbillentryid", "srcbillentryid");
                    this.setValueFromReport(entry, reportData, "srcbillentryseq", "srcbillentryseq");
                    this.setValueFromReport(entry, reportData, "businessdate", "bizdate");
                    this.setValueFromReport(entry, reportData, "accountdate", "accountdate");
                    this.setValueFromReport(entry, reportData, "saleorg_entry", "saleorgid");
                    this.setValueFromReport(entry, reportData, "salechannel_entry", "salechannelid");
                    this.setValueFromReport(entry, reportData, "settleorg_entry", "settleorgid");
                    this.setValueFromReport(entry, reportData, "settlechannel_entry", "balancechannelid");
                    this.setValueFromReport(entry, reportData, "orderchannel_entry", "orderchannelid");
                    this.setValueFromReport(entry, reportData, "customer_entry", "balancecustomerid");
                    this.setValueFromReport(entry, reportData, "item", "itemid");
                    this.setValueFromReport(entry, reportData, "ispresent", "ispresent");
                    this.setValueFromReport(entry, reportData, "materiel", "materialid");
                    this.setValueFromReport(entry, reportData, "unit", "unitid");
                    this.setValueFromReport(entry, reportData, "qty", "qty");
                    this.setValueFromReport(entry, reportData, "actualtaxprice", "actualtaxprice");
                    this.setValueFromReport(entry, reportData, "entryopeningbalance", "initbalanceamount");
                    this.setValueFromReport(entry, reportData, "entrypayamount", "paymentamount");
                    this.setValueFromReport(entry, reportData, "entrypayableamount", "payableamount");
                    this.setValueFromReport(entry, reportData, "entryadjustamount", "ajustamount");
                    this.setValueFromReport(entry, reportData, "entryreceivableamount", "balanceamount");
                    if ("occba_channelbalance".equals(reportData.getString("remark"))) {
                        checkAccount.set("openingbalance", (Object)reportData.getBigDecimal("initbalanceamount"));
                    }
                    this.pluginProxy.callAfter(p -> {
                        p.beforCreateCheckAccountEntry(reportData, entry);
                        return null;
                    });
                    break;
                }
            }
        }
    }

    private void setValueFromReport(DynamicObject entry, DynamicObject reportData, String entryCol, String reportCol) {
        if (reportData.containsProperty(reportCol)) {
            entry.set(entryCol, reportData.get(reportCol));
        }
    }
}

