/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.formplugin.checkbusinessaccount;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.CodeRuleUtil;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.ocbase.formplugin.base.OcbaseFormPlugin;
import kd.sdk.occ.occba.extpoint.CheckBusinessAccountCreate;
import kd.sdk.occ.occba.extpoint.ICheckBusinessAccountCreate;

public class CheckBusAccountCheckList
extends OcbaseFormPlugin {
    public static final String DATE_DEFAULT_FORMAT = "yyyyMMdd";
    public static final String CREATECHECKACCOUNT = "createcheckaccount";
    private static final String REPORTLISTAP = "reportlistap";
    private static final String ENTRYENTITY = "entryentity";
    private static final String PERIOD = "period";
    private static final String LINETYPE_TOTAL = "1";
    private static final String LINETYPE_OTHER = "0";
    private static final String[] KEYWORDS = new String[]{"settleorgid", "balancechannelid", "balancecustomerid", "accountypeid", "currencyid"};
    PluginProxy<ICheckBusinessAccountCreate> pluginProxy = PluginProxy.create((Object)new CheckBusinessAccountCreate(), ICheckBusinessAccountCreate.class, (String)"occ.occba.occba_checkbusaccountlist.ext", null);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ReportList reportList = (ReportList)this.getView().getParentView().getControl(REPORTLISTAP);
        int totalRecord = reportList.getTotalRecords();
        HashMap<String, String> keyAndNameMap = new HashMap<String, String>();
        DynamicObjectCollection reportDataList = reportList.getReportModel().getRowData(0, totalRecord, false);
        for (DynamicObject reportData : reportDataList) {
            if (!LINETYPE_TOTAL.equals(reportData.getString("linetype"))) continue;
            keyAndNameMap.put(this.getReportKey(reportData), this.getReportKeyName(reportData));
        }
        if (keyAndNameMap.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, keyAndNameMap.size());
        AtomicInteger atomicInteger = new AtomicInteger();
        long periodId = (Long)this.getView().getParentView().getModel().getValue("period_id");
        for (Map.Entry entry : keyAndNameMap.entrySet()) {
            String[] keySplit;
            int index = atomicInteger.getAndIncrement();
            for (String keyValue : keySplit = ((String)entry.getKey()).split("_")) {
                this.setValue(keyValue.split("#")[0], keyValue.split("#")[1], index);
            }
            this.setValue("name", entry.getValue(), index);
            this.setValue(PERIOD, periodId, index);
        }
    }

    private String getReportKey(DynamicObject reportData) {
        StringBuilder key = new StringBuilder();
        for (String words : KEYWORDS) {
            key.append(words).append("#").append(reportData.getLong(words + "_" + "id")).append("_");
        }
        return key.substring(0, key.length() - 1);
    }

    private String getReportKeyName(DynamicObject reportData) {
        StringBuilder key = new StringBuilder();
        for (String words : KEYWORDS) {
            key.append(reportData.getString(words + "." + "name")).append(" + ");
        }
        return key.substring(0, key.length() - 1) + " (" + this.getDateRange() + ")";
    }

    private String getDateRange() {
        String periodType = (String)this.getView().getParentView().getModel().getValue("periodtype");
        if (LINETYPE_TOTAL.equals(periodType)) {
            DynamicObject period = (DynamicObject)this.getView().getParentView().getModel().getValue(PERIOD);
            return period != null ? period.getString("monthname") : "";
        }
        Date startDate = (Date)this.getView().getParentView().getModel().getValue("startdate");
        Date endDate = (Date)this.getView().getParentView().getModel().getValue("enddate");
        if (startDate != null && endDate != null) {
            return DateUtil.getDateFormat((Date)startDate, (String)DATE_DEFAULT_FORMAT) + " - " + DateUtil.getDateFormat((Date)endDate, (String)DATE_DEFAULT_FORMAT);
        }
        return "";
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (key = operate.getOperateKey()) {
            case "createcheckaccount": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u751f\u6210\u7684\u5bf9\u8d26\u5355", (String)"CheckBusAccountCheckList_0", (String)"occ-occba-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
                ArrayList<DynamicObject> checkAccountList = new ArrayList<DynamicObject>(selectRows.length);
                ReportList reportList = (ReportList)this.getView().getParentView().getControl(REPORTLISTAP);
                long periodId = (Long)this.getView().getParentView().getModel().getValue("period_id");
                Date startDate = (Date)this.getView().getParentView().getModel().getValue("startdate");
                Date endDate = (Date)this.getView().getParentView().getModel().getValue("enddate");
                String[] billNoNew = CodeRuleUtil.batchCreateNumber((String)"occba_checkaccount", (int)selectRows.length);
                HashMap<String, DynamicObject> checkAccountNewRecord = new HashMap<String, DynamicObject>(selectRows.length);
                ArrayList<String> existBillName = new ArrayList<String>();
                AtomicInteger atoIndex = new AtomicInteger();
                for (int index : selectRows) {
                    DynamicObject entry = (DynamicObject)entryEntity.get(index);
                    long settleOrgId = entry.getLong("settleorgid_id");
                    long channelId = entry.getLong("balancechannelid_id");
                    long customerId = entry.getLong("balancecustomerid_id");
                    long accountId = entry.getLong("accountypeid_id");
                    long currencyId = entry.getLong("currencyid_id");
                    String name = entry.getString("name");
                    boolean isExist = this.checkIfExistCheckAccount(settleOrgId, channelId, customerId, accountId, currencyId, periodId);
                    if (isExist) {
                        existBillName.add(name);
                        continue;
                    }
                    DynamicObject checkAccount = BusinessDataServiceHelper.newDynamicObject((String)"occba_checkbusaccount");
                    checkAccount.set("billno", (Object)billNoNew[atoIndex.getAndIncrement()]);
                    checkAccount.set("name", (Object)name);
                    checkAccount.set("settleorg", (Object)settleOrgId);
                    checkAccount.set("settlechannel", (Object)channelId);
                    checkAccount.set("customer", (Object)customerId);
                    checkAccount.set("account", (Object)accountId);
                    checkAccount.set("currency", (Object)currencyId);
                    checkAccount.set(PERIOD, (Object)periodId);
                    checkAccount.set("startdate", (Object)startDate);
                    checkAccount.set("enddate", (Object)endDate);
                    checkAccount.set("billstatus", (Object)"A");
                    checkAccount.set("checkstatus", (Object)"A");
                    checkAccount.set("invalidstatus", (Object)"A");
                    checkAccount.set("creator", (Object)UserUtil.getCurrUserId());
                    checkAccount.set("openingbalance", (Object)BigDecimal.ZERO);
                    checkAccount.set("entryamount", (Object)BigDecimal.ZERO);
                    checkAccount.set("adjustamount", (Object)BigDecimal.ZERO);
                    checkAccount.set("useamount", (Object)BigDecimal.ZERO);
                    checkAccount.set("rebateamount", (Object)BigDecimal.ZERO);
                    checkAccount.set("balance", (Object)BigDecimal.ZERO);
                    checkAccountNewRecord.put(settleOrgId + "_" + channelId + "_" + customerId + "_" + accountId + "_" + currencyId, checkAccount);
                    checkAccountList.add(checkAccount);
                }
                this.createCheckAccount(reportList, checkAccountNewRecord);
                SaveServiceHelper.save((DynamicObject[])checkAccountList.toArray(new DynamicObject[checkAccountList.size()]));
                StringBuilder message = new StringBuilder();
                message.append(String.format(ResManager.loadKDString((String)"\u6210\u529f\u751f\u6210%1$s\u5f20\u5bf9\u8d26\u5355", (String)"CheckBusAccountCheckList_1", (String)"occ-occba-formplugin", (Object[])new Object[0]), checkAccountList.size()));
                if (!existBillName.isEmpty()) {
                    message.append(',');
                    message.append(String.format(ResManager.loadKDString((String)"\u5931\u8d25\u7684\u6709%1$s\u5f20\u3002\u4e0d\u80fd\u91cd\u590d\u751f\u6210\u7684\u5355\u5982\u4e0b:%n", (String)"CheckBusAccountCheckList_3", (String)"occ-occba-formplugin", (Object[])new Object[0]), existBillName.size()));
                    for (String billName : existBillName) {
                        message.append(billName).append("\n");
                    }
                }
                this.getView().showMessage(message.toString());
                this.getView().close();
                break;
            }
        }
        super.beforeDoOperation(args);
    }

    private boolean checkIfExistCheckAccount(long settleOrgId, long channelId, long customerId, long accountId, long currencyId, long periodId) {
        QFilter filter = new QFilter("settleorg", "=", (Object)settleOrgId);
        filter.and("settlechannel", "=", (Object)channelId);
        filter.and("customer", "=", (Object)customerId);
        filter.and("account", "=", (Object)accountId);
        filter.and("currency", "=", (Object)currencyId);
        filter.and(PERIOD, "=", (Object)periodId);
        filter.and("invalidstatus", "=", (Object)"A");
        return QueryServiceHelper.exists((String)"occba_checkbusaccount", (QFilter[])filter.toArray());
    }

    private void createCheckAccount(ReportList reportList, Map<String, DynamicObject> checkAccountNewRecord) {
        int totalRecord = reportList.getTotalRecords();
        DynamicObjectCollection reportDataList = reportList.getReportModel().getRowData(0, totalRecord, false);
        for (DynamicObject reportData : reportDataList) {
            String key = reportData.getLong("settleorgid_id") + "_" + reportData.getLong("balancechannelid_id") + "_" + reportData.getLong("balancecustomerid_id") + "_" + reportData.getLong("accountypeid_id") + "_" + reportData.getLong("currencyid_id");
            if (!checkAccountNewRecord.containsKey(key)) continue;
            DynamicObject checkAccount = checkAccountNewRecord.get(key);
            switch (reportData.getString("linetype")) {
                case "1": {
                    checkAccount.set("entryamount", (Object)reportData.getBigDecimal("recordedamount"));
                    checkAccount.set("adjustamount", (Object)reportData.getBigDecimal("ajustamount"));
                    checkAccount.set("useamount", (Object)reportData.getBigDecimal("useamount"));
                    checkAccount.set("rebateamount", (Object)reportData.getBigDecimal("returnamount"));
                    checkAccount.set("balance", (Object)reportData.getBigDecimal("receivableamount"));
                    this.pluginProxy.callAfter(p -> {
                        p.beforCreateCheckAccount(reportData, checkAccount);
                        return null;
                    });
                    break;
                }
                case "0": {
                    DynamicObject entry = checkAccount.getDynamicObjectCollection(ENTRYENTITY).addNew();
                    this.setValueFromReport(entry, reportData, "summary", "remark");
                    this.setValueFromReport(entry, reportData, "srcbillid", "srcbillid");
                    this.setValueFromReport(entry, reportData, "srcbillentity", "srcbillentity");
                    this.setValueFromReport(entry, reportData, "srcbilltype", "srcbilltype");
                    this.setValueFromReport(entry, reportData, "srcbillno", "srcbillno");
                    this.setValueFromReport(entry, reportData, "businessdate", "bizdate");
                    this.setValueFromReport(entry, reportData, "settleorg_entry", "settleorgid");
                    this.setValueFromReport(entry, reportData, "settlechannel_entry", "balancechannelid");
                    this.setValueFromReport(entry, reportData, "customer_entry", "balancecustomerid");
                    this.setValueFromReport(entry, reportData, "account_entry", "accountypeid");
                    this.setValueFromReport(entry, reportData, "entryentryamount", "recordedamount");
                    this.setValueFromReport(entry, reportData, "entryadjustamount", "ajustamount");
                    this.setValueFromReport(entry, reportData, "entryuseamount", "useamount");
                    this.setValueFromReport(entry, reportData, "entryrebateamount", "returnamount");
                    this.setValueFromReport(entry, reportData, "entryreceivableamount", "receivableamount");
                    if (LINETYPE_OTHER.equals(reportData.getString("remark"))) {
                        checkAccount.set("openingbalance", (Object)reportData.getBigDecimal("receivableamount"));
                    }
                    this.pluginProxy.callAfter(p -> {
                        p.beforCreateCheckAccountEntry(reportData, entry);
                        return null;
                    });
                    break;
                }
            }
        }
    }

    private void setValueFromReport(DynamicObject entry, DynamicObject reportData, String entryCol, String reportCol) {
        if (reportData.containsProperty(reportCol)) {
            entry.set(entryCol, reportData.get(reportCol));
        }
    }
}

