/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.formplugin.flowrecord;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.common.enums.channel.ChannelSupplyRelation;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.ocbase.formplugin.base.OcbaseListPlugin;
import kd.occ.ocbase.formplugin.template.BeForeF7Template;
import org.apache.commons.collections.CollectionUtils;

public class CusFlowRecordList
extends OcbaseListPlugin {
    public void setFilter(SetFilterEvent arg0) {
        super.setFilter(arg0);
        arg0.getQFilters().add(new QFilter("receivechannel", "=", (Object)B2BUserHelper.getLoginChannelId()));
    }

    public void filterContainerInit(FilterContainerInitArgs e) {
        super.filterContainerInit(e);
        List columns = e.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn column : columns) {
            if (!"channel.name".equals(column.getFieldName())) continue;
            CommonFilterColumn col = (CommonFilterColumn)column;
            DynamicObjectCollection resultCol = this.getPayChannels();
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(5);
            if (CollectionUtils.isNotEmpty((Collection)resultCol)) {
                ComboItem item = null;
                for (DynamicObject channel : resultCol) {
                    item = new ComboItem();
                    item.setId(String.valueOf(channel.get("orderchannel")));
                    item.setValue(String.valueOf(channel.get("orderchannel")));
                    item.setCaption(new LocaleString(channel.getString("orderchannel.name")));
                    comboItems.add(item);
                }
            }
            col.setComboItems(comboItems);
        }
    }

    private DynamicObjectCollection getPayChannels() {
        long receivechannelid = B2BUserHelper.getLoginChannelId();
        return QueryServiceHelper.query((String)"ocdbd_channel_authorize", (String)"orderchannel,orderchannel.name", (QFilter[])F7Utils.getEnableFilter().and("supplyrelation", "=", (Object)ChannelSupplyRelation.SUPPLY_CHANNEL.getValue()).and("salechannel", "=", (Object)receivechannelid).toArray());
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent arg0) {
        String entityId;
        switch (entityId = arg0.getRefEntityId()) {
            case "ocdbd_channel": {
                DynamicObjectCollection resultCol = this.getPayChannels();
                HashSet channelIdSet = new HashSet(100);
                if (CollectionUtils.isNotEmpty((Collection)resultCol)) {
                    channelIdSet.addAll(resultCol.stream().map(r -> r.getLong("orderchannel")).collect(Collectors.toSet()));
                }
                BeForeF7Template.fastAddListF7Filter((BeforeFilterF7SelectEvent)arg0, (QFilter)new QFilter("id", "in", channelIdSet));
                break;
            }
            case "bos_org": 
            case "bd_customer": {
                BeForeF7Template.fastAddListF7Filter((BeforeFilterF7SelectEvent)arg0, (QFilter)new QFilter("id", "in", (Object)0L));
                break;
            }
            case "bos_user": {
                BeForeF7Template.fastAddListF7Filter((BeforeFilterF7SelectEvent)arg0, (QFilter)new QFilter("id", "=", (Object)UserUtil.getCurrUserId()));
                break;
            }
            default: {
                super.filterContainerBeforeF7Select(arg0);
            }
        }
    }
}

