/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.formplugin.itemsupadjust;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.message.service.pa.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.formplugin.base.OcbaseBillPlugin;
import kd.occ.occba.business.itemsupplement.ItemSupplementPoolHelper;
import org.apache.commons.collections.CollectionUtils;

public class ItemSupplementAdjustEdit
extends OcbaseBillPlugin
implements ItemClickListener,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BasedataEdit bdEdit = (BasedataEdit)this.getView().getControl("account");
        bdEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
    }

    private List<Long> getSupportItemAccountList() {
        QFilter filter = new QFilter("issupportitem", "=", (Object)true);
        DynamicObjectCollection accountTypeList = QueryServiceHelper.query((String)"ocdbd_incentiveaccount", (String)"id", (QFilter[])filter.toArray());
        return accountTypeList.stream().map(a -> a.getLong("id")).collect(Collectors.toList());
    }

    private QFilter getSupplementAccountFilter() {
        QFilter filter = new QFilter("rebateaccount", ">", (Object)0);
        DynamicObjectCollection supplementList = QueryServiceHelper.query((String)"occba_supplement", (String)"rebateaccount", (QFilter[])filter.toArray());
        List idList = supplementList.stream().map(a -> a.getLong("rebateaccount")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(idList)) {
            return null;
        }
        return new QFilter("id", "not in", idList);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.triggerChangeEvent) {
            this.triggerChangeEvent = true;
            return;
        }
        String key = e.getProperty().getName();
        int rowIndex = this.getRowIndex(e);
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        switch (key) {
            case "item": {
                DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.updateValuesAfterItemChanges(newValue, rowIndex);
                this.reloadSupQty(rowIndex);
                break;
            }
            case "adjustqty": {
                BigDecimal availableQty = ((DynamicObject)entry.get(rowIndex)).getBigDecimal("availableqty");
                BigDecimal adjustQty = ((DynamicObject)entry.get(rowIndex)).getBigDecimal("adjustqty");
                BigDecimal afterQty = availableQty.add(adjustQty);
                if (afterQty == null || afterQty.compareTo(BigDecimal.ZERO) < 0) {
                    this.setValue("adjustqty", 0, rowIndex, false);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u6574\u540e\u7684\u53ef\u7528\u6570\u91cf\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"ItemSupplementAdjustEdit_0", (String)"occ-occba-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.setValue("afterqty", afterQty, rowIndex, false);
                break;
            }
            case "customer": {
                this.reloadSupQty(rowIndex);
                break;
            }
            case "adjusttype": {
                entry.clear();
                this.getModel().setValue("entryentity", (Object)entry);
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    private void updateValuesAfterItemChanges(DynamicObject item, int rowIndex) {
        if (item == null) {
            return;
        }
        this.getModel().setValue("material", (Object)DynamicObjectUtils.getPkValue((DynamicObject)item, (String)"material"), rowIndex);
        this.getModel().setValue("unit", (Object)DynamicObjectUtils.getPkValue((DynamicObject)item, (String)"baseunit"), rowIndex);
    }

    private void reloadSupQty(int rowIndex) {
        long rebateAccountId;
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("org"));
        long channelId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("customer", rowIndex));
        long itemId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("item", rowIndex));
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("material", rowIndex));
        long auxptyId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("auxpty", rowIndex));
        long unitId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("unit", rowIndex));
        DynamicObject itemSup = ItemSupplementPoolHelper.queryItemSupplementInfo((long)orgId, (long)channelId, (long)itemId, (long)materialId, (long)unitId, (long)auxptyId, (long)(rebateAccountId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("account"))));
        if (itemSup == null) {
            this.getModel().setValue("itemsupplement", null, rowIndex);
            this.getModel().setValue("adjustqty", null, rowIndex);
            this.getModel().setValue("availableqty", null, rowIndex);
            return;
        }
        this.getModel().setValue("itemsupplement", (Object)DynamicObjectUtils.getPkValue((DynamicObject)itemSup), rowIndex);
        this.getModel().setValue("availableqty", (Object)itemSup.getBigDecimal("availableqty"), rowIndex);
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String itemKey;
        switch (itemKey = e.getItemKey()) {
            case "tb_new": {
                DynamicObject org = this.getF7Value("org");
                if (org == null) {
                    e.setCancel(true);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"ItemSupplementAdjustEdit_1", (String)"occ-occba-formplugin", (Object[])new Object[0]));
                    return;
                }
                String adjustType = this.getStringValue("adjusttype");
                if (StringUtil.isEmpty((String)adjustType)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8c03\u6574\u7c7b\u578b\u3002", (String)"ItemSupplementAdjustEdit_2", (String)"occ-occba-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject account = this.getF7Value("account");
                if (!"B".equalsIgnoreCase(adjustType) || account != null) break;
                e.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u8c03\u6574\u7c7b\u578b\u4e3a\u201c\u65b0\u589e\u8d26\u6237\u201d\u65f6\uff0c\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u6c60\u4f59\u989d\u3002", (String)"ItemSupplementAdjustEdit_3", (String)"occ-occba-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "tb_new": {
                String adjustType = this.getStringValue("adjusttype");
                if (StringUtil.isEmpty((String)adjustType)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8c03\u6574\u7c7b\u578b\u3002", (String)"ItemSupplementAdjustEdit_2", (String)"occ-occba-formplugin", (Object[])new Object[0]));
                    return;
                }
                if ("A".equalsIgnoreCase(adjustType)) {
                    ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"occba_supplement", (boolean)true);
                    showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addnewentry"));
                    showParameter.setCustomParam("org", (Object)DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("org")));
                    this.getView().showForm((FormShowParameter)showParameter);
                    return;
                }
                DynamicObject channel = DynamicObjectUtils.getDynamicObject((DynamicObject)this.getF7Value("account"), (String)"channel");
                DynamicObjectCollection entity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                DynamicObject newEntity = entity.addNew();
                newEntity.set("customer", (Object)channel);
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName;
        super.afterAddRow(e);
        switch (entryName = e.getEntryProp().getName()) {
            case "entryentity": {
                RowDataEntity[] rowDataEntities;
                DynamicObject channel = DynamicObjectUtils.getDynamicObject((DynamicObject)this.getF7Value("account"), (String)"channel");
                long channelId = DynamicObjectUtils.getPkValue((DynamicObject)channel);
                for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
                    int rowIndex = rowDataEntity.getRowIndex();
                    this.setValue("customer", channelId, rowIndex);
                }
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        if (e.getReturnData() == null) {
            return;
        }
        ListSelectedRowCollection returnIdList = (ListSelectedRowCollection)e.getReturnData();
        List ids = returnIdList.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)returnIdList)) {
            return;
        }
        switch (actionId = e.getActionId()) {
            case "addnewentry": {
                DynamicObjectCollection entity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                QFilter filter = new QFilter("id", "in", ids);
                DynamicObject[] queryList = BusinessDataServiceHelper.load((String)"occba_supplement", (String)"id,number,channel,org,item,material,auxpty,unitid,supqty,occupyqty,availableqty,lastupdatetime,rebateaccount", (QFilter[])filter.toArray());
                List supplementList = DynamicObjectUtils.convertDynamicObjList((DynamicObject[])queryList);
                if (CollectionUtils.isEmpty((Collection)supplementList)) {
                    return;
                }
                Map<Long, DynamicObject> supMap = entity.stream().collect(Collectors.toMap(a -> DynamicObjectUtils.getPkValue((DynamicObject)a), a -> a, (k1, k2) -> k1));
                for (DynamicObject supplement : supplementList) {
                    if (supMap.containsKey(DynamicObjectUtils.getPkValue((DynamicObject)supplement))) continue;
                    DynamicObject addSupplement = entity.addNew();
                    addSupplement.set("item", (Object)supplement.getDynamicObject("item"));
                    addSupplement.set("material", (Object)supplement.getDynamicObject("material"));
                    addSupplement.set("customer", (Object)supplement.getDynamicObject("channel"));
                    addSupplement.set("auxpty", (Object)supplement.getDynamicObject("auxpty"));
                    addSupplement.set("unit", (Object)supplement.getDynamicObject("unitid"));
                    addSupplement.set("availableqty", (Object)supplement.getBigDecimal("availableqty"));
                    addSupplement.set("itemsupplement", (Object)supplement);
                }
                this.getView().updateView("entryentity");
                break;
            }
        }
    }
}

