/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.formplugin.moneyincome;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.ocbase.formplugin.base.OcbaseBillPlugin;
import kd.occ.occba.common.helper.LspWapper;
import org.apache.commons.collections.CollectionUtils;

public class MoneyIncomeEdit
extends OcbaseBillPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit payaccountTextEdit = (TextEdit)this.getView().getControl("payaccount");
        payaccountTextEdit.addButtonClickListener((ClickListener)this);
        TextEdit recaccountTextEdit = (TextEdit)this.getView().getControl("recaccount");
        recaccountTextEdit.addButtonClickListener((ClickListener)this);
        this.addF7Listener(this, new String[]{"receivechannel", "paychannelid"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObjectCollection recEntityColl = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject recEntryDynObj : recEntityColl) {
            if (DynamicObjectUtils.getPkValue((DynamicObject)recEntryDynObj, (String)"settleorgid") != 0L) continue;
            recEntryDynObj.set("settleorgid", (Object)this.getModel().getDataEntity().getDynamicObject("moneyorgid"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "recamount": {
                this.setSumRecAmount();
                break;
            }
            case "recaccountid": {
                DynamicObject recAccountDynObj = this.getF7Value("recaccountid");
                this.setValue("recaccount", DynamicObjectUtils.getString((DynamicObject)recAccountDynObj, (String)"bankaccountnumber"));
                String bankName = null;
                if (recAccountDynObj != null) {
                    bankName = DynamicObjectUtils.getString((DynamicObject)recAccountDynObj.getDynamicObject("bank"), (String)"name");
                }
                this.setValue("recbank", bankName);
                break;
            }
            case "recaccount": {
                String recAccount = this.getStringValue("recaccount");
                if (!StringUtils.isEmpty((String)recAccount)) break;
                this.setValue("recaccountid", null);
                this.setValue("recbank", null);
                break;
            }
            case "payaccount": {
                this.setValue("payaccountid", null);
                this.setValue("f7_payerbank", null);
                break;
            }
            case "paycustomerid": {
                this.setValue("payaccount", null);
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName;
        super.afterAddRow(e);
        switch (entryName = e.getEntryProp().getName()) {
            case "entryentity": {
                RowDataEntity[] rowDataEntities;
                Object moneyOrgId = this.getF7PKValue("moneyorgid");
                for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
                    int rowIndex = rowDataEntity.getRowIndex();
                    this.setValue("settleorgid", moneyOrgId, rowIndex);
                }
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryName;
        super.afterDeleteRow(e);
        switch (entryName = e.getEntryProp().getName()) {
            case "entryentity": {
                this.setSumRecAmount();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "recaccount": {
                if ("occba_moneyincome_s".equalsIgnoreCase(this.getFormId())) break;
                BasedataEdit lotIdBaseEdit = (BasedataEdit)this.getControl("recaccountid");
                lotIdBaseEdit.click();
                break;
            }
            case "payaccount": {
                if ("occba_moneyincome_s".equalsIgnoreCase(this.getFormId())) break;
                this.showCustomerBankInfoF7();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        block3 : switch (actionId = closedCallBackEvent.getActionId()) {
            case "payaccount": {
                Object returnData = closedCallBackEvent.getReturnData();
                if (returnData == null) {
                    return;
                }
                ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
                Object entryPk = rowInfo.getEntryPrimaryKeyValues()[0];
                DynamicObject customerDynObj = BusinessDataServiceHelper.loadSingle((String)"bd_customer", (String)String.join((CharSequence)",", "bankaccount", "accountname", "bank", "currency", "isdefault_bank"), (QFilter[])new QFilter[]{new QFilter("entry_bank.id", "=", entryPk)});
                DynamicObjectCollection entryBanks = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)customerDynObj, (String)"entry_bank");
                if (!CollectionUtils.isNotEmpty((Collection)entryBanks)) break;
                for (DynamicObject row : entryBanks) {
                    if (!row.getPkValue().equals(entryPk)) continue;
                    this.setValue("payaccount", row.getString("bankaccount"), false);
                    this.setValue("paybank", DynamicObjectUtils.getString((DynamicObject)row.getDynamicObject("bank"), (String)"name"));
                    this.setValue("reaccountname", DynamicObjectUtils.getString((DynamicObject)row, (String)"accountname"));
                    this.setValue("payaccountid", entryPk);
                    this.setValue("f7_payerbank", DynamicObjectUtils.getPkValue((DynamicObject)row, (String)"bank"));
                    break block3;
                }
                break;
            }
        }
    }

    private void showCustomerBankInfoF7() {
        ArrayList<String> showFields = new ArrayList<String>(10);
        showFields.add("bank.name");
        showFields.add("bankaccount");
        showFields.add("accountname");
        showFields.add("currency.name");
        showFields.add("isdefault_bank");
        ListShowParameter listShowParam = ShowFormHelper.createShowListForm((String)"bd_customer", (boolean)false, (int)2);
        listShowParam.setCustomParam("entity", (Object)"bd_customer");
        listShowParam.setCustomParam("entry", (Object)"entry_bank");
        listShowParam.setCustomParam("isEntryMain", (Object)Boolean.TRUE);
        listShowParam.setCustomParam("showFields", showFields);
        LspWapper lspWapper = new LspWapper(listShowParam);
        lspWapper.clearPlugins();
        lspWapper.registerScript("kingdee.occ.occba.mainpage.dynamicformlistscriptplugin");
        lspWapper.setMergeRow(false);
        listShowParam.setAppId("occba");
        ListFilterParameter listFilter = new ListFilterParameter();
        listFilter.setFilter(new QFilter("id", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("paycustomerid"))));
        listShowParam.setListFilterParameter(listFilter);
        listShowParam.setCaption(ResManager.loadKDString((String)"\u5ba2\u6237-\u94f6\u884c\u4fe1\u606f", (String)"MoneyIncomeEdit_0", (String)"occ-occba-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payaccount");
        listShowParam.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)listShowParam);
    }

    private void setSumRecAmount() {
        DynamicObjectCollection recEntryColl = this.getModel().getEntryEntity("entryentity");
        BigDecimal sumRecAmount = recEntryColl.stream().map(obj -> obj.getBigDecimal("recamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.setValue("sumrecamount", sumRecAmount);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "paychannelid": {
                if (!"occba_moneyincome".equalsIgnoreCase(this.getModelName()) || !SysParamsUtil.isByChannelUser()) break;
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)CUserHelper.getAuthorizedChannelIdList((long)UserUtil.getCurrUserId(), (boolean)true)));
                break;
            }
        }
    }

    protected String getFormId() {
        return "occba_moneyincome";
    }
}

