/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.formplugin.moneyincome;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.channel.ChannelSupplyRelation;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.CodeRuleUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.occba.formplugin.moneyincome.MoneyIncomeEdit;
import org.apache.commons.collections.CollectionUtils;

public class MoneyIncomeServerEdit
extends MoneyIncomeEdit
implements BeforeF7SelectListener {
    @Override
    public void afterCreateNewData(EventObject e) {
        DynamicObject moneyIncome = this.getModel().getDataEntity();
        String billNo = moneyIncome.getString("billno");
        if (StringUtils.isEmpty((String)billNo)) {
            moneyIncome.set("billno", (Object)CodeRuleUtil.getCodeRule((String)"occba_moneyincome_b2b"));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "paychannelid": {
                long receiveChannelId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("receivechannel"));
                if (receiveChannelId <= 0L) break;
                DynamicObjectCollection resultCol = QueryServiceHelper.query((String)"ocdbd_channel_authorize", (String)"orderchannel", (QFilter[])F7Utils.getEnableFilter().and("supplyrelation", "=", (Object)ChannelSupplyRelation.SUPPLY_CHANNEL.getValue()).and("salechannel", "=", (Object)receiveChannelId).toArray());
                if (CollectionUtils.isNotEmpty((Collection)resultCol)) {
                    HashSet channelIdSet = new HashSet(100);
                    channelIdSet.addAll(resultCol.stream().map(r -> r.getLong("orderchannel")).collect(Collectors.toSet()));
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", channelIdSet));
                    break;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)0L));
                break;
            }
            case "receivechannel": {
                List channelIds = CUserHelper.getAuthorizedChannelIdList((long)UserUtil.getCurrUserId(), (boolean)true);
                if (CollectionUtils.isNotEmpty((Collection)channelIds)) {
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)channelIds));
                    break;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "=", (Object)0L));
                break;
            }
            default: {
                super.beforeF7Select(e);
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"receivechannel", "paychannelid"});
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        if ("entryentity".equals(e.getEntryProp().getName())) {
            RowDataEntity[] rowDataEntity = e.getRowDataEntities();
            long receiveChannelId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("receivechannel"));
            if (rowDataEntity != null && rowDataEntity.length > 0) {
                for (RowDataEntity rowData : rowDataEntity) {
                    this.setValue("settlechannel", receiveChannelId, rowData.getRowIndex());
                }
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "receivechannel": {
                this.getModel().setValue("paychannelid", null);
                Object newValue = e.getChangeSet()[0].getNewValue();
                DynamicObjectCollection detaliList = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                for (DynamicObject detail : detaliList) {
                    detail.set("settlechannel", newValue);
                }
                this.getView().updateView("entryentity");
                break;
            }
            case "paychannelid": {
                break;
            }
            default: {
                super.propertyChanged(e);
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        DynamicObject moneyIncome = this.getModel().getDataEntity();
        String billNo = moneyIncome.getString("billno");
        if (StringUtils.isEmpty((String)billNo)) {
            moneyIncome.set("billno", (Object)CodeRuleUtil.getCodeRule((String)"occba_moneyincome_b2b"));
        }
    }

    @Override
    protected String getFormId() {
        return "occba_moneyincome_s";
    }
}

