/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.formplugin.moneyincome;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.common.enums.AccountPoolTypeEnum;
import kd.occ.ocbase.common.enums.Checked;
import kd.occ.ocbase.common.enums.channel.ChannelProperty;
import kd.occ.ocbase.common.enums.channel.ChannelSupplyRelation;
import kd.occ.ocbase.common.util.CodeRuleUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.occba.formplugin.moneyincome.MoneyIncomeEdit;

public class MyMoneyIncomeB2BEdit
extends MoneyIncomeEdit
implements BeforeF7SelectListener {
    private static final String DPORG = "dporg";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject moneyIncome = this.getModel().getDataEntity();
        String billNo = moneyIncome.getString("billno");
        if (StringUtils.isEmpty((String)billNo)) {
            moneyIncome.set("billno", (Object)CodeRuleUtil.getCodeRule((String)"occba_moneyincome"));
        }
        DynamicObject channel = BusinessDataServiceHelper.loadSingle((Object)B2BUserHelper.getLoginChannelId(), (String)"ocdbd_channel");
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)moneyIncome, (String)"paychannelid", (long)channel.getLong("id"));
        this.setValue(DPORG, this.getSettleOrgId(), false);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)this.getModel().getDataEntity(), (String)"moneyorgid", (long)this.getSettleOrgId());
        AccountPoolTypeEnum poolType = null;
        switch (ChannelProperty.ChannelProperty((String)channel.getString("channelproperty"))) {
            case DIRECT_CHANNEL: 
            case MIX_CHANNEL: {
                poolType = AccountPoolTypeEnum.BRANDS;
                break;
            }
            case INDIRECT_CHANNEL: {
                poolType = AccountPoolTypeEnum.CHANNEL;
                break;
            }
        }
        DynamicObjectUtils.copyDynamicObjectLPkValue((DynamicObject)channel, (String)"currency", (DynamicObject)moneyIncome, (String)"currencyid");
        DynamicObjectUtils.copyDynamicObjectLPkValue((DynamicObject)channel, (String)"customer", (DynamicObject)moneyIncome, (String)"paycustomerid");
        if (poolType != null) {
            moneyIncome.set("pooltype", (Object)poolType.getValue());
            DynamicObjectCollection entries = moneyIncome.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                switch (poolType) {
                    case BRANDS: {
                        entry.set("settlechannel", null);
                        DynamicObjectUtils.copyDynamicObjectLPkValue((DynamicObject)this.getModel().getDataEntity(), (String)"moneyorgid", (DynamicObject)entry, (String)"settleorgid");
                        break;
                    }
                    case CHANNEL: {
                        entry.set("settleorgid", null);
                        DynamicObjectUtils.copyDynamicObjectLPkValue((DynamicObject)this.getModel().getDataEntity(), (String)"receivechannel", (DynamicObject)entry, (String)"settlechannel");
                    }
                }
            }
        }
        BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{moneyIncome}, (IDataEntityType)this.getModel().getDataEntityType());
    }

    private long getSettleOrgId() {
        DynamicObject channelAuth;
        long settleOrgId = 0L;
        long supplyRelationId = B2BUserHelper.getLoginSupplyRelationId();
        if (supplyRelationId != 0L && (channelAuth = BusinessDataServiceHelper.loadSingle((Object)supplyRelationId, (String)"ocdbd_channel_authorize")) != null && channelAuth.getLong("saleorg_id") != 0L) {
            settleOrgId = this.getSettleOrgIdBySaleOrgId(channelAuth.getLong("saleorg_id"));
        }
        return settleOrgId;
    }

    private long getSettleOrgIdBySaleOrgId(long saleOrgId) {
        Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)saleOrgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        if (!CollectionUtils.isEmpty((Map)map)) {
            return Long.parseLong(map.get("id").toString());
        }
        return 0L;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"receivechannel", DPORG});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "receivechannel": {
                DynamicObject payChannel = this.getF7Value("paychannelid");
                if (payChannel != null) {
                    HashSet<Long> channelIdSet = new HashSet<Long>(100);
                    long parentChannelId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)payChannel, (String)"parent");
                    if (parentChannelId > 0L) {
                        channelIdSet.add(parentChannelId);
                    }
                    long payChannelId = payChannel.getLong("id");
                    DynamicObjectCollection resultCol = QueryServiceHelper.query((String)"ocdbd_channel_authorize", (String)"salechannel", (QFilter[])F7Utils.getEnableFilter().and("supplyrelation", "=", (Object)ChannelSupplyRelation.SUPPLY_CHANNEL.getValue()).and("orderchannel", "=", (Object)payChannelId).toArray());
                    if (!CollectionUtils.isEmpty((Collection)resultCol)) {
                        channelIdSet.addAll(resultCol.stream().map(r -> r.getLong("salechannel")).collect(Collectors.toSet()));
                    }
                    if (CollectionUtils.isEmpty(channelIdSet)) {
                        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)F7Utils.getEveFalseFilter());
                        break;
                    }
                    resultCol = QueryServiceHelper.query((String)"ocdbd_channel", (String)"balancechannel", (QFilter[])new QFilter("id", "in", channelIdSet).toArray());
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", resultCol.stream().map(r -> r.getLong("balancechannel")).collect(Collectors.toSet())));
                    break;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)F7Utils.getEveFalseFilter());
                break;
            }
            case "dporg": {
                long orderChannelId = B2BUserHelper.getLoginChannelId();
                QFilter filter = new QFilter("orderchannel", "=", (Object)orderChannelId);
                filter.and("enable", "=", (Object)Checked.YES.toString());
                String selectFields = String.join((CharSequence)",", "orderchannel", "saleorg", "salechannel");
                DynamicObjectCollection channelAuthList = QueryServiceHelper.query((String)"ocdbd_channel_authorize", (String)selectFields, (QFilter[])filter.toArray());
                HashSet<Long> settleOrgIds = new HashSet<Long>();
                if (channelAuthList != null && !channelAuthList.isEmpty()) {
                    for (DynamicObject channelAuth : channelAuthList) {
                        long settleOrgId = this.getSettleOrgIdBySaleOrgId(channelAuth.getLong("saleorg"));
                        if (settleOrgId == 0L) continue;
                        settleOrgIds.add(settleOrgId);
                    }
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", settleOrgIds));
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject payChannel = this.getF7Value("paychannelid");
        switch (ChannelProperty.ChannelProperty((String)payChannel.getString("channelproperty"))) {
            case MIX_CHANNEL: {
                this.setEnable(new String[]{"pooltype"});
                break;
            }
            default: {
                this.setUnEnable(new String[]{"pooltype"});
            }
        }
        if (!this.isAddNew()) {
            this.setValue(DPORG, this.getModel().getValue("moneyorgid"), false);
        }
        this.poolTypeChanged(false);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "pooltype": {
                this.poolTypeChanged(true);
                break;
            }
            case "moneyorgid": {
                this.moneyOrgChanged(e.getChangeSet()[0].getNewValue());
                break;
            }
            case "receivechannel": {
                this.receiveChannelChanged(e.getChangeSet()[0].getNewValue());
                break;
            }
            case "paychannelid": {
                break;
            }
            case "dporg": {
                this.setValue("moneyorgid", e.getChangeSet()[0].getNewValue());
                break;
            }
            default: {
                super.propertyChanged(e);
            }
        }
    }

    private void moneyOrgOrReceiveChannelChanged(Object newValue, String headF7Key, String entryF7Key) {
        DynamicObject bill = this.getModel().getDataEntity(true);
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entries) {
            DynamicObjectUtils.copyDynamicObjectLPkValue((DynamicObject)bill, (String)headF7Key, (DynamicObject)entry, (String)entryF7Key);
            if (newValue != null) continue;
            entry.set(entryF7Key, null);
        }
        if (newValue != null) {
            BusinessDataServiceHelper.loadRefence((Object[])entries.toArray(), (IDataEntityType)entries.getDynamicObjectType());
        }
        this.getView().updateView("entryentity");
    }

    private void moneyOrgChanged(Object newValue) {
        this.moneyOrgOrReceiveChannelChanged(newValue, "moneyorgid", "settleorgid");
    }

    private void receiveChannelChanged(Object newValue) {
        this.moneyOrgOrReceiveChannelChanged(newValue, "receivechannel", "settlechannel");
    }

    private void poolTypeChanged(boolean isHandlerValue) {
        AccountPoolTypeEnum poolType = AccountPoolTypeEnum.controlMethodName((String)this.getStringValue("pooltype"));
        if (poolType != null) {
            switch (poolType) {
                case BRANDS: {
                    this.setMustInput(DPORG, true);
                    this.setMustInput("settleorgid", true);
                    this.setMustInput("receivechannel", false);
                    this.setMustInput("settlechannel", false);
                    this.setUnEnable(new String[]{"recbank"});
                    break;
                }
                case CHANNEL: {
                    this.setMustInput(DPORG, false);
                    this.setMustInput("settleorgid", false);
                    this.setMustInput("receivechannel", true);
                    this.setMustInput("settlechannel", true);
                    this.setEnable(new String[]{"recbank"});
                }
            }
            if (isHandlerValue) {
                this.setValue("recbank", null);
                this.setValue("recaccount", null);
                this.setValue("recaccountid", null);
                this.setValue("sumrecamount", null);
                this.getModel().deleteEntryData("entryentity");
                switch (poolType) {
                    case BRANDS: {
                        this.setValue("receivechannel", null);
                        DynamicObject rowA = this.getModel().getEntryEntity("entryentity").addNew();
                        DynamicObjectUtils.copyDynamicObjectLPkValue((DynamicObject)this.getModel().getDataEntity(), (String)"moneyorgid", (DynamicObject)rowA, (String)"settleorgid");
                        BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{rowA}, (IDataEntityType)this.getModel().getEntryEntity("entryentity").getDynamicObjectType());
                        this.getView().updateView("entryentity");
                        break;
                    }
                    case CHANNEL: {
                        this.setValue("moneyorgid", this.getSettleOrgId());
                        DynamicObject rowB = this.getModel().getEntryEntity("entryentity").addNew();
                        DynamicObjectUtils.copyDynamicObjectLPkValue((DynamicObject)this.getModel().getDataEntity(), (String)"receivechannel", (DynamicObject)rowB, (String)"settlechannel");
                        BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{rowB}, (IDataEntityType)this.getModel().getEntryEntity("entryentity").getDynamicObjectType());
                        this.getView().updateView("entryentity");
                    }
                }
            }
        }
    }
}

