/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.formplugin.moneyusesetting;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.helper.ComboItemHelper;
import kd.occ.ocbase.common.enums.Enable;
import kd.occ.ocbase.common.enums.occba.ControlTimeEnum;
import kd.occ.ocbase.common.enums.occba.ControlTypeEnum;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.formplugin.base.OcbaseBillPlugin;

public class MoneyUseSettingEdit
extends OcbaseBillPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"billtypeid"});
        Toolbar toolbar = (Toolbar)this.getView().getControl("advcontoolbarap");
        if (toolbar != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setUpdateMoneyTimeEnable();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "billtypeid": {
                Object billEntityId = this.getF7PKValue("billentityid");
                if (billEntityId == null) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u4f7f\u7528\u5355\u636e\u3002", (String)"MoneyUseSettingEdit_0", (String)"occ-occba-formplugin", (Object[])new Object[0]));
                    return;
                }
                QFilter qfilter = new QFilter("billformid", "=", billEntityId);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)qfilter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "billentityid": {
                this.setValue("billtypeid", null);
                break;
            }
            case "controltime": {
                Object controlTime = this.getValue("controltime");
                this.setValue("updatemoneytime", controlTime);
                String controlTypeValue = this.getValue("controltype").toString();
                if ((ControlTypeEnum.CANCEL.getValue().equals(controlTypeValue) || ControlTypeEnum.WARNNING.getValue().equals(controlTypeValue)) && ControlTimeEnum.NO_CONTROL.getValue().equals(controlTime.toString())) {
                    Object oldValue = e.getChangeSet()[0].getOldValue();
                    this.setValue("controltime", oldValue);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u63a7\u5236\u65f6\u70b9\u4e0d\u80fd\u9009\u62e9\u3010\u65e0\u3011\uff0c\u53ea\u80fd\u9009\u62e9\u63d0\u4ea4\u6216\u5ba1\u6838\u3002", (String)"MoneyUseSettingEdit_1", (String)"occ-occba-formplugin", (Object[])new Object[0]));
                }
                this.setUpdateMoneyTimeEnable();
                break;
            }
            case "controltype": {
                Object controlType = this.getValue("controltype");
                String contolTime = ControlTimeEnum.SUBMIT.getValue();
                if (ControlTypeEnum.NO_CONTROL.getValue().equals(controlType.toString())) {
                    contolTime = ControlTimeEnum.NO_CONTROL.getValue();
                }
                this.setValue("controltime", contolTime);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String itemKey;
        switch (itemKey = e.getItemKey()) {
            case "addrow": {
                this.showChannelAuthorizePage();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String key = evt.getActionId();
        ListSelectedRowCollection rows = (ListSelectedRowCollection)evt.getReturnData();
        if (rows == null || rows.size() == 0) {
            return;
        }
        List relationIdList = rows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        switch (key) {
            case "addFromChannelAuthorize": {
                DynamicObjectCollection relationDynObjColl = QueryServiceHelper.query((String)"ocdbd_channel_authorize", (String)String.join((CharSequence)",", "id", "saleorg", "salechannel", "orderchannel", "supplyrelation"), (QFilter[])new QFilter("id", "in", relationIdList).toArray());
                int size = relationDynObjColl.size();
                int[] addRowIndexs = this.getModel().batchCreateNewEntryRow("entryentity", size);
                for (int i = 0; i < size; ++i) {
                    int rowIndex = addRowIndexs[i];
                    DynamicObject relationDynObj = (DynamicObject)relationDynObjColl.get(i);
                    this.setValue("supplyrelationid", relationDynObj.get("id"), rowIndex);
                    this.setValue("supplyrelation", relationDynObj.getString("supplyrelation"), rowIndex);
                    this.setValue("saleorgid", relationDynObj.getLong("saleorg"), rowIndex);
                    this.setValue("salechannelid", relationDynObj.getLong("salechannel"), rowIndex);
                    this.setValue("orderchannelid", relationDynObj.getLong("orderchannel"), rowIndex);
                }
                break;
            }
        }
    }

    private void showChannelAuthorizePage() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"ocdbd_supplier", (boolean)true, (int)0, (boolean)true);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addFromChannelAuthorize"));
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        DynamicObjectCollection channelEntryColl = this.getModel().getEntryEntity("entryentity");
        Set existSupplyRelationIdSet = channelEntryColl.stream().map(obj -> obj.get("supplyrelationid")).collect(Collectors.toSet());
        if (!CommonUtils.isNull(existSupplyRelationIdSet)) {
            listFilterParameter.getQFilters().add(new QFilter("id", "not in", existSupplyRelationIdSet));
        }
        listFilterParameter.getQFilters().add(new QFilter("enable", "=", (Object)Enable.ENABLE.toString()));
        parameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void setUpdateMoneyTimeEnable() {
        String controlTime = (String)this.getValue("controltime");
        boolean enable = ControlTimeEnum.NO_CONTROL.getValue().equals(controlTime);
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{"updatemoneytime"});
        this.getView().setEnable(Boolean.valueOf(!enable), new String[]{"controltime"});
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("controltype");
        HashSet<String> set = new HashSet<String>(1);
        set.add("1");
        ComboItemHelper.setItemVisible((ComboEdit)comboEdit, set, (boolean)false);
    }
}

